/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.DistributionStatusLinkView;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.EditLinkListener;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.ProcessingStatusView;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.QuickInfoViewBuilder;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.StatusView;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.view.thumbnail.TitleThumbnailWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class SearchResultTableColumn
extends ColumnBase<String, TitleRecord> {
    private UiColumn uiColumn;
    private TitleListPanel panel;
    private static final String STYLE_THUMBNAIL_IMAGE = "content-TitleListPanel-thumbnailImage";
    private static final String ID_COL_WIDTH = "5%";
    private boolean linkEnabled = true;

    public SearchResultTableColumn(UiColumn uiColumn, TitleListPanel panel) {
        super(uiColumn.getInternalName(), uiColumn.getDisplayName());
        this.uiColumn = uiColumn;
        this.panel = panel;
        if (panel == null) {
            this.linkEnabled = false;
        }
    }

    public View<String> getView(TitleRecord record) {
        UISearchResultRec t = record.getTitle();
        if (SearchResultTableColumn.isStatusColumn(this.uiColumn)) {
            return new StatusView(record);
        }
        if (SearchResultTableColumn.isThumbnailColumn(this.uiColumn)) {
            return new ThumbnailView(record);
        }
        if (SearchResultTableColumn.isQuickInfoColumn(this.uiColumn)) {
            return new QuickInfoViewBuilder(record);
        }
        for (UiField f : t.getFields()) {
            String colInternalName = TableColumnNameHelper.getColumnName(f.getName(), f.getParentAssetType());
            LabelStringView view = new LabelStringView(f.getValue());
            if (!colInternalName.equals(this.getName())) continue;
            if (this.getName().equalsIgnoreCase("id")) {
                if (this.linkEnabled) {
                    return new TitleHyperLinkView(t.getId());
                }
                return new LabelStringView(String.valueOf(t.getId()));
            }
            if (this.getName().equalsIgnoreCase("distributionStatus")) {
                return new DistributionStatusLinkView(t.getId(), f.getValue());
            }
            if (this.getName().equalsIgnoreCase("processingStatus")) {
                return new ProcessingStatusView(f.getValue());
            }
            return view;
        }
        return new LabelStringView("ERROR: Value not available");
    }

    public UiColumn getUiColumn() {
        return this.uiColumn;
    }

    public void setUiColumn(UiColumn uiColumn) {
        this.uiColumn = uiColumn;
    }

    public static boolean isStatusColumn(UiColumn column) {
        return "status".equals(column.getName());
    }

    public static boolean isThumbnailColumn(UiColumn column) {
        return "thumbnail".equals(column.getName());
    }

    public static boolean isQuickInfoColumn(UiColumn column) {
        return "quickInfo".equals(column.getName());
    }

    public static boolean isIdColumn(UiColumn column) {
        return "id".equals(column.getName());
    }

    public String getColumnCellStyle() {
        if (SearchResultTableColumn.isThumbnailColumn(this.uiColumn)) {
            return "nwt-TableColumnPanel-dataCell-icon";
        }
        String style = "nwt-TableColumnPanel-dataCell-general";
        if (this.uiColumn.getDataType() != null) {
            switch (this.uiColumn.getDataType()) {
                case BOOLEAN: 
                case STRING: {
                    if (this.uiColumn.getName().equalsIgnoreCase("status")) {
                        style = "nwt-TableColumnPanel-dataCell-icon";
                        break;
                    }
                    style = "nwt-TableColumnPanel-dataCell-text";
                    break;
                }
                case FLOAT: 
                case INTEGER: {
                    style = "nwt-TableColumnPanel-dataCell-numeric";
                    break;
                }
                case DATE: 
                case TIME: {
                    style = "nwt-TableColumnPanel-dataCell-date";
                }
            }
        }
        return style;
    }

    public String getColumnWidth() {
        if (SearchResultTableColumn.isIdColumn(this.uiColumn)) {
            return ID_COL_WIDTH;
        }
        return "";
    }

    private static class ThumbnailView
    implements View<String> {
        TitleRecord record;

        public ThumbnailView(TitleRecord record) {
            this.record = record;
        }

        public Widget getWidget() {
            TitleThumbnailWidget widget = new TitleThumbnailWidget();
            widget.addStyleName(SearchResultTableColumn.STYLE_THUMBNAIL_IMAGE);
            widget.setInput(this.record.getTitle().getId(), null);
            return widget;
        }

        public void release() {
        }

        public String getStyleName() {
            return null;
        }
    }

    private class TitleHyperLinkView
    implements View<String> {
        private long titleId;
        private static final String HREF_TITLE_ID = "#Content.Search.Id=";
        private static final String HREF_SERIES_TITLE_ID = "#Content.SeriesSearch.Id=";

        public TitleHyperLinkView(long titleId) {
            this.titleId = titleId;
        }

        public Widget getWidget() {
            String href = HREF_TITLE_ID;
            if (SearchResultTableColumn.this.panel.isSeries()) {
                href = HREF_SERIES_TITLE_ID;
            }
            Anchor anchor = new Anchor(String.valueOf(this.titleId), String.valueOf(href) + String.valueOf(this.titleId));
            anchor.addClickHandler((ClickHandler)new EditLinkListener(this.titleId, SearchResultTableColumn.this.panel));
            return anchor;
        }

        public String getStyleName() {
            return "table-data-link";
        }

        public void release() {
        }
    }
}

