/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.model.UiAsset;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchService;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.AssetRecord;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleAssetColumn;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import java.util.ArrayList;
import java.util.List;

public class TitleAssetDataProvider
implements DataProvider<Long, AssetRecord> {
    private UiTable uiTable;
    private List<Column<?, AssetRecord>> columns;
    private List<UiColumn> uiColumns;
    private TitleRecord parentRecord;
    TitleSearchServiceAsync searchService = (TitleSearchServiceAsync)GWT.create(TitleSearchService.class);

    public TitleAssetDataProvider(TitleRecord parentRecord, UiTable uiTable) {
        this.parentRecord = parentRecord;
        this.uiTable = uiTable;
        this.initColumns();
    }

    private void initColumns() {
        this.columns = new ArrayList();
        this.uiColumns = this.uiTable.getColumns();
        if (this.uiColumns != null) {
            for (UiColumn uiColumn : this.uiColumns) {
                String colInternalName = TableColumnNameHelper.getColumnName(uiColumn.getName(), null);
                TitleAssetColumn column = new TitleAssetColumn(colInternalName, uiColumn.getDisplayName());
                column.setCellStyle(this.getColumnCellStyle(uiColumn));
                this.columns.add((Column<?, AssetRecord>)column);
            }
        }
    }

    private String getColumnCellStyle(UiColumn column) {
        String style = "nwt-TableColumnPanel-dataCell-general";
        if (column.getDataType() != null) {
            switch (column.getDataType()) {
                case BOOLEAN: 
                case STRING: {
                    style = "nwt-TableColumnPanel-dataCell-text";
                    break;
                }
                case FLOAT: 
                case INTEGER: {
                    style = "nwt-TableColumnPanel-dataCell-numeric";
                    break;
                }
                case DATE: 
                case TIME: {
                    style = "nwt-TableColumnPanel-dataCell-date";
                }
            }
        }
        return style;
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public List<Column<?, AssetRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<AssetRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public void getRecords(final AsyncCallback<List<AssetRecord>> callback) {
        this.searchService.getAssetInfo(this.parentRecord.getKey(), this.uiTable.getColumns(), (AsyncCallback<List<UiAsset>>)new NeptuneAsyncCallback<List<UiAsset>>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<UiAsset> result) {
                ArrayList<AssetRecord> records = new ArrayList<AssetRecord>();
                for (UiAsset uiAsset : result) {
                    records.add(new AssetRecord(uiAsset));
                }
                callback.onSuccess(records);
            }
        });
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return false;
    }
}

