/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.model.NoPartnersException;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.model.UiInvalidQwikSrchException;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchService;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.QuickInfoColumnProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.StatusColumnProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.view.TitlePageHelper;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UISortOrder;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import java.util.ArrayList;
import java.util.List;

public class UiAssetTableDataProvider
implements DataProvider<Long, TitleRecord> {
    private TitleListPanel view;
    private List<UiColumn> uiColumns;
    private List<UiColumn> uiColumnsForQuery;
    private List<UiColumn> uiColumnsForExport;
    private List<Column<?, TitleRecord>> columns = new ArrayList();
    private SortOrder defaultSortOrder;
    private Column<?, TitleRecord> defaultSortColumn;
    private List<Column<?, TitleRecord>> sortableColumns = new ArrayList();
    private PageFeatureImpl pageFeature;
    private SortFeatureImpl<Long, TitleRecord> sortFeature;
    private int prevValidPageNumber = -1;
    private ContentMessages displayMessages = (ContentMessages)GWT.create(ContentMessages.class);

    public UiAssetTableDataProvider(TitleListPanel view) {
        this.view = view;
    }

    public void init(List<UiColumn> searchResultsColumns) {
        this.uiColumns = searchResultsColumns;
        this.uiColumnsForQuery = new ArrayList<UiColumn>();
        this.uiColumnsForExport = new ArrayList<UiColumn>();
        if (this.uiColumns != null) {
            for (UiColumn uiColumn : this.uiColumns) {
                if (UiAssetTableDataProvider.isThumbnailColumn(uiColumn)) continue;
                if (UiAssetTableDataProvider.isStatusColumn(uiColumn)) {
                    StatusColumnProvider statusColumnProvider = StatusColumnProvider.getInstance();
                    this.uiColumnsForQuery.addAll(statusColumnProvider.getColumns());
                    continue;
                }
                this.uiColumnsForQuery.add(uiColumn);
                this.uiColumnsForExport.add(uiColumn);
            }
        }
        this.uiColumnsForQuery.add(new UiColumn("contentClassId", "ContentClass", false, null, UIFieldType.PMM_TITLE, false, UiColumn.DataType.INTEGER, false, false));
    }

    public void setDisplayColumns(List<Column<?, TitleRecord>> columns) {
        this.columns = columns;
    }

    public void setSortColumns(List<Column<?, TitleRecord>> columns) {
        this.sortableColumns = columns;
    }

    public Column<?, TitleRecord> getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    public SortOrder getDefaultSortOrder() {
        return this.defaultSortOrder;
    }

    public List<Column<?, TitleRecord>> getSortableColumns() {
        return this.sortableColumns;
    }

    public void setPageFeature(PageFeatureImpl pageFeature) {
        this.pageFeature = pageFeature;
    }

    public void setSortFeature(SortFeatureImpl<Long, TitleRecord> sortFeature) {
        this.sortFeature = sortFeature;
    }

    public void initialize(final AsyncCallback<Void> callback) {
        boolean quickInfoIsSelected = false;
        for (final UiColumn uic : this.uiColumnsForQuery) {
            if (!UiAssetTableDataProvider.isQuickInfoColumn(uic)) continue;
            QuickInfoColumnProvider qInfoProvider = QuickInfoColumnProvider.getInstance();
            NeptuneAsyncCallback<List<UiColumn>> fieldCallback = new NeptuneAsyncCallback<List<UiColumn>>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(List<UiColumn> quickInfoColumns) {
                    for (UiColumn c : quickInfoColumns) {
                        c.setQuickInfoField(true);
                    }
                    UiAssetTableDataProvider.this.uiColumnsForQuery.addAll(quickInfoColumns);
                    UiAssetTableDataProvider.this.uiColumnsForQuery.remove(uic);
                    int colPosition = UiAssetTableDataProvider.this.uiColumnsForExport.indexOf(uic);
                    ArrayList remainingSelectedCols = new ArrayList();
                    if (colPosition < UiAssetTableDataProvider.this.uiColumnsForExport.size() - 1) {
                        remainingSelectedCols.addAll(UiAssetTableDataProvider.this.uiColumnsForExport.subList(colPosition + 1, UiAssetTableDataProvider.this.uiColumnsForExport.size()));
                    }
                    UiAssetTableDataProvider.this.uiColumnsForExport.remove(colPosition);
                    if (remainingSelectedCols.size() > 0) {
                        UiAssetTableDataProvider.this.uiColumnsForExport.removeAll(remainingSelectedCols);
                    }
                    UiAssetTableDataProvider.this.uiColumnsForExport.addAll(quickInfoColumns);
                    if (remainingSelectedCols.size() > 0) {
                        UiAssetTableDataProvider.this.uiColumnsForExport.addAll(remainingSelectedCols);
                    }
                    callback.onSuccess(null);
                }
            };
            qInfoProvider.getColumns(fieldCallback);
            quickInfoIsSelected = true;
            break;
        }
        if (!quickInfoIsSelected) {
            callback.onSuccess(null);
        }
    }

    public List<Column<?, TitleRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<TitleRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public void getRecords(final AsyncCallback<List<TitleRecord>> callback) {
        this.view.handleGetRecordsRequest();
        this.view.resetMessagePanel();
        TitleSearchServiceAsync searchService = (TitleSearchServiceAsync)GWT.create(TitleSearchService.class);
        UITitleFilter titleFilter = this.view.getTitleFilter();
        final boolean exceedMaxPage = this.checkPageInfo(titleFilter);
        if (TableColumnNameHelper.isMetdataField(this.sortFeature.getSortColumnName())) {
            titleFilter.getSortInfo().setSortFieldType(UIFieldType.ASSET);
            String columnName = TableColumnNameHelper.getColumnName(this.sortFeature.getSortColumnName());
            titleFilter.getSortInfo().setSortColumnName(columnName);
            String colSection = TableColumnNameHelper.getSectionName(this.sortFeature.getSortColumnName()).toUpperCase();
            titleFilter.getSortInfo().setSortColumnSection(colSection);
        } else {
            titleFilter.getSortInfo().setSortFieldType(UIFieldType.PMM_TITLE);
            titleFilter.getSortInfo().setSortColumnName(this.sortFeature.getSortColumnName());
        }
        UISortOrder order = UISortOrder.DESCENDING;
        if (this.sortFeature.isAscending()) {
            order = UISortOrder.ASCENDING;
        }
        titleFilter.getSortInfo().setSortOrder(order);
        searchService.getTitles(titleFilter, this.uiColumnsForQuery, (AsyncCallback<UISearchResult>)new NeptuneAsyncCallback<UISearchResult>(){

            public void onNeptuneFailure(Throwable caught) {
                UiAssetTableDataProvider.this.pageFeature.setRecordCount(-1);
                if (caught instanceof NoPartnersException || caught instanceof UiInvalidQwikSrchException) {
                    callback.onSuccess(new ArrayList());
                } else {
                    callback.onFailure(caught);
                }
                UiAssetTableDataProvider.this.view.handleGetRecordsFailureResponse(caught);
            }

            public void onNeptuneSuccess(UISearchResult result) {
                ArrayList<TitleRecord> records = new ArrayList<TitleRecord>();
                if ((result.getTitles() == null || result.getTitles().size() == 0) && UiAssetTableDataProvider.this.prevValidPageNumber != -1) {
                    int requestedPageNumber = UiAssetTableDataProvider.this.pageFeature.getPageNumber();
                    UiAssetTableDataProvider.this.pageFeature.setPageNumber(UiAssetTableDataProvider.this.prevValidPageNumber);
                    UiAssetTableDataProvider.this.view.hideBusyIndicator();
                    Window.alert((String)UiAssetTableDataProvider.this.displayMessages.noRecordsFound(requestedPageNumber));
                    callback.onFailure(null);
                    return;
                }
                for (UISearchResultRec t : result.getTitles()) {
                    records.add(new TitleRecord(t));
                }
                UiAssetTableDataProvider.this.pageFeature.setRecordCount(result.getTotalCount());
                UiAssetTableDataProvider.this.pageFeature.setHasMorePages(result.isHasMoreResults());
                UiAssetTableDataProvider.this.prevValidPageNumber = UiAssetTableDataProvider.this.pageFeature.getPageNumber();
                callback.onSuccess(records);
                UiAssetTableDataProvider.this.view.handleGetRecordsSuccessResponse(records);
                if (exceedMaxPage) {
                    UiAssetTableDataProvider.this.view.showErrorMessage(UiAssetTableDataProvider.this.displayMessages.exceedMaxTitlesError());
                }
            }
        });
    }

    private boolean checkPageInfo(UITitleFilter titleFilter) {
        boolean exceedMaxPage = TitlePageHelper.enhancePageFeature((PageFeature)this.pageFeature);
        titleFilter.getPageInfo().setStartIndex((this.pageFeature.getPageNumber() - 1) * this.pageFeature.getPageSize());
        titleFilter.getPageInfo().setMaxCount(this.pageFeature.getPageSize());
        return exceedMaxPage;
    }

    public boolean isCheckboxEnabled() {
        return this.view.hasActions();
    }

    public boolean isRecordCountEnabled() {
        return false;
    }

    public List<UiColumn> getExportColumns() {
        return this.uiColumnsForExport;
    }

    public static boolean isThumbnailColumn(UiColumn column) {
        return "thumbnail".equals(column.getName());
    }

    public static boolean isStatusColumn(UiColumn column) {
        return "status".equals(column.getName());
    }

    public static boolean isQuickInfoColumn(UiColumn column) {
        return "quickInfo".equals(column.getName());
    }
}

