/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list.goButton;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.OperationCompletedAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ButtonClickListener
implements ClickHandler {
    private ListBoxWidget<String> list;
    private ListBoxWidget<String> parameterList;
    private IView view;
    private ServiceMap serviceMap;
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private ContentMessages displayMessages = (ContentMessages)GWT.create(ContentMessages.class);
    private ITitleSitesServiceAsync titleSitesService = (ITitleSitesServiceAsync)GWT.create(ITitleSitesService.class);
    private final String TARGET_SERVICE_IMPL = "Target Title(s)";

    public ButtonClickListener(ListBoxWidget<String> list, ListBoxWidget<String> parameterList, IView view, ServiceMap serviceMap) {
        this.list = list;
        this.parameterList = parameterList;
        this.view = view;
        this.serviceMap = serviceMap;
    }

    public void setParameterList(ListBoxWidget<String> parameterList) {
        this.parameterList = parameterList;
    }

    public void onClick(ClickEvent event) {
        int selectedIndex = this.list.getSelectedIndex();
        String displayName = this.list.getItemText(selectedIndex);
        ITitleActionService serviceImpl = this.serviceMap.getService(displayName);
        if (serviceImpl == null) {
            throw new RuntimeException("Service impl for : " + displayName + " could not be found.");
        }
        List ids = this.view.getSeletedRecordIds();
        OperationCompletedAsyncCallback callback = new OperationCompletedAsyncCallback(serviceImpl, this.view);
        if (ids.size() == 0) {
            callback.onFailure((Throwable)new RuntimeException(this.displayConstants.atLeastOneTitleSelectionRequired()));
            return;
        }
        IActionInput input = this.view.getInputToExecution();
        if (serviceImpl.getConfirmation()) {
            this.view.show(false);
            this.getConfirmation(serviceImpl, ids, input, callback);
        } else {
            serviceImpl.execute(ids, (String)this.parameterList.getSelectedItem(), input, (AsyncCallback)callback);
        }
    }

    protected void getConfirmation(final ITitleActionService serviceImpl, final List<Long> ids, final IActionInput input, final OperationCompletedAsyncCallback callback) {
        final PopupContainer confirmation = new PopupContainer(false, true);
        final VerticalContainer popContainer = new VerticalContainer();
        if ("Target Title(s)".equals(serviceImpl.getName())) {
            StringBuilder parmList = new StringBuilder();
            ArrayList<String> selectedSiteNames = new ArrayList<String>(Arrays.asList(this.getSelectedSite(parmList).split(",")));
            this.titleSitesService.getAreAllDependencySitesSelectedWithSiteNames(selectedSiteNames, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                public void onNeptuneSuccess(Boolean result) {
                    if (!result.booleanValue()) {
                        popContainer.add((Widget)new LabelWidget(ButtonClickListener.this.displayMessages.targetConfirmationMessageWithSiteDependency("Target Title(s)")));
                    } else {
                        popContainer.add((Widget)new LabelWidget(ButtonClickListener.this.displayMessages.confirmationMessage("Target Title(s)")));
                    }
                    ButtonClickListener.this.getConfirmationDetails(serviceImpl, ids, input, callback, confirmation, popContainer);
                }

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure((Throwable)new RuntimeException(caught.getMessage()));
                }
            });
        } else {
            popContainer.add((Widget)new LabelWidget(this.displayMessages.confirmationMessage(serviceImpl.getName())));
            this.getConfirmationDetails(serviceImpl, ids, input, callback, confirmation, popContainer);
        }
    }

    protected void getConfirmationDetails(final ITitleActionService serviceImpl, final List<Long> ids, final IActionInput input, final OperationCompletedAsyncCallback callback, final PopupContainer confirmation, VerticalContainer popContainer) {
        HorizontalContainer buttonContainer = new HorizontalContainer();
        buttonContainer.addStyleName("cms_button_container");
        ButtonWidget yesButton = new ButtonWidget(this.displayConstants.confirmationYes());
        yesButton.removeStyleName("gwt-Button");
        yesButton.addStyleName("ebBtn");
        yesButton.addStyleName("ebBtn_color_green");
        yesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ButtonClickListener.this.view.show(true);
                confirmation.hide();
                StringBuilder parmList = new StringBuilder();
                boolean isFirst = true;
                if (ButtonClickListener.this.parameterList.isMultipleSelect()) {
                    int i = 0;
                    int l = ButtonClickListener.this.parameterList.getItemCount();
                    while (i < l) {
                        if (ButtonClickListener.this.parameterList.isItemSelected(i)) {
                            String selectedParameter = ButtonClickListener.this.parameterList.getItemText(i);
                            if (!isFirst) {
                                parmList.append(",");
                            } else {
                                isFirst = false;
                            }
                            parmList.append(selectedParameter);
                        }
                        ++i;
                    }
                    serviceImpl.execute(ids, parmList.toString(), input, (AsyncCallback)callback);
                } else {
                    serviceImpl.execute(ids, (String)ButtonClickListener.this.parameterList.getSelectedItem(), input, (AsyncCallback)callback);
                }
            }
        });
        buttonContainer.add((Widget)yesButton);
        ButtonWidget noButton = new ButtonWidget(this.displayConstants.confirmationNo());
        noButton.removeStyleName("gwt-Button");
        noButton.addStyleName("ebBtn");
        noButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ButtonClickListener.this.view.show(true);
                ButtonClickListener.this.view.show(ButtonClickListener.this.displayConstants.cancelledOperation());
                confirmation.hide();
            }
        });
        buttonContainer.add((Widget)noButton);
        popContainer.add((Widget)buttonContainer);
        popContainer.setCellHorizontalAlignment((Widget)buttonContainer, HasHorizontalAlignment.ALIGN_CENTER);
        confirmation.add((Widget)popContainer);
        confirmation.center();
        confirmation.show();
    }

    private String getSelectedSite(StringBuilder parmList) {
        boolean isFirst = true;
        if (this.parameterList.isMultipleSelect()) {
            int i = 0;
            int l = this.parameterList.getItemCount();
            while (i < l) {
                if (this.parameterList.isItemSelected(i)) {
                    String selectedParameter = this.parameterList.getItemText(i);
                    if (!isFirst) {
                        parmList.append(",");
                    } else {
                        isFirst = false;
                    }
                    parmList.append(selectedParameter);
                }
                ++i;
            }
        }
        return parmList.toString();
    }

    protected ListBoxWidget<String> getList() {
        return this.list;
    }

    protected void setList(ListBoxWidget<String> list) {
        this.list = list;
    }

    protected IView getView() {
        return this.view;
    }

    protected void setView(IView view) {
        this.view = view;
    }

    protected ServiceMap getServiceMap() {
        return this.serviceMap;
    }

    protected void setServiceMap(ServiceMap serviceMap) {
        this.serviceMap = serviceMap;
    }

    protected ContentConstants getDisplayConstants() {
        return this.displayConstants;
    }

    protected void setDisplayConstants(ContentConstants displayConstants) {
        this.displayConstants = displayConstants;
    }

    protected ContentMessages getDisplayMessages() {
        return this.displayMessages;
    }

    protected void setDisplayMessages(ContentMessages displayMessages) {
        this.displayMessages = displayMessages;
    }

    protected ListBoxWidget<String> getParameterList() {
        return this.parameterList;
    }
}

