/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list.goButton;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.ButtonClickListener;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleAssetActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.OperationCompletedAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ExpandingProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.ExpandingFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TitleListButtonClickListener
extends ButtonClickListener {
    private TitleListPanel titleListPanel;

    public TitleListButtonClickListener(ListBoxWidget<String> list, ListBoxWidget<String> parameterList, TitleListPanel view, ServiceMap serviceMap) {
        super(list, parameterList, view, serviceMap);
        this.titleListPanel = view;
    }

    @Override
    public void onClick(ClickEvent event) {
        int selectedIndex = this.getList().getSelectedIndex();
        String displayName = this.getList().getItemText(selectedIndex);
        ITitleActionService serviceImpl = this.getServiceMap().getService(displayName);
        if (serviceImpl == null) {
            throw new RuntimeException("Service impl for : " + displayName + " could not be found.");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        List selectedIds = this.titleListPanel.getAssetTable().getSelectedRecords();
        for (TitleRecord tr : selectedIds) {
            ids.add(tr.getKey());
        }
        OperationCompletedAsyncCallback callback = new OperationCompletedAsyncCallback(serviceImpl, this.getView());
        if (serviceImpl.needTitlesTobeSelected() && ids.size() == 0) {
            callback.onFailure((Throwable)new RuntimeException(this.getDisplayConstants().atLeastOneTitleSelectionRequired()));
            return;
        }
        IActionInput input = this.getView().getInputToExecution();
        if (serviceImpl instanceof ITitleAssetActionService) {
            Map<Long, List<Long>> titleAssetIdsMap = this.getTitleAssetIdsMap();
            ((ITitleAssetActionService)serviceImpl).executeAddAssets(titleAssetIdsMap, (String)this.getParameterList().getSelectedItem(), input, (AsyncCallback)callback);
        } else if (serviceImpl.getConfirmation()) {
            this.getView().show(false);
            this.getConfirmation(serviceImpl, ids, input, callback);
        } else {
            serviceImpl.execute(ids, (String)this.getParameterList().getSelectedItem(), input, (AsyncCallback)callback);
        }
    }

    private Map<Long, List<Long>> getTitleAssetIdsMap() {
        HashMap<Long, List<Long>> titleAssetIdsMap = new HashMap<Long, List<Long>>();
        ExpandingFeature expandingFeature = this.titleListPanel.getAssetTable().getExpandingFeature();
        if (expandingFeature != null) {
            ExpandingProvider expandingProvider = expandingFeature.getExpandingProvider();
            List titlesList = this.titleListPanel.getAssetTable().getRecords();
            for (TitleRecord titleRecord : titlesList) {
                List selectedIdsByParent = expandingProvider.getSelectedRecords((Record)titleRecord);
                for (Record r : selectedIdsByParent) {
                    this.storeNewPair(titleAssetIdsMap, titleRecord.getKey(), (Long)r.getKey());
                }
            }
        }
        return titleAssetIdsMap;
    }

    private void storeNewPair(Map<Long, List<Long>> titleAssetIdsMap, Long titleId, Long assetId) {
        List<Long> assetIdsList = titleAssetIdsMap.get(titleId);
        if (assetIdsList == null) {
            assetIdsList = new ArrayList<Long>(1);
            titleAssetIdsMap.put(titleId, assetIdsList);
        }
        assetIdsList.add(assetId);
    }
}

