/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.title.UiTitleCriteriaService;
import com.tandbergtv.cms.portal.content.client.rpc.title.UiTitleCriteriaServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchColumnPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchNotFoundException;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchPanelBase;
import com.tandbergtv.cms.portal.content.client.tab.search.SelectionValidationException;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchEvent;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchNameUniqueException;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.SearchOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleSearch;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleSearchBase;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiSortInfo;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class AdvancedSearchPanel
extends SearchPanelBase {
    private static final String STYLE_ADVANCED_SEARCH_PANEL = "advanced-search-panel";
    private static final String SPACING_STYLE = "search-criteria-spacing";
    private static final String SAVE_SEARCH_PANEL_STYLE = "save-search-panel";
    private CriteriaListingPanel criteriaListingPanel;
    private CheckBoxWidget shareSearch;
    private TextBoxWidget searchName;
    private ButtonWidget saveSearchButton;
    private ButtonWidget copySearchButton;
    private LabelWidget copyIndicator;
    private UITitleSearchBase currentEditSearch;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private ContentConstants contentConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private UiTitleCriteriaServiceAsync criteriaService = (UiTitleCriteriaServiceAsync)GWT.create(UiTitleCriteriaService.class);

    public AdvancedSearchPanel(SearchColumnPanel searchColumnPanel, NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
        super(searchColumnPanel, neptuneSecurity, criteriaMode);
        VerticalContainer mainPanel = new VerticalContainer();
        HorizontalContainer saveSearchPanel = new HorizontalContainer();
        this.criteriaListingPanel = new CriteriaListingPanel(criteriaMode, null, (BaseOperator)new SearchOperator());
        this.copyIndicator = new LabelWidget("(" + this.contentConstants.copyIndicatorText() + ")");
        this.copyIndicator.setVisible(false);
        HorizontalContainer innerHorizontalContainer = new HorizontalContainer();
        VerticalContainer innerVerticalContainer = new VerticalContainer();
        HorizontalContainer headerHorizontalContainer = new HorizontalContainer();
        ImageWidget imageWidgetHelp = new ImageWidget("cms_contentmgmt_ui/resources/images/information_black_16px.svg");
        imageWidgetHelp.setVisible(true);
        LabelWidget descLabelWidget = new LabelWidget(this.contentConstants.advancedSearchHeaderDescription());
        descLabelWidget.setWordWrap(false);
        final LabelWidget tipLabelWidget = new LabelWidget(this.contentConstants.advancedSearchTip());
        tipLabelWidget.setVisible(false);
        imageWidgetHelp.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (tipLabelWidget.isVisible()) {
                    tipLabelWidget.setVisible(false);
                } else {
                    tipLabelWidget.setVisible(true);
                }
            }
        });
        headerHorizontalContainer.add((Widget)descLabelWidget);
        headerHorizontalContainer.add((Widget)imageWidgetHelp);
        headerHorizontalContainer.add((Widget)tipLabelWidget);
        mainPanel.add((Widget)headerHorizontalContainer);
        mainPanel.add((Widget)innerHorizontalContainer);
        innerHorizontalContainer.add((Widget)innerVerticalContainer);
        innerHorizontalContainer.add((Widget)searchColumnPanel);
        innerVerticalContainer.add((Widget)this.criteriaListingPanel);
        innerVerticalContainer.add((Widget)saveSearchPanel);
        innerVerticalContainer.add((Widget)this.copyIndicator);
        mainPanel.addStyleName(STYLE_ADVANCED_SEARCH_PANEL);
        mainPanel.setCellHorizontalAlignment((Widget)saveSearchPanel, HasHorizontalAlignment.ALIGN_LEFT);
        LabelWidget searchNameLabel = new LabelWidget(this.contentConstants.searchName());
        saveSearchPanel.add((Widget)searchNameLabel);
        saveSearchPanel.setCellVerticalAlignment((Widget)searchNameLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.searchName = new TextBoxWidget();
        this.searchName.setVisibleLength(50);
        this.searchName.setMaxLength(100);
        this.searchName.addStyleName(SPACING_STYLE);
        saveSearchPanel.add((Widget)this.searchName);
        this.shareSearch = new CheckBoxWidget(this.contentConstants.shareChkBox());
        this.shareSearch.addStyleName(SPACING_STYLE);
        saveSearchPanel.add((Widget)this.shareSearch);
        saveSearchPanel.setCellVerticalAlignment((Widget)this.shareSearch, HasVerticalAlignment.ALIGN_MIDDLE);
        saveSearchPanel.addStyleName(SAVE_SEARCH_PANEL_STYLE);
        this.initWidget((Widget)mainPanel);
        searchColumnPanel.init(new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                AdvancedSearchPanel.this.showErrorMessage(AdvancedSearchPanel.this.contentConstants.errorLoadingColumns());
            }

            public void onNeptuneSuccess(Void result) {
            }
        });
    }

    public ButtonWidget buildSearchButton() {
        ButtonWidget searchButton = new ButtonWidget(this.contentConstants.searchButtonName());
        searchButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!AdvancedSearchPanel.this.validate()) {
                    return;
                }
                AdvancedSearchPanel.this.resetMessageListener();
                TitleSearchEvent searchEvent = new TitleSearchEvent(AdvancedSearchPanel.this.buildFilter(), AdvancedSearchPanel.this.searchColumnPanel.getSelectedColumns());
                AdvancedSearchPanel.this.fireEvent(searchEvent);
            }
        });
        searchButton.removeStyleName("gwt-Button");
        searchButton.addStyleName("ebBtn");
        searchButton.addStyleName("ebBtn_color_darkBlue");
        searchButton.addStyleName("search_button_icon");
        return searchButton;
    }

    public ButtonWidget buildSaveSearchButton() {
        ButtonWidget save = new ButtonWidget(this.contentConstants.saveButton());
        save.removeStyleName("gwt-Button");
        save.addStyleName("ebBtn");
        save.addStyleName("ebBtn_color_green");
        save.addStyleName("save_button_icon");
        save.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int id;
                if (!AdvancedSearchPanel.this.validate()) {
                    return;
                }
                UITitleFilter filter = AdvancedSearchPanel.this.buildFilter();
                String searchNameStr = AdvancedSearchPanel.this.searchName.getValue();
                if (searchNameStr.isEmpty()) {
                    AdvancedSearchPanel.this.showErrorMessage(AdvancedSearchPanel.this.contentConstants.searchNameReq());
                    return;
                }
                if (AdvancedSearchPanel.this.currentEditSearch == null) {
                    AdvancedSearchPanel.this.currentEditSearch = new UITitleSearchBase(-1, "", AdvancedSearchPanel.this.neptuneSecurity.getUsername());
                }
                UITitleSearch search = (id = AdvancedSearchPanel.this.currentEditSearch.getTitleSearchId()) <= 0 ? new UITitleSearch(AdvancedSearchPanel.this.neptuneSecurity.getUsername(), searchNameStr, filter, AdvancedSearchPanel.this.shareSearch.getValue().booleanValue(), AdvancedSearchPanel.this.getSelectedSearchResultsColumns()) : new UITitleSearch(id, AdvancedSearchPanel.this.neptuneSecurity.getUsername(), searchNameStr, filter, AdvancedSearchPanel.this.shareSearch.getValue().booleanValue(), AdvancedSearchPanel.this.getSelectedSearchResultsColumns());
                AdvancedSearchPanel.this.busyIndicator.center();
                AdvancedSearchPanel.this.criteriaService.saveTitleSearch(search, (AsyncCallback<Integer>)new NeptuneAsyncCallback<Integer>(){

                    public void onNeptuneFailure(Throwable caught) {
                        if (caught instanceof TitleSearchNameUniqueException) {
                            AdvancedSearchPanel.this.showErrorMessage(AdvancedSearchPanel.this.contentConstants.errSearchNameUnique());
                        } else {
                            AdvancedSearchPanel.this.showErrorMessage(AdvancedSearchPanel.this.contentConstants.errWhileSaving());
                        }
                        AdvancedSearchPanel.this.busyIndicator.hide();
                    }

                    public void onNeptuneSuccess(Integer titleSearchId) {
                        AdvancedSearchPanel.this.clearCriteria();
                        (this).AdvancedSearchPanel.this.searchTabPanel.showListView();
                        AdvancedSearchPanel.this.showInfoMessage(AdvancedSearchPanel.this.contentConstants.succSearchSave());
                        if (AdvancedSearchPanel.this.busyIndicator.isShowing()) {
                            AdvancedSearchPanel.this.busyIndicator.hide();
                        }
                    }
                });
            }
        });
        return save;
    }

    public ButtonWidget buildCopySearchButton() {
        final ButtonWidget copy = new ButtonWidget(this.contentConstants.copyButton());
        copy.removeStyleName("gwt-Button");
        copy.addStyleName("ebBtn");
        copy.addStyleName("ebBtn_color_green");
        copy.addStyleName("copy_button_icon");
        copy.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!AdvancedSearchPanel.this.validate()) {
                    return;
                }
                int titleSearchId = -1;
                if (AdvancedSearchPanel.this.currentEditSearch != null) {
                    titleSearchId = AdvancedSearchPanel.this.currentEditSearch.getTitleSearchId();
                }
                if (titleSearchId == -1) {
                    AdvancedSearchPanel.this.currentEditSearch = new UITitleSearchBase(-1, "", AdvancedSearchPanel.this.neptuneSecurity.getUsername());
                    AdvancedSearchPanel.this.managePersistanceButton(-1, AdvancedSearchPanel.this.neptuneSecurity.getUsername());
                    if (AdvancedSearchPanel.this.busyIndicator.isShowing()) {
                        AdvancedSearchPanel.this.busyIndicator.hide();
                    }
                } else {
                    UITitleFilter filter = AdvancedSearchPanel.this.buildFilter();
                    String searchNameStr = AdvancedSearchPanel.this.searchName.getValue();
                    AdvancedSearchPanel.this.currentEditSearch = (UITitleSearchBase)new UITitleSearch(AdvancedSearchPanel.this.neptuneSecurity.getUsername(), searchNameStr, filter, AdvancedSearchPanel.this.shareSearch.getValue().booleanValue(), AdvancedSearchPanel.this.getSelectedSearchResultsColumns());
                    AdvancedSearchPanel.this.managePersistanceButton(0, AdvancedSearchPanel.this.neptuneSecurity.getUsername());
                }
                copy.setVisible(false);
                AdvancedSearchPanel.this.copyIndicator.setVisible(true);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        AdvancedSearchPanel.this.searchName.selectAll();
                        AdvancedSearchPanel.this.searchName.setFocus(true);
                    }
                });
            }
        });
        return copy;
    }

    @Override
    public boolean validate() {
        if (this.criteriaListingPanel == null) {
            return false;
        }
        try {
            this.searchColumnPanel.validateSelections();
            return this.criteriaListingPanel.validate();
        }
        catch (SelectionValidationException e) {
            this.searchColumnPanel.showErrorMessage(e.getMessage());
            return false;
        }
    }

    private UITitleFilter buildFilter() {
        if (this.criteriaListingPanel.isEmpty()) {
            return this.getAllTitlesFilter();
        }
        UITitleFilter filter = new UITitleFilter();
        filter.setCriteriaMode(this.criteriaMode);
        UITitleFilterListNode rootNode = this.criteriaListingPanel.getCriteria();
        filter.setRootNode((IUITitleFilterNode)rootNode);
        this.setFilterSortInfo(filter);
        filter.setIncludeCount(true);
        return filter;
    }

    private UITitleFilter getAllTitlesFilter() {
        UITitleFilter filter = new UITitleFilter();
        this.setFilterSortInfo(filter);
        filter.setCriteriaMode(this.criteriaMode);
        filter.setRootNode(null);
        filter.setIncludeCount(true);
        return filter;
    }

    private void setFilterSortInfo(UITitleFilter filter) {
        if (this.getSelectedSortColumn().getFieldType().equals((Object)UIFieldType.ASSET)) {
            filter.getSortInfo().setSortFieldType(UIFieldType.ASSET);
            filter.getSortInfo().setSortColumnSection(this.getSelectedSortColumn().getSectionName());
        } else {
            filter.getSortInfo().setSortFieldType(UIFieldType.PMM_TITLE);
        }
        filter.getSortInfo().setSortColumnName(this.getSelectedSortColumn().getName());
        filter.getSortInfo().setSortOrder(this.getSelectedSortOrder());
    }

    public void loadCriteria(int titleSearchId) {
        this.shareSearch.setValue(Boolean.valueOf(false));
        this.searchName.setText("");
        if (this.copyIndicator != null) {
            this.copyIndicator.setVisible(false);
        }
        this.criteriaListingPanel.resetCriteria();
        if (titleSearchId == -1) {
            this.currentEditSearch = new UITitleSearchBase(-1, "", this.neptuneSecurity.getUsername());
            this.managePersistanceButton(-1, this.neptuneSecurity.getUsername());
            if (this.busyIndicator.isShowing()) {
                this.busyIndicator.hide();
            }
            return;
        }
        if (!this.busyIndicator.isShowing()) {
            this.busyIndicator.center();
        }
        this.criteriaService.getTitleSearch(titleSearchId, (AsyncCallback<UITitleSearch>)new NeptuneAsyncCallback<UITitleSearch>(){

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof SearchNotFoundException) {
                    AdvancedSearchPanel.this.showErrorMessage(AdvancedSearchPanel.this.contentConstants.searchNotFound());
                } else {
                    AdvancedSearchPanel.this.showErrorMessage(AdvancedSearchPanel.this.contentConstants.errorLoadCrit());
                }
                AdvancedSearchPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(UITitleSearch result) {
                String currentUser;
                boolean isSharedSearch = result.isShare();
                String ownerUser = result.getUserName();
                if (ownerUser.equals(currentUser = AdvancedSearchPanel.this.neptuneSecurity.getUsername()) || isSharedSearch) {
                    AdvancedSearchPanel.this.searchName.setText(result.getName());
                    AdvancedSearchPanel.this.shareSearch.setValue(Boolean.valueOf(isSharedSearch));
                    AdvancedSearchPanel.this.criteriaListingPanel.setFilter(result.getTitleFilter().getRootNode());
                    UiColumn sortCol = AdvancedSearchPanel.this.buildUiColumn(result.getTitleFilter().getSortInfo());
                    AdvancedSearchPanel.this.searchColumnPanel.setSelections(result.getDisplayColumns(), sortCol, result.getTitleFilter().getSortInfo().getSortOrder());
                    AdvancedSearchPanel.this.managePersistanceButton(result.getTitleSearchId(), ownerUser);
                    AdvancedSearchPanel.this.currentEditSearch = (UITitleSearchBase)result;
                } else {
                    AdvancedSearchPanel.this.showErrorMessage(AdvancedSearchPanel.this.contentConstants.notAuthorized());
                }
                AdvancedSearchPanel.this.busyIndicator.hide();
            }
        });
    }

    public void clearCriteria() {
        this.loadCriteria(-1);
    }

    private UiColumn buildUiColumn(UiSortInfo sortInfo) {
        UiColumn uic = new UiColumn();
        uic.setName(sortInfo.getSortColumnName());
        uic.setSectionName(sortInfo.getSortColumnSection());
        return uic;
    }

    private void managePersistanceButton(int titleSearchId, String searchOwner) {
        boolean isNewRule;
        boolean ruleBelongsToMe = this.neptuneSecurity.getUsername().equals(searchOwner);
        boolean bl = isNewRule = titleSearchId == -1;
        if (this.saveSearchButton != null) {
            this.saveSearchButton.setVisible(ruleBelongsToMe);
        }
        if (this.copySearchButton != null) {
            this.copySearchButton.setVisible(!isNewRule);
        }
    }

    public ButtonWidget getSaveSearchButton() {
        return this.saveSearchButton;
    }

    public void setSaveSearchButton(ButtonWidget saveSearchButton) {
        this.saveSearchButton = saveSearchButton;
    }

    public ButtonWidget getCopySearchButton() {
        return this.copySearchButton;
    }

    public void setCopySearchButton(ButtonWidget copySearchButton) {
        this.copySearchButton = copySearchButton;
    }
}

