/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.exception.BasicSearchFieldValidationException;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleBasicSearchFieldProvider;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleBasicSearchFieldProviderAsync;
import com.tandbergtv.cms.portal.content.client.tab.search.BasicSearchRowEvent;
import com.tandbergtv.cms.portal.content.client.tab.search.BasicSearchRowHandler;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiBasicSearchField;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSDateRangeWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SimpleRHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueBooleanBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.FloatValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.LongValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BasicSearchRow
extends HorizontalPanel {
    private TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private List<UiBasicSearchField> searchFieldsCache = null;
    private ListBoxWidget<UiBasicSearchField> searchFields;
    private UiBasicSearchField currentSearchField;
    private Label operatorLabel;
    private SimplePanel valueContainer;
    private MessageArea messageArea;

    public BasicSearchRow(final UiCriteriaMode criteriaMode) {
        ITitleBasicSearchFieldProviderAsync sfp = (ITitleBasicSearchFieldProviderAsync)GWT.create(ITitleBasicSearchFieldProvider.class);
        sfp.getBasicSearcFields(criteriaMode, (AsyncCallback<List<UiBasicSearchField>>)new NeptuneAsyncCallback<List<UiBasicSearchField>>(){

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof BasicSearchFieldValidationException) {
                    BasicSearchRow.this.buildUi(criteriaMode);
                    BasicSearchRow.this.messageArea.setErrorMessage(caught.getMessage());
                }
            }

            public void onNeptuneSuccess(List<UiBasicSearchField> result) {
                BasicSearchRow.this.searchFieldsCache = result;
                BasicSearchRow.this.buildUi(criteriaMode);
            }
        });
        this.setSpacing(3);
    }

    private void buildUi(UiCriteriaMode critMode) {
        boolean isSeries = this.isSeries();
        this.searchFields = new ListBoxWidget();
        List pmmFields = PMMFieldProvider.getBasicSearchFields((UiCriteriaMode)critMode);
        for (UiBasicSearchField sf : pmmFields) {
            if (isSeries && sf.getXpath().equalsIgnoreCase("contentClassId")) continue;
            this.searchFields.addItem(sf.getDisplayName(), (Object)sf);
        }
        String complexFieldStr = "";
        if (this.searchFieldsCache != null) {
            for (UiBasicSearchField sf : this.searchFieldsCache) {
                if (!sf.isComplex()) {
                    this.searchFields.addItem(sf.getDisplayName(), (Object)sf);
                    continue;
                }
                complexFieldStr = !complexFieldStr.isEmpty() ? String.valueOf(complexFieldStr) + " ,  " + sf.getXpath() : String.valueOf(complexFieldStr) + "  " + sf.getXpath();
            }
        }
        if (!complexFieldStr.isEmpty()) {
            this.messageArea.setErrorMessage("Complex field defined in configuration file: " + complexFieldStr);
        }
        this.currentSearchField = (UiBasicSearchField)this.searchFields.getSelectedItem();
        this.searchFields.addChangeHandler(this.getSearchFieldsChangeHandler());
        this.add((Widget)this.searchFields);
        this.operatorLabel = new Label(this.myConstants.getString(this.currentSearchField.getDefaultOperator().toString()));
        this.operatorLabel.setWidth("70px");
        this.valueContainer = new SimplePanel();
        this.valueContainer.setWidget((Widget)this.getValueWidget(""));
        this.add((Widget)this.operatorLabel);
        this.setCellHorizontalAlignment((Widget)this.operatorLabel, HasHorizontalAlignment.ALIGN_CENTER);
        this.setCellVerticalAlignment((Widget)this.operatorLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.add((Widget)this.valueContainer);
        this.add((Widget)this.buildRemoveButton());
    }

    private boolean isSeries() {
        if (this.searchFieldsCache != null) {
            for (UiBasicSearchField searchField : this.searchFieldsCache) {
                if (!searchField.getAssetType().equalsIgnoreCase("series")) continue;
                return true;
            }
        }
        return false;
    }

    public HandlerRegistration addBasicSearchRowHandler(BasicSearchRowHandler handler) {
        return this.addHandler(handler, BasicSearchRowEvent.TYPE);
    }

    private Button buildRemoveButton() {
        Button removeButton = new Button();
        removeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BasicSearchRow.this.fireEvent(new BasicSearchRowEvent(BasicSearchRow.this));
            }
        });
        removeButton.removeStyleName("gwt-Button");
        removeButton.addStyleName("deleterow_button_icon");
        return removeButton;
    }

    public boolean validate() {
        return ((RHSValueWidget)this.valueContainer.getWidget()).validate();
    }

    public UITitleFilterValueNode getValue() {
        UiBasicSearchField selectedItem = (UiBasicSearchField)this.searchFields.getSelectedItem();
        UIDataType dataType = selectedItem.getDatatype();
        List value = ((RHSValueWidget)this.valueContainer.getWidget()).getValues();
        BaseOperator operator = selectedItem.getDefaultOperator();
        if (this.operatorLabel.getText().equals(this.myConstants.equal())) {
            operator = BaseOperator.EQUAL;
        }
        return new UITitleFilterValueNode(selectedItem.getXpath(), selectedItem.getAssetType(), selectedItem.getFieldType(), operator, value, operator.getParamType(), false, false, dataType, "", "", "");
    }

    private ChangeHandler getSearchFieldsChangeHandler() {
        return new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                UiBasicSearchField si = (UiBasicSearchField)BasicSearchRow.this.searchFields.getSelectedItem();
                BaseOperator operator = si.getDefaultOperator();
                boolean newItemHasSuggested = BasicSearchRow.this.hasSuggestedValues(si);
                if (newItemHasSuggested) {
                    operator = BaseOperator.EQUAL;
                }
                if (!si.getDatatype().equals((Object)BasicSearchRow.this.currentSearchField.getDatatype()) || newItemHasSuggested || BasicSearchRow.this.hasSuggestedValues(BasicSearchRow.this.currentSearchField)) {
                    BasicSearchRow.this.operatorLabel.setText(BasicSearchRow.this.myConstants.getString(operator.toString()));
                    BasicSearchRow.this.valueContainer.setWidget((Widget)BasicSearchRow.this.getValueWidget(""));
                }
                BasicSearchRow.this.currentSearchField = si;
            }
        };
    }

    private boolean hasSuggestedValues(UiBasicSearchField field) {
        return field.getSuggestedValues() != null || this.getSuggestedValues(field) != null;
    }

    private Map<String, String> getSuggestedValuesMap(UiBasicSearchField field) {
        UIDataType dataType = field.getDatatype();
        if ((dataType.equals((Object)UIDataType.STRING) || dataType.equals((Object)UIDataType.INTEGER) || dataType.equals((Object)UIDataType.FLOAT)) && AssetFieldTreeObject.getFieldOptions() != null) {
            return (Map)AssetFieldTreeObject.getFieldOptions().get(field.getXpath());
        }
        return null;
    }

    private List<UIValueOption> getSuggestedValues(UiBasicSearchField field) {
        if (field.getSuggestedValues() != null) {
            return field.getSuggestedValues();
        }
        ArrayList<UIValueOption> uiOptions = new ArrayList<UIValueOption>();
        Map<String, String> suggValues = this.getSuggestedValuesMap(field);
        if (suggValues == null) {
            return null;
        }
        for (Map.Entry<String, String> option : suggValues.entrySet()) {
            uiOptions.add(new UIValueOption(option.getValue(), option.getKey()));
        }
        return uiOptions;
    }

    private RHSValueWidget getValueWidget(String oldValue) {
        UiBasicSearchField field = (UiBasicSearchField)this.searchFields.getSelectedItem();
        UIDataType dataType = field.getDatatype();
        List<UIValueOption> suggestedValues = this.getSuggestedValues(field);
        SimpleRHSValueWidget rhsValWid = null;
        if (suggestedValues != null) {
            rhsValWid = new SimpleRHSValueWidget((SingleValueWidget)new ValueTextBox((IRulesValidator)new StringValidator(), suggestedValues, field.supportsOther()));
            rhsValWid.setStyleName("basicsearch");
            return rhsValWid;
        }
        switch (dataType) {
            case INTEGER: {
                return new SimpleRHSValueWidget((SingleValueWidget)new ValueTextBox((IRulesValidator)new LongValidator()));
            }
            case FLOAT: {
                return new SimpleRHSValueWidget((SingleValueWidget)new ValueTextBox((IRulesValidator)new FloatValidator()));
            }
            case BOOLEAN: {
                return new SimpleRHSValueWidget((SingleValueWidget)new ValueBooleanBox());
            }
            case DATE: {
                return new RHSDateRangeWidget();
            }
            case TIME: {
                return new SimpleRHSValueWidget((SingleValueWidget)new ValueTextBox((IRulesValidator)new TimeValidator()));
            }
        }
        return new SimpleRHSValueWidget((SingleValueWidget)new ValueTextBox((IRulesValidator)new StringValidator()));
    }

    public MessageArea getMessageArea() {
        return this.messageArea;
    }

    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }
}

