/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.tab.search.BasicSearchRow;
import com.tandbergtv.cms.portal.content.client.tab.search.BasicSearchRowHandler;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchColumnPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SelectionValidationException;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchEvent;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class NewBasicSearchPanel
extends VerticalPanel {
    private static final String STYLE_BASIC_SEARCH_PANEL = "basic-search-panel";
    private ContentConstants myConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private VerticalPanel basicSearchRows;
    private Button search;
    private SearchColumnPanel searchColumnPanel;
    private MessageArea messageArea;
    private UiCriteriaMode criteriaMode;

    public NewBasicSearchPanel(SearchColumnPanel searchColumnPanel, UiCriteriaMode criteriaMode, MessageArea messageArea) {
        this.criteriaMode = criteriaMode;
        this.messageArea = messageArea;
        HorizontalContainer headerHorizontalContainer = new HorizontalContainer();
        ImageWidget imageWidgetHelp = new ImageWidget("cms_contentmgmt_ui/resources/images/information_black_16px.svg");
        imageWidgetHelp.setVisible(true);
        LabelWidget descLabelWidget = new LabelWidget(this.myConstants.basicSearchHeaderDescription());
        descLabelWidget.setWordWrap(false);
        final LabelWidget tipLabelWidget = new LabelWidget(this.myConstants.basicSearchTip());
        tipLabelWidget.setVisible(false);
        imageWidgetHelp.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (tipLabelWidget.isVisible()) {
                    tipLabelWidget.setVisible(false);
                } else {
                    tipLabelWidget.setVisible(true);
                }
            }
        });
        headerHorizontalContainer.add((Widget)descLabelWidget);
        headerHorizontalContainer.add((Widget)imageWidgetHelp);
        headerHorizontalContainer.add((Widget)tipLabelWidget);
        this.add((Widget)headerHorizontalContainer);
        this.basicSearchRows = new VerticalPanel();
        this.addDefaultRow(messageArea);
        this.add((Widget)this.basicSearchRows);
        this.search = this.buildSearchButton();
        this.add((Widget)this.buildAddButton());
        HorizontalPanel buttonPanel = new HorizontalPanel();
        this.add((Widget)buttonPanel);
        this.add((Widget)this.search);
        this.addStyleName(STYLE_BASIC_SEARCH_PANEL);
        this.searchColumnPanel = searchColumnPanel;
    }

    private Button buildAddButton() {
        Button addButton = new Button(this.myConstants.addRow(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                BasicSearchRow newRow = new BasicSearchRow(NewBasicSearchPanel.this.criteriaMode);
                newRow.addBasicSearchRowHandler(NewBasicSearchPanel.this.getRowHandler());
                NewBasicSearchPanel.this.basicSearchRows.add((Widget)newRow);
            }
        });
        addButton.removeStyleName("gwt-Button");
        addButton.addStyleName("ebBtn");
        addButton.addStyleName("addrow_button_icon");
        return addButton;
    }

    private void addDefaultRow(MessageArea messageArea) {
        BasicSearchRow defaultRow = new BasicSearchRow(this.criteriaMode);
        defaultRow.setMessageArea(messageArea);
        defaultRow.addBasicSearchRowHandler(this.getRowHandler());
        this.basicSearchRows.add((Widget)defaultRow);
    }

    private BasicSearchRowHandler getRowHandler() {
        return new BasicSearchRowHandler(){

            @Override
            public void handleRowRemove(BasicSearchRow rowToRemove) {
                NewBasicSearchPanel.this.basicSearchRows.remove((Widget)rowToRemove);
                if (NewBasicSearchPanel.this.basicSearchRows.getWidgetCount() == 0) {
                    NewBasicSearchPanel.this.addDefaultRow(NewBasicSearchPanel.this.messageArea);
                }
            }
        };
    }

    public HandlerRegistration addTitleSearchHandler(TitleSearchHandler handler) {
        return this.addHandler(handler, TitleSearchEvent.TYPE);
    }

    private Button buildSearchButton() {
        Button searchButton = new Button(this.myConstants.searchButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                boolean isValid = true;
                UITitleFilterListNode list = new UITitleFilterListNode();
                for (Widget w : NewBasicSearchPanel.this.basicSearchRows) {
                    BasicSearchRow row = (BasicSearchRow)w;
                    if (!row.validate()) {
                        isValid = false;
                        continue;
                    }
                    list.addItem((IUITitleFilterNode)row.getValue());
                    try {
                        NewBasicSearchPanel.this.searchColumnPanel.validateSelections();
                    }
                    catch (SelectionValidationException e) {
                        isValid = false;
                        NewBasicSearchPanel.this.searchColumnPanel.showErrorMessage(e.getMessage());
                    }
                }
                if (isValid) {
                    UITitleFilter filter = new UITitleFilter();
                    filter.setCriteriaMode(NewBasicSearchPanel.this.criteriaMode);
                    filter.setRootNode((IUITitleFilterNode)list);
                    filter.setIncludeCount(true);
                    NewBasicSearchPanel.this.setFilterSortInfo(filter);
                    TitleSearchEvent searchEvent = new TitleSearchEvent(filter, NewBasicSearchPanel.this.searchColumnPanel.getSelectedColumns());
                    NewBasicSearchPanel.this.fireEvent(searchEvent);
                }
            }
        });
        searchButton.removeStyleName("gwt-Button");
        searchButton.addStyleName("ebBtn");
        searchButton.addStyleName("ebBtn_color_darkBlue");
        searchButton.addStyleName("search_button_icon");
        return searchButton;
    }

    public void reset() {
        this.basicSearchRows.clear();
        this.addDefaultRow(this.messageArea);
    }

    private void setFilterSortInfo(UITitleFilter filter) {
        if (this.searchColumnPanel.getSelectedSortColumn().getFieldType().equals((Object)UIFieldType.ASSET)) {
            filter.getSortInfo().setSortFieldType(UIFieldType.ASSET);
            filter.getSortInfo().setSortColumnSection(this.searchColumnPanel.getSelectedSortColumn().getSectionName());
        } else {
            filter.getSortInfo().setSortFieldType(UIFieldType.PMM_TITLE);
        }
        filter.getSortInfo().setSortColumnName(this.searchColumnPanel.getSelectedSortColumn().getName());
        filter.getSortInfo().setSortOrder(this.searchColumnPanel.getSelectedSortOrder());
    }
}

