/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchColumnPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchPanelBase;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchEvent;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterQuickSearch;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class QuickSearchPanel
extends SearchPanelBase {
    private static final String STYLE_QUICK_SEARCH_PANEL = "quick-search-panel";
    private VerticalContainer verticalContainer;
    private HorizontalContainer horizontalContainer;
    private TextBox quickSearchBox;
    private ContentConstants contentConstants = (ContentConstants)GWT.create(ContentConstants.class);

    public QuickSearchPanel(NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
        this(null, neptuneSecurity, criteriaMode);
    }

    public QuickSearchPanel(SearchColumnPanel searchColumnPanel, NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
        super(searchColumnPanel, neptuneSecurity, criteriaMode);
        this.verticalContainer = new VerticalContainer();
        HorizontalContainer headerHorizontalContainer = new HorizontalContainer();
        ImageWidget imageWidgetHelp = new ImageWidget("cms_contentmgmt_ui/resources/images/information_black_16px.svg");
        imageWidgetHelp.setVisible(true);
        LabelWidget descLabelWidget = new LabelWidget(this.contentConstants.quickSearchHeaderDescription());
        descLabelWidget.setWordWrap(false);
        final LabelWidget tipLabelWidget = new LabelWidget(this.contentConstants.quickSearchTip());
        tipLabelWidget.setVisible(false);
        imageWidgetHelp.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (tipLabelWidget.isVisible()) {
                    tipLabelWidget.setVisible(false);
                } else {
                    tipLabelWidget.setVisible(true);
                }
            }
        });
        headerHorizontalContainer.add((Widget)descLabelWidget);
        headerHorizontalContainer.add((Widget)imageWidgetHelp);
        headerHorizontalContainer.add((Widget)tipLabelWidget);
        this.verticalContainer.add((Widget)headerHorizontalContainer);
        this.horizontalContainer = new HorizontalContainer();
        this.horizontalContainer.setSpacing(10);
        this.horizontalContainer.add((Widget)this.buildQuickSearchBox());
        this.horizontalContainer.add((Widget)this.buildQSGoButton());
        this.verticalContainer.addStyleName(STYLE_QUICK_SEARCH_PANEL);
        this.verticalContainer.add((Widget)this.horizontalContainer);
        this.initWidget((Widget)this.verticalContainer);
    }

    public void resetFocus() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                QuickSearchPanel.this.quickSearchBox.setFocus(true);
            }
        });
    }

    private TextBox buildQuickSearchBox() {
        this.quickSearchBox = new TextBox();
        this.quickSearchBox.setWidth("325px");
        this.quickSearchBox.setMaxLength(255);
        this.quickSearchBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    QuickSearchPanel.this.performQuickSearch();
                }
            }
        });
        return this.quickSearchBox;
    }

    private void performQuickSearch() {
        String value = this.quickSearchBox.getValue().trim();
        if (value.isEmpty()) {
            this.showErrorMessage(this.contentConstants.qsEmptyErr());
            return;
        }
        UITitleFilter filter = new UITitleFilter();
        filter.setCriteriaMode(this.criteriaMode);
        filter.setIncludeCount(true);
        this.setFilterSortInfo(filter);
        filter.setRootNode((IUITitleFilterNode)new UITitleFilterQuickSearch(value));
        TitleSearchEvent searchEvent = new TitleSearchEvent(filter, this.getSelectedSearchResultsColumns());
        this.fireEvent(searchEvent);
    }

    private ButtonWidget buildQSGoButton() {
        ButtonWidget qsGoButton = new ButtonWidget(this.contentConstants.goButton());
        qsGoButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (QuickSearchPanel.this.validate()) {
                    QuickSearchPanel.this.performQuickSearch();
                }
            }
        });
        qsGoButton.removeStyleName("gwt-Button");
        qsGoButton.addStyleName("ebBtn");
        qsGoButton.addStyleName("ebBtn_color_darkBlue");
        qsGoButton.addStyleName("search_button_icon");
        return qsGoButton;
    }

    private void setFilterSortInfo(UITitleFilter filter) {
        if (this.getSelectedSortColumn().getFieldType().equals((Object)UIFieldType.ASSET)) {
            filter.getSortInfo().setSortFieldType(UIFieldType.ASSET);
            filter.getSortInfo().setSortColumnSection(this.getSelectedSortColumn().getSectionName());
        } else {
            filter.getSortInfo().setSortFieldType(UIFieldType.PMM_TITLE);
        }
        filter.getSortInfo().setSortColumnName(this.getSelectedSortColumn().getName());
        filter.getSortInfo().setSortOrder(this.getSelectedSortOrder());
    }
}

