/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.rpc.title.UiTitleCriteriaService;
import com.tandbergtv.cms.portal.content.client.rpc.title.UiTitleCriteriaServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchColumnPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchNotFoundException;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchPanelBase;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchEvent;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleSearch;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleSearchBase;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SavedSearchListPanel
extends SearchPanelBase {
    private static final String STYLE_NAME_SAVED_SEARCHES_TABLE = "saved-searches-table";
    private static final String STYLE_NAME_HEADER_ROW = "saved-searches-table-header";
    private static final String STYLE_NAME_DATA_ROW = "saved-searches-table-data";
    private static final String STYLE_NAME_CHECKBOX_CELL = "saved-searches-cell-checkbox";
    private static final String STYLE_NAME_SEARCH_ID_CELL = "saved-searches-cell-search-id";
    private static final String STYLE_NAME_SEARCH_NAME_CELL = "saved-searches-cell-search-name";
    private static final String STYLE_NAME_SHARED_CELL = "saved-searches-cell-shared";
    private static final String STYLE_NAME_SEARCH_OWNER_CELL = "saved-searches-cell-search-owner";
    private static final String STYLE_NAME_GO_BUTTON_CELL = "saved-searches-cell-button-go";
    private static final String STYLE_NAME_SAVED_SEARCH_HYPERLINK = "saved-search-hyperlink";
    private static final String ROLE_NAME_ADMIN = "Admin";
    private SimpleContainer mainContainer;
    private FlexTable flexTable;
    private List<CheckBoxWidget> checkBoxesList = new ArrayList<CheckBoxWidget>();
    private CheckBoxWidget allCB;
    private Set<Integer> selectedIds = new HashSet<Integer>();
    private BusyIndicator busyIndicator = new BusyIndicator();
    private ContentConstants contentConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private ContentMessages messages = (ContentMessages)GWT.create(ContentMessages.class);
    private UiTitleCriteriaServiceAsync criteriaService = (UiTitleCriteriaServiceAsync)GWT.create(UiTitleCriteriaService.class);

    public SavedSearchListPanel(SearchColumnPanel searchColumnPanel, NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
        super(searchColumnPanel, neptuneSecurity, criteriaMode);
        this.mainContainer = new SimpleContainer();
        VerticalContainer verticalContainer = new VerticalContainer();
        this.mainContainer.setWidget((Widget)verticalContainer);
        HorizontalContainer headerHorizontalContainer = new HorizontalContainer();
        ImageWidget imageWidgetHelp = new ImageWidget("cms_contentmgmt_ui/resources/images/information_black_16px.svg");
        imageWidgetHelp.setVisible(true);
        LabelWidget descLabelWidget = new LabelWidget(this.contentConstants.savedSearchHeaderDescription());
        final LabelWidget tipLabelWidget = new LabelWidget(this.contentConstants.savedSearchTip());
        tipLabelWidget.setVisible(false);
        imageWidgetHelp.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (tipLabelWidget.isVisible()) {
                    tipLabelWidget.setVisible(false);
                } else {
                    tipLabelWidget.setVisible(true);
                }
            }
        });
        headerHorizontalContainer.add((Widget)descLabelWidget);
        descLabelWidget.setWordWrap(false);
        headerHorizontalContainer.add((Widget)imageWidgetHelp);
        headerHorizontalContainer.add((Widget)tipLabelWidget);
        verticalContainer.add((Widget)headerHorizontalContainer);
        this.flexTable = new FlexTable();
        verticalContainer.add((Widget)this.flexTable);
        this.initWidget((Widget)this.mainContainer);
        this.refreshTable();
    }

    public void refresh() {
        this.resetMessageListener();
        this.refreshTable();
    }

    public void refreshTable() {
        this.flexTable.removeAllRows();
        this.selectedIds.clear();
        this.checkBoxesList = new ArrayList<CheckBoxWidget>();
        if (!this.busyIndicator.isShowing()) {
            this.busyIndicator.center();
        }
        this.criteriaService.getTitleSearches(0, 0, this.neptuneSecurity.getUsername(), this.criteriaMode, (AsyncCallback<List<UITitleSearchBase>>)new NeptuneAsyncCallback<List<UITitleSearchBase>>(){

            public void onNeptuneFailure(Throwable caught) {
                SavedSearchListPanel.this.showErrorMessage(SavedSearchListPanel.this.contentConstants.errLoadingSavedSearches());
                SavedSearchListPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(List<UITitleSearchBase> searches) {
                SavedSearchListPanel.this.populateTable(searches);
                if (SavedSearchListPanel.this.busyIndicator.isShowing()) {
                    SavedSearchListPanel.this.busyIndicator.hide();
                }
            }
        });
    }

    public void deleteSelected() {
        this.resetMessageListener();
        if (this.selectedIds.size() > 0) {
            String msg = this.messages.confirmDelSelectedSavedSearch();
            if (Window.confirm((String)msg)) {
                if (!this.busyIndicator.isShowing()) {
                    this.busyIndicator.center();
                }
                this.criteriaService.deleteTitleSearches(this.selectedIds, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneFailure(Throwable caught) {
                        SavedSearchListPanel.this.showErrorMessage(SavedSearchListPanel.this.contentConstants.errWhileDeling());
                        SavedSearchListPanel.this.busyIndicator.hide();
                    }

                    public void onNeptuneSuccess(Void result) {
                        SavedSearchListPanel.this.refreshTable();
                        SavedSearchListPanel.this.showInfoMessage(SavedSearchListPanel.this.contentConstants.successDeleteSearches());
                        if (SavedSearchListPanel.this.busyIndicator.isShowing()) {
                            SavedSearchListPanel.this.busyIndicator.hide();
                        }
                    }
                });
            }
        } else {
            this.showErrorMessage(this.contentConstants.noSearchSelected());
        }
    }

    private void populateTable(List<UITitleSearchBase> searches) {
        this.flexTable.clear();
        this.flexTable.addStyleName(STYLE_NAME_SAVED_SEARCHES_TABLE);
        this.flexTable.getRowFormatter().addStyleName(0, STYLE_NAME_HEADER_ROW);
        this.allCB = new CheckBoxWidget();
        this.allCB.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (SavedSearchListPanel.this.checkBoxesList != null) {
                    for (CheckBoxWidget cb : SavedSearchListPanel.this.checkBoxesList) {
                        cb.setValue((Boolean)event.getValue(), true);
                    }
                }
            }
        });
        this.flexTable.setWidget(0, 0, (Widget)this.allCB);
        this.flexTable.setText(0, 1, this.contentConstants.searchListIDColumnHeader());
        this.flexTable.setText(0, 2, this.contentConstants.searchListNameColumnHeader());
        this.flexTable.setText(0, 3, this.contentConstants.searchListSharedColumnHeader());
        this.flexTable.setText(0, 4, this.contentConstants.searchListOwnerColumnHeader());
        this.flexTable.setText(0, 5, this.contentConstants.searchListGoColumnHeader());
        this.flexTable.getCellFormatter().addStyleName(0, 0, STYLE_NAME_CHECKBOX_CELL);
        int rowIndex = 1;
        UITitleSearchBase empty = new UITitleSearchBase(-1, this.contentConstants.showAllSearch(), this.neptuneSecurity.getUsername());
        this.populateTableRow(empty, rowIndex);
        for (UITitleSearchBase search : searches) {
            this.populateTableRow(search, ++rowIndex);
        }
    }

    private void populateTableRow(final UITitleSearchBase search, int rowNumber) {
        this.flexTable.getRowFormatter().addStyleName(rowNumber, STYLE_NAME_DATA_ROW);
        final int titleSearchId = search.getTitleSearchId();
        boolean isShared = search.isShare();
        String owner = search.getUserName();
        boolean isCurrentUserAdmin = this.neptuneSecurity.isUserInRole(ROLE_NAME_ADMIN);
        boolean isDeletable = false;
        if (isCurrentUserAdmin || this.getCurrentUser().equalsIgnoreCase(owner)) {
            isDeletable = true;
        }
        if (titleSearchId > 0 && isDeletable) {
            CheckBoxWidget cb = new CheckBoxWidget();
            this.flexTable.setWidget(rowNumber, 0, (Widget)cb);
            this.flexTable.getCellFormatter().addStyleName(rowNumber, 0, STYLE_NAME_CHECKBOX_CELL);
            this.checkBoxesList.add(cb);
            cb.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        SavedSearchListPanel.this.selectedIds.add(titleSearchId);
                    } else {
                        SavedSearchListPanel.this.allCB.setValue(Boolean.valueOf(false), false);
                        SavedSearchListPanel.this.selectedIds.remove(titleSearchId);
                    }
                }
            });
        }
        String strTitleSearchId = String.valueOf(titleSearchId);
        if (titleSearchId <= 0) {
            strTitleSearchId = "";
        }
        LabelWidget labelId = new LabelWidget(strTitleSearchId);
        this.flexTable.setWidget(rowNumber, 1, (Widget)labelId);
        this.flexTable.getCellFormatter().addStyleName(rowNumber, 1, STYLE_NAME_SEARCH_ID_CELL);
        labelId.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SavedSearchListPanel.this.goToSavedSearch(titleSearchId);
            }
        });
        LabelWidget labelName = new LabelWidget(search.getName());
        this.flexTable.setWidget(rowNumber, 2, (Widget)labelName);
        this.flexTable.getCellFormatter().addStyleName(rowNumber, 2, STYLE_NAME_SEARCH_NAME_CELL);
        if (titleSearchId > 0) {
            labelName.addStyleName(STYLE_NAME_SAVED_SEARCH_HYPERLINK);
            labelName.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SavedSearchListPanel.this.goToSavedSearch(titleSearchId);
                }
            });
        }
        ImageWidget img = new ImageWidget("cms_contentmgmt_ui/resources/images/tick.png");
        if (titleSearchId == -1 || isShared) {
            this.flexTable.setWidget(rowNumber, 3, (Widget)img);
            this.flexTable.getCellFormatter().addStyleName(rowNumber, 3, STYLE_NAME_SHARED_CELL);
        }
        LabelWidget labelOwner = new LabelWidget(search.getUserName());
        this.flexTable.setWidget(rowNumber, 4, (Widget)labelOwner);
        this.flexTable.getCellFormatter().addStyleName(rowNumber, 4, STYLE_NAME_SEARCH_OWNER_CELL);
        ButtonWidget goButton = new ButtonWidget(this.contentConstants.goButton());
        goButton.removeStyleName("gwt-Button");
        goButton.addStyleName("ebBtn");
        goButton.addStyleName("ebBtn_color_darkBlue");
        goButton.addStyleName("search_button_icon");
        goButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SavedSearchListPanel.this.resetMessageListener();
                if (search.getTitleSearchId() == -1) {
                    if (SavedSearchListPanel.this.validate()) {
                        TitleSearchEvent searchEvent = new TitleSearchEvent(SavedSearchListPanel.this.getAllTitlesFilter(), SavedSearchListPanel.this.getSelectedSearchResultsColumns());
                        SavedSearchListPanel.this.fireEvent(searchEvent);
                    }
                } else {
                    SavedSearchListPanel.this.getFilterAndFireSearch(search);
                }
            }
        });
        this.flexTable.setWidget(rowNumber, 5, (Widget)goButton);
        this.flexTable.getCellFormatter().addStyleName(rowNumber, 5, STYLE_NAME_GO_BUTTON_CELL);
    }

    private void goToSavedSearch(int titleSearchId) {
        this.searchTabPanel.goToSavedSearch(titleSearchId);
    }

    private UITitleFilter getAllTitlesFilter() {
        UITitleFilter filter = new UITitleFilter();
        this.setFilterSortInfo(filter);
        filter.setCriteriaMode(this.criteriaMode);
        filter.setRootNode(null);
        filter.setIncludeCount(true);
        return filter;
    }

    private void setFilterSortInfo(UITitleFilter filter) {
        if (this.getSelectedSortColumn().getFieldType().equals((Object)UIFieldType.ASSET)) {
            filter.getSortInfo().setSortFieldType(UIFieldType.ASSET);
            filter.getSortInfo().setSortColumnSection(this.getSelectedSortColumn().getSectionName());
        } else {
            filter.getSortInfo().setSortFieldType(UIFieldType.PMM_TITLE);
        }
        filter.getSortInfo().setSortColumnName(this.getSelectedSortColumn().getName());
        filter.getSortInfo().setSortOrder(this.getSelectedSortOrder());
    }

    private void getFilterAndFireSearch(UITitleSearchBase search) {
        this.busyIndicator.center();
        this.criteriaService.getTitleSearch(search.getTitleSearchId(), (AsyncCallback<UITitleSearch>)new NeptuneAsyncCallback<UITitleSearch>(){

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof SearchNotFoundException) {
                    SavedSearchListPanel.this.showErrorMessage(SavedSearchListPanel.this.contentConstants.searchNotFound());
                } else {
                    SavedSearchListPanel.this.showErrorMessage(SavedSearchListPanel.this.contentConstants.errRetrievingSearch());
                }
                SavedSearchListPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(UITitleSearch result) {
                SavedSearchListPanel.this.busyIndicator.hide();
                UITitleFilter filter = result.getTitleFilter();
                filter.setIncludeCount(result.getTitleFilter().isCountIncluded());
                List<UiColumn> queryColumns = SavedSearchListPanel.this.searchColumnPanel.getUiColumnsForSavedDisplayColumns(result.getDisplayColumns());
                TitleSearchEvent searchEvent = new TitleSearchEvent(filter, queryColumns);
                SavedSearchListPanel.this.fireEvent(searchEvent);
            }
        });
    }
}

