/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.rpc.title.SearchColumnPreference;
import com.tandbergtv.cms.portal.content.client.rpc.title.SearchPreferenceDisplayColumn;
import com.tandbergtv.cms.portal.content.client.rpc.title.UiTitleCriteriaService;
import com.tandbergtv.cms.portal.content.client.rpc.title.UiTitleCriteriaServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.SearchResultColumnProvider;
import com.tandbergtv.cms.portal.content.client.tab.search.SelectionValidationException;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UISortOrder;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiSortInfo;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWithHiddenNameWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.orderabletable.OrderableTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.orderabletable.TableRow;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SearchColumnPanel
extends VerticalContainer
implements IMessageEmitter {
    private static final String STYLE_PREFERENCES_PANEL = "preferences-panel";
    private static final UISortOrder DEFAULT_SORT_ORDER = UISortOrder.DESCENDING;
    private static int HEADER_ROW = 1;
    private static String SEARCH_COL_NAME = "Columns";
    private final List<String> noOrderColumns = new ArrayList<String>(Arrays.asList("id"));
    OrderableTable displayColTable;
    HorizontalContainer sortByContainer;
    ListBoxWidget<UiColumn> sortByListBox;
    ListBoxWidget<UISortOrder> sortOrderListBox;
    ButtonWidget saveAsPreferencesButton;
    private List<UiColumn> searchResultColumns;
    private List<UiColumn> sortColumns;
    private String defaultInternalSortColumnName;
    private ContentConstants constants = (ContentConstants)GWT.create(ContentConstants.class);
    private ContentMessages messages = (ContentMessages)GWT.create(ContentMessages.class);
    private UiTitleCriteriaServiceAsync criteriaService = (UiTitleCriteriaServiceAsync)GWT.create(UiTitleCriteriaService.class);
    private SearchColumnPreference prefs;
    private static String MISSING_DISPLAY_COL_DELIMITER = ",";
    private static int ID_SORT_POSITION = 0;
    private UiCriteriaMode criteriaMode;
    private IMessageListener messageListener;
    private boolean hasUserDefaultPreferences;
    private boolean hasInstructions;
    private List<CheckBoxWidget> radioGroup = new ArrayList<CheckBoxWidget>();

    public SearchColumnPanel(UiCriteriaMode criteriaMode, boolean hasUserDefaultPreferences, boolean hasInstructions) {
        this.criteriaMode = criteriaMode;
        this.hasUserDefaultPreferences = hasUserDefaultPreferences;
        this.hasInstructions = hasInstructions;
    }

    public void init(final NeptuneAsyncCallback<Void> initCallback) {
        NeptuneAsyncCallback<Void> callback = new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                initCallback.onFailure(caught);
                Window.alert((String)("Failed to initialize Search Column Table. Reason: " + (caught != null ? caught.getMessage() : "")));
            }

            public void onNeptuneSuccess(Void result) {
                SearchColumnPanel.this.initWidgets();
                initCallback.onSuccess(null);
            }
        };
        this.getUserPreferences(this.criteriaMode, callback);
    }

    private void getUserPreferences(UiCriteriaMode criteriaMode, final NeptuneAsyncCallback<Void> callback) {
        this.criteriaService.getSearchColumnPreferences(criteriaMode, (AsyncCallback<SearchColumnPreference>)new NeptuneAsyncCallback<SearchColumnPreference>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(SearchColumnPreference prefs) {
                SearchColumnPanel.this.setPrefs(prefs);
                SearchColumnPanel.this.getColumns((NeptuneAsyncCallback<Void>)callback);
            }
        });
    }

    private void getColumns(final NeptuneAsyncCallback<Void> callback) {
        SearchResultColumnProvider columnProvider = new SearchResultColumnProvider(this.criteriaMode);
        columnProvider.getSearchColumns((AsyncCallback<SearchResultColumnProvider.SearchColumns>)new NeptuneAsyncCallback<SearchResultColumnProvider.SearchColumns>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(SearchResultColumnProvider.SearchColumns result) {
                SearchColumnPanel.this.setColumns(result);
                callback.onNeptuneSuccess(null);
            }
        });
    }

    private void setColumns(SearchResultColumnProvider.SearchColumns cols) {
        this.setSearchResultColumns(cols.getDisplayColumns());
        this.setSortColumns(cols.getSortColumns());
        this.setDefaultInternalSortColumnName(cols.getDefaultInternalSortColumnName());
    }

    private void initWidgets() {
        this.clear();
        this.createTable();
        VerticalContainer chVerticalContainer = new VerticalContainer();
        if (this.hasInstructions) {
            HorizontalContainer headerContainer = new HorizontalContainer();
            ImageWidget imageWidgetHelp = new ImageWidget("cms_contentmgmt_ui/resources/images/information_black_16px.svg");
            imageWidgetHelp.setVisible(true);
            LabelWidget descLabelWidget = new LabelWidget(this.constants.prefrencesHeaderDescription());
            descLabelWidget.setWordWrap(false);
            final LabelWidget noteLabelWidget = this.criteriaMode.equals((Object)UiCriteriaMode.SERIES) ? new LabelWidget(this.constants.prefrencesNoteSeries()) : new LabelWidget(this.constants.prefrencesNote());
            final ArrayList<LabelWidget> subDesc = new ArrayList<LabelWidget>();
            String[] stringArray = this.constants.prefrencesHeaderSubDescriptions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String headerSubDescription = stringArray[n2];
                subDesc.add(new LabelWidget(headerSubDescription));
                ++n2;
            }
            noteLabelWidget.setVisible(false);
            imageWidgetHelp.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (noteLabelWidget.isVisible()) {
                        for (LabelWidget l : subDesc) {
                            l.setVisible(false);
                        }
                        noteLabelWidget.setVisible(false);
                    } else {
                        for (LabelWidget l : subDesc) {
                            l.setVisible(true);
                        }
                        noteLabelWidget.setVisible(true);
                    }
                }
            });
            headerContainer.add((Widget)descLabelWidget);
            headerContainer.add((Widget)imageWidgetHelp);
            VerticalContainer vc = new VerticalContainer();
            chVerticalContainer.add((Widget)headerContainer);
            Iterator iterator = subDesc.iterator();
            while (iterator.hasNext()) {
                LabelWidget l = (LabelWidget)iterator.next();
                l.setVisible(false);
                vc.add((Widget)l);
            }
            vc.add((Widget)noteLabelWidget);
            headerContainer.add((Widget)vc);
            this.add((Widget)chVerticalContainer);
        }
        VerticalContainer prefsVerticalContainer = new VerticalContainer();
        this.add((Widget)prefsVerticalContainer);
        prefsVerticalContainer.add((Widget)this.displayColTable);
        this.buildSortByPanel();
        this.addStyleName(STYLE_PREFERENCES_PANEL);
        HorizontalContainer buttonsContainer = new HorizontalContainer();
        prefsVerticalContainer.add((Widget)buttonsContainer);
        this.saveAsPreferencesButton = new ButtonWidget(this.constants.saveColumnsAsPreferences());
        this.saveAsPreferencesButton.removeStyleName("gwt-Button");
        this.saveAsPreferencesButton.addStyleName("ebBtn");
        this.saveAsPreferencesButton.addStyleName("ebBtn_color_green");
        this.saveAsPreferencesButton.addStyleName("save_button_icon");
        this.saveAsPreferencesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    SearchColumnPanel.this.saveColumnInfo();
                }
                catch (SelectionValidationException e) {
                    SearchColumnPanel.this.showErrorMessage(e.getMessage());
                }
            }
        });
        buttonsContainer.add((Widget)this.saveAsPreferencesButton);
        this.saveAsPreferencesButton.setVisible(this.hasUserDefaultPreferences);
        if (this.prefs != null) {
            ArrayList<UiColumn> selPrefColumns = new ArrayList<UiColumn>();
            for (SearchPreferenceDisplayColumn sc : this.prefs.getSelectedColumns()) {
                UiColumn c = new UiColumn();
                c.setInternalName(sc.getInternalName());
                selPrefColumns.add(c);
            }
            UiColumn selectedSortCol = new UiColumn();
            selectedSortCol.setInternalName(this.prefs.getSortColumn().getInternalName());
            UiColumn missingSortCol = null;
            List<UiColumn> missingCols = this.findMissingDisplayColumns(selPrefColumns);
            if (this.isSortColumnMissing(selectedSortCol)) {
                missingSortCol = selectedSortCol;
            }
            this.notifyMissingSelections(missingCols, missingSortCol);
        }
        this.setSelectionsFromPrefsOrDefault(null, null);
        this.setSortOrderFromPrefs(null);
    }

    private void removeMissingFromPrefsSelections(List<UiColumn> missingCols, UiColumn missingSortCol) {
        if (missingCols != null) {
            block0: for (UiColumn missing : missingCols) {
                for (SearchPreferenceDisplayColumn prefCol : this.prefs.getSelectedColumns()) {
                    if (!prefCol.getInternalName().equals(missing.getInternalName())) continue;
                    this.prefs.getSelectedColumns().remove(prefCol);
                    continue block0;
                }
            }
        }
        if (missingSortCol != null) {
            String idInternalName = ((UiColumn)this.sortByListBox.getItem(ID_SORT_POSITION)).getInternalName();
            SearchPreferenceDisplayColumn defaultSortCol = new SearchPreferenceDisplayColumn(idInternalName);
            this.prefs.setSortColumn(defaultSortCol);
        }
    }

    private void createTable() {
        this.displayColTable = new OrderableTable("", true, true, this.noOrderColumns.size());
        this.displayColTable.addColumn(this.constants.searchResultsColumnName(), SEARCH_COL_NAME);
        this.displayColTable.addColumn(this.constants.searchSortBy(), "Sort");
    }

    private void showSuccessMessage(String message) {
        this.showInfoMessage(message);
    }

    private List<UiColumn> findMissingDisplayColumns(List<UiColumn> displayCols) {
        ArrayList<UiColumn> missingDisplayColumns = new ArrayList<UiColumn>();
        for (UiColumn col : displayCols) {
            boolean foundMatchingResultCol = false;
            for (UiColumn uic : this.getSearchResultColumns()) {
                if (!uic.getInternalName().equals(col.getInternalName())) continue;
                foundMatchingResultCol = true;
                break;
            }
            if (foundMatchingResultCol) continue;
            missingDisplayColumns.add(col);
        }
        return missingDisplayColumns;
    }

    private boolean isSortColumnMissing(UiColumn sortCol) {
        boolean sortColIsMissing = true;
        int i = 0;
        while (i < this.sortByListBox.getItemCount()) {
            if (((UiColumn)this.sortByListBox.getItem(i)).equals((Object)sortCol)) {
                sortColIsMissing = false;
                break;
            }
            ++i;
        }
        return sortColIsMissing;
    }

    private boolean isSelected(UiColumn c, Set<String> internalNames) {
        String internalName = c.getInternalName();
        if (internalNames != null) {
            return internalNames.contains(internalName);
        }
        if (this.prefs != null && this.prefs.getSelectedColumns() != null) {
            for (SearchPreferenceDisplayColumn dc : this.prefs.getSelectedColumns()) {
                if (!internalName.equals(dc.getInternalName())) continue;
                return true;
            }
            return false;
        }
        return c.isSelectedByDefault();
    }

    private void saveColumnInfo() throws SelectionValidationException {
        this.validateSelections();
        ArrayList<SearchPreferenceDisplayColumn> selectedColumns = new ArrayList<SearchPreferenceDisplayColumn>();
        String internalColumnName = "";
        int i = 0;
        while (i < this.displayColTable.getRowCount()) {
            TableRow row = this.displayColTable.getTableRow(i);
            Widget column = this.displayColTable.getWidget(i + HEADER_ROW, SEARCH_COL_NAME);
            if (column instanceof LabelWithHiddenNameWidget) {
                internalColumnName = ((LabelWithHiddenNameWidget)column).getInternalText();
            }
            if (row.isChecked()) {
                SearchPreferenceDisplayColumn c = new SearchPreferenceDisplayColumn(internalColumnName);
                selectedColumns.add(c);
            }
            ++i;
        }
        SearchPreferenceDisplayColumn sortColumn = new SearchPreferenceDisplayColumn(((UiColumn)this.sortByListBox.getSelectedItem()).getInternalName());
        UISortOrder sortOrder = this.getSelectedSortOrder();
        final SearchColumnPreference preference = new SearchColumnPreference(selectedColumns, sortColumn, sortOrder.ordinal());
        this.criteriaService.saveSearchColumnsAsPreference(preference, this.criteriaMode, new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                SearchColumnPanel.this.showErrorMessage(String.valueOf(SearchColumnPanel.this.constants.preferencesNotSaved()) + caught.getLocalizedMessage());
            }

            public void onSuccess(Void result) {
                SearchColumnPanel.this.setPrefs(preference);
                SearchColumnPanel.this.showSuccessMessage(SearchColumnPanel.this.constants.preferencesSaved());
            }
        });
    }

    public void validateSelections() throws SelectionValidationException {
        if (!this.isSortcolumnSelected()) {
            throw new SelectionValidationException(this.constants.sortColumnValidationError());
        }
    }

    private boolean isDragAllowed(UiColumn column) {
        return !this.noOrderColumns.contains(column.getName());
    }

    private void buildSortByPanel() {
        LabelWidget sortByLabel = new LabelWidget("Sort By: ");
        this.sortByListBox = new ListBoxWidget();
        for (UiColumn c : this.getSortColumns()) {
            this.sortByListBox.insertItem(c.getDisplayName(), (Object)c, this.sortByListBox.getItemCount());
        }
        this.setSelectedSortColumn(null);
        this.sortByContainer = new HorizontalContainer();
        this.sortByContainer.add((Widget)sortByLabel);
        this.sortByContainer.add(this.sortByListBox);
        this.sortByContainer.setSpacing(3);
        this.sortOrderListBox = new ListBoxWidget();
        this.sortOrderListBox.insertItem(UISortOrder.ASCENDING.name(), (Object)UISortOrder.ASCENDING, 0);
        this.sortOrderListBox.insertItem(UISortOrder.DESCENDING.name(), (Object)UISortOrder.DESCENDING, 1);
        this.sortOrderListBox.setVisible(false);
        this.sortByListBox.setVisible(false);
        sortByLabel.setVisible(false);
        this.sortByContainer.add(this.sortOrderListBox);
    }

    private void setSelectedSortColumn(UiColumn sortCol) {
        for (UiColumn c : this.getSortColumns()) {
            if (!this.isSelectedForSort(c, sortCol)) continue;
            this.sortByListBox.setSelectedItem((Object)c);
        }
    }

    private void setSortOrderFromPrefs(UISortOrder sortOrder) {
        if (sortOrder != null) {
            this.sortOrderListBox.setSelectedItem((Object)sortOrder);
            return;
        }
        if (this.prefs != null && this.prefs.getSortOrder() != -1) {
            int intSortOrder = this.prefs.getSortOrder();
            switch (intSortOrder) {
                case 0: {
                    this.sortOrderListBox.setSelectedItem((Object)UISortOrder.ASCENDING);
                    break;
                }
                case 1: {
                    this.sortOrderListBox.setSelectedItem((Object)UISortOrder.DESCENDING);
                }
            }
        } else {
            this.sortOrderListBox.setSelectedItem((Object)DEFAULT_SORT_ORDER);
        }
    }

    private boolean isSelectedForSort(UiColumn c, UiColumn sortCol) {
        if (sortCol != null) {
            return sortCol.getInternalName().equals(c.getInternalName());
        }
        if (this.prefs != null && this.prefs.getSortColumn() != null) {
            return this.prefs.getSortColumn().getInternalName().equals(c.getInternalName());
        }
        return false;
    }

    public List<UiColumn> getSearchResultColumns() {
        return this.searchResultColumns;
    }

    public void setSearchResultColumns(List<UiColumn> searchResultColumns) {
        this.searchResultColumns = searchResultColumns;
    }

    public List<UiColumn> getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(List<UiColumn> sortColumns) {
        this.sortColumns = sortColumns;
    }

    public void setPrefs(SearchColumnPreference prefs) {
        if (prefs.getSelectedColumns().size() > 0 && prefs.getSortColumn() != null) {
            this.prefs = prefs;
        }
    }

    public List<UiColumn> getSelectedColumns() {
        ArrayList<UiColumn> selectedCols = new ArrayList<UiColumn>();
        String internalColumnName = "";
        int i = 0;
        while (i < this.displayColTable.getRowCount()) {
            TableRow row = this.displayColTable.getTableRow(i);
            Widget column = this.displayColTable.getWidget(i + HEADER_ROW, SEARCH_COL_NAME);
            if (column instanceof LabelWithHiddenNameWidget) {
                internalColumnName = ((LabelWithHiddenNameWidget)column).getInternalText();
            }
            if (row.isChecked()) {
                selectedCols.add(this.getColumn(internalColumnName));
            }
            ++i;
        }
        return selectedCols;
    }

    private UiColumn getColumn(String internalColumnName) {
        for (UiColumn c : this.searchResultColumns) {
            if (!c.getInternalName().equals(internalColumnName)) continue;
            return c;
        }
        return null;
    }

    public String getDefaultInternalSortColumnName() {
        return this.defaultInternalSortColumnName;
    }

    public void setDefaultInternalSortColumnName(String defaultInternalSortColumnName) {
        this.defaultInternalSortColumnName = defaultInternalSortColumnName;
    }

    public UiColumn getSelectedSortColumn() {
        return (UiColumn)this.sortByListBox.getSelectedItem();
    }

    public UISortOrder getSelectedSortOrder() {
        UISortOrder sortOrder = (UISortOrder)this.sortOrderListBox.getSelectedItem();
        return sortOrder;
    }

    public void registerMessageListener(IMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void showInfoMessage(String infoMsg) {
        if (this.messageListener != null) {
            this.messageListener.setInfoMessage(infoMsg);
        }
    }

    public void showErrorMessage(String errorMessage) {
        if (this.messageListener != null) {
            this.messageListener.setErrorMessage(errorMessage);
        }
    }

    public void resetMessageListener() {
        if (this.messageListener != null) {
            this.messageListener.reset();
        }
    }

    private boolean isSortcolumnSelected() {
        String sortColDisplayName = ((UiColumn)this.sortByListBox.getSelectedItem()).getDisplayName();
        int i = 0;
        while (i < this.displayColTable.getRowCount()) {
            String columnName;
            TableRow row = this.displayColTable.getTableRow(i);
            Widget column = this.displayColTable.getWidget(i + HEADER_ROW, SEARCH_COL_NAME);
            if (column instanceof LabelWithHiddenNameWidget && (columnName = ((LabelWithHiddenNameWidget)column).getText()).equals(sortColDisplayName)) {
                return row.isChecked();
            }
            ++i;
        }
        return false;
    }

    public void setSelections(List<UiColumn> displayCols, UiColumn sortCol, UISortOrder sortOrder) {
        this.displayColTable.clear();
        if (displayCols.isEmpty()) {
            this.setSelectionsFromPrefsOrDefault(null, null);
            this.setSortOrderFromPrefs(null);
            this.setSelectedSortColumn(null);
        } else {
            HashSet<String> enabledInternalColumnNames = new HashSet<String>();
            for (UiColumn col : displayCols) {
                enabledInternalColumnNames.add(col.getInternalName());
            }
            String sortColumnName = null;
            if (sortCol != null && sortCol.getInternalName() != null) {
                sortColumnName = sortCol.getInternalName();
            }
            this.setSelectionsFromPrefsOrDefault(enabledInternalColumnNames, sortColumnName);
            this.setSortOrderFromPrefs(sortOrder);
            this.setSelectedSortColumn(sortCol);
            UiColumn missingSortCol = null;
            List<UiColumn> missingCols = this.findMissingDisplayColumns(displayCols);
            boolean sortColIsMissing = this.isSortColumnMissing(sortCol);
            if (sortColIsMissing) {
                missingSortCol = sortCol;
            }
            this.notifyMissingSelections(missingCols, missingSortCol);
            this.removeDisplayColumnsFromSelection(missingCols, displayCols);
            if (!sortColIsMissing) {
                this.sortByListBox.setSelectedItem((Object)sortCol);
            }
            this.sortOrderListBox.setSelectedItem((Object)sortOrder);
        }
    }

    private void removeDisplayColumnsFromSelection(List<UiColumn> missingCols, List<UiColumn> displayCols) {
        block0: for (UiColumn mCol : missingCols) {
            for (UiColumn dCol : displayCols) {
                if (!mCol.getInternalName().equalsIgnoreCase(dCol.getInternalName())) continue;
                displayCols.remove(dCol);
                continue block0;
            }
        }
    }

    private void notifyMissingSelections(List<UiColumn> missingCols, UiColumn sortCol) {
        if (missingCols != null) {
            StringBuilder mdCols = new StringBuilder();
            if (missingCols.size() > 0) {
                for (UiColumn missingCol : missingCols) {
                    if (mdCols.length() > 0) {
                        mdCols.append(MISSING_DISPLAY_COL_DELIMITER);
                    }
                    mdCols.append(missingCol.getInternalName());
                }
                this.showErrorMessage(this.messages.missingSelectedSearchDisplayColumns(mdCols.toString()));
            }
        }
        if (sortCol != null) {
            this.showErrorMessage(this.messages.missingSelectedSortColumn(sortCol.getInternalName()));
            this.sortByListBox.setSelectedIndex(ID_SORT_POSITION);
        }
    }

    private List<UiColumn> reorderDisplayCols(List<UiColumn> displayCols) {
        ArrayList<UiColumn> uiCols = new ArrayList<UiColumn>();
        this.addSpecialCols(uiCols);
        this.selectSpecialCols(uiCols, displayCols);
        int i = 0;
        while (i < displayCols.size()) {
            if (!this.noOrderColumns.contains(displayCols.get(i).getInternalName())) {
                uiCols.add(displayCols.get(i));
            }
            ++i;
        }
        for (UiColumn c : this.getSearchResultColumns()) {
            boolean selected = false;
            for (UiColumn selCol : displayCols) {
                if (!c.getInternalName().equals(selCol.getInternalName())) continue;
                selCol.setDisplayName(c.getDisplayName());
                selCol.setSelected(true);
                selected = true;
                break;
            }
            if (selected || this.noOrderColumns.contains(c.getInternalName())) continue;
            c.setSelected(false);
            uiCols.add(c);
        }
        return uiCols;
    }

    private void selectSpecialCols(List<UiColumn> uiCols, List<UiColumn> displayCols) {
        block0: for (UiColumn c : uiCols) {
            boolean selected = false;
            for (UiColumn dc : displayCols) {
                if (c.getInternalName().equals(dc.getInternalName())) {
                    selected = true;
                    c.setSelected(true);
                    continue block0;
                }
                if (selected) continue;
                c.setSelected(false);
            }
        }
    }

    private void addSpecialCols(List<UiColumn> uiCols) {
        for (UiColumn c : this.getSearchResultColumns()) {
            if (!c.getInternalName().equals("id")) continue;
            uiCols.add(c);
            break;
        }
    }

    public void setSelectionsFromPrefsOrDefault(Set<String> enabledInternalColumnNames, String sortColumnName) {
        ArrayList<UiColumn> selectedCols = new ArrayList();
        if (sortColumnName == null && this.prefs != null && this.prefs.getSortColumn() != null) {
            sortColumnName = this.prefs.getSortColumn().getInternalName();
        }
        if (this.prefs == null) {
            selectedCols = this.getSearchResultColumns();
        } else {
            int i = 0;
            while (i < this.prefs.getSelectedColumns().size()) {
                UiColumn c = new UiColumn();
                c.setInternalName(this.prefs.getSelectedColumns().get(i).getInternalName());
                selectedCols.add(c);
                ++i;
            }
        }
        List<UiColumn> reorderedDisplayColumns = this.reorderDisplayCols(selectedCols);
        int i = 0;
        while (i < reorderedDisplayColumns.size()) {
            final UiColumn c = reorderedDisplayColumns.get(i);
            LabelWithHiddenNameWidget label = new LabelWithHiddenNameWidget(c.getInternalName(), c.getDisplayName());
            try {
                int intSortOrder;
                boolean dragAllowed = this.isDragAllowed(c);
                boolean isSelected = this.isSelected(c, enabledInternalColumnNames);
                boolean chbkEnabled = !c.getInternalName().equals("id");
                this.displayColTable.addItem(this.displayColTable.getRowCount(), SEARCH_COL_NAME, (Widget)label, "nwt-TableColumnPanel-dataCell-text", dragAllowed, isSelected, chbkEnabled);
                final CheckBoxWidget radio = new CheckBoxWidget();
                this.radioGroup.add(radio);
                radio.setStyleName("gwt-RadioButton");
                radio.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        int j = 0;
                        while (j < SearchColumnPanel.this.sortByListBox.getItemCount()) {
                            if (c.getDisplayName().equalsIgnoreCase(SearchColumnPanel.this.sortByListBox.getItemText(j))) break;
                            ++j;
                        }
                        SearchColumnPanel.this.cleanAllCheckboxValue();
                        radio.setValue(Boolean.valueOf(true));
                        SearchColumnPanel.this.sortByListBox.setSelectedIndex(j);
                    }
                });
                radio.setEnabled(false);
                if (sortColumnName == null) {
                    radio.setValue(Boolean.valueOf(i == 0));
                } else {
                    boolean bVal = c.getInternalName().equals(sortColumnName);
                    radio.setValue(Boolean.valueOf(bVal));
                }
                HorizontalContainer horizontalContainer = new HorizontalContainer();
                final ImageWidget imageWidgetSort = new ImageWidget();
                int n = intSortOrder = this.prefs != null ? this.prefs.getSortOrder() : 0;
                if (intSortOrder == 0) {
                    imageWidgetSort.setUrl("cms_contentmgmt_ui/resources/images/sort_ascending.png");
                } else {
                    imageWidgetSort.setUrl("cms_contentmgmt_ui/resources/images/sort_descending.png");
                }
                imageWidgetSort.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (((UISortOrder)SearchColumnPanel.this.sortOrderListBox.getSelectedItem()).toString().equals(UISortOrder.ASCENDING.toString())) {
                            SearchColumnPanel.this.sortOrderListBox.setSelectedItem((Object)UISortOrder.DESCENDING);
                            imageWidgetSort.setUrl("cms_contentmgmt_ui/resources/images/sort_descending.png");
                        } else {
                            SearchColumnPanel.this.sortOrderListBox.setSelectedItem((Object)UISortOrder.ASCENDING);
                            imageWidgetSort.setUrl("cms_contentmgmt_ui/resources/images/sort_ascending.png");
                        }
                    }
                });
                LabelWidget lb = new LabelWidget("Sort By:");
                lb.addStyleName("table-header-nonSortable-text");
                horizontalContainer.add((Widget)lb);
                horizontalContainer.add((Widget)imageWidgetSort);
                if (i == 0) {
                    this.displayColTable.addItem(i - 1, "Sort", (Widget)horizontalContainer, null);
                    this.displayColTable.addItem(i, "Sort", (Widget)radio, null);
                } else {
                    this.displayColTable.addItem(i, "Sort", (Widget)radio, null);
                }
                int j = 0;
                while (j < this.sortByListBox.getItemCount()) {
                    if (c.getDisplayName().equalsIgnoreCase(this.sortByListBox.getItemText(j))) {
                        radio.setEnabled(true);
                        break;
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String msg = "Error populating table: ";
                this.showErrorMessage(String.valueOf(msg) + e.getMessage());
                throw new RuntimeException("Error populating table", e);
            }
            ++i;
        }
    }

    public void clearMessages() {
        this.resetMessageListener();
    }

    private void cleanAllCheckboxValue() {
        for (CheckBoxWidget cb : this.radioGroup) {
            cb.setValue(Boolean.valueOf(false));
        }
    }

    public List<UiColumn> getUiColumnsForSavedDisplayColumns(List<UiColumn> savedCols) {
        ArrayList<UiColumn> displayCols = new ArrayList<UiColumn>();
        if (savedCols.isEmpty()) {
            for (UiColumn dc : this.getSearchResultColumns()) {
                if (!this.isSelected(dc, null)) continue;
                displayCols.add(dc);
            }
        } else {
            int i = 0;
            while (i < savedCols.size()) {
                for (UiColumn c : this.searchResultColumns) {
                    if (!c.getInternalName().equalsIgnoreCase(savedCols.get(i).getInternalName())) continue;
                    displayCols.add(c);
                    break;
                }
                ++i;
            }
        }
        return displayCols;
    }

    public UiColumn getUiColumnForSavedSortColumn(UiSortInfo savedCol) {
        for (UiColumn c : this.sortColumns) {
            if (!c.getName().equalsIgnoreCase(savedCol.getSortColumnName())) continue;
            if (c.getSectionName() == null && savedCol.getSortColumnSection() == null) {
                return c;
            }
            if (c.getSectionName() == null || savedCol.getSortColumnSection() == null || !c.getSectionName().equalsIgnoreCase(savedCol.getSortColumnSection())) continue;
            return c;
        }
        return null;
    }

    public void clearSelections() {
        this.displayColTable.clear();
    }
}

