/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchColumnPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchTabPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SelectionValidationException;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchEvent;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UISortOrder;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiSortInfo;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import java.util.List;

public class SearchPanelBase
extends Composite
implements IMessageEmitter {
    protected NeptuneSecurity neptuneSecurity;
    protected UiCriteriaMode criteriaMode;
    protected IMessageListener messageListener;
    protected SearchColumnPanel searchColumnPanel;
    protected SearchTabPanel searchTabPanel;

    public SearchPanelBase(NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
        this(null, neptuneSecurity, criteriaMode);
    }

    public SearchPanelBase(SearchColumnPanel searchColumnPanel, NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
        this.searchColumnPanel = searchColumnPanel;
        this.neptuneSecurity = neptuneSecurity;
        this.criteriaMode = criteriaMode;
    }

    public void registerMessageListener(IMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void showInfoMessage(String infoMsg) {
        if (this.messageListener != null) {
            this.messageListener.setInfoMessage(infoMsg);
        }
    }

    public void showErrorMessage(String errorMessage) {
        if (this.messageListener != null) {
            this.messageListener.setErrorMessage(errorMessage);
        }
    }

    public void resetMessageListener() {
        if (this.messageListener != null) {
            this.messageListener.reset();
        }
    }

    public List<UiColumn> getDisplayColumns() {
        return this.searchColumnPanel.getSearchResultColumns();
    }

    public List<UiColumn> getSelectedSearchResultsColumns() {
        return this.searchColumnPanel.getSelectedColumns();
    }

    public UiColumn getSelectedSortColumn() {
        return this.searchColumnPanel.getSelectedSortColumn();
    }

    public UISortOrder getSelectedSortOrder() {
        return this.searchColumnPanel.getSelectedSortOrder();
    }

    public UiColumn getSortColumn(UiSortInfo partialSortInfo) {
        return this.searchColumnPanel.getUiColumnForSavedSortColumn(partialSortInfo);
    }

    public HandlerRegistration addTitleSearchHandler(TitleSearchHandler handler) {
        return this.addHandler(handler, TitleSearchEvent.TYPE);
    }

    protected SearchTabPanel getSearchTabPanel() {
        return this.searchTabPanel;
    }

    protected void setSearchTabPanel(SearchTabPanel searchTabPanel) {
        this.searchTabPanel = searchTabPanel;
    }

    public String getCurrentUser() {
        return this.neptuneSecurity.getUsername();
    }

    public boolean validate() {
        boolean isValid = false;
        try {
            this.searchColumnPanel.validateSelections();
            isValid = true;
        }
        catch (SelectionValidationException e) {
            this.searchColumnPanel.showErrorMessage(e.getMessage());
        }
        return isValid;
    }
}

