/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiServiceItem;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionListDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.TitleListButtonClickListener;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IResizable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import java.util.Iterator;
import java.util.List;

public class SearchResultsPanel
extends Composite {
    private static final String STYLE_NAME_SEARCH_RESULTS_PANEL = "search-results-panel";
    private VerticalContainer mainContainer;
    HeaderPanel headerPanel;
    private TitleListPanel titleListPanel;
    private boolean isSeries;
    private ButtonWidget goButton;
    private ButtonWidget cancelButton;
    private ListBoxWidget<String> actionsListBox;
    private ListBoxWidget<String> parameterListBox;
    private ListBoxWidget<String> multiSelectParameterListBox;
    TitleListButtonClickListener actionButtonHandler = null;
    boolean useMultiSelectParameters = false;
    private ServiceMap serviceMap = new ServiceMap();
    private ServiceLoader serviceLoader;
    private ContentConstants contentConstants = (ContentConstants)GWT.create(ContentConstants.class);

    public SearchResultsPanel(TitleListPanel titleListPanel, boolean isSeries) {
        this.titleListPanel = titleListPanel;
        this.isSeries = isSeries;
        this.serviceLoader = NeptuneApplication.getApplication().getServiceLoader();
        this.headerPanel = !isSeries ? new HeaderPanel(this.contentConstants.advancedSearchResultsLabel()) : new HeaderPanel(this.contentConstants.seriesSearchResultsLabel());
        this.headerPanel.setStyleName("content-header-style");
        String tabTitle = this.contentConstants.searchResultsTabTitle();
        String anchorPrefix = "Content.Search.Results";
        ResizableContainer resizableContainer = new ResizableContainer((Widget)titleListPanel, tabTitle, anchorPrefix);
        resizableContainer.addHeightOffsettingWidget((Widget)this.headerPanel);
        resizableContainer.getTabContainer().getTabBar().setVisible(false);
        this.mainContainer = new VerticalContainer();
        this.mainContainer.addStyleName(STYLE_NAME_SEARCH_RESULTS_PANEL);
        this.mainContainer.add((Widget)this.headerPanel);
        this.mainContainer.add((Widget)resizableContainer);
        this.initWidget((Widget)this.mainContainer);
        this.actionsListBox = new ListBoxWidget(false);
        this.parameterListBox = new ListBoxWidget(false);
        this.parameterListBox.setVisible(false);
        this.multiSelectParameterListBox = new ListBoxWidget(true);
        this.multiSelectParameterListBox.setVisible(false);
        this.cancelButton = new ButtonWidget(this.contentConstants.cancelButtonName());
        this.cancelButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchResultsPanel.this.cancelClickedAction();
            }
        });
        this.goButton = new ButtonWidget(this.contentConstants.applyButton());
        this.actionButtonHandler = new TitleListButtonClickListener(this.actionsListBox, this.parameterListBox, titleListPanel, this.serviceMap);
        this.goButton.addClickHandler((ClickHandler)this.actionButtonHandler);
        this.goButton.removeStyleName("gwt-Button");
        this.goButton.addStyleName("ebBtn");
        this.goButton.addStyleName("ebBtn_color_green");
        this.buildActionsListWidgets((IResizable)resizableContainer);
        resizableContainer.addButton(tabTitle, this.cancelButton);
        resizableContainer.addBottomWidget(tabTitle, this.actionsListBox);
        resizableContainer.addBottomWidget(tabTitle, this.parameterListBox);
        resizableContainer.addBottomWidget(tabTitle, this.multiSelectParameterListBox);
        resizableContainer.addButton(tabTitle, this.goButton);
        resizableContainer.updateSize();
    }

    private void buildActionsListWidgets(final IResizable resizable) {
        ActionListDataProvider<ITitleService> listItemProvider = new ActionListDataProvider<ITitleService>(ITitleService.class, this.serviceLoader, this.isSeries);
        for (UiServiceItem item : listItemProvider.getItems(this.serviceMap)) {
            this.actionsListBox.addItem(item.getName(), (Object)item.getClassName());
        }
        this.actionsListBox.setSelectedIndex(listItemProvider.getSelectedItemIndex(this.serviceMap, this.titleListPanel.getInput()));
        String displayName = this.actionsListBox.getItemText(this.actionsListBox.getSelectedIndex());
        if (displayName.trim().isEmpty()) {
            this.setWidgetsForNoAction();
        }
        this.actionsListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SearchResultsPanel.this.parameterListBox.setVisible(false);
                SearchResultsPanel.this.multiSelectParameterListBox.setVisible(false);
                SearchResultsPanel.this.goButton.setEnabled(false);
                int selectedIndex = SearchResultsPanel.this.actionsListBox.getSelectedIndex();
                String displayName = SearchResultsPanel.this.actionsListBox.getItemText(selectedIndex);
                if (displayName.trim().isEmpty()) {
                    SearchResultsPanel.this.setWidgetsForNoAction();
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            resizable.updateSize();
                        }
                    });
                    return;
                }
                ITitleActionService selectedAction = SearchResultsPanel.this.serviceMap.getService(displayName);
                if (selectedAction.getName().equals(SearchResultsPanel.this.contentConstants.runTargetSitesServiceName()) || selectedAction.getName().equals(SearchResultsPanel.this.contentConstants.satelitePitchBottomServiceName()) || selectedAction.getName().equals(SearchResultsPanel.this.contentConstants.satelitePitchTopServiceName()) || selectedAction.getName().equals(SearchResultsPanel.this.contentConstants.terrestrialPitchBottomServiceName()) || selectedAction.getName().equals(SearchResultsPanel.this.contentConstants.terrestrialPitchTopServiceName())) {
                    SearchResultsPanel.this.useMultiSelectParameters = true;
                    SearchResultsPanel.this.actionButtonHandler.setParameterList((ListBoxWidget<String>)SearchResultsPanel.this.multiSelectParameterListBox);
                } else {
                    SearchResultsPanel.this.useMultiSelectParameters = false;
                    SearchResultsPanel.this.actionButtonHandler.setParameterList((ListBoxWidget<String>)SearchResultsPanel.this.parameterListBox);
                }
                selectedAction.getServiceParameters((NeptuneAsyncCallback)new NeptuneAsyncCallback<List<String>>(){

                    public void onNeptuneFailure(Throwable caught) {
                        SearchResultsPanel.this.parameterListBox.setVisible(false);
                        SearchResultsPanel.this.multiSelectParameterListBox.setVisible(false);
                        SearchResultsPanel.this.titleListPanel.reportFailure(caught);
                    }

                    public void onNeptuneSuccess(List<String> result) {
                        if (result != null) {
                            if (!(this).SearchResultsPanel.this.useMultiSelectParameters) {
                                this.setParameterList((ListBoxWidget<String>)SearchResultsPanel.this.parameterListBox, result);
                                SearchResultsPanel.this.parameterListBox.setVisible(true);
                                SearchResultsPanel.this.multiSelectParameterListBox.setVisible(false);
                            } else {
                                this.setParameterList((ListBoxWidget<String>)SearchResultsPanel.this.multiSelectParameterListBox, result);
                                SearchResultsPanel.this.parameterListBox.setVisible(false);
                                SearchResultsPanel.this.multiSelectParameterListBox.setVisible(true);
                            }
                        }
                        SearchResultsPanel.this.goButton.setEnabled(true);
                        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                            public void execute() {
                                resizable.updateSize();
                            }
                        });
                    }
                });
            }

            private void setParameterList(ListBoxWidget<String> listBox, List<String> parameters) {
                listBox.clear();
                Iterator<String> iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    String p;
                    String name = p = iterator.next();
                    String value = p;
                    if (p != null && p.contains("ParamSeparator")) {
                        String[] pArray = p.split("ParamSeparator");
                        if (pArray.length > 0) {
                            name = pArray[0];
                        }
                        if (pArray.length > 1) {
                            value = pArray[1];
                        }
                    }
                    listBox.addItem(name, (Object)value);
                }
            }
        });
        resizable.updateSize();
    }

    private void cancelClickedAction() {
        this.titleListPanel.getAnchorChangeNotifier().anchorChanged("");
        this.titleListPanel.fireEvent((GwtEvent)new ViewCancelEvent());
    }

    private void setWidgetsForNoAction() {
        this.actionsListBox.setSelectedItem((Object)"");
        this.parameterListBox.clear();
        this.parameterListBox.setVisible(false);
        this.goButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
    }
}

