/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.tab.search.AdvancedSearchPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.MessageEmitterSimpleContainer;
import com.tandbergtv.cms.portal.content.client.tab.search.NewBasicSearchPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.QuickSearchPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SavedSearchListPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchColumnPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchEvent;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldProviderResults;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.ContentClassInfo;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.IContentClassProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.IContentClassProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiSortInfo;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import java.util.List;
import java.util.Map;

public class SearchTabPanel
extends Composite {
    private ResizableContainer resizableContainer;
    private NeptuneSecurity neptuneSecurity;
    private UiCriteriaMode criteriaMode;
    private MessageArea messageArea;
    private QuickSearchPanel quickSearchPanel;
    private NewBasicSearchPanel basicSearchPanel;
    private AdvancedSearchPanel advancedSearchPanel;
    private AdvancedSearchPanel savedSearchPanel;
    private SavedSearchListPanel savedSearchListPanel;
    private SimpleContainer savedSearchListWrapper;
    private SearchColumnPanel searchColumnPanel;
    private SearchColumnPanel advancedSearchColumnPanel;
    private SearchColumnPanel savedSearchColumnPanel;
    private ContentConstants contentConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private final IContentClassProviderAsync contentClassProvider = (IContentClassProviderAsync)GWT.create(IContentClassProvider.class);
    final ButtonWidget createSavedSearchButton = new ButtonWidget(this.contentConstants.createButton());
    final ButtonWidget deleteSavedSearchButton = new ButtonWidget(this.contentConstants.delButton());
    final ButtonWidget cancelSavedSearchButton = new ButtonWidget(this.contentConstants.cancelButtonName());
    private ButtonWidget searchSavedSearchButton;
    private ButtonWidget searchAdvancedSearchButton;
    private ButtonWidget saveAdvancedSearchButton;
    final ButtonWidget saveSavedSearchButton;
    private ButtonWidget copySavedSearchButton;
    private BusyIndicator busyIndicator = new BusyIndicator();

    public SearchTabPanel(NeptuneSecurity neptuneSecurity, UiCriteriaMode criteriaMode) {
        this.neptuneSecurity = neptuneSecurity;
        this.criteriaMode = criteriaMode;
        this.messageArea = new MessageArea();
        this.messageArea.reset();
        this.searchColumnPanel = new SearchColumnPanel(criteriaMode, true, true);
        this.advancedSearchColumnPanel = new SearchColumnPanel(criteriaMode, false, false);
        this.savedSearchColumnPanel = new SearchColumnPanel(criteriaMode, false, false);
        String anchorPrefix = "Content.Search";
        if (UiCriteriaMode.SERIES.equals((Object)criteriaMode)) {
            anchorPrefix = "Content.SeriesSearch";
        }
        this.savedSearchListPanel = new SavedSearchListPanel(this.searchColumnPanel, neptuneSecurity, criteriaMode);
        String savedSearchTabTitle = this.contentConstants.savedTabTitle();
        this.savedSearchListPanel.setSearchTabPanel(this);
        this.savedSearchPanel = new AdvancedSearchPanel(this.savedSearchColumnPanel, neptuneSecurity, criteriaMode);
        this.savedSearchPanel.setSearchTabPanel(this);
        this.savedSearchListWrapper = new MessageEmitterSimpleContainer();
        this.savedSearchListWrapper.setWidget((Widget)this.savedSearchListPanel);
        this.resizableContainer = new ResizableContainer((Widget)this.savedSearchListWrapper, savedSearchTabTitle, anchorPrefix, this.messageArea);
        this.initWidget((Widget)this.resizableContainer);
        this.savedSearchColumnPanel.registerMessageListener((IMessageListener)this.resizableContainer);
        this.savedSearchPanel.registerMessageListener((IMessageListener)this.resizableContainer);
        this.quickSearchPanel = new QuickSearchPanel(this.searchColumnPanel, neptuneSecurity, criteriaMode);
        this.resizableContainer.addTab((Widget)this.quickSearchPanel, this.contentConstants.quickSearchTabTitle());
        this.basicSearchPanel = new NewBasicSearchPanel(this.searchColumnPanel, criteriaMode, this.messageArea);
        this.resizableContainer.addTab((Widget)this.basicSearchPanel, this.contentConstants.basicSearchHeader());
        this.advancedSearchPanel = new AdvancedSearchPanel(this.advancedSearchColumnPanel, neptuneSecurity, criteriaMode);
        this.resizableContainer.addTab((Widget)this.advancedSearchPanel, this.contentConstants.advancedSearchHeader());
        this.advancedSearchPanel.setSearchTabPanel(this);
        this.advancedSearchColumnPanel.registerMessageListener((IMessageListener)this.resizableContainer);
        this.resizableContainer.addTab((Widget)this.searchColumnPanel, this.contentConstants.preferencesTabTitle());
        this.resizableContainer.reset();
        TabContainer tabContainer = this.resizableContainer.getTabContainer();
        tabContainer.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                int selectedTabIndex = (Integer)event.getSelectedItem();
                switch (selectedTabIndex) {
                    case 0: {
                        SearchTabPanel.this.savedSearchListWrapper.getWidget();
                        break;
                    }
                    case 1: {
                        SearchTabPanel.this.quickSearchPanel.resetMessageListener();
                        SearchTabPanel.this.quickSearchPanel.resetFocus();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        SearchTabPanel.this.advancedSearchPanel.resetMessageListener();
                    }
                    case 4: {
                        SearchTabPanel.this.searchColumnPanel.init(new NeptuneAsyncCallback<Void>(){

                            public void onNeptuneFailure(Throwable caught) {
                                SearchTabPanel.this.messageArea.setErrorMessage(SearchTabPanel.this.contentConstants.errorLoadingColumns());
                            }

                            public void onNeptuneSuccess(Void result) {
                            }
                        });
                    }
                }
            }
        });
        this.resizableContainer.addButton(savedSearchTabTitle, this.createSavedSearchButton);
        this.createSavedSearchButton.removeStyleName("gwt-Button");
        this.createSavedSearchButton.addStyleName("ebBtn");
        this.createSavedSearchButton.addStyleName("ebBtn_color_green");
        this.createSavedSearchButton.addStyleName("create_button_icon");
        this.createSavedSearchButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchTabPanel.this.goToSavedSearch(-1);
            }
        });
        this.resizableContainer.addButton(savedSearchTabTitle, this.deleteSavedSearchButton);
        this.deleteSavedSearchButton.removeStyleName("gwt-Button");
        this.deleteSavedSearchButton.addStyleName("ebBtn");
        this.deleteSavedSearchButton.addStyleName("delete_button_icon");
        this.deleteSavedSearchButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchTabPanel.this.savedSearchListPanel.deleteSelected();
            }
        });
        this.saveSavedSearchButton = this.savedSearchPanel.buildSaveSearchButton();
        this.savedSearchPanel.setSaveSearchButton(this.saveSavedSearchButton);
        this.resizableContainer.addButton(savedSearchTabTitle, this.saveSavedSearchButton);
        this.saveSavedSearchButton.setVisible(false);
        this.searchSavedSearchButton = this.savedSearchPanel.buildSearchButton();
        this.resizableContainer.addButton(savedSearchTabTitle, this.searchSavedSearchButton);
        this.searchSavedSearchButton.setVisible(false);
        this.copySavedSearchButton = this.savedSearchPanel.buildCopySearchButton();
        this.savedSearchPanel.setCopySearchButton(this.copySavedSearchButton);
        this.resizableContainer.addButton(savedSearchTabTitle, this.copySavedSearchButton);
        this.copySavedSearchButton.setVisible(false);
        this.resizableContainer.addButton(savedSearchTabTitle, this.cancelSavedSearchButton);
        this.cancelSavedSearchButton.removeStyleName("gwt-Button");
        this.cancelSavedSearchButton.addStyleName("ebBtn");
        this.cancelSavedSearchButton.setVisible(false);
        this.cancelSavedSearchButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchTabPanel.this.showListView();
            }
        });
        this.searchAdvancedSearchButton = this.advancedSearchPanel.buildSearchButton();
        this.resizableContainer.addButton(this.contentConstants.advancedSearchHeader(), this.searchAdvancedSearchButton);
        this.saveAdvancedSearchButton = this.advancedSearchPanel.buildSaveSearchButton();
        this.advancedSearchPanel.setSaveSearchButton(this.saveAdvancedSearchButton);
        this.resizableContainer.addButton(this.contentConstants.advancedSearchHeader(), this.saveAdvancedSearchButton);
        this.initializeAssetTreeObj();
    }

    public ResizableContainer getResizableContainer() {
        return this.resizableContainer;
    }

    public void addHeightOffsettingWidget(Widget w) {
        this.resizableContainer.addHeightOffsettingWidget(w);
    }

    public void setOffsetHeight(int offsetHeight) {
        this.resizableContainer.setOffsetHeight(offsetHeight);
    }

    public HandlerRegistration addTitleSearchHandler(TitleSearchHandler handler) {
        if (this.savedSearchPanel != null) {
            this.savedSearchPanel.addTitleSearchHandler(handler);
        }
        if (this.quickSearchPanel != null) {
            this.quickSearchPanel.addTitleSearchHandler(handler);
        }
        if (this.basicSearchPanel != null) {
            this.basicSearchPanel.addTitleSearchHandler(handler);
        }
        if (this.advancedSearchPanel != null) {
            this.advancedSearchPanel.addTitleSearchHandler(handler);
        }
        if (this.savedSearchListPanel != null) {
            this.savedSearchListPanel.addTitleSearchHandler(handler);
        }
        return this.addHandler(handler, TitleSearchEvent.TYPE);
    }

    private void initializeAssetTreeObj() {
        AssetTreeObject.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                SearchTabPanel.this.messageArea.setErrorMessage(SearchTabPanel.this.contentConstants.errorLoadingSpec());
            }

            public void onNeptuneSuccess(Void result) {
                SearchTabPanel.this.loadSearchColumns();
            }
        });
    }

    private void loadSearchColumns() {
        this.searchColumnPanel.init(new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                SearchTabPanel.this.messageArea.setErrorMessage(SearchTabPanel.this.contentConstants.errorLoadingColumns());
            }

            public void onNeptuneSuccess(Void result) {
                SearchTabPanel.this.loadContentClasses();
            }
        });
    }

    private void loadContentClasses() {
        this.contentClassProvider.getContentClassInfo((AsyncCallback)new NeptuneAsyncCallback<ContentClassInfo>(){

            public void onNeptuneFailure(Throwable caught) {
                SearchTabPanel.this.messageArea.setErrorMessage(SearchTabPanel.this.contentConstants.errorLoadingContentClasses());
            }

            public void onNeptuneSuccess(ContentClassInfo result) {
                SearchTabPanel.this.loadSpecification();
                PMMFieldProvider.setContentClasses((List)result.getContentClasses());
                AssetFieldTreeObject.setFieldOptions((Map)result.getContentClassOptions());
            }
        });
    }

    private void loadSpecification() {
        IMdmFieldProviderAsync specManagerService = (IMdmFieldProviderAsync)GWT.create(IMdmFieldProvider.class);
        specManagerService.getFields(TreeCreator.getSpecLastUpdateDate(), (AsyncCallback)new NeptuneAsyncCallback<FieldProviderResults>(){

            public void onNeptuneFailure(Throwable caught) {
                SearchTabPanel.this.messageArea.setErrorMessage(SearchTabPanel.this.contentConstants.errorLoadingSpec());
                SearchTabPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(FieldProviderResults result) {
                if (result.requiresUpdate()) {
                    TreeCreator.setSpec((FieldProviderResults)result);
                }
                SearchTabPanel.this.buildUi();
            }
        });
    }

    private void buildUi() {
        this.basicSearchPanel.reset();
    }

    public UiColumn getSortColumn(UiSortInfo partialSortInfo) {
        return this.searchColumnPanel.getUiColumnForSavedSortColumn(partialSortInfo);
    }

    public AdvancedSearchPanel getAdvancedSearchPanel() {
        return this.advancedSearchPanel;
    }

    public void selectTab(String tabTitle) {
        this.resizableContainer.selectTab(tabTitle);
    }

    public void goToSavedSearch(final int titleSearchId) {
        this.savedSearchColumnPanel.init(new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                SearchTabPanel.this.messageArea.setErrorMessage(SearchTabPanel.this.contentConstants.errorLoadingColumns());
            }

            public void onNeptuneSuccess(Void result) {
                SearchTabPanel.this.showSearchView(titleSearchId);
            }
        });
    }

    public void showListView() {
        this.selectTab(this.contentConstants.savedTabTitle());
        this.savedSearchListWrapper.setWidget((Widget)this.savedSearchListPanel);
        this.savedSearchListPanel.refreshTable();
        this.createSavedSearchButton.setVisible(true);
        this.deleteSavedSearchButton.setVisible(true);
        this.cancelSavedSearchButton.setVisible(false);
        this.saveSavedSearchButton.setVisible(false);
        this.searchSavedSearchButton.setVisible(false);
        this.copySavedSearchButton.setVisible(false);
    }

    public void showSearchView(int titleSearchId) {
        this.selectTab(this.contentConstants.savedTabTitle());
        this.savedSearchPanel.loadCriteria(titleSearchId);
        this.savedSearchListWrapper.setWidget((Widget)this.savedSearchPanel);
        this.createSavedSearchButton.setVisible(false);
        this.deleteSavedSearchButton.setVisible(false);
        this.cancelSavedSearchButton.setVisible(true);
        this.saveSavedSearchButton.setVisible(true);
        this.searchSavedSearchButton.setVisible(true);
        if (titleSearchId > 0) {
            this.copySavedSearchButton.setVisible(true);
        } else {
            this.copySavedSearchButton.setVisible(false);
        }
    }

    static /* synthetic */ AdvancedSearchPanel access$0(SearchTabPanel searchTabPanel) {
        return searchTabPanel.savedSearchPanel;
    }
}

