/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.NoPartnersException;
import com.tandbergtv.cms.portal.content.client.model.UiInvalidQwikSrchException;
import com.tandbergtv.cms.portal.content.client.tab.list.ResultsLoadedHandler;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListViewInput;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchResultsPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchTabPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchEvent;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterQuickSearch;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiSortInfo;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;

public class TitleSearchPanel
extends SimpleContainer {
    private final NeptuneSecurity security;
    private final TitleListViewInput titleListViewInput;
    private Long requestKey;
    private String action;
    private String listOfAssetIds;
    private String tab;
    private Integer searchId;
    private WidgetMenuItem.AnchorChangeListener anchorChangeNotifier;
    private SimpleContainer searchPanel;
    private SimpleContainer criteriaPanelWrapper;
    private SearchTabPanel searchTabPanel;
    private SimpleContainer searchResultPanelWrapper;
    private HeaderPanel headerPanel;
    private ContentConstants myConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private UiCriteriaMode criteriaMode;

    public TitleSearchPanel(NeptuneSecurity security, UiCriteriaMode criteriaMode) {
        this.security = security;
        this.criteriaMode = criteriaMode;
        this.titleListViewInput = new TitleListViewInput(0L, 0L, 0L, 0L);
        this.initialize();
    }

    private void initialize() {
        this.searchPanel = new SimpleContainer();
        this.searchResultPanelWrapper = new SimpleContainer();
        VerticalContainer containerPanel = new VerticalContainer();
        containerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        containerPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        containerPanel.setSpacing(5);
        containerPanel.setWidth("100%");
        if (this.criteriaMode == UiCriteriaMode.EPISODE) {
            this.headerPanel = new HeaderPanel(this.myConstants.advancedSearchLabel());
        } else if (this.criteriaMode == UiCriteriaMode.SERIES) {
            this.headerPanel = new HeaderPanel(this.myConstants.seriesAdvancedSearchLabel());
        }
        this.headerPanel.getLabel().setStyleName("content-search-header-style");
        containerPanel.add((Widget)this.headerPanel);
        this.criteriaPanelWrapper = new SimpleContainer();
        this.criteriaPanelWrapper.setWidget((Widget)new LabelWidget());
        containerPanel.add((Widget)this.criteriaPanelWrapper);
        this.searchPanel.setWidget((Widget)containerPanel);
        this.searchResultPanelWrapper.setWidget((Widget)new LabelWidget(""));
        this.setWidget((Widget)this.searchPanel);
    }

    public void reset() {
        this.titleListViewInput.resetInfo();
        this.requestKey = null;
        this.action = null;
        this.listOfAssetIds = null;
        this.showSearchView();
    }

    public void showSearchView() {
        this.searchResultPanelWrapper.clear();
        this.searchTabPanel = new SearchTabPanel(this.security, this.criteriaMode);
        this.searchTabPanel.addHeightOffsettingWidget((Widget)this.headerPanel);
        this.searchTabPanel.setOffsetHeight(20);
        this.searchTabPanel.addTitleSearchHandler(this.getSearchHandler());
        this.criteriaPanelWrapper.setWidget((Widget)this.searchTabPanel);
        this.setWidget((Widget)this.searchPanel);
    }

    public void showPopulatedSearchPanel() {
        this.setWidget((Widget)this.searchPanel);
    }

    public void showSearchResultsView() {
        this.setWidget((Widget)this.searchResultPanelWrapper);
    }

    boolean isShowingSearchResultsView() {
        return this.getWidget() != null && this.getWidget() == this.searchResultPanelWrapper;
    }

    void setSearchResultsView(Widget widget) {
        this.searchResultPanelWrapper.setWidget(widget);
    }

    Widget getSearchResultsView() {
        return this.searchResultPanelWrapper.getWidget();
    }

    private TitleSearchHandler getSearchHandler() {
        TitleSearchHandler searchHandler = new TitleSearchHandler(){

            @Override
            public void search(TitleSearchEvent event) {
                UITitleFilter filter = event.getTitleFilter();
                boolean isQuickSearch = false;
                if (filter.getRootNode() instanceof UITitleFilterQuickSearch) {
                    isQuickSearch = true;
                }
                if (!TitleSearchPanel.this.security.isUserInRole("AssetManagement_View")) {
                    Window.alert((String)"User is not authorized to search for assets.");
                    throw new RuntimeException("User is not authorized to search for assets.");
                }
                ResultsLoadedHandler handler = new ResultsLoadedHandler(){

                    @Override
                    public void resultsFailedToLoad(Throwable caught) {
                        if (caught instanceof NoPartnersException) {
                            TitleSearchPanel.this.searchTabPanel.getResizableContainer().setErrorMessage(TitleSearchPanel.this.myConstants.noParntersErrMsg());
                        } else if (caught instanceof UiInvalidQwikSrchException) {
                            String message = caught.getMessage();
                            if (message == null || message.isEmpty()) {
                                message = "Server error.";
                            }
                            TitleSearchPanel.this.searchTabPanel.getResizableContainer().setErrorMessage(message);
                        } else {
                            TitleSearchPanel.this.showSearchResultsView();
                            TitleSearchPanel.this.getAnchorChangeNotifier().anchorChanged("Results");
                        }
                    }

                    @Override
                    public void resultsLoaded() {
                        TitleSearchPanel.this.showSearchResultsView();
                        TitleSearchPanel.this.getAnchorChangeNotifier().anchorChanged("Results");
                    }
                };
                UiSortInfo sInfo = event.getTitleFilter().getSortInfo();
                boolean isSeries = false;
                if (TitleSearchPanel.this.criteriaMode == UiCriteriaMode.SERIES) {
                    isSeries = true;
                }
                TitleListPanel titleListPanel = new TitleListPanel(TitleSearchPanel.this.getAnchorChangeNotifier(), filter, TitleSearchPanel.this.getTitleListViewInput(), TitleSearchPanel.this.getRequestKey(), TitleSearchPanel.this.getAction(), TitleSearchPanel.this.getListOfAssetIds(), null, isQuickSearch, isSeries, handler, event.getDisplayColumns(), TitleSearchPanel.this.searchTabPanel.getSortColumn(sInfo), sInfo.getSortOrder(), TitleSearchPanel.this.searchResultPanelWrapper);
                SearchResultsPanel searchResultsPanel = new SearchResultsPanel(titleListPanel, isSeries);
                TitleSearchPanel.this.searchResultPanelWrapper.setWidget((Widget)searchResultsPanel);
                titleListPanel.setSearchResultsPanel(searchResultsPanel);
                titleListPanel.addViewCancelHandler(new ViewCancelHandler(){

                    public void onCancel(ViewCancelEvent event) {
                        TitleSearchPanel.this.showPopulatedSearchPanel();
                    }
                });
            }
        };
        return searchHandler;
    }

    public Long getRequestKey() {
        return this.requestKey;
    }

    public void setRequestKey(Long requestKey) {
        this.requestKey = requestKey;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getListOfAssetIds() {
        return this.listOfAssetIds;
    }

    public void setListOfAssetIds(String listOfAssetIds) {
        this.listOfAssetIds = listOfAssetIds;
    }

    public String getTab() {
        return this.tab;
    }

    public void setTab(String tab) {
        this.tab = tab;
    }

    public Integer getSearchId() {
        return this.searchId;
    }

    public void setSearchId(Integer searchId) {
        this.searchId = searchId;
    }

    public TitleListViewInput getTitleListViewInput() {
        return this.titleListViewInput;
    }

    public NeptuneSecurity getSecurity() {
        return this.security;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeNotifier() {
        return this.anchorChangeNotifier;
    }

    public void setAnchorChangeNotifier(WidgetMenuItem.AnchorChangeListener anchorChangeNotifier) {
        this.anchorChangeNotifier = anchorChangeNotifier;
    }
}

