/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchPanel;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.series.SeriesTitleView;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;
import java.util.HashMap;
import java.util.Map;

class TitleSearchView
extends LazyView {
    private TitleSearchPanel widget = null;
    private WidgetMenuItem.AnchorChangeListener anchorChangeNotifier;
    private UiCriteriaMode criteriaMode;
    private static final String SCHEDULE_ID = "scheduleId";
    private static final String TITLE_LIST_ID = "titleListId";
    private static final String LICENSE_ID = "licenseId";
    private static final String OFFER_ID = "offerTitleId";
    private static final String ACTION = "action";
    private static final String REQUEST_KEY = "request_key";
    private static final String TITLE_ID = "titleId";
    private static final String LIST_OF_ASSET_IDS = "listOfAssetIds";
    private static final String CONTENT_SEARCH_ANCHOR = "Content.Search";
    private static final String RETURN_ANCHOR = "returnAnchor";

    public TitleSearchView(UiCriteriaMode criteriaMode) {
        this.criteriaMode = criteriaMode;
    }

    protected Widget createWidget() {
        this.widget = new TitleSearchPanel(ClientAuthorizationManager.getSecurity(), this.criteriaMode);
        if (this.anchorChangeNotifier != null) {
            this.widget.setAnchorChangeNotifier(this.anchorChangeNotifier);
        }
        return this.widget;
    }

    public String getAnchor() {
        if (this.widget == null) {
            return null;
        }
        if (this.widget.isShowingSearchResultsView()) {
            Widget searchResultWidget = this.widget.getSearchResultsView();
            if (searchResultWidget instanceof TitleView) {
                return ((TitleView)searchResultWidget).getAnchor();
            }
            return "Results";
        }
        HashMap<String, String> anchorTokens = new HashMap<String, String>();
        if (this.widget.getTitleListViewInput().getScheduleId() != 0L) {
            long scheduleId = this.widget.getTitleListViewInput().getScheduleId();
            anchorTokens.put(SCHEDULE_ID, String.valueOf(scheduleId));
        }
        if (this.widget.getTitleListViewInput().getTitleListId() != 0L) {
            long titleListId = this.widget.getTitleListViewInput().getTitleListId();
            anchorTokens.put(TITLE_LIST_ID, String.valueOf(titleListId));
        }
        if (this.widget.getTitleListViewInput().getLicenseId() != 0L) {
            long licenseId = this.widget.getTitleListViewInput().getLicenseId();
            anchorTokens.put(LICENSE_ID, String.valueOf(licenseId));
        }
        if (this.widget.getTitleListViewInput().getOfferTitleId() != 0L) {
            long offerTitleId = this.widget.getTitleListViewInput().getOfferTitleId();
            anchorTokens.put(OFFER_ID, String.valueOf(offerTitleId));
        }
        if (this.widget.getRequestKey() != null) {
            anchorTokens.put(REQUEST_KEY, this.widget.getRequestKey().toString());
            if (this.widget.getAction() != null) {
                anchorTokens.put(ACTION, this.widget.getAction());
            }
            if (this.widget.getListOfAssetIds() != null) {
                anchorTokens.put(LIST_OF_ASSET_IDS, this.widget.getListOfAssetIds());
            }
        }
        return new AnchorTokenizer().buildAnchor(anchorTokens);
    }

    public void setWidgetAnchor(String anchor) {
        AnchorTokenizer tokenizer;
        Map anchorTokens;
        this.widget.reset();
        if (anchor != null && anchor.startsWith("?")) {
            anchor = anchor.substring(1);
        }
        if ((anchorTokens = (tokenizer = new AnchorTokenizer()).parseAnchor(anchor)).containsKey(TITLE_ID)) {
            anchor = this.transformAnchor(tokenizer, anchorTokens);
        }
        if (anchorTokens.containsKey("Id")) {
            String returnAnchor = (String)anchorTokens.get(RETURN_ANCHOR);
            TitleViewEventHandler titleViewEventHandler = new TitleViewEventHandler(returnAnchor);
            TitleView titleView = this.criteriaMode == UiCriteriaMode.SERIES ? new SeriesTitleView() : new TitleView();
            titleView.addViewCancelHandler(titleViewEventHandler);
            titleView.addViewAnchorChangeHandler(titleViewEventHandler);
            titleView.setAnchor(anchor);
            this.widget.setSearchResultsView((Widget)titleView);
            this.widget.showSearchResultsView();
        } else {
            Long scheduleId = this.getLongValue((String)anchorTokens.get(SCHEDULE_ID));
            Long titleListId = this.getLongValue((String)anchorTokens.get(TITLE_LIST_ID));
            Long licenseId = this.getLongValue((String)anchorTokens.get(LICENSE_ID));
            Long offerTitleId = this.getLongValue((String)anchorTokens.get(OFFER_ID));
            String action = (String)anchorTokens.get(ACTION);
            Long requestKey = this.getLongValue((String)anchorTokens.get(REQUEST_KEY));
            String listOfAssetIds = (String)anchorTokens.get(LIST_OF_ASSET_IDS);
            if (scheduleId != null) {
                this.widget.getTitleListViewInput().setScheduleId(scheduleId);
            }
            if (titleListId != null) {
                this.widget.getTitleListViewInput().setTitleListId(titleListId);
            }
            if (licenseId != null) {
                this.widget.getTitleListViewInput().setLicenseId(licenseId);
            }
            if (offerTitleId != null) {
                this.widget.getTitleListViewInput().setOfferTitleId(offerTitleId);
            }
            this.widget.setRequestKey(requestKey);
            if (requestKey != null) {
                this.widget.setAction(action);
                this.widget.setListOfAssetIds(listOfAssetIds);
            }
        }
    }

    private String transformAnchor(AnchorTokenizer tokenizer, Map<String, String> anchorTokens) {
        this.renameMapKey(anchorTokens, TITLE_ID, "Id");
        this.renameMapKey(anchorTokens, ACTION, "Action");
        this.renameMapKey(anchorTokens, REQUEST_KEY, "RequestKey");
        this.renameMapKey(anchorTokens, LIST_OF_ASSET_IDS, "AssetIDs");
        return tokenizer.buildAnchor(anchorTokens);
    }

    private void renameMapKey(Map<String, String> map, String oldKey, String newKey) {
        if (map.containsKey(oldKey)) {
            String value = map.remove(oldKey);
            map.put(newKey, value);
        }
    }

    private Long getLongValue(String longValue) {
        if (longValue != null && longValue.trim().length() > 0) {
            try {
                return new Long(longValue);
            }
            catch (RuntimeException runtimeException) {}
        }
        return null;
    }

    public TitleSearchPanel getTitleSearchPanel() {
        return this.widget;
    }

    void setAnchorChangeNotifier(WidgetMenuItem.AnchorChangeListener anchorChangeListener) {
        this.anchorChangeNotifier = anchorChangeListener;
        if (this.widget != null) {
            this.widget.setAnchorChangeNotifier(this.anchorChangeNotifier);
        }
    }

    private final class TitleViewEventHandler
    implements ViewCancelHandler,
    ViewAnchorChangeHandler {
        private String returnAnchor;

        public TitleViewEventHandler(String returnAnchor) {
            this.returnAnchor = returnAnchor == null || returnAnchor.isEmpty() ? TitleSearchView.CONTENT_SEARCH_ANCHOR : returnAnchor;
        }

        public void onCancel(ViewCancelEvent event) {
            History.newItem((String)this.returnAnchor);
        }

        public void onAnchorChange(ViewAnchorChangeEvent event) {
            TitleSearchView.this.delegateViewAnchorChangeEvent(event);
        }
    }
}

