/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.IUIAssetVisitor;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import java.util.ArrayList;
import java.util.List;

public abstract class UIAsset
implements IsSerializable,
ICopyable {
    private static final String ROOT_FIELD_NAME = "Metadata";
    private Long id;
    private UIAsset parentAsset;
    private Long originalAssetId;
    private Integer originalAssetRevision;
    private boolean active = true;
    private UIComplexField rootField;
    private boolean thumbnailAvailable;
    private List<UIAssetFile> files = new ArrayList<UIAssetFile>();
    private String version;

    public UIAsset() {
        this.rootField = new UIComplexField();
        this.rootField.setParentAsset(this);
        this.rootField.setName(ROOT_FIELD_NAME);
        this.thumbnailAvailable = false;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOriginalAssetId() {
        return this.originalAssetId;
    }

    public void setOriginalAssetId(Long originalAssetId) {
        this.originalAssetId = originalAssetId;
    }

    public Integer getOriginalAssetRevision() {
        return this.originalAssetRevision;
    }

    public void setOriginalAssetRevision(Integer originalAssetRevision) {
        this.originalAssetRevision = originalAssetRevision;
    }

    public UIAsset getRootAsset() {
        return this.parentAsset != null ? this.parentAsset.getRootAsset() : this;
    }

    public UIAsset getParentAsset() {
        return this.parentAsset;
    }

    public void setParentAsset(UIAsset parentAsset) {
        this.parentAsset = parentAsset;
    }

    public abstract String getAssetType();

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isThumbnailAvailable() {
        return this.thumbnailAvailable;
    }

    public void setThumbnailAvailable(boolean thumbnailAvailable) {
        this.thumbnailAvailable = thumbnailAvailable;
    }

    public UIComplexField getRootField() {
        return this.rootField;
    }

    public List<UIAssetFile> getFiles() {
        return this.files;
    }

    public void addFile(UIAssetFile file) {
        file.setParentAsset(this);
        if (!this.files.contains(file)) {
            this.files.add(file);
        }
    }

    public boolean removeFile(UIAssetFile file) {
        boolean result = this.files.remove(file);
        if (result) {
            file.setParentAsset(null);
        }
        return result;
    }

    @Override
    public abstract UIAsset createCopy();

    protected void copyProperties(UIAsset copy) {
        copy.setId(this.getId());
        copy.setActive(this.isActive());
        copy.setOriginalAssetId(this.getOriginalAssetId());
        copy.setOriginalAssetRevision(this.getOriginalAssetRevision());
        copy.setThumbnailAvailable(this.isThumbnailAvailable());
        copy.rootField = this.rootField.createCopy();
        for (UIAssetFile file : this.getFiles()) {
            copy.addFile(file.createCopy());
        }
    }

    public abstract void accept(IUIAssetVisitor var1);

    public void clearFields() {
        List<UIAsset> assets;
        this.getRootField().getChildren().removeAll();
        if (this instanceof UIGroupAsset && (assets = ((UIGroupAsset)this).getChildren().getAll()) != null) {
            for (UIAsset asset : assets) {
                asset.clearFields();
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

