/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.IUIAssetMap;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.IUIAssetVisitor;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetMap;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIItemAsset;
import java.util.ArrayList;
import java.util.List;

public class UIGroupAsset
extends UIAsset {
    private String assetType;
    private IUIAssetMap children = new UIAssetMap();
    private Long seriesDocumentId;
    private Long seasonAssetId;
    private List<Long> refTitleIds;

    @Override
    public String getAssetType() {
        return this.assetType;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public IUIAssetMap getChildren() {
        return this.children;
    }

    public void setChildren(IUIAssetMap children) {
        if (children != null) {
            for (UIAsset asset : children.getAll()) {
                asset.setParentAsset(this);
            }
        }
        this.children = children != null ? children : new UIAssetMap();
    }

    public List<UIItemAsset> getChildItems(String assetType) {
        return this.children.getItems(assetType);
    }

    public List<UIGroupAsset> getChildGroups(String assetType) {
        return this.children.getGroups(assetType);
    }

    public void addChild(UIAsset asset) {
        if (asset != null) {
            asset.setParentAsset(this);
            this.children.addAsset(asset);
        }
    }

    public boolean removeChild(UIAsset asset) {
        boolean removed = this.children.removeAsset(asset);
        if (removed) {
            asset.setParentAsset(null);
        }
        return removed;
    }

    @Override
    public UIGroupAsset createCopy() {
        UIGroupAsset copy = new UIGroupAsset();
        this.copyProperties(copy);
        return copy;
    }

    protected void copyProperties(UIGroupAsset copy) {
        super.copyProperties(copy);
        copy.setAssetType(this.getAssetType());
        for (UIAsset child : this.getChildren().getAll()) {
            copy.addChild(child.createCopy());
        }
    }

    @Override
    public void accept(IUIAssetVisitor visitor) {
        visitor.visit(this);
    }

    public Long getSeriesDocumentId() {
        return this.seriesDocumentId;
    }

    public void setSeriesDocumentId(Long seriesDocumentId) {
        this.seriesDocumentId = seriesDocumentId;
    }

    public Long getSeasonAssetId() {
        return this.seasonAssetId;
    }

    public void setSeasonAssetId(Long seasonAssetId) {
        this.seasonAssetId = seasonAssetId;
    }

    public void addReferencedTitleId(Long titleId) {
        if (this.refTitleIds == null) {
            this.refTitleIds = new ArrayList<Long>();
        }
        this.refTitleIds.add(titleId);
    }

    public void removeReferencedTitleId(Long titleId) {
        this.refTitleIds.remove(titleId);
    }

    public List<Long> getReferencedTitleIds() {
        return this.refTitleIds;
    }

    public void setReferencedTitleIds(List<Long> titleIds) {
        this.refTitleIds = titleIds;
    }
}

