/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.model.sites;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIActiveDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UILocalTitleSites;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITrackingSiteItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class UITitleSites
implements IsSerializable,
ICopyable {
    List<UIDistributionSiteItem> distributionSiteItems = new ArrayList<UIDistributionSiteItem>();
    Map<String, List<UITrackingSiteItem>> trackingSiteLookUp = new TreeMap<String, List<UITrackingSiteItem>>();
    List<UIActiveDistributionSiteItem> activeDistributionSiteItems = new ArrayList<UIActiveDistributionSiteItem>();
    private Long titleId = null;
    private UILocalTitleSites local = null;
    private Set<String> activeSiteNames = new TreeSet<String>();
    private Set<String> inactiveSiteNames = new TreeSet<String>();

    public UILocalTitleSites getLocal() {
        return this.local;
    }

    public void setLocal(UILocalTitleSites local) {
        this.local = local;
    }

    public List<UIActiveDistributionSiteItem> getActiveDistributionSiteItems() {
        return this.activeDistributionSiteItems;
    }

    public void setActiveDistributionSiteItems(List<UIActiveDistributionSiteItem> activeDistributionSiteItems) {
        this.activeDistributionSiteItems = activeDistributionSiteItems;
    }

    public List<UIDistributionSiteItem> getDistributionSiteItems() {
        return this.distributionSiteItems;
    }

    public void setDistributionSiteItems(List<UIDistributionSiteItem> distSiteItems) {
        this.distributionSiteItems = distSiteItems != null ? distSiteItems : new ArrayList();
    }

    public Long getTitleId() {
        return this.titleId;
    }

    public void setTitleId(Long masterTitleId) {
        this.titleId = masterTitleId;
    }

    public Set<String> getActiveSiteNames() {
        return this.activeSiteNames;
    }

    public void setActiveSiteNames(Set<String> activeSiteNames) {
        this.activeSiteNames = activeSiteNames;
    }

    public Set<String> getInactiveSiteNames() {
        return this.inactiveSiteNames;
    }

    public void setInactiveSiteNames(Set<String> inactiveSiteNames) {
        this.inactiveSiteNames = inactiveSiteNames;
    }

    @Override
    public UITitleSites createCopy() {
        UITitleSites copy = new UITitleSites();
        copy.setTitleId(this.getTitleId());
        for (UIDistributionSiteItem distSiteItem : this.getDistributionSiteItems()) {
            copy.getDistributionSiteItems().add(distSiteItem.createCopy());
        }
        for (String key : this.trackingSiteLookUp.keySet()) {
            List<UITrackingSiteItem> val = this.trackingSiteLookUp.get(key);
            copy.getTrackingSiteLookUp().put(key, val);
        }
        for (String activeSiteName : this.activeSiteNames) {
            copy.getActiveSiteNames().add(activeSiteName);
        }
        for (String inactiveSiteName : this.inactiveSiteNames) {
            copy.getInactiveSiteNames().add(inactiveSiteName);
        }
        return copy;
    }

    public Map<String, List<UITrackingSiteItem>> getTrackingSiteLookUp() {
        return this.trackingSiteLookUp;
    }

    public void setTrackingSiteLookUp(Map<String, List<UITrackingSiteItem>> trackingSiteLookUp) {
        this.trackingSiteLookUp = trackingSiteLookUp;
    }

    public List<UITrackingSiteItem> getPagedTrackingSiteItems(String distributionSite, int startIndexForPage, int pageSize) {
        ArrayList<UITrackingSiteItem> trackingSiteItemsForPage = new ArrayList<UITrackingSiteItem>();
        List<UITrackingSiteItem> items = null;
        if (distributionSite == null && this.trackingSiteLookUp.values() != null) {
            Collection<List<UITrackingSiteItem>> allItems = this.trackingSiteLookUp.values();
            Iterator<List<UITrackingSiteItem>> iter = allItems.iterator();
            items = new ArrayList<UITrackingSiteItem>();
            while (iter.hasNext()) {
                items.addAll((Collection<UITrackingSiteItem>)iter.next());
            }
        } else {
            items = this.trackingSiteLookUp.get(distributionSite);
        }
        if (items != null) {
            int i = startIndexForPage;
            int last = i + pageSize;
            while (i < items.size() && i < last) {
                if (i >= 0) {
                    trackingSiteItemsForPage.add(items.get(i));
                }
                ++i;
            }
        }
        return trackingSiteItemsForPage;
    }

    public int getTotalTrackingSites(String distributionSite) {
        int count = 0;
        if (distributionSite == null && this.trackingSiteLookUp.values() != null) {
            Collection<List<UITrackingSiteItem>> allItems = this.trackingSiteLookUp.values();
            Iterator<List<UITrackingSiteItem>> iter = allItems.iterator();
            while (iter.hasNext()) {
                count += iter.next().size();
            }
        } else {
            List<UITrackingSiteItem> items = this.trackingSiteLookUp.get(distributionSite);
            if (items != null) {
                count = items.size();
            }
        }
        return count;
    }
}

