/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.create.model.ContentCreateData;
import com.tandbergtv.cms.portal.content.client.create.model.TitleViewData;
import com.tandbergtv.cms.portal.content.client.title.view.ContentCreateController;
import com.tandbergtv.cms.portal.content.client.title.view.ContentSelectorView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.series.SeriesTitleView;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;

public class ContentCreateView
extends Composite {
    private ContentCreateController controller;
    private final SimpleContainer rootContainer = new SimpleContainer();
    private SimplePanel emptyPanel;
    private ContentSelectorView selectorView;
    private TitleView titleView;
    private BusyIndicator busyIndicator;

    public ContentCreateView() {
        this.initWidget((Widget)this.rootContainer);
        this.busyIndicator = new BusyIndicator();
    }

    public void showTitleView(TitleViewData data, String returnAnchor) {
        this.createTitleView(data.contentClassTypeId);
        if (returnAnchor == null || returnAnchor.trim().length() < 1) {
            returnAnchor = "Content.Search";
        }
        this.titleView.addViewCancelHandler(new TitleViewCancelHandler(returnAnchor));
        NeptuneApplication application = NeptuneApplication.getApplication();
        ContentComponent cfr_ignored_0 = (ContentComponent)application.getComponent(ContentComponent.class);
        long partnerId = data.partnerId;
        long contentClassId = data.contentClassId;
        TitleViewInput viewInput = new TitleViewInput(partnerId, contentClassId);
        this.titleView.setInput(viewInput);
        this.titleView.refresh();
        this.rootContainer.setWidget((Widget)this.titleView);
    }

    private void createTitleView(int contentClassType) {
        this.titleView = contentClassType == 1 ? new SeriesTitleView() : new TitleView();
        this.titleView.addViewAnchorChangeHandler(new ViewAnchorChangeHandler(){

            public void onAnchorChange(ViewAnchorChangeEvent event) {
                if (ContentCreateView.this.titleView.getInput() != null && ContentCreateView.this.titleView.getInput().isExistingTitle()) {
                    String anchor = "Content.Search";
                    if (event.getAnchor() != null && event.getAnchor().trim().length() > 0) {
                        anchor = String.valueOf(anchor) + "." + event.getAnchor();
                    }
                    History.newItem((String)anchor, (boolean)false);
                }
            }
        });
    }

    public void showSelectorView(ContentCreateData data, String returnAnchor) {
        if (this.selectorView == null) {
            this.selectorView = new ContentSelectorView(this.controller);
        }
        this.selectorView.setReturnAnchor(returnAnchor);
        this.selectorView.refresh(data);
        this.rootContainer.setWidget((Widget)this.selectorView);
    }

    public void showSelectorViewForCategory(ContentCreateData data, String returnAnchor) {
        if (this.selectorView == null) {
            this.selectorView = new ContentSelectorView(this.controller);
        }
        this.selectorView.setReturnAnchor(returnAnchor);
        this.selectorView.refresh(data);
        this.rootContainer.setWidget((Widget)this.selectorView);
    }

    public ContentCreateController getController() {
        return this.controller;
    }

    public void setController(ContentCreateController controller) {
        this.controller = controller;
    }

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyindicator() {
        this.busyIndicator.hide();
    }

    public void showEmptyView() {
        this.rootContainer.setWidget((Widget)this.emptyPanel);
    }

    public void showError(String error) {
        Window.alert((String)("Error: " + error));
    }

    class TitleViewCancelHandler
    implements ViewCancelHandler {
        private String returnAnchor;

        public TitleViewCancelHandler(String returnAnchor) {
            this.returnAnchor = returnAnchor;
        }

        public void onCancel(ViewCancelEvent event) {
            History.newItem((String)this.returnAnchor);
        }
    }
}

