/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.create.model.ContentCreateData;
import com.tandbergtv.cms.portal.content.client.create.model.TitleViewData;
import com.tandbergtv.cms.portal.content.client.create.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.create.model.UISourcePartner;
import com.tandbergtv.cms.portal.content.client.title.view.ContentCreateController;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.List;

public class ContentSelectorView
extends Composite {
    private static final String TAB_NAME = "Content Selector";
    private String returnAnchor = "Content.Search";
    private SimpleContainer rootContainer = new SimpleContainer();
    private ListBox lbSourcePartner;
    private ListBox lbContentClass;
    private ContentCreateData data;

    public ContentSelectorView(final ContentCreateController controller) {
        this.initWidget((Widget)this.rootContainer);
        this.addStyleName("ContentSelectorView");
        VerticalPanel vp = new VerticalPanel();
        vp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        HeaderPanel header = new HeaderPanel("Create Content");
        header.setStyleName("content-header-style");
        vp.add((Widget)header);
        FlexTable dropdownPanel = new FlexTable();
        dropdownPanel.setCellSpacing(10);
        dropdownPanel.setStyleName("content-create-table-style");
        this.lbSourcePartner = new ListBox();
        this.lbSourcePartner.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String strPartnerId = ContentSelectorView.this.lbSourcePartner.getValue(ContentSelectorView.this.lbSourcePartner.getSelectedIndex());
                ContentSelectorView.this.lbContentClass.clear();
                UISourcePartner partner = ContentSelectorView.this.data.getSourcePartnerById(strPartnerId);
                ContentSelectorView.this.addClasses(partner);
            }
        });
        dropdownPanel.setWidget(0, 0, (Widget)new Label("Content Provider:"));
        dropdownPanel.setWidget(0, 1, (Widget)this.lbSourcePartner);
        this.lbContentClass = new ListBox();
        dropdownPanel.setWidget(1, 0, (Widget)new Label("Content Class:"));
        dropdownPanel.setWidget(1, 1, (Widget)this.lbContentClass);
        ButtonWidget btnNext = new ButtonWidget("Create Content", new ClickHandler(){

            public void onClick(ClickEvent event) {
                String strPartnerId = ContentSelectorView.this.lbSourcePartner.getValue(ContentSelectorView.this.lbSourcePartner.getSelectedIndex());
                String strContentClassId = ContentSelectorView.this.lbContentClass.getValue(ContentSelectorView.this.lbContentClass.getSelectedIndex());
                try {
                    TitleViewData tvData = new TitleViewData();
                    tvData.partnerId = Long.parseLong(strPartnerId);
                    tvData.contentClassId = Long.parseLong(strContentClassId);
                    UIContentClass cc = ContentSelectorView.this.data.findContentClass(tvData.partnerId, tvData.contentClassId);
                    if (cc != null) {
                        tvData.contentClassTypeId = cc.typeId;
                    }
                    if (controller != null) {
                        controller.showTitleView(tvData, ContentSelectorView.this.returnAnchor);
                    }
                }
                catch (Exception exception) {
                    Window.alert((String)"Please select a source partner and a content class");
                    return;
                }
            }
        });
        btnNext.removeStyleName("gwt-Button");
        btnNext.addStyleName("ebBtn");
        btnNext.addStyleName("ebBtn_color_green");
        btnNext.addStyleName("create_button_icon");
        ButtonWidget btnCancel = new ButtonWidget("Cancel", new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)ContentSelectorView.this.returnAnchor);
            }
        });
        btnCancel.removeStyleName("gwt-Button");
        btnCancel.addStyleName("ebBtn");
        ResizableContainer resizableContainer = new ResizableContainer((Widget)dropdownPanel, TAB_NAME, null);
        resizableContainer.getTabContainer().getTabBar().setVisible(false);
        resizableContainer.addHeightOffsettingWidget((Widget)header);
        resizableContainer.addButton(TAB_NAME, btnNext);
        resizableContainer.addButton(TAB_NAME, btnCancel);
        vp.add((Widget)resizableContainer);
        this.rootContainer.setWidget((Widget)vp);
    }

    public void setReturnAnchor(String anchor) {
        this.returnAnchor = anchor == null || anchor.trim().length() < 1 ? "Content.Search" : anchor;
    }

    public String getReturnAnchor() {
        return this.returnAnchor;
    }

    public void refresh(ContentCreateData data) {
        UISourcePartner partner2;
        this.data = data;
        this.lbSourcePartner.clear();
        this.lbContentClass.clear();
        List<UISourcePartner> partners = data.getSourcePartnerList();
        if (partners != null && !partners.isEmpty()) {
            for (UISourcePartner partner2 : partners) {
                this.lbSourcePartner.addItem(partner2.getDisplayName(), "" + partner2.getId());
            }
        }
        partner2 = null;
        if (partners != null && !partners.isEmpty()) {
            partner2 = partners.get(0);
        }
        this.addClasses(partner2);
    }

    private void addClasses(UISourcePartner partner) {
        if (partner == null) {
            return;
        }
        List<UIContentClass> classes = partner.getContentClassList();
        if (classes != null && !classes.isEmpty()) {
            for (UIContentClass cc : classes) {
                this.lbContentClass.addItem(cc.name, "" + cc.id);
            }
        }
    }
}

