/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessageCache;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasViewCancelHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;
import java.util.ArrayList;
import java.util.List;

public class TitleErrorPanel
extends Composite
implements HasViewCancelHandlers {
    private static final String STYLE_NAME = "content-TitleErrorPanel";
    private static final String STYLE_LABEL = "content-TitleErrorPanel-message";
    private static final String STYLE_BUTTON = "content-TitleErrorPanel-button";
    private String errorMessage;
    private List<EventListener> listeners = new ArrayList<EventListener>();
    private SimpleContainer rootContainer;
    private HorizontalContainer buttonContainer;
    private VerticalContainer container;
    private boolean showCancel = false;

    public TitleErrorPanel(String message) {
        this(message, false);
    }

    public TitleErrorPanel(String message, boolean showCancel) {
        this.errorMessage = message;
        this.showCancel = showCancel;
        this.initialize();
    }

    protected void initialize() {
        TitleViewMessages messages = TitleViewMessageCache.getMessages();
        this.rootContainer = new SimpleContainer();
        this.rootContainer.addStyleName(STYLE_NAME);
        this.initWidget((Widget)this.rootContainer);
        this.container = new VerticalContainer();
        this.rootContainer.setWidget((Widget)this.container);
        LabelWidget label = new LabelWidget(this.errorMessage);
        label.addStyleName(STYLE_LABEL);
        this.container.add((Widget)label);
        this.buttonContainer = new HorizontalContainer();
        this.container.add((Widget)this.buttonContainer);
        String text = messages.refreshButtonLabel();
        ButtonWidget button = new ButtonWidget(text);
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleErrorPanel.this.fireRefreshClicked();
            }
        });
        this.buttonContainer.add((Widget)button);
        if (this.showCancel) {
            String cancelText = messages.cancelButton();
            ButtonWidget cancelButton = new ButtonWidget(cancelText);
            cancelButton.removeStyleName("gwt-Button");
            cancelButton.addStyleName("ebBtn");
            cancelButton.addStyleName(STYLE_BUTTON);
            cancelButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    TitleErrorPanel.this.fireCancelClicked();
                }
            });
            this.buttonContainer.add((Widget)cancelButton);
        }
    }

    private void fireRefreshClicked() {
        for (EventListener listener : this.listeners) {
            listener.onRefreshClicked(this);
        }
    }

    private void fireCancelClicked() {
        this.fireEvent((GwtEvent)new ViewCancelEvent());
    }

    public HandlerRegistration addViewCancelHandler(ViewCancelHandler handler) {
        return this.addHandler((EventHandler)handler, ViewCancelEvent.getType());
    }

    public void addEventListener(EventListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    public static interface EventListener {
        public void onRefreshClicked(TitleErrorPanel var1);
    }
}

