/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.UITitleOverview;
import com.tandbergtv.cms.portal.content.client.title.model.UIViewInfo;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewHeaderWidget;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.activity.TitleActivityTab;
import com.tandbergtv.cms.portal.content.client.title.view.history.TitleHistoryTab;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleMetadataTab;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationView;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory.MSOOverridesHistoryTab;
import com.tandbergtv.cms.portal.content.client.title.view.offers.TitleOfferTab;
import com.tandbergtv.cms.portal.content.client.title.view.props.TitlePropertiesTab;
import com.tandbergtv.cms.portal.content.client.title.view.rules.RulesPreviewTab;
import com.tandbergtv.cms.portal.content.client.title.view.series.TitleSeriesTab;
import com.tandbergtv.cms.portal.content.client.title.view.sites.TitleSitesTab;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.event.BeforeContentChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.application.event.BeforeContentChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasViewAnchorChangeHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasViewCancelHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasViewCommitHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCommitEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCommitHandler;

public class TitleView
extends Composite
implements HasAnchor,
HasViewAnchorChangeHandlers,
HasViewCommitHandlers<TitleViewInput>,
HasViewCancelHandlers {
    private TitleMetadataTab metadataTab;
    private final SimpleContainer viewContainer = new SimpleContainer();
    private VerticalContainer contentContainer;
    private TitleViewHeaderWidget headerPanel;
    private TitleValidationView messageView;
    private TabContainer tabContainer;
    private BusyIndicator busyIndicator;
    private TitleViewMessages messages;
    private ITitleViewServiceAsync viewService;
    private TitleClientBundle bundle;
    private TitleViewInput input;
    private boolean ignoreTabEvents = false;
    private HandlerRegistration windowEventRegistration;
    private HandlerRegistration contentChangeRegistration;
    private static final String TITLE_VIEW_STYLE = "content-TitleView";
    private static final String TITLE_VIEW_TABCONTAINER = "content-TitleView-tabContainer";
    private static final String TITLE_HEADER_PANEL_STYLE = "content-TitleView-headerPanel";
    private static final String STYLE_SEVERE_ERROR = "content-TitleView-severeErrorLabel";
    private static int CMS_HEADER_MENU_SIZE_PX = 115;
    private static int METADATA_TAB_INDEX = 0;

    public TitleView() {
        this.initWidget((Widget)this.viewContainer);
        this.initialize();
    }

    public TitleView(TitleViewInput input) {
        this();
        this.setInput(input);
        this.refresh();
    }

    public void showMessage(TitleValidationViewInput data) {
        this.messageView.refresh(data);
    }

    public Widget getMessageViewWidget() {
        return this.messageView;
    }

    public TitleMetadataTab getMetadataTab() {
        return this.metadataTab;
    }

    public String getAnchor() {
        return this.getInput() != null ? this.getInput().buildAnchor() : null;
    }

    public void setAnchor(String anchor) {
        TitleViewInput input = new TitleViewInput(anchor);
        this.setInput(input);
        this.refresh();
    }

    public TitleViewInput getInput() {
        return this.input;
    }

    public void setInput(TitleViewInput input) {
        this.input = input;
    }

    protected void onLoad() {
        super.onLoad();
        this.windowEventRegistration = Window.addWindowClosingHandler((Window.ClosingHandler)new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                TitleViewTab tab = TitleView.this.getSelectedTab();
                if (tab != null && tab.isDirty()) {
                    event.setMessage(TitleView.this.getViewMessages().tabConfirmIgnoreChangesMessage());
                }
            }
        });
        NeptuneApplication app = NeptuneApplication.getApplication();
        this.contentChangeRegistration = app.addBeforeContentChangeHandler(new BeforeContentChangeHandler(){

            public void onBeforeContentChange(BeforeContentChangeEvent event) {
                TitleViewTab tab = TitleView.this.getSelectedTab();
                if (!TitleView.this.ignoreChangesOnTab(tab)) {
                    event.cancel();
                }
            }
        });
    }

    protected void onUnload() {
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        if (this.windowEventRegistration != null) {
            this.windowEventRegistration.removeHandler();
            this.windowEventRegistration = null;
        }
        if (this.contentChangeRegistration != null) {
            this.contentChangeRegistration.removeHandler();
            this.contentChangeRegistration = null;
        }
        super.onUnload();
    }

    public HandlerRegistration addViewCancelHandler(ViewCancelHandler handler) {
        return this.addHandler((EventHandler)handler, ViewCancelEvent.getType());
    }

    public HandlerRegistration addViewAnchorChangeHandler(ViewAnchorChangeHandler handler) {
        return this.addHandler((EventHandler)handler, ViewAnchorChangeEvent.getType());
    }

    public HandlerRegistration addViewCommitHandler(ViewCommitHandler<TitleViewInput> handler) {
        return this.addHandler((EventHandler)handler, ViewCommitEvent.getType());
    }

    public void fireViewAnchorChange() {
        String anchor = this.getAnchor();
        this.fireEvent((GwtEvent)new ViewAnchorChangeEvent(anchor));
    }

    protected void fireViewCommit() {
        this.fireEvent((GwtEvent)new ViewCommitEvent((Object)this.getInput()));
    }

    void fireCancelled(TitleViewTab source) {
        this.fireEvent((GwtEvent)new ViewCancelEvent());
    }

    void fireTitleCreated(TitleViewTab source, UITitle title) {
        this.input.updateTitle(title);
        this.fireViewAnchorChange();
        this.markTabsStale(source);
        this.enableTabSelection();
        this.fireViewCommit();
    }

    void fireTitleUpdated(TitleViewTab source, UITitle title) {
        this.input.updateTitle(title);
        this.markTabsStale(source);
        this.fireViewCommit();
    }

    void fireBatchTitleUpdated(TitleViewTab source) {
        this.markTabsStale(source);
        this.fireViewCommit();
    }

    void handleTabDirtyChange(TitleViewTab source) {
        String tabDisplayName = source.getTabDisplayName();
        if (source.isDirty()) {
            tabDisplayName = String.valueOf(tabDisplayName) + " " + this.getViewMessages().tabDirtyMarker();
        }
        int index = this.getTabIndex(source.getTabName());
        this.tabContainer.getTabBar().setTabText(index, tabDisplayName);
    }

    ITitleViewServiceAsync getViewService() {
        return this.viewService;
    }

    TitleViewMessages getViewMessages() {
        return this.messages;
    }

    TitleClientBundle getBundle() {
        return this.bundle;
    }

    private void initialize() {
        this.initializeServices();
        this.initializeWidgets();
    }

    private void initializeServices() {
        this.viewService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        this.bundle = new TitleClientBundle();
    }

    private void initializeWidgets() {
        this.busyIndicator = new BusyIndicator();
        this.addStyleName(TITLE_VIEW_STYLE);
        this.contentContainer = new VerticalContainer();
        this.headerPanel = new TitleViewHeaderWidget(this);
        this.headerPanel.addStyleName(TITLE_HEADER_PANEL_STYLE);
        this.messageView = new TitleValidationView();
        this.tabContainer = new TabContainer();
        this.tabContainer.addStyleName(TITLE_VIEW_TABCONTAINER);
        this.addTabs(this.tabContainer);
        this.tabContainer.selectTab(0);
        this.disableTabSelection();
        TitleTabEventHandler handler = new TitleTabEventHandler();
        this.tabContainer.addSelectionHandler((SelectionHandler)handler);
        this.tabContainer.addBeforeSelectionHandler((BeforeSelectionHandler)handler);
        this.contentContainer.add((Widget)this.headerPanel);
        this.contentContainer.add((Widget)this.messageView);
        this.contentContainer.add((Widget)this.tabContainer);
    }

    protected void addTabs(TabContainer tabContainer) {
        TitleViewTab tab = null;
        this.metadataTab = new TitleMetadataTab(this);
        tabContainer.add((Widget)this.metadataTab, this.metadataTab.getTabDisplayName());
        tab = new TitlePropertiesTab(this);
        tabContainer.add((Widget)tab, tab.getTabDisplayName());
        tab = new TitleHistoryTab(this);
        tabContainer.add((Widget)tab, tab.getTabDisplayName());
        boolean isSitesFeatureActive = this.isSitesFeatureActive();
        if (isSitesFeatureActive) {
            tab = new TitleSitesTab(this);
            tabContainer.add((Widget)tab, tab.getTabDisplayName());
        }
        tab = new TitleActivityTab(this);
        tabContainer.add((Widget)tab, tab.getTabDisplayName());
        tab = new TitleSeriesTab(this);
        tabContainer.add((Widget)tab, tab.getTabDisplayName());
        tab = new RulesPreviewTab(this);
        tabContainer.add((Widget)tab, tab.getTabDisplayName());
        tab = new MSOOverridesHistoryTab(this);
        tabContainer.add((Widget)tab, tab.getTabDisplayName());
        tab = new TitleOfferTab(this);
        tabContainer.add((Widget)tab, tab.getTabDisplayName());
    }

    protected void renderActionsListWidgets(UIViewInfo viewInfo) {
        if (this.getInput() != null && this.getInput().getTitleId() != null) {
            if (viewInfo.getIsSiteTitle()) {
                this.removeTabByName("Series");
                this.getMetadataTab().buildActionsListWidgets(true, false);
            } else {
                this.getMetadataTab().buildActionsListWidgets(false, false);
            }
        } else {
            this.getMetadataTab().setWidgetsVisibility(false);
        }
    }

    private boolean isSitesFeatureActive() {
        NeptuneApplication application = NeptuneApplication.getApplication();
        ContentComponent component = (ContentComponent)application.getComponent(ContentComponent.class);
        return component.isSitesFeatureActive();
    }

    public void refresh() {
        this.markTabsStale(null);
        this.refreshInput();
    }

    private void markTabsStale(TitleViewTab source) {
        int tabIndex = 0;
        while (tabIndex < this.tabContainer.getTabBar().getTabCount()) {
            Widget widget = this.tabContainer.getWidget(tabIndex);
            if (widget instanceof TitleViewTab && !widget.equals((Object)source)) {
                ((TitleViewTab)widget).markStale();
            }
            ++tabIndex;
        }
    }

    private void refreshInput() {
        this.viewContainer.clear();
        if (this.getInput() == null) {
            return;
        }
        if (this.getInput().isInvalidAnchor()) {
            String invalidField = this.getInput().getInvalidAnchorField();
            String message = this.getViewMessages().viewAnchorInvalid(invalidField);
            this.showSevereError(message);
        } else if (!this.getInput().hasTitleReadPermission()) {
            String message = this.getViewMessages().viewNotAuthorized();
            this.showSevereError(message);
        } else if (!this.getInput().isBulkEdit() && !this.getInput().hasTitleCreatePermission() && this.getInput().getTitleId() == null) {
            String message = this.getViewMessages().createNotAuthorized();
            this.showSevereError(message);
        } else {
            this.showBusyIndicator();
            this.viewService.getViewInfo(this.getInput().getTitle(), new AsyncCallback<UIViewInfo>(){

                public void onFailure(Throwable caught) {
                    String error = caught != null ? caught.getLocalizedMessage() : "";
                    String name = TitleView.this.getInput().getSpecificationName();
                    String message = name != null ? TitleView.this.getViewMessages().specificationFetchFailure(name, error) : TitleView.this.getViewMessages().defaultSpecificationFetchFailure(error);
                    TitleView.this.showSevereError(message);
                    TitleView.this.hideBusyIndicator();
                }

                public void onSuccess(UIViewInfo viewInfo) {
                    if (viewInfo.getViewPermission()) {
                        TitleView.this.viewContainer.setWidget((Widget)TitleView.this.contentContainer);
                        TitleView.this.ignoreTabEvents = true;
                        try {
                            TitleView.this.disableTabSelection();
                            TitleView.this.tabContainer.selectTab(TitleView.this.getSelectedTabIndex());
                        }
                        finally {
                            TitleView.this.ignoreTabEvents = false;
                        }
                        TitleView.this.renderActionsListWidgets(viewInfo);
                        if (!viewInfo.getIsMediaPathSiteTitle()) {
                            TitleView.this.removeTabByName("MSOOverridesHistory");
                        }
                        if (!viewInfo.getIsPackageTitle()) {
                            TitleView.this.removeTabByName("Offers");
                        }
                        if (viewInfo.getIsOfferTitle()) {
                            TitleView.this.removeTabByName("Series");
                            TitleView.this.getInput().setOffer(true);
                        }
                        TitleView.this.updateTab(TitleView.this.tabContainer.getTabBar().getSelectedTab());
                        TitleView.this.enableTabSelection();
                    } else {
                        String message = TitleView.this.getViewMessages().viewNotAuthorized();
                        TitleView.this.showSevereError(message);
                    }
                    TitleView.this.hideBusyIndicator();
                }
            });
        }
    }

    private void removeTabByName(String tabName) {
        Widget w;
        int tabIndex = this.getTabIndex(tabName);
        if (tabIndex >= 0 && (w = this.tabContainer.getWidget(tabIndex)) != null) {
            this.tabContainer.remove(w);
        }
    }

    private int getSelectedTabIndex() {
        String tabName;
        int index = METADATA_TAB_INDEX;
        if (this.getInput().isExistingTitle() && (index = this.getTabIndex(tabName = this.getInput().getTabName())) < 0) {
            index = METADATA_TAB_INDEX;
        }
        return index;
    }

    private TitleViewTab getSelectedTab() {
        Widget widget = this.tabContainer.getWidget(this.getSelectedTabIndex());
        if (widget instanceof TitleViewTab) {
            return (TitleViewTab)widget;
        }
        return null;
    }

    private void updateTab(int tabIndex) {
        TitleViewTab tab;
        Widget widget = this.tabContainer.getWidget(tabIndex);
        if (widget instanceof TitleViewTab && (tab = (TitleViewTab)widget).isStale()) {
            tab.refresh();
        }
    }

    private void enableTabSelection() {
        boolean existingTitle = this.getInput().getTitleId() != null;
        int tabCount = this.tabContainer.getTabBar().getTabCount();
        int tabIndex = 0;
        while (tabIndex < tabCount) {
            boolean enabled;
            Widget widget = this.tabContainer.getWidget(tabIndex);
            boolean bl = enabled = existingTitle && !this.input.isBulkEdit();
            if (widget instanceof TitleMetadataTab) {
                enabled = true;
            }
            this.tabContainer.getTabBar().setTabEnabled(tabIndex, enabled);
            ++tabIndex;
        }
    }

    private void disableTabSelection() {
        int tabCount = this.tabContainer.getTabBar().getTabCount();
        int tabIndex = 0;
        while (tabIndex < tabCount) {
            this.tabContainer.getTabBar().setTabEnabled(tabIndex, false);
            ++tabIndex;
        }
    }

    void showSevereError(String message) {
        this.hideBusyIndicator();
        LabelWidget label = new LabelWidget(message);
        label.addStyleName(STYLE_SEVERE_ERROR);
        this.viewContainer.setWidget((Widget)label);
    }

    private boolean ignoreChangesOnTab(TitleViewTab tab) {
        if (tab != null && tab.isDirty()) {
            return Window.confirm((String)this.getViewMessages().tabConfirmIgnoreChangesMessage());
        }
        return true;
    }

    public void showTab(String tabName) {
        int index = this.getEnabledTabIndex(tabName);
        if (index >= 0 && this.tabContainer.getTabBar().getSelectedTab() != index) {
            this.tabContainer.selectTab(index);
        }
    }

    private int getEnabledTabIndex(String tabName) {
        int index = this.getTabIndex(tabName);
        if (index >= 0 && !this.tabContainer.getTabBar().isTabEnabled(index)) {
            index = -1;
        }
        return index;
    }

    private int getTabIndex(String tabName) {
        int tabCount = this.tabContainer.getTabBar().getTabCount();
        int tabIndex = 0;
        while (tabIndex < tabCount) {
            Widget widget = this.tabContainer.getWidget(tabIndex);
            if (widget instanceof TitleViewTab && ((TitleViewTab)widget).getTabName().equals(tabName)) {
                return tabIndex;
            }
            ++tabIndex;
        }
        return -1;
    }

    void updateTitleHeader(UITitleOverview overview) {
        this.headerPanel.setInput(overview);
        this.headerPanel.refresh();
    }

    void showMasterTitleComparison(Long masterTitleId, String targetedVersion) {
        int index = this.getEnabledTabIndex("Sites");
        if (index >= 0) {
            TitleSitesTab tab = (TitleSitesTab)this.tabContainer.getWidget(index);
            tab.showMasterTitleComparison(masterTitleId, targetedVersion);
            this.showTab("Sites");
        }
    }

    void showDistributedTitleComparison(Long titleId, String distributedVersion) {
        int index = this.getEnabledTabIndex("Sites");
        if (index >= 0) {
            TitleSitesTab tab = (TitleSitesTab)this.tabContainer.getWidget(index);
            tab.showDistributedTitleComparison(titleId, distributedVersion);
            this.showTab("Sites");
        }
    }

    int getTabHeight() {
        return Window.getClientHeight() - this.getUsedHeight();
    }

    int getTabWidth() {
        return Window.getClientWidth() - this.getUsedWidth();
    }

    int getUsedHeight() {
        int usedHeight = CMS_HEADER_MENU_SIZE_PX;
        usedHeight += this.headerPanel.getOffsetHeight() + this.tabContainer.getTabBar().getOffsetHeight();
        return usedHeight += 10;
    }

    int getUsedWidth() {
        return 40;
    }

    BusyIndicator getBusyIndicator() {
        return this.busyIndicator;
    }

    void showBusyIndicator() {
        this.busyIndicator.center();
    }

    void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    private class TitleTabEventHandler
    implements SelectionHandler<Integer>,
    BeforeSelectionHandler<Integer> {
        private TitleTabEventHandler() {
        }

        public void onSelection(SelectionEvent<Integer> event) {
            if (TitleView.this.ignoreTabEvents) {
                return;
            }
            Widget widget = TitleView.this.tabContainer.getWidget(((Integer)event.getSelectedItem()).intValue());
            if (widget instanceof TitleViewTab) {
                TitleViewTab viewTab = (TitleViewTab)widget;
                TitleView.this.getInput().setTabName(viewTab.getTabName());
                viewTab.onTabSelected();
                TitleView.this.fireViewAnchorChange();
            }
            TitleView.this.updateTab((Integer)event.getSelectedItem());
        }

        public void onBeforeSelection(BeforeSelectionEvent<Integer> event) {
            Widget widget;
            if (TitleView.this.ignoreTabEvents) {
                return;
            }
            int currentIndex = TitleView.this.tabContainer.getTabBar().getSelectedTab();
            if (currentIndex != -1 && (widget = TitleView.this.tabContainer.getWidget(currentIndex)) instanceof TitleViewTab) {
                TitleViewTab tab = (TitleViewTab)widget;
                if (tab.isDirty()) {
                    if (!TitleView.this.ignoreChangesOnTab(tab)) {
                        event.cancel();
                    } else {
                        tab.refresh();
                        tab.onTabUnselected();
                    }
                } else {
                    tab.onTabUnselected();
                }
            }
        }
    }
}

