/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UITitleOverview;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.thumbnail.TitleThumbnailWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITitleStatus;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class TitleViewHeaderWidget
extends Composite {
    private final SimpleContainer container;
    private final TitleView view;
    private HorizontalContainer contents;
    private VerticalContainer outerContents;
    private UITitleOverview input;
    private ImageWidget titleTypeImage;
    private ImageWidget statusImage;
    private ImageWidget distributionStatusImage;
    private ImageWidget processingStatusImage;
    private ImageWidget originalDifferenceImage;
    private ImageWidget distributionDifferenceImage;
    private SimpleContainer thumbnailHolder;
    private TitleThumbnailWidget thumbnailImage;
    private LabelWidget headingLabel;
    private LabelWidget statusLabel;
    private LabelWidget contentClassLabel;
    private boolean showStatusImage = true;
    private static final String STYLE_NWT_HEADER = "nwt-HeaderPanel";
    private static final String STYLE_NAME = "content-TitleViewHeaderWidget";
    private static final String STYLE_CONTENTS = "content-TitleViewHeaderWidget-contents";
    private static final String STYLE_NWT_HEADING_LABEL = "nwt-HeaderPanel-label";
    private static final String STYLE_HEADING_LABEL = "content-TitleViewHeaderWidget-headingLabel";
    private static final String STYLE_ICON = "content-TitleViewHeaderWidget-icon";
    private static final String STYLE_TITLE_TYPE_ICON = "content-TitleViewHeaderWidget-typeIcon";
    private static final String STYLE_TITLE_THUMBNAIL = "content-TitleViewHeaderWidget-thumbnail";
    private static final String STYLE_STATUS_ICON = "content-TitleViewHeaderWidget-statusIcon";
    private static final String STYLE_STATUS_LABEL = "content-TitleViewHeaderWidget-statusLabel";
    private static final String STYLE_DISTRIBUTION_STATUS_ICON = "content-TitleViewHeaderWidget-distributionStatusIcon";
    private static final String STYLE_PROCESSING_STATUS_ICON = "content-TitleViewHeaderWidget-processingStatusIcon";
    private static final String STYLE_ORIGINAL_DIFF_ICON = "content-TitleViewHeaderWidget-orginalCompareIcon";
    private static final String STYLE_SITE_DIFF_ICON = "content-TitleViewHeaderWidget-siteCompareIcon";
    private static final String CONTENT_VIEW_ANCHOR = "Content.Search.Id=";
    private static final String STYLE_IMAGE_LINK = "imageLink";

    public TitleViewHeaderWidget(TitleView parentView) {
        this.view = parentView;
        this.container = new SimpleContainer();
        this.initWidget((Widget)this.container);
        this.initialize();
    }

    private void initialize() {
        this.addStyleName(STYLE_NWT_HEADER);
        this.addStyleName(STYLE_NAME);
        this.outerContents = new VerticalContainer();
        this.container.add((Widget)this.outerContents);
        this.contentClassLabel = new LabelWidget();
        this.contentClassLabel.setStyleName("content-create-header-style");
        this.contentClassLabel.setText("Content Metadata Management");
        this.outerContents.add((Widget)this.contentClassLabel);
        this.contents = new HorizontalContainer();
        this.contents.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
        this.contents.addStyleName(STYLE_CONTENTS);
        this.outerContents.add((Widget)this.contents);
        this.titleTypeImage = new ImageWidget();
        this.titleTypeImage.addStyleName(STYLE_ICON);
        this.titleTypeImage.addStyleName(STYLE_TITLE_TYPE_ICON);
        this.titleTypeImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleViewHeaderWidget.this.handleTitleTypeImageClick();
            }
        });
        this.thumbnailHolder = new SimpleContainer();
        this.thumbnailHolder.setStyleName(STYLE_TITLE_THUMBNAIL);
        this.thumbnailImage = new TitleThumbnailWidget();
        this.thumbnailImage.addStyleName(STYLE_ICON);
        this.thumbnailHolder.setWidget((Widget)this.thumbnailImage);
        this.headingLabel = new LabelWidget();
        this.headingLabel.addStyleName(STYLE_NWT_HEADING_LABEL);
        this.headingLabel.addStyleName(STYLE_HEADING_LABEL);
        this.statusImage = new ImageWidget();
        this.statusImage.addStyleName(STYLE_ICON);
        this.statusImage.addStyleName(STYLE_STATUS_ICON);
        this.statusLabel = new LabelWidget();
        this.statusLabel.addStyleName(STYLE_STATUS_LABEL);
        this.processingStatusImage = new ImageWidget();
        this.processingStatusImage.addStyleName(STYLE_ICON);
        this.processingStatusImage.addStyleName(STYLE_PROCESSING_STATUS_ICON);
        this.distributionStatusImage = new ImageWidget();
        this.distributionStatusImage.addStyleName(STYLE_ICON);
        this.distributionStatusImage.addStyleName(STYLE_DISTRIBUTION_STATUS_ICON);
        this.distributionStatusImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleViewHeaderWidget.this.handleDistributionStatusImageClick();
            }
        });
        this.originalDifferenceImage = new ImageWidget();
        this.originalDifferenceImage.addStyleName(STYLE_ICON);
        this.originalDifferenceImage.addStyleName(STYLE_ORIGINAL_DIFF_ICON);
        this.originalDifferenceImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleViewHeaderWidget.this.handleOriginalDifferenceImageClick();
            }
        });
        this.distributionDifferenceImage = new ImageWidget();
        this.distributionDifferenceImage.addStyleName(STYLE_ICON);
        this.distributionDifferenceImage.addStyleName(STYLE_SITE_DIFF_ICON);
        this.distributionDifferenceImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleViewHeaderWidget.this.handleDistributionDifferenceImageClick();
            }
        });
    }

    public UITitleOverview getInput() {
        return this.input;
    }

    public void setInput(UITitleOverview input) {
        this.input = input;
    }

    private TitleView getView() {
        return this.view;
    }

    public void refresh() {
        UITitleStatus titleStatus;
        String heading;
        String ccName;
        this.contents.clear();
        this.titleTypeImage.removeStyleName(STYLE_IMAGE_LINK);
        this.originalDifferenceImage.removeStyleName(STYLE_IMAGE_LINK);
        this.distributionDifferenceImage.removeStyleName(STYLE_IMAGE_LINK);
        this.distributionStatusImage.removeStyleName(STYLE_IMAGE_LINK);
        if (this.getInput() == null) {
            return;
        }
        this.thumbnailImage.setInput(this.getInput().getId(), null);
        this.contents.add((Widget)this.thumbnailHolder);
        String typeName = "";
        boolean isOffer = this.view.getInput().isOffer();
        typeName = isOffer ? (this.getInput().isSiteTitle() ? "siteOffer" : "originalOffer") : (this.getInput().isSiteTitle() ? "siteTitle" : "originalTitle");
        this.view.getBundle().updateIcon((Image)this.titleTypeImage, typeName);
        this.titleTypeImage.addStyleName(STYLE_ICON);
        this.titleTypeImage.addStyleName(STYLE_TITLE_TYPE_ICON);
        if (this.getInput().isSiteTitle()) {
            this.titleTypeImage.addStyleName(STYLE_IMAGE_LINK);
        }
        if (((ccName = this.view.getInput().getContentClassName()) == null || ccName.isEmpty()) && this.input.getContentClassName() != null) {
            ccName = this.input.getContentClassName();
        }
        if ((heading = this.getInput().getHeading()) == null) {
            heading = "";
        }
        if (this.view.getInput().isBulkEdit()) {
            this.headingLabel.setText("Batch Edit:" + this.view.getInput().getOrderedBulkEditTitleIds());
        } else {
            this.headingLabel.setText(this.view.getViewMessages().contentDetails(heading));
        }
        VerticalPanel headerPanel = new VerticalPanel();
        VerticalPanel semiVP = new VerticalPanel();
        LabelWidget lw = new LabelWidget("Content Class: " + ccName);
        semiVP.add((Widget)lw);
        semiVP.add((Widget)this.headingLabel);
        lw.setStyleName(this.headingLabel.getStyleName());
        HorizontalPanel titleDetailsPanel = new HorizontalPanel();
        if (this.view.getInput() == null || !this.view.getInput().isSeriesTitle()) {
            titleDetailsPanel.add((Widget)this.titleTypeImage);
        }
        if ((titleStatus = this.getInput().getStatus()) == null) {
            titleStatus = UITitleStatus.DRAFT;
        }
        if (!this.view.getInput().isBulkEdit()) {
            if (this.showStatusImage) {
                this.view.getBundle().updateTitleStatusIcon((Image)this.statusImage, titleStatus, Boolean.valueOf(isOffer));
                this.statusImage.addStyleName(STYLE_ICON);
                this.statusImage.addStyleName(STYLE_STATUS_ICON);
                titleDetailsPanel.add((Widget)this.statusImage);
            } else {
                String name = this.view.getBundle().getStatusName(titleStatus);
                this.statusLabel.setText("[" + name + "]");
                titleDetailsPanel.add((Widget)this.statusLabel);
            }
        }
        semiVP.add((Widget)titleDetailsPanel);
        if (this.getInput().isSiteTitle()) {
            UIDistributionStatus status = UIDistributionStatus.valueOf((String)this.getInput().getDistributionStatus());
            if (status == null) {
                status = UIDistributionStatus.TARGETED;
            }
            this.view.getBundle().updateDistributionStatusIcon((Image)this.distributionStatusImage, status);
            this.distributionStatusImage.addStyleName(STYLE_ICON);
            this.distributionStatusImage.addStyleName(STYLE_DISTRIBUTION_STATUS_ICON);
            if (status == UIDistributionStatus.FAILED) {
                if (this.getInput().getDistributionStatusDetail() == UIDistributionSiteItem.LIC_LIMIT_EXCEEDED) {
                    this.distributionStatusImage.setTitle(this.view.getViewMessages().distLimitExceeded());
                } else if (this.getInput().getDistributionStatusDetail() == UIDistributionSiteItem.DIST_DEPENDENCY_TIMEOUT) {
                    this.distributionStatusImage.setTitle(this.view.getViewMessages().distDependencyTimeout());
                }
            }
            titleDetailsPanel.add((Widget)this.distributionStatusImage);
            boolean different = this.getInput().isChangedAfterTargeting();
            String iconName = "";
            iconName = isOffer ? (different ? "originalOfferDifferent" : "originalOfferNotDifferent") : (different ? "originalTitleDifferent" : "originalTitleNotDifferent");
            this.view.getBundle().updateIcon((Image)this.originalDifferenceImage, iconName);
            this.originalDifferenceImage.addStyleName(STYLE_ICON);
            this.originalDifferenceImage.addStyleName(STYLE_ORIGINAL_DIFF_ICON);
            if (different) {
                this.originalDifferenceImage.addStyleName(STYLE_IMAGE_LINK);
            }
            titleDetailsPanel.add((Widget)this.originalDifferenceImage);
            different = this.getInput().isChangedAfterDistribution();
            iconName = isOffer ? (different ? "distributedOfferDifferent" : "distributedOfferNotDifferent") : (different ? "distributedTitleDifferent" : "distributedTitleNotDifferent");
            this.view.getBundle().updateIcon((Image)this.distributionDifferenceImage, iconName);
            this.distributionDifferenceImage.addStyleName(STYLE_ICON);
            this.distributionDifferenceImage.addStyleName(STYLE_SITE_DIFF_ICON);
            if (different) {
                this.distributionDifferenceImage.addStyleName(STYLE_IMAGE_LINK);
            }
            titleDetailsPanel.add((Widget)this.distributionDifferenceImage);
        } else if (this.input != null && this.view.getInput() != null && !this.view.getInput().isSeriesTitle() && this.view.getInput().getTitleId() != null) {
            this.view.getBundle().updateProcessingStatusIcon((Image)this.processingStatusImage, this.input.getProcessingStatus());
            this.processingStatusImage.addStyleName(STYLE_ICON);
            this.processingStatusImage.addStyleName(STYLE_PROCESSING_STATUS_ICON);
            titleDetailsPanel.add((Widget)new HTML("<span>&nbsp;</span>"));
            titleDetailsPanel.add((Widget)this.processingStatusImage);
            this.distributionStatusImage.addStyleName(STYLE_ICON);
            this.distributionStatusImage.addStyleName(STYLE_DISTRIBUTION_STATUS_ICON);
            this.distributionStatusImage.addStyleName(STYLE_IMAGE_LINK);
            this.view.getBundle().updateDistributionStatusIcon((Image)this.distributionStatusImage, this.input.getDistributionStatus());
            titleDetailsPanel.add((Widget)new HTML("<span>&nbsp;</span>"));
            titleDetailsPanel.add((Widget)this.distributionStatusImage);
        }
        headerPanel.add((Widget)semiVP);
        this.contents.add((Widget)headerPanel);
    }

    private void handleOriginalDifferenceImageClick() {
        if (this.getInput() == null || !this.getInput().isChangedAfterTargeting()) {
            return;
        }
        String version = this.getInput().getOriginalVersion();
        this.getView().showMasterTitleComparison(this.getInput().getOriginalId(), version);
    }

    private void handleDistributionDifferenceImageClick() {
        if (this.getInput() == null || !this.getInput().isChangedAfterDistribution()) {
            return;
        }
        String version = this.getInput().getDistributedVersion();
        this.getView().showDistributedTitleComparison(this.getInput().getId(), version);
    }

    private void handleTitleTypeImageClick() {
        if (this.getInput() == null || !this.getInput().isSiteTitle() || !ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"})) {
            return;
        }
        History.newItem((String)(CONTENT_VIEW_ANCHOR + this.getInput().getOriginalId()));
    }

    private void handleDistributionStatusImageClick() {
        if (!this.getInput().isSiteTitle()) {
            History.newItem((String)(CONTENT_VIEW_ANCHOR + this.getInput().getId() + "&Tab=Sites"));
        }
    }
}

