/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.UITitleOverview;
import com.tandbergtv.cms.portal.content.client.title.model.history.UITitleHistory;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.UITitleInfo;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITitleStatus;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TitleViewInput {
    private Long requestKey;
    private String action;
    private String listOfAssetIds;
    private String tabName;
    private String assetName;
    private boolean invalidAnchor;
    private String invalidAnchorField;
    private Set<Long> bulkEditTitleIds = null;
    private Long selectedAssetId;
    private String from;
    private boolean isOffer;
    private ITitleViewServiceAsync viewService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
    private UIAssetSpecification specification = null;
    private UITitle title = null;
    public static final String TITLE_ID_ANCHOR_KEY = "Id";
    public static final String REQUESTKEY_ANCHOR_KEY = "RequestKey";
    public static final String ACTION_ANCHOR_KEY = "Action";
    public static final String ASSET_IDS_ANCHOR_KEY = "AssetIDs";
    public static final String SELECTED_ASSET_ID_ANCHOR_KEY = "SelectedAsset.Id";
    public static final String TAB_ANCHOR_KEY = "Tab";
    public static final String ASSET_ANCHOR_KEY = "Asset";
    public static final String ACTION_SELECT = "SELECT";
    public static final String ACTION_MAP = "MAP_ASSET";
    public static final String ACTION_CORRECT = "CORRECT";
    public static final String ACTION_DECONFLICT = "DECONFLICT";
    public static final String METADATA_TAB_NAME = "Metadata";
    public static final String HISTORY_TAB_NAME = "History";
    public static final String ACTIVITY_TAB_NAME = "Activity";
    public static final String SITES_TAB_NAME = "Sites";

    public TitleViewInput(String anchor) {
        this.parseAnchor(anchor);
    }

    public TitleViewInput(long partnerId, long contentClassId) {
        this.title = new UITitle();
        this.title.setPartnerId(partnerId);
        this.title.setContentClassId(contentClassId);
    }

    public TitleViewInput(Long titleId, Long requestKey, String action, String listOfAssetIds) {
        this.title = new UITitle();
        this.title.setId(titleId);
        this.requestKey = requestKey;
        this.action = action;
        this.listOfAssetIds = listOfAssetIds;
    }

    public TitleViewInput(Collection<Long> titleIds, long contentClassId) {
        this.title = new UITitle();
        this.title.setContentClassId(contentClassId);
        if (titleIds == null || titleIds.size() == 0) {
            throw new IllegalArgumentException("Cannot perform bulk edit of 0 titles.");
        }
        this.bulkEditTitleIds = new HashSet<Long>();
        this.bulkEditTitleIds.addAll(titleIds);
    }

    public UITitle getTitle() {
        return this.title;
    }

    public String getFrom() {
        return this.from;
    }

    public boolean isOffer() {
        return this.isOffer;
    }

    public void setOffer(boolean isOffer) {
        this.isOffer = isOffer;
    }

    public boolean hasTitleReadPermission() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"});
    }

    public boolean hasTitleModifyPermission() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Modify"});
    }

    public boolean hasTitleCreatePermission() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Create"});
    }

    public String getSpecificationName() {
        return this.getDefaultSpecificationName();
    }

    public Long getTitleId() {
        return this.title.getId();
    }

    public boolean isExistingTitle() {
        return this.title.getId() != null;
    }

    public boolean isBulkEdit() {
        return this.bulkEditTitleIds != null;
    }

    void updateTitle(UITitle title) {
        if (this.getTitleId() == null) {
            this.title.setId(title.getId());
        }
        this.invalidateTitle();
        this.title.setMetadata(title.getMetadata());
        this.title.setHistory(title.getHistory());
    }

    public void invalidateTitle() {
        this.invalidateMetadata();
        this.invalidateHistory();
    }

    public boolean isSiteTitle() {
        return this.title.getOverview().isSiteTitle();
    }

    public UITitleMetadata getMetadata() {
        return this.title.getMetadata();
    }

    private void onGetMetadataSuccess(final AsyncCallback<UITitleInfo> callback, UITitleInfo result) {
        this.specification = result.getSpecification();
        if (this.title.getId() != null) {
            UITitle resTitle = result.getTitle();
            UITitleOverview overview = resTitle.getOverview();
            if (overview == null) {
                overview = new UITitleOverview();
            }
            overview.setContentClassName(this.specification.getContentClassName());
            this.title.setOverview(overview);
            this.title.setMetadata(resTitle.getMetadata());
            this.title.setContentClassId(resTitle.getContentClassId());
            callback.onSuccess((Object)result);
        } else {
            UITitleOverview overview = new UITitleOverview();
            overview.setStatus(UITitleStatus.DRAFT);
            overview.setContentClassName(this.specification.getContentClassName());
            this.title.setOverview(overview);
            UITitleMetadata metadata = new UITitleMetadata();
            UIAssetFactory assetFactory = new UIAssetFactory();
            UIGroupAsset rootAsset = (UIGroupAsset)assetFactory.createAsset(this.specification, this.isBulkEdit());
            if (overview.getContentClassName().equalsIgnoreCase("Offer")) {
                rootAsset.setReferencedTitleIds(new ArrayList<Long>());
            }
            metadata.setRootAsset(rootAsset);
            metadata.setTitleStatus(UITitleStatus.DRAFT);
            this.title.setMetadata(metadata);
            if (this.bulkEditTitleIds != null && this.bulkEditTitleIds.size() >= 1) {
                Long bulkTitleId = this.bulkEditTitleIds.iterator().next();
                this.viewService.getTitle(bulkTitleId, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

                    public void onNeptuneFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onNeptuneSuccess(UITitle result) {
                        TitleViewInput.this.title.setContentClassId(result.getContentClassId());
                        UITitleInfo info = new UITitleInfo();
                        info.setTitle(result);
                        info.setSpecification(TitleViewInput.this.specification);
                        callback.onSuccess((Object)info);
                    }
                });
            } else {
                result.setTitle(this.title);
                callback.onSuccess((Object)result);
            }
        }
    }

    public void getMetadata(final AsyncCallback<UITitleInfo> callback) {
        if (this.bulkEditTitleIds != null) {
            this.viewService.getTitleMetadataInfoForBatch(this.title.getContentClassId(), (AsyncCallback<UITitleInfo>)new NeptuneAsyncCallback<UITitleInfo>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(UITitleInfo result) {
                    TitleViewInput.this.onGetMetadataSuccess((AsyncCallback<UITitleInfo>)callback, result);
                }
            });
        } else {
            this.viewService.getTitleMetadataInfo(this.title.getId(), this.title.getContentClassId(), this.title.getPartnerId(), (AsyncCallback<UITitleInfo>)new NeptuneAsyncCallback<UITitleInfo>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(UITitleInfo result) {
                    TitleViewInput.this.onGetMetadataSuccess((AsyncCallback<UITitleInfo>)callback, result);
                }
            });
        }
    }

    public void invalidateMetadata() {
        this.title.setMetadata(null);
    }

    public Set<Long> getBulkEditTitleIds() {
        return this.bulkEditTitleIds;
    }

    public List<Long> getOrderedBulkEditTitleIds() {
        if (this.bulkEditTitleIds == null) {
            return null;
        }
        ArrayList<Long> titleIds = new ArrayList<Long>(this.bulkEditTitleIds);
        Collections.sort(titleIds);
        return titleIds;
    }

    public UITitleHistory getHistory() {
        return this.title.getHistory();
    }

    public void getHistory(final AsyncCallback<UITitle> callback) {
        Long titleId = this.title.getId();
        UITitleHistory history = this.title.getHistory();
        if (history != null) {
            callback.onSuccess((Object)this.title);
        } else if (titleId != null) {
            this.viewService.getTitleHistory(titleId, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(UITitle result) {
                    TitleViewInput.this.title.setOverview(result.getOverview());
                    TitleViewInput.this.title.setHistory(result.getHistory());
                    callback.onSuccess((Object)result);
                }
            });
        } else {
            UITitleOverview overview = new UITitleOverview();
            overview.setStatus(UITitleStatus.DRAFT);
            this.title.setOverview(overview);
            history = new UITitleHistory();
            this.title.setHistory(history);
            callback.onSuccess((Object)this.title);
        }
    }

    public void invalidateHistory() {
        this.title.setHistory(null);
    }

    public Long getRequestKey() {
        return this.requestKey;
    }

    public String getAction() {
        return this.action;
    }

    public String getListOfAssetIds() {
        return this.listOfAssetIds;
    }

    public boolean isSelectButtonVisible() {
        return ACTION_SELECT.equals(this.getAction());
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public boolean isInvalidAnchor() {
        return this.invalidAnchor;
    }

    public String getInvalidAnchorField() {
        return this.invalidAnchorField;
    }

    public Long getSelectedAssetId() {
        return this.selectedAssetId;
    }

    public void setSelectedAssetId(Long selectedAssetId) {
        this.selectedAssetId = selectedAssetId;
    }

    public String buildAnchor() {
        AnchorTokenizer tokenizer = new AnchorTokenizer();
        LinkedHashMap<String, String> anchorTokens = new LinkedHashMap<String, String>();
        if (this.getTitleId() != null) {
            anchorTokens.put(TITLE_ID_ANCHOR_KEY, this.getTitleId().toString());
        }
        if (this.getRequestKey() != null) {
            anchorTokens.put(REQUESTKEY_ANCHOR_KEY, this.getRequestKey().toString());
        }
        if (this.getAction() != null) {
            anchorTokens.put(ACTION_ANCHOR_KEY, this.getAction());
        }
        if (this.getListOfAssetIds() != null) {
            anchorTokens.put(ASSET_IDS_ANCHOR_KEY, this.getListOfAssetIds());
        }
        if (this.getTabName() != null) {
            anchorTokens.put(TAB_ANCHOR_KEY, this.tabName);
        }
        if (this.getAssetName() != null) {
            anchorTokens.put(ASSET_ANCHOR_KEY, this.assetName);
        }
        if (this.getSelectedAssetId() != null) {
            anchorTokens.put(SELECTED_ASSET_ID_ANCHOR_KEY, this.selectedAssetId.toString());
        }
        return tokenizer.buildAnchor(anchorTokens);
    }

    private void parseAnchor(String anchor) {
        AnchorTokenizer tokenizer = new AnchorTokenizer();
        Map anchorTokens = tokenizer.parseAnchor(anchor);
        this.title = new UITitle();
        this.title.setId(this.parseLong((String)anchorTokens.get(TITLE_ID_ANCHOR_KEY), TITLE_ID_ANCHOR_KEY));
        this.requestKey = this.parseLong((String)anchorTokens.get(REQUESTKEY_ANCHOR_KEY), REQUESTKEY_ANCHOR_KEY);
        this.action = (String)anchorTokens.get(ACTION_ANCHOR_KEY);
        this.listOfAssetIds = (String)anchorTokens.get(ASSET_IDS_ANCHOR_KEY);
        this.tabName = (String)anchorTokens.get(TAB_ANCHOR_KEY);
        this.assetName = (String)anchorTokens.get(ASSET_ANCHOR_KEY);
        this.selectedAssetId = this.parseLong((String)anchorTokens.get(SELECTED_ASSET_ID_ANCHOR_KEY), SELECTED_ASSET_ID_ANCHOR_KEY);
        this.from = (String)anchorTokens.get("From");
    }

    private String getDefaultSpecificationName() {
        NeptuneApplication application = NeptuneApplication.getApplication();
        ContentComponent component = (ContentComponent)application.getComponent(ContentComponent.class);
        return component.getSpecificationName();
    }

    private Long parseLong(String value, String fieldName) {
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (RuntimeException runtimeException) {
            if (!this.invalidAnchor) {
                this.invalidAnchor = true;
                this.invalidAnchorField = fieldName;
            }
            return null;
        }
    }

    public String getContentClassName() {
        return this.specification == null ? "" : this.specification.getContentClassName();
    }

    public boolean isSeriesTitle() {
        return this.specification != null && this.specification.getContentClassTypeId() == 1;
    }

    public boolean isCategoryTitle() {
        return this.specification != null && this.specification.getContentClassTypeId() == 2;
    }

    public boolean isOfferTitle() {
        return this.specification != null && this.specification.getContentClassTypeId() == 3;
    }
}

