/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.UITitleOverview;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.TitleErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public abstract class TitleViewTab
extends Composite {
    private SimpleContainer mainContainer;
    protected TitleView titleView;
    private boolean stale = true;
    private boolean dirty = false;
    private static final String STYLE_NAME = "content-TitleViewTab";

    public TitleViewTab(TitleView parent) {
        this.titleView = parent;
        this.mainContainer = new SimpleContainer();
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.mainContainer);
        this.initialize();
    }

    protected abstract void initialize();

    protected SimpleContainer getContainer() {
        return this.mainContainer;
    }

    public final void refresh() {
        this.getTitleView().showMessage(null);
        this.clearDirty();
        this.refreshTab();
    }

    protected abstract void refreshTab();

    public TitleView getTitleView() {
        return this.titleView;
    }

    public TitleViewInput getViewInput() {
        return this.titleView.getInput();
    }

    public ITitleViewServiceAsync getViewService() {
        return this.titleView.getViewService();
    }

    public TitleViewMessages getViewMessages() {
        return this.titleView.getViewMessages();
    }

    public boolean isStale() {
        return this.stale;
    }

    public void markStale() {
        this.stale = true;
        this.clearDirty();
    }

    protected void markUpdated() {
        this.stale = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void markDirty() {
        this.setDirty(true);
    }

    protected void clearDirty() {
        this.setDirty(false);
    }

    private void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.getTitleView().handleTabDirtyChange(this);
        }
    }

    protected void onCancelled() {
        this.getTitleView().fireCancelled(this);
    }

    protected void onTitleCreated(UITitle title) {
        this.getTitleView().fireTitleCreated(this, title);
    }

    protected void onTitleUpdated(UITitle title) {
        this.getTitleView().fireTitleUpdated(this, title);
    }

    protected void onBatchTitleUpdated() {
        this.getTitleView().fireBatchTitleUpdated(this);
    }

    protected void updateTitleHeader(UITitleOverview overview) {
        this.getTitleView().updateTitleHeader(overview);
    }

    protected void showSevereError(String message) {
        this.getTitleView().showSevereError(message);
    }

    protected void showErrorPanel(String message) {
        TitleErrorPanel errorPanel = new TitleErrorPanel(message);
        errorPanel.addEventListener(new TitleErrorPanel.EventListener(){

            @Override
            public void onRefreshClicked(TitleErrorPanel panel) {
                TitleViewTab.this.refresh();
            }
        });
        this.getContainer().setWidget((Widget)errorPanel);
    }

    protected void onTabSelected() {
    }

    protected void onTabUnselected() {
    }

    protected BusyIndicator getBusyIndicator() {
        return this.getTitleView().getBusyIndicator();
    }

    protected void showBusyIndicator() {
        this.getTitleView().showBusyIndicator();
    }

    protected void hideBusyIndicator() {
        this.getTitleView().hideBusyIndicator();
    }

    protected int getTabWidth() {
        return this.getTitleView().getTabWidth();
    }

    protected int getTabHeight() {
        return this.getTitleView().getTabHeight();
    }

    protected int getUsedHeight() {
        return this.getTitleView().getUsedHeight();
    }

    protected int getUsedWidth() {
        return this.getTitleView().getUsedWidth();
    }

    protected abstract String getTabName();

    public abstract String getTabDisplayName();
}

