/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.activity;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.tab.SucessPanel;
import com.tandbergtv.cms.portal.content.client.title.model.activity.UITitleActivity;
import com.tandbergtv.cms.portal.content.client.title.view.activity.ActivityItemRecord;
import com.tandbergtv.cms.portal.content.client.title.view.activity.CurrentActivityItemDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.activity.HistoryActivityItemDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.activity.TitleActivityTab;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

class ActivityPanel
extends SimpleContainer {
    private TitleActivityTab parent;
    private VerticalContainer mainContainer;
    private SucessPanel currentActivityInfoPanel;
    private ErrorPanel currentActivityErrorPanel;
    private SucessPanel historyActivityInfoPanel;
    private ErrorPanel historyActivityErrorPanel;
    private CurrentActivityItemDataProvider dataProviderCurrentActivity;
    private Table<Long, ActivityItemRecord> tableCurrentActivity;
    private HistoryActivityItemDataProvider dataProviderHistoryActivity;
    private Table<Long, ActivityItemRecord> tableHistoryActivity;
    private HeaderPanel separator;
    private LabelWidget currentActivityLabel;
    private LabelWidget historyActivityLabel;
    private UITitleActivity activity = null;
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-TitleListsPanel";

    public ActivityPanel(TitleActivityTab parent) {
        this.parent = parent;
        this.initWidgets();
        LabelWidget blankLabel = new LabelWidget("");
        this.setWidget((Widget)blankLabel);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        String message = this.parent.getViewMessages().currentActivityLabel();
        this.currentActivityLabel = new LabelWidget(message);
        this.currentActivityInfoPanel = new SucessPanel();
        this.currentActivityInfoPanel.setVisible(false);
        this.currentActivityErrorPanel = new ErrorPanel();
        this.currentActivityErrorPanel.setVisible(false);
        this.dataProviderCurrentActivity = new CurrentActivityItemDataProvider(this);
        this.tableCurrentActivity = new Table((DataProvider)this.dataProviderCurrentActivity);
        this.separator = new HeaderPanel("");
        message = this.parent.getViewMessages().historyActivityLabel();
        this.historyActivityLabel = new LabelWidget(message);
        this.historyActivityInfoPanel = new SucessPanel();
        this.historyActivityInfoPanel.setVisible(false);
        this.historyActivityErrorPanel = new ErrorPanel();
        this.historyActivityErrorPanel.setVisible(false);
        this.dataProviderHistoryActivity = new HistoryActivityItemDataProvider(this);
        this.tableHistoryActivity = new Table((DataProvider)this.dataProviderHistoryActivity);
        this.mainContainer.add((Widget)this.currentActivityLabel);
        this.mainContainer.add((Widget)this.currentActivityInfoPanel);
        this.mainContainer.add((Widget)this.currentActivityErrorPanel);
        this.mainContainer.add(this.tableCurrentActivity);
        this.mainContainer.add((Widget)this.separator);
        this.mainContainer.add((Widget)this.historyActivityLabel);
        this.mainContainer.add((Widget)this.historyActivityInfoPanel);
        this.mainContainer.add((Widget)this.historyActivityErrorPanel);
        this.mainContainer.add(this.tableHistoryActivity);
    }

    public UITitleActivity getUITitleActivity() {
        return this.activity;
    }

    private void refreshCurrentActivityTable() {
        if (!this.tableCurrentActivity.isInitialized()) {
            this.tableCurrentActivity.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    ActivityPanel.this.tableCurrentActivity.refresh();
                }
            });
        } else {
            this.tableCurrentActivity.refresh();
        }
    }

    private void refreshHistoryActivityTable() {
        if (!this.tableHistoryActivity.isInitialized()) {
            this.tableHistoryActivity.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    ActivityPanel.this.tableHistoryActivity.refresh();
                }
            });
        } else {
            this.tableHistoryActivity.refresh();
        }
    }

    void handleGetTitleActivityRecordsSuccess(UITitleActivity activity) {
        String message;
        this.activity = activity;
        this.historyActivityErrorPanel.setVisible(false);
        this.currentActivityErrorPanel.setVisible(false);
        if (activity.getCurrentItems().size() == 0) {
            message = this.parent.getViewMessages().currentActivityNotPresent();
            this.tableCurrentActivity.setVisible(false);
            this.currentActivityInfoPanel.setVisible(true);
            this.currentActivityInfoPanel.showSuccessMessage(message);
        } else {
            this.tableCurrentActivity.setVisible(true);
            this.currentActivityInfoPanel.setVisible(false);
            this.currentActivityInfoPanel.reset();
            this.refreshCurrentActivityTable();
        }
        if (activity.getHistoryItems().size() == 0) {
            message = this.parent.getViewMessages().historyActivityNotPresent();
            this.tableHistoryActivity.setVisible(false);
            this.historyActivityInfoPanel.setVisible(true);
            this.historyActivityInfoPanel.showSuccessMessage(message);
        } else {
            this.tableHistoryActivity.setVisible(true);
            this.historyActivityInfoPanel.setVisible(false);
            this.historyActivityInfoPanel.reset();
            this.refreshHistoryActivityTable();
        }
        if (this.getWidget() != this.mainContainer) {
            this.setWidget((Widget)this.mainContainer);
        }
    }

    void handleGetTitleActivityRecordsFailure(String errMsg) {
        this.historyActivityInfoPanel.setVisible(false);
        this.currentActivityInfoPanel.setVisible(false);
        this.tableCurrentActivity.setVisible(false);
        this.tableHistoryActivity.setVisible(false);
        this.historyActivityErrorPanel.setVisible(false);
        this.currentActivityErrorPanel.setVisible(true);
        this.currentActivityErrorPanel.showErrorMessage(errMsg);
        if (this.getWidget() != this.mainContainer) {
            this.setWidget((Widget)this.mainContainer);
        }
    }
}

