/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.activity;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.portlet.PortletConstants;
import com.tandbergtv.cms.portal.content.client.title.model.activity.UIActivityItem;
import com.tandbergtv.cms.portal.content.client.title.model.activity.UITitleActivity;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.activity.ActivityItemColumn;
import com.tandbergtv.cms.portal.content.client.title.view.activity.ActivityItemRecord;
import com.tandbergtv.cms.portal.content.client.title.view.activity.ActivityPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.List;

class CurrentActivityItemDataProvider
implements DataProvider<Long, ActivityItemRecord> {
    private TitleViewMessages messages;
    private List<Column<?, ActivityItemRecord>> columns;
    private ActivityPanel parent;
    private PageFeature parentPageFeature;
    private PortletConstants constants;
    public static final String STATUS_COLUMN_NAME = "status";
    public static final String WORKORDER_COLUMN_NAME = "workOrderId";
    public static final String CURRENT_TASK_COLUMN_NAME = "currentTask";
    public static final String TEMPLATE_COLUMN_NAME = "template";
    public static final String START_TIME_NAME = "startTime";

    public CurrentActivityItemDataProvider(ActivityPanel parent) {
        this.parent = parent;
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        this.initializeColumns();
    }

    private void initializeColumns() {
        this.columns = new ArrayList();
        String displayName = null;
        ActivityItemColumn column = null;
        final NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();
        this.columns.add(this.prepareStatusColumn());
        displayName = this.messages.currentActivityTableWorkOrderIdColumn();
        column = new ActivityItemColumn(WORKORDER_COLUMN_NAME, displayName){

            @Override
            protected String getColumnText(ActivityItemRecord record) {
                return record.getActivityItem().getWorkOrderId().toString();
            }

            @Override
            public View<String> getView(final ActivityItemRecord record) {
                return new View<String>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        if (security.isUserInRole("WorkOrderManagement_View")) {
                            return new HyperlinkWidget(record.getActivityItem().getWorkOrderId().toString(), "Workflow.Work Orders.Search.Id=" + record.getActivityItem().getWorkOrderId());
                        }
                        return new LabelWidget(record.getActivityItem().getWorkOrderId().toString());
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, ActivityItemRecord>)column);
        displayName = this.messages.currentActivityTableCurrentTaskColumn();
        column = new ActivityItemColumn(CURRENT_TASK_COLUMN_NAME, displayName){

            @Override
            protected String getColumnText(ActivityItemRecord record) {
                return record.getActivityItem().getCurrentTask().toString();
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, ActivityItemRecord>)column);
        displayName = this.messages.currentActivityTableTemplateColumn();
        column = new ActivityItemColumn(TEMPLATE_COLUMN_NAME, displayName){

            @Override
            protected String getColumnText(ActivityItemRecord record) {
                return record.getActivityItem().getTemplate();
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, ActivityItemRecord>)column);
        displayName = this.messages.currentActivityTableStartTimeColumn();
        column = new ActivityItemColumn(START_TIME_NAME, displayName){

            @Override
            protected String getColumnText(ActivityItemRecord record) {
                return CurrentActivityItemDataProvider.this.getStartDateValue(record.getActivityItem());
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-date");
        this.columns.add((Column<?, ActivityItemRecord>)column);
    }

    private Column<String, ActivityItemRecord> prepareStatusColumn() {
        ColumnBase<String, ActivityItemRecord> column = null;
        String displayName = this.messages.currentActivityTableStatusColumn();
        column = new ColumnBase<String, ActivityItemRecord>(STATUS_COLUMN_NAME, displayName){

            public View<String> getView(final ActivityItemRecord record) {
                return new View<String>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        String status = record.getActivityItem().getStatus();
                        String statusToolTip = record.getActivityItem().getStatusToolTip();
                        ImageWidget image = CurrentActivityItemDataProvider.this.getImage(status, statusToolTip);
                        return image;
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-icon");
        return column;
    }

    public List<Column<?, ActivityItemRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<ActivityItemRecord> callback) {
        UIActivityItem activityItem = new UIActivityItem();
        activityItem.setId(key);
        callback.onSuccess((Object)new ActivityItemRecord(activityItem));
    }

    public void getRecords(AsyncCallback<List<ActivityItemRecord>> callback) {
        UITitleActivity result = this.parent.getUITitleActivity();
        ArrayList<ActivityItemRecord> records = new ArrayList<ActivityItemRecord>();
        for (UIActivityItem activityItem : result.getCurrentItems()) {
            records.add(new ActivityItemRecord(activityItem));
        }
        callback.onSuccess(records);
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    private String getStartDateValue(UIActivityItem activityItem) {
        if (activityItem.getStartTime() == null) {
            return null;
        }
        return activityItem.getStartTime();
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    private ImageWidget getImage(String stateName, String toolTip) {
        ImageWidget image = new ImageWidget("images/icon_rect_" + stateName + ".png");
        if (toolTip == null) {
            image.setTitle(this.getLocalizedStateName(stateName));
        } else {
            image.setTitle(toolTip);
        }
        return image;
    }

    private String getLocalizedStateName(String stateName) {
        return this.constants.getString(STATUS_COLUMN_NAME + stateName);
    }
}

