/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.activity;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleActivityViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleActivityViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.activity.ActivityPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.RefreshWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshHandler;

public class TitleActivityTab
extends TitleViewTab {
    private static final int DEFAULT_REFRESH_RATE = 180;
    private static final int MINIMUM_REFRESH_RATE = 30;
    private RefreshWidget<ActivityPanel> mainPanel;
    private ITitleActivityViewServiceAsync titleActivityViewService = (ITitleActivityViewServiceAsync)GWT.create(ITitleActivityViewService.class);
    private static final String STYLE_LOADING_LABEL = "content-TitleMetadataTab-loadingMessage";
    public static final String TAB_NAME = "Activity";

    public TitleActivityTab(TitleView parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.addStyleDependentName("activity");
        ActivityPanel activityPanel = new ActivityPanel(this);
        this.mainPanel = new RefreshWidget((Widget)activityPanel);
        this.mainPanel.setRefreshOnLoad(false);
        this.mainPanel.setRefreshPeriod(this.getRefreshPeriod());
        this.mainPanel.addRefreshHandler(new RefreshHandler(){

            public void onRefresh(RefreshEvent event) {
                TitleActivityTab.this.handleRefreshEvent(event);
            }
        });
        this.getContainer().setWidget(this.mainPanel);
    }

    @Override
    protected String getTabName() {
        return TAB_NAME;
    }

    @Override
    public String getTabDisplayName() {
        return this.getViewMessages().activityTabName();
    }

    @Override
    public void refreshTab() {
        this.getTitleView().showMessage(null);
        this.showBusyIndicator();
        this.showLoadingMessage();
        this.refreshPanel();
    }

    private void showLoadingMessage() {
        String message = this.getViewMessages().activityLoading();
        LabelWidget label = new LabelWidget(message);
        label.addStyleName(STYLE_LOADING_LABEL);
        this.getContainer().setWidget((Widget)label);
    }

    void refreshPanel() {
        Long titleId = this.getViewInput().getTitleId();
        this.titleActivityViewService.getTitleActivity(titleId, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

            public void onNeptuneSuccess(UITitle result) {
                ((ActivityPanel)TitleActivityTab.this.mainPanel.getWidget()).handleGetTitleActivityRecordsSuccess(result.getActivity());
                TitleActivityTab.this.getContainer().setWidget((Widget)TitleActivityTab.this.mainPanel);
                TitleActivityTab.this.updateTitleHeader(result.getOverview());
                TitleActivityTab.this.hideBusyIndicator();
            }

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof ReadDeletedTitleException) {
                    TitleActivityTab.this.showSevereError(caught.getMessage());
                } else {
                    String error = caught.getLocalizedMessage();
                    String message = TitleActivityTab.this.getViewMessages().activityFetchFailure(error);
                    TitleActivityTab.this.showErrorPanel(message);
                }
                TitleActivityTab.this.hideBusyIndicator();
            }
        });
    }

    private int getRefreshPeriod() {
        NeptuneApplication application = NeptuneApplication.getApplication();
        ContentComponent component = (ContentComponent)application.getComponent(ContentComponent.class);
        Integer refreshRateValue = component.getTitleSitesViewRefreshRate();
        int refreshRate = 180;
        try {
            if (refreshRateValue != null && (refreshRate = refreshRateValue.intValue()) < 30) {
                refreshRate = 30;
            }
        }
        catch (Exception exception) {
            refreshRate = 180;
        }
        return refreshRate * 1000;
    }

    private void handleRefreshEvent(RefreshEvent event) {
        boolean visible = true;
        Widget widget = this.getContainer().getWidget();
        while (widget != null && visible) {
            visible &= widget.isVisible();
            widget = widget.getParent();
        }
        if (visible) {
            this.refresh();
        }
    }
}

