/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.view.HasViewChangeHandlers;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeEvent;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.MetadataView;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileView;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class AssetContent
extends Composite
implements HasViewChangeHandlers {
    private SimpleContainer rootContainer;
    private VerticalContainer container;
    private final AssetTree.AssetInfo asset;
    private List<UIAssetFilePath> filePaths;
    private boolean readOnly;
    private MetadataView metadataView;
    private FileView fileView;
    private ViewChangeHandler handler = new EventHandler();
    private static final String STYLE_NAME = "content-AssetContent";

    public AssetContent(TitleView tView, AssetTree.AssetInfo assetInfo, List<UIAssetFilePath> filePaths) {
        this(tView, assetInfo, filePaths, false);
    }

    public AssetContent(TitleView tView, AssetTree.AssetInfo assetInfo, List<UIAssetFilePath> filePaths, boolean readOnly) {
        this.asset = assetInfo;
        this.filePaths = filePaths;
        this.readOnly = readOnly;
        this.rootContainer = new SimpleContainer();
        this.rootContainer.addStyleName(STYLE_NAME);
        this.container = new VerticalContainer();
        this.rootContainer.setWidget((Widget)this.container);
        this.initWidget((Widget)this.rootContainer);
        this.createMetadata(assetInfo);
        this.createFiles(tView, assetInfo);
    }

    private final void createMetadata(AssetTree.AssetInfo assetInfo) {
        this.metadataView = new MetadataView(this.asset.getDefinition(), this.readOnly, assetInfo.isBatchEdit());
        this.metadataView.addViewChangeHandler(this.handler);
        this.container.add((Widget)this.metadataView);
        this.metadataView.setInput(assetInfo);
    }

    private void createFiles(TitleView tView, AssetTree.AssetInfo asset) {
        if (asset.isBatchEdit() || asset.getDefinition().isHideFileView()) {
            return;
        }
        UIAssetFileDefinition fileDefinition = asset.getDefinition().getFileDefinition();
        this.fileView = new FileView(tView, fileDefinition, this.filePaths, this.readOnly);
        this.fileView.addViewChangeHandler(this.handler);
        if (!asset.isBatchEdit()) {
            this.container.add((Widget)this.fileView);
        }
        this.fileView.setInput(asset);
    }

    public AssetTree.AssetInfo getAsset() {
        return this.asset;
    }

    public void markDirty() {
        if (this.fileView != null) {
            this.fileView.markDirty();
        }
    }

    public List<AssetValidationMessage> validate(boolean draft) {
        ArrayList<AssetValidationMessage> messages = new ArrayList<AssetValidationMessage>();
        this.metadataView.validate(messages, draft);
        if (this.fileView != null) {
            this.fileView.validate(messages, draft);
        }
        return messages;
    }

    public void setFocus(Widget widget) {
        Widget parentWidget = widget.getParent();
        while (parentWidget != null && !parentWidget.equals(this)) {
            if (parentWidget instanceof DisclosureContainer) {
                ((DisclosureContainer)parentWidget).setOpen(true);
            } else if (parentWidget instanceof DisclosurePanel) {
                ((DisclosurePanel)parentWidget).setOpen(true);
            }
            parentWidget = parentWidget.getParent();
        }
        if (widget instanceof Focusable) {
            ((Focusable)widget).setFocus(true);
        }
    }

    @Override
    public HandlerRegistration addViewChangeHandler(ViewChangeHandler handler) {
        return this.addHandler(handler, ViewChangeEvent.getType());
    }

    private class EventHandler
    implements ViewChangeHandler {
        private EventHandler() {
        }

        @Override
        public void onViewChange(ViewChangeEvent event) {
            AssetContent.this.fireEvent(event);
        }
    }
}

