/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.HasViewChangeHandlers;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessageCache;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeEvent;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetContent;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.keyframes.KeyframesLogicalClipPanel;
import com.tandbergtv.cms.portal.content.client.title.view.keyframes.KeyframesSetImagePanel;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.RefTitlesPanel;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.SetVideoImagePanel;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoAvailTimeCodePanel;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoLogicalClipPanel;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoSnapshotPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeResource;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AssetPanel
extends Composite
implements HasViewChangeHandlers {
    private List<Widget> offsettingWidgets = new ArrayList<Widget>();
    private TitleView titleView;
    private SimpleContainer container;
    private AssetTree assetTree;
    private ScrollPanel leftScrollPanel;
    private ScrollPanel rightScrollPanel;
    private SimpleContainer assetContent;
    private boolean readOnly = false;
    private AssetTree.AssetInfo input;
    private List<UIAssetFilePath> filePaths;
    private IUIAssetFactory assetFactory = new UIAssetFactory();
    private final Map<AssetTree.AssetInfo, AssetContent> assetInfoWidgets = new HashMap<AssetTree.AssetInfo, AssetContent>();
    private PopupPanel contextMenu;
    private TitleViewMessages constants;
    private RefTitlesPanel refTitlesPanel = null;
    private ViewChangeHandler handler = new EventHandler();
    private boolean dirty = false;
    private static final String STYLE_NAME = "content-AssetPanel";
    private static final String STYLE_CONTEXT_MENU = "content-AssetPanel-contextMenu";
    private static final String STYLE_CONTEXT_MENU_DISABLED = "content-AssetPanel-contextMenu-disabled";
    private HandlerRegistration windowRegistration;
    private static final String DOWN_ICON = "cms_contentmgmt_ui/resources/images/child-collapseAll-normalState.png";
    private static final String UP_ICON = "cms_contentmgmt_ui/resources/images/child-expandAll-normalState.png";
    private boolean heightChange = false;
    public int height;
    public int lastLeftPanelHeight = 0;

    public AssetPanel(TitleView titleView, AssetTree.AssetInfo input, List<UIAssetFilePath> filePaths, boolean readOnly) {
        this.titleView = titleView;
        this.readOnly = readOnly;
        this.filePaths = filePaths;
        this.input = input;
        this.initialize();
    }

    public void addOffsettingWidget(Widget widget) {
        this.offsettingWidgets.add(widget);
    }

    private void initialize() {
        this.constants = TitleViewMessageCache.getMessages();
        this.container = new SimpleContainer();
        this.container.setStyleName(STYLE_NAME);
        this.initWidget((Widget)this.container);
        TreeResource images = new TreeResource();
        this.assetTree = new AssetTree(images, this.input);
        VerticalContainer vc = new VerticalContainer();
        LabelWidget textLabelExpand = new LabelWidget("Expand All");
        textLabelExpand.setStyleName("settings-view-expand-collapse-style");
        textLabelExpand.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = AssetPanel.this.assetTree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(true);
                }
            }
        });
        LabelWidget textLabelCollapse = new LabelWidget("Collapse All");
        textLabelCollapse.setStyleName("settings-view-expand-collapse-style");
        textLabelCollapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = AssetPanel.this.assetTree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(false);
                }
            }
        });
        ImageWidget dropDownImgCollapse = new ImageWidget(DOWN_ICON);
        dropDownImgCollapse.setStyleName("drop-arrow-asset-collapse-all");
        dropDownImgCollapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = AssetPanel.this.assetTree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(false);
                }
            }
        });
        ImageWidget dropDownImgExpand = new ImageWidget(UP_ICON);
        dropDownImgExpand.setStyleName("drop-arrow-expand-all");
        dropDownImgExpand.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = AssetPanel.this.assetTree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(true);
                }
            }
        });
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.add((Widget)dropDownImgExpand);
        horizontalPanel.add((Widget)textLabelExpand);
        horizontalPanel.add((Widget)dropDownImgCollapse);
        horizontalPanel.add((Widget)textLabelCollapse);
        vc.add((Widget)horizontalPanel);
        this.leftScrollPanel = new ScrollPanel((Widget)this.assetTree);
        this.leftScrollPanel.setWidth("250px");
        this.assetContent = new SimpleContainer();
        this.rightScrollPanel = new ScrollPanel((Widget)this.assetContent);
        this.rightScrollPanel.addStyleName("RightPanel");
        this.rightScrollPanel.setWidth("97%");
        this.assetTree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                AssetContent widget = null;
                if (((TreeItem)event.getSelectedItem()).getTitle().equals("ReferencedTitles")) {
                    if (AssetPanel.this.refTitlesPanel != null) {
                        AssetPanel.this.refTitlesPanel.refresh();
                        AssetPanel.this.assetContent.setWidget((Widget)AssetPanel.this.refTitlesPanel);
                        AssetPanel.this.refTitlesPanel.updateSize();
                        AssetPanel.this.rightScrollPanel.getElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                        AssetPanel.this.rightScrollPanel.setHeight("100%");
                        AssetPanel.this.heightChange = true;
                    }
                } else {
                    if (AssetPanel.this.heightChange) {
                        AssetPanel.this.rightScrollPanel.getElement().getStyle().setOverflow(Style.Overflow.AUTO);
                        AssetPanel.this.updateSize();
                        AssetPanel.this.heightChange = false;
                    }
                    widget = AssetPanel.this.getAssetContent((TreeItem)event.getSelectedItem());
                    AssetPanel.this.assetContent.setWidget((Widget)widget);
                }
            }
        });
        this.contextMenu = new PopupPanel(true);
        this.contextMenu.addStyleName(STYLE_CONTEXT_MENU);
        this.assetTree.addContextMenuHandler(new ContextMenuHandler(){

            public void onContextMenu(ContextMenuEvent event) {
                AssetPanel.this.showContextMenu(event);
            }
        });
        HorizontalPanel splitContainer = new HorizontalPanel();
        splitContainer.setStyleName("ScrollPanelContainer");
        VerticalContainer verticalContainer = new VerticalContainer();
        verticalContainer.add((Widget)horizontalPanel);
        verticalContainer.add((Widget)this.leftScrollPanel);
        verticalContainer.addStyleName("LeftPanel");
        splitContainer.add((Widget)verticalContainer);
        splitContainer.add((Widget)this.rightScrollPanel);
        this.container.setWidget((Widget)splitContainer);
        this.assetTree.setSelectedAssetInfo(this.input);
    }

    public List<AssetValidationMessage> validate(boolean draft) {
        ArrayList<AssetValidationMessage> messages = new ArrayList<AssetValidationMessage>();
        ArrayList<TreeItem> treeItems = new ArrayList<TreeItem>();
        int index = 0;
        while (index < this.assetTree.getItemCount()) {
            treeItems.add(this.assetTree.getItem(index));
            ++index;
        }
        this.validate(treeItems, messages, draft);
        return messages;
    }

    private void validate(List<TreeItem> allTreeItems, List<AssetValidationMessage> messages, boolean draft) {
        while (allTreeItems.size() > 0) {
            TreeItem currentTreeItem = allTreeItems.remove(0);
            AssetContent widget = this.getAssetContent(currentTreeItem);
            messages.addAll(widget.validate(draft));
            int index = 0;
            while (index < currentTreeItem.getChildCount()) {
                allTreeItems.add(currentTreeItem.getChild(index));
                ++index;
            }
        }
    }

    public void setFocus(AssetValidationMessage message) {
        AssetTree.AssetInfo assetInfo = message.getAsset();
        if (assetInfo != null) {
            this.assetTree.setSelectedAssetInfo(message.getAsset());
            final AssetContent widget = this.assetInfoWidgets.get(message.getAsset());
            final Widget fieldWidget = message.getFieldWidget();
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    widget.setFocus(fieldWidget);
                }
            });
            return;
        }
    }

    public AssetTree.AssetInfo getSelectedAssetInfo() {
        return this.assetTree.getSelectedAssetInfo();
    }

    private void showContextMenu(ContextMenuEvent event) {
        List<String> videoAssetTypes;
        MenuItem disabledItem;
        String text2;
        UIGroupAsset parent;
        UIAsset asset;
        TreeItem selectedTreeItem = this.assetTree.getSelectedItem();
        AssetTree.AssetInfo selectedAssetInfo = this.assetTree.getSelectedAssetInfo();
        if (this.readOnly || selectedAssetInfo == null) {
            return;
        }
        this.contextMenu.clear();
        boolean hasItems = false;
        MenuBar menuBar = new MenuBar(true);
        MenuBar addItemBar = new MenuBar(true);
        UIAssetDefinition assetDefinition = selectedAssetInfo.getDefinition();
        if (assetDefinition instanceof UIGroupAssetDefinition) {
            UIGroupAssetDefinition groupAssetDefinition = (UIGroupAssetDefinition)assetDefinition;
            asset = (UIGroupAsset)selectedAssetInfo.getAsset();
            boolean hasAddMenuItem = false;
            for (UIAssetDefinition assetDef : groupAssetDefinition.getChildren()) {
                int amountLeft;
                String assetType = assetDef.getAssetType();
                int existingCount = ((UIGroupAsset)asset).getChildItems(assetType).size();
                int maximumCount = assetDef.getMaximumCount();
                if (this.input.isBatchEdit()) {
                    maximumCount = assetDef.getBatchMaximumCount();
                }
                if ((amountLeft = maximumCount - existingCount) <= 0) continue;
                hasAddMenuItem = true;
                AddAssetCommand addCommand = new AddAssetCommand(selectedTreeItem, (UIGroupAsset)asset, assetDef);
                addItemBar.addItem(assetDef.getDisplayName(), (Scheduler.ScheduledCommand)addCommand);
            }
            if (hasAddMenuItem) {
                menuBar.addItem(new MenuItem(this.constants.assetTreeMenuItemAddText(), addItemBar));
                hasItems = true;
            }
        }
        int minimumCount = assetDefinition.getMinimumCount();
        if (this.input.isBatchEdit()) {
            minimumCount = assetDefinition.getBatchMinimumCount();
        }
        if ((parent = (UIGroupAsset)(asset = selectedAssetInfo.getAsset()).getParentAsset()) != null && parent.getChildItems(asset.getAssetType()).size() > minimumCount) {
            String text = this.constants.assetTreeMenuItemRemoveText();
            menuBar.addItem(new MenuItem(text, (Scheduler.ScheduledCommand)new RemoveAssetCommand(selectedTreeItem)));
            hasItems = true;
        }
        NeptuneApplication application = NeptuneApplication.getApplication();
        ContentComponent component = (ContentComponent)application.getComponent(ContentComponent.class);
        List<String> imageAssetTypes = component.getImageAssetTypes();
        boolean isLicensed = component.isLicensedForVideoPreview();
        String assetType = asset.getAssetType();
        if (imageAssetTypes.contains(assetType)) {
            String text1 = this.constants.assetTreeMenuItemSetImageFromKeyframesText();
            menuBar.addItem(new MenuItem(text1, (Scheduler.ScheduledCommand)new SetImageFromKeyframesCommand(selectedTreeItem)));
            text2 = this.constants.assetTreeMenuItemSetImageFromSnapshotsText();
            if (isLicensed) {
                menuBar.addItem(new MenuItem(text2, (Scheduler.ScheduledCommand)new SetImageFromSnapshotsCommand(selectedTreeItem)));
            } else {
                disabledItem = new MenuItem(text2, (Scheduler.ScheduledCommand)new DoNothingCommand(selectedTreeItem));
                disabledItem.setStyleName(STYLE_CONTEXT_MENU_DISABLED);
                menuBar.addItem(disabledItem);
            }
            hasItems = true;
        }
        if ("LOGICALCLIP".equals(assetType)) {
            String text1 = this.constants.assetTreeMenuItemSetMarkInMarkOutFromKeyframesText();
            text2 = this.constants.assetTreeMenuItemSetMarkInMarkOutFromVideoText();
            menuBar.addItem(new MenuItem(text1, (Scheduler.ScheduledCommand)new SetMarkInMarkOutFromKeyframesCommand(selectedTreeItem)));
            if (isLicensed) {
                menuBar.addItem(new MenuItem(text2, (Scheduler.ScheduledCommand)new SetMarkInMarkOutFromVideoCommand(selectedTreeItem)));
            } else {
                disabledItem = new MenuItem(text2, (Scheduler.ScheduledCommand)new DoNothingCommand(selectedTreeItem));
                disabledItem.setStyleName(STYLE_CONTEXT_MENU_DISABLED);
                menuBar.addItem(disabledItem);
            }
            hasItems = true;
        }
        if ((videoAssetTypes = component.getVideoAssetTypes()).contains(assetType)) {
            String text = this.constants.assetTreeMenuItemCreateImageFromVideoText();
            String availText = this.constants.assetTreeMenuItemSetAvailTimeCodesFromVideoText();
            if (isLicensed) {
                menuBar.addItem(new MenuItem(text, (Scheduler.ScheduledCommand)new CreateImageFromVideoCommand(selectedTreeItem)));
                menuBar.addItem(new MenuItem(availText, (Scheduler.ScheduledCommand)new SetAvailTimeCodesFromVideoCommand(selectedTreeItem)));
            } else {
                MenuItem disabledItem2 = new MenuItem(text, (Scheduler.ScheduledCommand)new DoNothingCommand(selectedTreeItem));
                disabledItem2.setStyleName(STYLE_CONTEXT_MENU_DISABLED);
                menuBar.addItem(disabledItem2);
                MenuItem disabledAvailItem = new MenuItem(availText, (Scheduler.ScheduledCommand)new DoNothingCommand(selectedTreeItem));
                disabledAvailItem.setStyleName(STYLE_CONTEXT_MENU_DISABLED);
                menuBar.addItem(disabledAvailItem);
            }
            hasItems = true;
        }
        event.preventDefault();
        event.stopPropagation();
        if (hasItems) {
            this.contextMenu.add((Widget)menuBar);
            int x = event.getNativeEvent().getClientX() + Window.getScrollLeft();
            int y = event.getNativeEvent().getClientY() + Window.getScrollTop();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.contextMenu.setPopupPosition(x, y);
            this.contextMenu.show();
        }
    }

    private AssetContent getAssetContent(TreeItem treeItem) {
        return this.getAssetContent(this.assetTree.getAssetInfo(treeItem));
    }

    private AssetContent getAssetContent(AssetTree.AssetInfo assetInfo) {
        UIGroupAsset root;
        AssetContent widget = this.assetInfoWidgets.get(assetInfo);
        if (widget == null && assetInfo != null) {
            widget = new AssetContent(this.titleView, assetInfo, this.filePaths, this.readOnly);
            if (this.dirty) {
                widget.markDirty();
            }
            widget.addViewChangeHandler(this.handler);
            this.assetInfoWidgets.put(assetInfo, widget);
        }
        if (assetInfo.getAsset() instanceof UIGroupAsset && (root = (UIGroupAsset)assetInfo.getAsset()).getAssetType().equalsIgnoreCase("Package") && assetInfo.getInput().isOfferTitle() && this.refTitlesPanel == null) {
            this.refTitlesPanel = new RefTitlesPanel(assetInfo, this);
            this.refTitlesPanel.initDataProvider((AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                    Window.alert((String)caught.getLocalizedMessage());
                }

                public void onNeptuneSuccess(Void result) {
                    AssetPanel.this.handleAfterAddTitleToOffer();
                }
            });
            this.refTitlesPanel.addViewChangeHandler(this.handler);
        }
        return widget;
    }

    public void handleAfterAddTitleToOffer() {
        if (this.titleView.getInput().getAssetName() != null && this.titleView.getInput().getAssetName().equalsIgnoreCase("ReferenceTitles")) {
            this.assetTree.setSelectedItem(this.assetTree.getReferenceTitleAssetTreeItem(), true);
        }
    }

    public void redraw() {
        this.showWidgetInRightScrollPanel((Widget)this.assetContent);
        this.updateSize();
    }

    private void showWidgetInRightScrollPanel(Widget widget) {
        this.rightScrollPanel.setWidget(widget);
    }

    public void redraw(AssetTree.AssetInfo assetInfo) {
        this.assetInfoWidgets.put(assetInfo, null);
        this.assetContent.setWidget((Widget)this.getAssetContent(assetInfo));
        this.redraw();
        this.fireViewChangeEvent();
    }

    private void fireViewChangeEvent() {
        this.fireEvent(new ViewChangeEvent());
        this.dirty = true;
        for (AssetContent content : this.assetInfoWidgets.values()) {
            if (content == null) continue;
            content.markDirty();
        }
    }

    public AssetTree.AssetInfo getInput() {
        return this.input;
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                AssetPanel.this.updateSize();
            }
        });
    }

    protected void onUnload() {
        this.contextMenu.hide();
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        super.onUnload();
    }

    public void updateSize() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                AssetPanel.this.height = Window.getClientHeight() - 265 - 31 - 30;
                for (Widget w : AssetPanel.this.offsettingWidgets) {
                    AssetPanel.this.height -= w.getOffsetHeight();
                }
                if (AssetPanel.this.getLeftScrollPanelHeight() + 34 >= AssetPanel.this.height) {
                    AssetPanel.this.leftScrollPanel.setHeight(String.valueOf(AssetPanel.this.height - 34) + "px");
                } else {
                    AssetPanel.this.leftScrollPanel.setHeight("100%");
                }
                AssetPanel.this.rightScrollPanel.setHeight(String.valueOf(AssetPanel.this.height) + "px");
            }
        });
    }

    public int getLeftScrollPanelHeight() {
        return this.leftScrollPanel.getElement().getClientHeight();
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public HandlerRegistration addViewChangeHandler(ViewChangeHandler handler) {
        return this.addHandler(handler, ViewChangeEvent.getType());
    }

    private final class AddAssetCommand
    implements Command {
        private final TreeItem parentTreeItem;
        private final UIGroupAsset parentAsset;
        private final UIAssetDefinition assetDef;

        public AddAssetCommand(TreeItem treeItem, UIGroupAsset parentAsset, UIAssetDefinition assetDefinition) {
            this.parentTreeItem = treeItem;
            this.parentAsset = parentAsset;
            this.assetDef = assetDefinition;
        }

        public void execute() {
            UIAsset newAsset = AssetPanel.this.assetFactory.createAsset(this.assetDef, true, AssetPanel.this.input.isBatchEdit());
            this.parentAsset.addChild(newAsset);
            AssetTree.AssetInfo assetInfo = new AssetTree.AssetInfo(AssetPanel.this.input.getInput(), newAsset, this.assetDef, AssetPanel.this.input.isBatchEdit());
            AssetPanel.this.assetTree.addTreeItem(assetInfo, this.parentTreeItem);
            AssetPanel.this.contextMenu.hide();
            AssetPanel.this.fireViewChangeEvent();
            AssetPanel.this.updateSize();
        }
    }

    private final class CreateImageFromVideoCommand
    implements Command {
        private final TreeItem treeItem;

        public CreateImageFromVideoCommand(TreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public void execute() {
            AssetTree.AssetInfo object = AssetPanel.this.assetTree.getAssetInfo(this.treeItem);
            VideoSnapshotPanel videoSnapshotPanel = new VideoSnapshotPanel();
            AssetPanel.this.showWidgetInRightScrollPanel((Widget)videoSnapshotPanel);
            videoSnapshotPanel.setTitleView(AssetPanel.this.titleView);
            videoSnapshotPanel.setAssetPanel(AssetPanel.this);
            videoSnapshotPanel.setAssetInfo(object);
            AssetPanel.this.contextMenu.hide();
        }
    }

    private final class DoNothingCommand
    implements Command {
        public DoNothingCommand(TreeItem treeItem) {
        }

        public void execute() {
        }
    }

    private class EventHandler
    implements ViewChangeHandler {
        private EventHandler() {
        }

        @Override
        public void onViewChange(ViewChangeEvent event) {
            AssetPanel.this.fireViewChangeEvent();
        }
    }

    private final class RemoveAssetCommand
    implements Command {
        private final TreeItem treeItem;

        public RemoveAssetCommand(TreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public void execute() {
            AssetTree.AssetInfo object = AssetPanel.this.assetTree.getAssetInfo(this.treeItem);
            AssetTree.AssetInfo parentObject = AssetPanel.this.assetTree.getAssetInfo(this.treeItem.getParentItem());
            ((UIGroupAsset)parentObject.getAsset()).removeChild(object.getAsset());
            this.removeTreeItem(this.treeItem);
            AssetPanel.this.assetTree.setSelectedAssetInfo(parentObject);
            AssetPanel.this.contextMenu.hide();
            AssetPanel.this.fireViewChangeEvent();
        }

        private void removeTreeItem(TreeItem treeItem) {
            int index = 0;
            while (index < treeItem.getChildCount()) {
                this.removeTreeItem(treeItem.getChild(index));
                ++index;
            }
            treeItem.remove();
            AssetPanel.this.assetInfoWidgets.remove(AssetPanel.this.assetTree.getAssetInfo(treeItem));
        }
    }

    private final class SetAvailTimeCodesFromVideoCommand
    implements Command {
        private final TreeItem treeItem;

        public SetAvailTimeCodesFromVideoCommand(TreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public void execute() {
            AssetTree.AssetInfo object = AssetPanel.this.assetTree.getAssetInfo(this.treeItem);
            VideoAvailTimeCodePanel videoAvailTimeCodePanel = new VideoAvailTimeCodePanel();
            AssetPanel.this.showWidgetInRightScrollPanel((Widget)videoAvailTimeCodePanel);
            videoAvailTimeCodePanel.setTitleView(AssetPanel.this.titleView);
            videoAvailTimeCodePanel.setAssetPanel(AssetPanel.this);
            videoAvailTimeCodePanel.setAssetInfo(object);
            AssetPanel.this.contextMenu.hide();
        }
    }

    private final class SetImageFromKeyframesCommand
    implements Command {
        private final TreeItem treeItem;

        public SetImageFromKeyframesCommand(TreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public void execute() {
            AssetTree.AssetInfo object = AssetPanel.this.assetTree.getAssetInfo(this.treeItem);
            KeyframesSetImagePanel keyframesSetImagePanel = new KeyframesSetImagePanel();
            AssetPanel.this.showWidgetInRightScrollPanel((Widget)keyframesSetImagePanel);
            keyframesSetImagePanel.setAssetInfo(object);
            keyframesSetImagePanel.setAssetPanel(AssetPanel.this);
            AssetPanel.this.contextMenu.hide();
        }
    }

    private final class SetImageFromSnapshotsCommand
    implements Command {
        private final TreeItem treeItem;

        public SetImageFromSnapshotsCommand(TreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public void execute() {
            AssetTree.AssetInfo object = AssetPanel.this.assetTree.getAssetInfo(this.treeItem);
            SetVideoImagePanel setImageFromSnapshotsPanel = new SetVideoImagePanel();
            AssetPanel.this.showWidgetInRightScrollPanel((Widget)setImageFromSnapshotsPanel);
            setImageFromSnapshotsPanel.setAssetInfo(object);
            setImageFromSnapshotsPanel.setAssetPanel(AssetPanel.this);
            AssetPanel.this.contextMenu.hide();
        }
    }

    private final class SetMarkInMarkOutFromKeyframesCommand
    implements Command {
        private final TreeItem treeItem;

        public SetMarkInMarkOutFromKeyframesCommand(TreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public void execute() {
            AssetTree.AssetInfo object = AssetPanel.this.assetTree.getAssetInfo(this.treeItem);
            KeyframesLogicalClipPanel keyframesLogicalClipPanel = new KeyframesLogicalClipPanel();
            AssetPanel.this.showWidgetInRightScrollPanel((Widget)keyframesLogicalClipPanel);
            keyframesLogicalClipPanel.setAssetPanel(AssetPanel.this);
            keyframesLogicalClipPanel.setAssetInfo(object);
            AssetPanel.this.contextMenu.hide();
        }
    }

    private final class SetMarkInMarkOutFromVideoCommand
    implements Command {
        private final TreeItem treeItem;

        public SetMarkInMarkOutFromVideoCommand(TreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public void execute() {
            AssetTree.AssetInfo object = AssetPanel.this.assetTree.getAssetInfo(this.treeItem);
            VideoLogicalClipPanel videoLogicalClipPanel = new VideoLogicalClipPanel();
            AssetPanel.this.showWidgetInRightScrollPanel((Widget)videoLogicalClipPanel);
            videoLogicalClipPanel.setTitleView(AssetPanel.this.titleView);
            videoLogicalClipPanel.setAssetPanel(AssetPanel.this);
            videoLogicalClipPanel.setAssetInfo(object);
            AssetPanel.this.contextMenu.hide();
        }
    }
}

