/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.HasContextMenuHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTreeItemBuilder;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeResource;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import java.util.ArrayList;
import java.util.HashSet;

public class AssetTree
extends TreeWidget
implements HasContextMenuHandlers {
    private static final String STYLE_NAME = "content-AssetTree";
    protected AssetTreeItemBuilder itemBuilder = new AssetTreeItemBuilder();

    public AssetTree(AssetInfo rootAsset) {
        this.addStyleName(STYLE_NAME);
        TreeItem rootItem = this.createItem(rootAsset);
        this.addItem(rootItem);
    }

    public AssetTree(TreeResource myResource, AssetInfo rootAsset) {
        super((Tree.Resources)myResource);
        this.addStyleName(STYLE_NAME);
        TreeItem rootItem = this.createItem(rootAsset);
        this.addItem(rootItem);
    }

    public void addItem(AssetInfo rootAsset) {
        this.addStyleName(STYLE_NAME);
        TreeItem rootItem = this.createItem(rootAsset);
        rootItem.addItem(this.createItem(rootAsset));
        this.addItem(rootItem);
    }

    public AssetInfo getAssetInfo(TreeItem treeItem) {
        AssetInfo assetInfo = null;
        if (treeItem != null && treeItem.getUserObject() instanceof AssetInfo) {
            assetInfo = (AssetInfo)treeItem.getUserObject();
        }
        return assetInfo;
    }

    public TreeItem getReferenceTitleAssetTreeItem() {
        return this.itemBuilder.getReferenceTitleTreeItem();
    }

    public AssetInfo getSelectedAssetInfo() {
        return this.getAssetInfo(this.getSelectedItem());
    }

    public void setSelectedAssetInfo(AssetInfo assetInfo) {
        if (assetInfo == null) {
            return;
        }
        TreeItem item = this.findItem(assetInfo);
        if (item != null) {
            this.setSelectedItem(item);
        }
    }

    public void onBrowserEvent(Event event) {
        int evType = DOM.eventGetType((Event)event);
        switch (evType) {
            case 4: {
                if (DOM.eventGetButton((Event)event) == 2) {
                    NativeEvent nativeEvent = Document.get().createMouseDownEvent(-1, event.getScreenX(), event.getScreenY(), event.getClientX(), event.getClientY(), event.getCtrlKey(), event.getAltKey(), event.getShiftKey(), event.getMetaKey(), 1);
                    DOM.eventGetTarget((Event)event).dispatchEvent(nativeEvent);
                    break;
                }
                super.onBrowserEvent(event);
                break;
            }
            default: {
                super.onBrowserEvent(event);
            }
        }
    }

    public HandlerRegistration addContextMenuHandler(ContextMenuHandler handler) {
        return this.addDomHandler((EventHandler)handler, ContextMenuEvent.getType());
    }

    public void addTreeItem(AssetInfo assetInfo, AssetInfo parentAssetInfo) {
        this.addTreeItem(assetInfo, this.findItem(parentAssetInfo));
    }

    public void addTreeItem(AssetInfo assetInfo, TreeItem parentTreeItem) {
        TreeItem oldSelection = this.getSelectedItem();
        TreeItem newTreeItem = this.createItem(assetInfo);
        AssetInfo parentAssetInfo = this.getAssetInfo(parentTreeItem);
        String assetType = assetInfo.getDefinition().getAssetType();
        UIGroupAssetDefinition definition = (UIGroupAssetDefinition)parentAssetInfo.getDefinition();
        HashSet<String> precedingAssetTypes = new HashSet<String>();
        for (UIAssetDefinition childDefinition : definition.getChildren()) {
            precedingAssetTypes.add(childDefinition.getAssetType());
            if (childDefinition.getAssetType().equals(assetType)) break;
        }
        ArrayList<TreeItem> childTreeItems = new ArrayList<TreeItem>();
        boolean inserted = false;
        int index = 0;
        while (index < parentTreeItem.getChildCount()) {
            TreeItem childTreeItem = parentTreeItem.getChild(index);
            String currentAssetType = this.getAssetInfo(childTreeItem).getDefinition().getAssetType();
            if (!inserted && !precedingAssetTypes.contains(currentAssetType)) {
                childTreeItems.add(newTreeItem);
                inserted = true;
            }
            childTreeItems.add(childTreeItem);
            ++index;
        }
        if (!inserted) {
            childTreeItems.add(newTreeItem);
        }
        parentTreeItem.removeItems();
        for (TreeItem childTreeItem : childTreeItems) {
            parentTreeItem.addItem(childTreeItem);
        }
        if (oldSelection != null && oldSelection != this.getSelectedItem()) {
            this.setSelectedItem(oldSelection);
        }
    }

    protected TreeItem createItem(AssetInfo assetInfo) {
        return this.itemBuilder.buildTreeItem(assetInfo);
    }

    private TreeItem findItem(AssetInfo assetInfo) {
        int i = 0;
        while (i < this.getItemCount()) {
            TreeItem item = this.findItem(assetInfo, this.getItem(i));
            if (item != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private TreeItem findItem(AssetInfo assetInfo, TreeItem item) {
        TreeItem matchedItem = null;
        AssetInfo object = this.getAssetInfo(item);
        if (assetInfo.equals(object)) {
            matchedItem = item;
        } else {
            int i = 0;
            while (i < item.getChildCount()) {
                matchedItem = this.findItem(assetInfo, item.getChild(i));
                if (matchedItem != null) break;
                ++i;
            }
        }
        return matchedItem;
    }

    public static final class AssetInfo {
        private final TitleViewInput input;
        private final UIAsset asset;
        private final UIAssetDefinition assetDefinition;
        private final boolean isBatchEdit;

        public AssetInfo(TitleViewInput input, UIAsset asset, UIAssetDefinition assetDefinition) {
            this(input, asset, assetDefinition, false);
        }

        public AssetInfo(TitleViewInput input, UIAsset asset, UIAssetDefinition assetDefinition, boolean isBatchEdit) {
            this.input = input;
            this.asset = asset;
            this.assetDefinition = assetDefinition;
            this.isBatchEdit = isBatchEdit;
        }

        public UIAsset getAsset() {
            return this.asset;
        }

        public UIAssetDefinition getDefinition() {
            return this.assetDefinition;
        }

        public boolean isBatchEdit() {
            return this.isBatchEdit;
        }

        public TitleViewInput getInput() {
            return this.input;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof AssetInfo)) {
                return false;
            }
            return ((AssetInfo)other).getAsset().equals(this.getAsset());
        }
    }
}

