/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIItemAsset;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.thumbnail.TitleThumbnailWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.IUIAssetDefinitionVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIItemAssetDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class AssetTreeItemBuilder
implements IUIAssetDefinitionVisitor {
    protected transient AssetTree.AssetInfo parentAssetInfo;
    protected transient TreeItem parentTreeItem;
    private static final String STYLE_ITEM = "content-AssetTree-item";
    private static final String STYLE_ITEM_LABEL = "content-AssetTree-itemLabel";
    private static final String STYLE_ITEM_THUMBNAIL = "content-AssetTree-itemThumbnail";
    public TreeItem refTitleIdItem;

    public TreeItem buildTreeItem(AssetTree.AssetInfo assetInfo) {
        UIGroupAsset root;
        TreeItem item = new TreeItem(this.buildTreeItemWidget(assetInfo));
        item.setUserObject((Object)assetInfo);
        this.buildChildTreeItems(item, assetInfo);
        item.setState(true);
        if (assetInfo.getAsset() instanceof UIGroupAsset && (root = (UIGroupAsset)assetInfo.getAsset()).getAssetType().equalsIgnoreCase("Package") && assetInfo.getInput().isOfferTitle() && !assetInfo.getInput().isBulkEdit()) {
            this.refTitleIdItem = new TreeItem(this.buildTreeItemWidgetForRefTitleIDs());
            this.refTitleIdItem.setUserObject((Object)assetInfo);
            this.refTitleIdItem.setTitle("ReferencedTitles");
            item.addItem(this.refTitleIdItem);
        }
        return item;
    }

    public TreeItem getReferenceTitleTreeItem() {
        return this.refTitleIdItem;
    }

    private Widget buildTreeItemWidget(AssetTree.AssetInfo assetInfo) {
        HorizontalContainer container = new HorizontalContainer();
        container.addStyleName(STYLE_ITEM);
        container.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        LabelWidget label = new LabelWidget(assetInfo.getDefinition().getDisplayName());
        label.addStyleName(STYLE_ITEM_LABEL);
        container.add((Widget)label);
        if (assetInfo.getAsset().isThumbnailAvailable()) {
            TitleThumbnailWidget thumbnail = new TitleThumbnailWidget();
            thumbnail.addStyleName(STYLE_ITEM_THUMBNAIL);
            thumbnail.setInput(assetInfo.getInput().getTitleId(), assetInfo.getAsset().getId());
            container.add((Widget)thumbnail);
        }
        return container;
    }

    protected void buildChildTreeItems(TreeItem treeItem, AssetTree.AssetInfo assetInfo) {
        UIAssetDefinition definition = assetInfo.getDefinition();
        if (definition instanceof UIGroupAssetDefinition) {
            UIGroupAssetDefinition groupDefinition = (UIGroupAssetDefinition)definition;
            for (UIAssetDefinition childDefinition : groupDefinition.getChildren()) {
                this.parentAssetInfo = assetInfo;
                this.parentTreeItem = treeItem;
                childDefinition.accept((IUIAssetDefinitionVisitor)this);
                this.parentAssetInfo = null;
                this.parentTreeItem = null;
            }
        }
    }

    public void visit(UIGroupAssetDefinition assetDefinition) {
        AssetTree.AssetInfo parentAssetInfo = this.parentAssetInfo;
        TreeItem parentTreeItem = this.parentTreeItem;
        UIGroupAsset parentAsset = (UIGroupAsset)parentAssetInfo.getAsset();
        for (UIGroupAsset asset : parentAsset.getChildGroups(assetDefinition.getAssetType())) {
            AssetTree.AssetInfo childAssetInfo = new AssetTree.AssetInfo(parentAssetInfo.getInput(), asset, (UIAssetDefinition)assetDefinition, parentAssetInfo.isBatchEdit());
            parentTreeItem.addItem(this.buildTreeItem(childAssetInfo));
        }
    }

    public void visit(UIItemAssetDefinition assetDefinition) {
        AssetTree.AssetInfo parentAssetInfo = this.parentAssetInfo;
        TreeItem parentTreeItem = this.parentTreeItem;
        UIGroupAsset parentAsset = (UIGroupAsset)parentAssetInfo.getAsset();
        for (UIItemAsset asset : parentAsset.getChildItems(assetDefinition.getAssetType())) {
            AssetTree.AssetInfo childAssetInfo = new AssetTree.AssetInfo(parentAssetInfo.getInput(), asset, (UIAssetDefinition)assetDefinition, parentAssetInfo.isBatchEdit());
            parentTreeItem.addItem(this.buildTreeItem(childAssetInfo));
        }
    }

    private Widget buildTreeItemWidgetForRefTitleIDs() {
        HorizontalContainer container = new HorizontalContainer();
        container.addStyleName(STYLE_ITEM);
        container.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        LabelWidget label = new LabelWidget("Referenced Titles");
        label.addStyleName(STYLE_ITEM_LABEL);
        container.add((Widget)label);
        return container;
    }
}

