/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.asset.MetadataTypeMismatchException;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex.ComplexFieldGroupWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex.ComplexFieldWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class ComplexFieldGroupContainer
extends ComplexFieldGroupWidget {
    private VerticalContainer container;
    private IUIAssetFactory assetFactory = new UIAssetFactory();
    private static final String STYLE_NAME = "content-ComplexFieldGroupContainer";
    private static final String STYLE_ERROR_CONTAINER = "content-ComplexFieldGroupContainer-errorDisclosureContainer";

    public ComplexFieldGroupContainer(UIComplexFieldDefinition fieldDefinition, boolean readOnly) {
        super(fieldDefinition, readOnly);
        this.container = new VerticalContainer();
        this.container.addStyleName(STYLE_NAME);
        this.initWidget((Widget)this.container);
    }

    @Override
    public void refresh() {
        this.container.clear();
        if (this.getParentField() == null) {
            return;
        }
        List<UIComplexField> inputFields = null;
        try {
            inputFields = this.getFields();
        }
        catch (MetadataTypeMismatchException mtme) {
            this.reportMismatchError(mtme);
            return;
        }
        for (UIComplexField field : inputFields) {
            Widget widget = this.buildComplexFieldWidget(field);
            this.container.add(widget);
        }
        this.addNewFieldWidgets();
    }

    private Widget buildComplexFieldWidget(UIComplexField field) {
        final ComplexFieldWidget widget = new ComplexFieldWidget(this.getFieldDefinition(), this.isReadOnly(), this.getParentAsset().isBatchEdit());
        widget.addViewChangeHandler(this.getViewChangeEventDelegator());
        widget.setInput(this.getParentAsset(), field);
        boolean visible = !this.isReadOnly() && this.getFieldDefinition().getMaximumCount() != 1;
        ButtonWidget addButton = widget.getAddButton();
        addButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ComplexFieldGroupContainer.this.handleAddButtonClick(widget);
            }
        });
        addButton.setVisible(visible);
        addButton.setEnabled(visible);
        ButtonWidget removeButton = widget.getRemoveButton();
        removeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ComplexFieldGroupContainer.this.handleRemoveButtonClick(widget);
            }
        });
        removeButton.setVisible(visible);
        removeButton.setEnabled(visible);
        return widget;
    }

    private void addNewFieldWidgets() {
        int fieldCount = this.getFieldCount();
        int minCount = this.getFieldDefinition().getMinimumCount();
        if (minCount <= 0) {
            minCount = 1;
        }
        int count = fieldCount;
        while (count < minCount) {
            UIComplexField newField = this.createNewField();
            Widget widget = this.buildComplexFieldWidget(newField);
            this.container.add(widget);
            ++count;
        }
    }

    private UIComplexField createNewField() {
        UIComplexFieldDefinition definition = this.getFieldDefinition();
        UIComplexField newField = (UIComplexField)this.assetFactory.createAssetField((UIFieldDefinition)definition);
        this.getParentField().addField(newField);
        return newField;
    }

    private void handleAddButtonClick(ComplexFieldWidget widget) {
        if (this.isReadOnly()) {
            return;
        }
        int index = this.container.getWidgetIndex((Widget)widget);
        if (index == -1) {
            return;
        }
        int maxCount = this.getFieldDefinition().getMaximumCount();
        if (maxCount != -1 && maxCount <= this.getFieldCount()) {
            return;
        }
        UIComplexField newField = this.createNewField();
        Widget newWidget = this.buildComplexFieldWidget(newField);
        this.container.insert(newWidget, index + 1);
        this.fireViewChangeEvent();
    }

    private void handleRemoveButtonClick(ComplexFieldWidget widget) {
        if (this.isReadOnly()) {
            return;
        }
        int index = this.container.getWidgetIndex((Widget)widget);
        if (index == -1) {
            return;
        }
        widget.removeFromParent();
        this.getParentField().removeField(widget.getField());
        this.fireViewChangeEvent();
        this.addNewFieldWidgets();
    }

    @Override
    public void validate(List<AssetValidationMessage> messages, boolean draft) {
        for (Widget widget : this.container) {
            if (!(widget instanceof ComplexFieldWidget)) continue;
            ComplexFieldWidget complexFieldWidget = (ComplexFieldWidget)widget;
            complexFieldWidget.validate(messages, draft);
        }
    }

    @Override
    public void reportMismatchError(MetadataTypeMismatchException mtme) {
        String heading = this.getFieldDefinition().getDisplayName();
        RoundedDisclosureContainer disclosure = new RoundedDisclosureContainer(heading, true);
        disclosure.addStyleName(STYLE_ERROR_CONTAINER);
        Widget errorWidget = this.buildMetadataMismatchErrorWidget(mtme);
        disclosure.setContent(errorWidget);
        this.container.add((Widget)disclosure);
    }
}

