/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.HasViewChangeHandlers;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessageCache;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeEvent;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.asset.MetadataTypeMismatchException;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.CollapsedFieldHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex.ComplexFieldGroupWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex.table.ComplexFieldTable;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.table.SimpleFieldTable;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComplexFieldWidget
extends Composite
implements HasViewChangeHandlers {
    private SimpleContainer container;
    private DisclosureContainer disclosureContainer;
    private ButtonWidget addButton;
    private ButtonWidget removeButton;
    private SimpleFieldTable simpleFieldContainer;
    private VerticalContainer complexGroupContainer;
    private EventHandler internalHandler = new EventHandler();
    private UIComplexFieldDefinition fieldDefinition;
    private boolean readOnly;
    private AssetTree.AssetInfo parentAsset;
    private UIComplexField field;
    private TitleViewMessages messages = TitleViewMessageCache.getMessages();
    private Map<UIComplexFieldDefinition, ComplexFieldGroupWidget> complexWidgetMap;
    private IUIAssetFactory assetFactory;
    private static final String STYLE_NAME = "content-ComplexFieldWidget";
    private static final String STYLE_DISCLOSURE_CONTAINER = "content-ComplexFieldWidget-disclosureContainer";
    private static final String STYLE_DISCLOSURE_HEADER = "content-ComplexFieldWidget-disclosureHeader";
    private static final String STYLE_HEADER_LABEL = "content-ComplexFieldWidget-disclosureHeader-label";
    private static final String STYLE_HEADER_ADD_BUTTON = "content-ComplexFieldWidget-disclosureHeader-addButton";
    private static final String STYLE_HEADER_REMOVE_BUTTON = "content-ComplexFieldWidget-disclosureHeader-removeButton";
    private static final String STYLE_DISCLOSURE_CONTENTS = "content-ComplexFieldWidget-disclosureContents";
    private static final String STYLE_COMPLEX_GROUPS_TABLE = "content-ComplexFieldWidget-complexGroupsContainer";

    public ComplexFieldWidget(UIComplexFieldDefinition definition, boolean readOnly) {
        this(definition, readOnly, true);
    }

    public ComplexFieldWidget(UIComplexFieldDefinition definition, boolean readOnly, boolean batchEdit) {
        this.fieldDefinition = definition;
        this.readOnly = readOnly;
        this.complexWidgetMap = new HashMap<UIComplexFieldDefinition, ComplexFieldGroupWidget>();
        this.assetFactory = new UIAssetFactory();
        this.container = new SimpleContainer();
        this.initWidget((Widget)this.container);
        this.initialize(batchEdit);
    }

    private void initialize(boolean batchEdit) {
        this.addStyleName(STYLE_NAME);
        Widget headingWidget = this.buildHeadingWidget();
        this.disclosureContainer = new RoundedDisclosureContainer(headingWidget, true);
        this.disclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.container.add((Widget)this.disclosureContainer);
        VerticalContainer contentContainer = new VerticalContainer();
        contentContainer.addStyleName(STYLE_DISCLOSURE_CONTENTS);
        this.disclosureContainer.setContent((Widget)contentContainer);
        this.simpleFieldContainer = new SimpleFieldTable(this.fieldDefinition, this.readOnly);
        this.simpleFieldContainer.addViewChangeHandler(this.internalHandler);
        contentContainer.add((Widget)this.simpleFieldContainer);
        this.complexGroupContainer = new VerticalContainer();
        this.complexGroupContainer.addStyleName(STYLE_COMPLEX_GROUPS_TABLE);
        contentContainer.add((Widget)this.complexGroupContainer);
        this.addComplexGroupWidgets(this.fieldDefinition, batchEdit);
    }

    private Widget buildHeadingWidget() {
        HorizontalContainer headingPanel = new HorizontalContainer();
        headingPanel.addStyleName(STYLE_DISCLOSURE_HEADER);
        LabelWidget headingLabel = new LabelWidget(this.getFieldDisplayName());
        headingLabel.addStyleName(STYLE_HEADER_LABEL);
        headingPanel.add((Widget)headingLabel);
        this.addButton = new ButtonWidget(this.messages.fieldAddButton());
        this.addButton.addStyleName(STYLE_HEADER_ADD_BUTTON);
        this.addButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                event.stopPropagation();
            }
        });
        this.addButton.setVisible(false);
        this.addButton.setEnabled(false);
        headingPanel.add((Widget)this.addButton);
        this.removeButton = new ButtonWidget(this.messages.fieldRemoveButton());
        this.removeButton.addStyleName(STYLE_HEADER_REMOVE_BUTTON);
        this.removeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                event.stopPropagation();
            }
        });
        this.removeButton.setVisible(false);
        this.removeButton.setEnabled(false);
        headingPanel.add((Widget)this.removeButton);
        return headingPanel;
    }

    protected String getFieldDisplayName() {
        return this.fieldDefinition.getDisplayName();
    }

    private void addComplexGroupWidgets(UIComplexFieldDefinition parent, boolean batchEdit) {
        if (batchEdit && !parent.isBatch()) {
            return;
        }
        ComplexFieldTable widget = null;
        for (UIFieldDefinition child : parent.getChildren()) {
            if (!(child instanceof UIComplexFieldDefinition) || batchEdit && !child.isBatch()) continue;
            UIComplexFieldDefinition complexChild = (UIComplexFieldDefinition)child;
            if (complexChild.getMaximumCount() != 1) {
                widget = new ComplexFieldTable(complexChild, this.readOnly);
                widget.addViewChangeHandler(this.internalHandler);
                this.complexGroupContainer.add((Widget)widget);
                this.complexWidgetMap.put(complexChild, widget);
                continue;
            }
            this.addComplexGroupWidgets(complexChild, batchEdit);
        }
    }

    public ButtonWidget getAddButton() {
        return this.addButton;
    }

    public ButtonWidget getRemoveButton() {
        return this.removeButton;
    }

    public void setInput(AssetTree.AssetInfo asset, UIComplexField complexField) {
        this.parentAsset = asset;
        this.field = complexField;
        this.simpleFieldContainer.setInput(this.parentAsset, this.field);
        for (Widget widget : this.complexGroupContainer) {
            if (!(widget instanceof ComplexFieldGroupWidget)) continue;
            ComplexFieldGroupWidget complexGroupWidget = (ComplexFieldGroupWidget)widget;
            try {
                this.setInput(complexGroupWidget);
            }
            catch (MetadataTypeMismatchException mtme) {
                complexGroupWidget.setInput(this.parentAsset, null);
                complexGroupWidget.reportMismatchError(mtme);
            }
        }
    }

    private void setInput(ComplexFieldGroupWidget complexGroupWidget) throws MetadataTypeMismatchException {
        UIComplexFieldDefinition targetDefinition = complexGroupWidget.getFieldDefinition();
        CollapsedFieldHandler handler = new CollapsedFieldHandler(this.assetFactory, this.fieldDefinition, (UIFieldDefinition)targetDefinition);
        UIComplexField parent = handler.getCollapsedFieldParent(this.field);
        complexGroupWidget.setInput(this.parentAsset, parent);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public UIComplexFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public AssetTree.AssetInfo getParentAsset() {
        return this.parentAsset;
    }

    public UIComplexField getField() {
        return this.field;
    }

    protected TitleViewMessages getViewMessages() {
        return this.messages;
    }

    public void refresh() {
        this.simpleFieldContainer.refresh();
        for (Widget widget : this.complexGroupContainer) {
            if (!(widget instanceof ComplexFieldGroupWidget)) continue;
            ComplexFieldGroupWidget complexGroupWidget = (ComplexFieldGroupWidget)widget;
            complexGroupWidget.refresh();
        }
        this.disclosureContainer.setOpen(true);
    }

    public void validate(List<AssetValidationMessage> messages, boolean draft) {
        this.simpleFieldContainer.validate(messages, draft);
        for (Widget widget : this.complexGroupContainer) {
            if (!(widget instanceof ComplexFieldGroupWidget)) continue;
            ComplexFieldGroupWidget complexGroupWidget = (ComplexFieldGroupWidget)widget;
            complexGroupWidget.validate(messages, draft);
        }
    }

    @Override
    public HandlerRegistration addViewChangeHandler(ViewChangeHandler handler) {
        return this.addHandler(handler, ViewChangeEvent.getType());
    }

    private class EventHandler
    implements ViewChangeHandler {
        private EventHandler() {
        }

        @Override
        public void onViewChange(ViewChangeEvent event) {
            ComplexFieldWidget.this.fireEvent(event);
        }
    }
}

