/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex.table;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasKeyUpHandlers;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetContentTable;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.asset.MetadataTypeMismatchException;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.CollapsedFieldHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex.ComplexFieldGroupWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.complex.table.ComplexTableMetadataWidgetBuilder;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.SimpleFieldWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PushButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComplexFieldTable
extends ComplexFieldGroupWidget {
    private DisclosureContainer disclosureContainer;
    private SimpleContainer container;
    private AssetContentTable table;
    private final List<UISimpleFieldDefinition> columnFieldDefinitions = new ArrayList<UISimpleFieldDefinition>();
    private IUIAssetFactory assetFactory = new UIAssetFactory();
    private UIComplexField newField = null;
    private List<HandlerRegistration> newFieldHandlers = new ArrayList<HandlerRegistration>();
    private Map<UIComplexField, Widget> rowIdentifier = new HashMap<UIComplexField, Widget>();
    private static final String STYLE_NAME = "content-ComplexFieldTable";
    private static final String STYLE_CONTAINER = "content-ComplexFieldTable-container";
    private static final String STYLE_ASSET_TABLE = "content-ComplexFieldTable-assetTable";

    public ComplexFieldTable(UIComplexFieldDefinition fieldDefinition, boolean readOnly) {
        super(fieldDefinition, readOnly);
        String heading = fieldDefinition.getDisplayName();
        this.disclosureContainer = new RoundedDisclosureContainer(heading, true);
        this.disclosureContainer.addStyleName(STYLE_NAME);
        this.container = new SimpleContainer();
        this.container.addStyleName(STYLE_CONTAINER);
        this.disclosureContainer.setContent((Widget)this.container);
        this.initWidget((Widget)this.disclosureContainer);
        this.initialize();
    }

    private void initialize() {
        this.table = new AssetContentTable();
        this.table.addStyleName(STYLE_ASSET_TABLE);
        this.container.setWidget((Widget)this.table);
        this.buildColumnFieldDefinitions((UIFieldDefinition)this.getFieldDefinition());
        int colIndex = 0;
        for (UISimpleFieldDefinition columnFieldDefinition : this.columnFieldDefinitions) {
            this.table.addHeading(columnFieldDefinition.getDisplayName());
            LabelWidget widget = this.table.getHeadingWidget(colIndex);
            widget.setTitle(columnFieldDefinition.getXPath());
            ++colIndex;
        }
    }

    private void buildColumnFieldDefinitions(UIFieldDefinition fieldDefinition) {
        if (fieldDefinition instanceof UIComplexFieldDefinition) {
            UIComplexFieldDefinition complexDefinition = (UIComplexFieldDefinition)fieldDefinition;
            for (UIFieldDefinition childDefinition : complexDefinition.getChildren()) {
                this.buildColumnFieldDefinitions(childDefinition);
            }
        } else if (fieldDefinition instanceof UISimpleFieldDefinition) {
            this.columnFieldDefinitions.add((UISimpleFieldDefinition)fieldDefinition);
        }
    }

    @Override
    public void refresh() {
        boolean applyCC;
        this.disclosureContainer.setOpen(true);
        this.table.removeAllRows();
        this.rowIdentifier.clear();
        this.clearNewRowState();
        this.container.setWidget((Widget)this.table);
        if (this.getParentField() == null) {
            return;
        }
        boolean bl = applyCC = this.getParentAsset().getAsset().getId() == null;
        if (applyCC) {
            boolean hasNonDefaultValue = false;
            for (UISimpleFieldDefinition fieldDefinition : this.columnFieldDefinitions) {
                if (fieldDefinition.getDefaultValue() == null || fieldDefinition.getDefaultValue().isEmpty()) continue;
                hasNonDefaultValue = true;
            }
            if (hasNonDefaultValue) {
                UIComplexField field = (UIComplexField)this.assetFactory.createAssetField((UIFieldDefinition)this.getFieldDefinition());
                this.getParentField().addField(field);
            }
        }
        List<UIComplexField> inputFields = null;
        try {
            inputFields = this.getFields();
        }
        catch (MetadataTypeMismatchException mtme) {
            this.reportMismatchError(mtme);
            return;
        }
        for (UIComplexField field : inputFields) {
            this.buildRow(field, applyCC);
        }
        this.addNewFieldRow();
    }

    private void buildRow(UIComplexField field, boolean applyContentClass) {
        int row = this.table.addRow();
        for (UISimpleFieldDefinition fieldDefinition : this.columnFieldDefinitions) {
            Widget widget = this.buildMetadataWidget(field, fieldDefinition, applyContentClass);
            this.table.addCell(row, widget);
        }
        Widget deleteButton = this.buildDeleteButton(field);
        this.table.addCell(row, deleteButton);
        this.table.addTableCellStyle(row, this.table.getCellCount(row) - 1, "content-AssetContentTable-cell-body-delete");
        this.rowIdentifier.put(field, deleteButton);
    }

    private void addNewFieldRow() {
        boolean showNewRow;
        int maxCount = this.getFieldDefinition().getMaximumCount();
        int rowCount = this.table.getRowCount();
        boolean newRowMissing = this.newField == null;
        boolean underMaxLimit = maxCount == -1 || maxCount > rowCount;
        boolean bl = showNewRow = !this.isReadOnly() || rowCount == 0;
        if (newRowMissing && underMaxLimit && showNewRow) {
            this.newField = (UIComplexField)this.assetFactory.createAssetField((UIFieldDefinition)this.getFieldDefinition());
            this.buildRow(this.newField, false);
        }
    }

    private void clearNewRowState() {
        this.newField = null;
        for (HandlerRegistration registration : this.newFieldHandlers) {
            registration.removeHandler();
        }
        this.newFieldHandlers.clear();
    }

    private void handleFieldUpdated(UIComplexField field) {
        if (field.equals(this.newField)) {
            this.getParentField().addField(field);
            this.clearNewRowState();
            this.showDeleteButton(field);
            this.addNewFieldRow();
        }
        this.fireViewChangeEvent();
    }

    private void handleFieldDeleted(UIComplexField field) {
        this.addNewFieldRow();
        this.fireViewChangeEvent();
    }

    private Widget buildDeleteButton(final UIComplexField field) {
        ImageWidget image = new ImageWidget("cms_contentmgmt_ui/resources/images/title_metadata_delete.gif");
        final PushButtonWidget button = new PushButtonWidget(image);
        button.addStyleName("content-AssetContent-deleteButton");
        boolean isReadOnly = this.isReadOnly() || field.equals(this.newField);
        button.setEnabled(!isReadOnly);
        button.setVisible(!isReadOnly);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ComplexFieldTable.this.handleDeleteButtonClicked(field, (Widget)button, event);
            }
        });
        return button;
    }

    private void showDeleteButton(UIComplexField field) {
        Widget lookupWidget = this.rowIdentifier.get(field);
        int row = this.table.getRow(lookupWidget);
        int column = this.columnFieldDefinitions.size();
        if (row >= 0 && column >= 0) {
            FocusWidget button = (FocusWidget)this.table.getCellWidget(row, column);
            button.setEnabled(true);
            button.setVisible(true);
        }
    }

    private void handleDeleteButtonClicked(UIComplexField field, Widget button, ClickEvent event) {
        if (!this.validateFieldDelete(field)) {
            return;
        }
        int row = this.table.getRow(button);
        this.table.removeRow(row);
        this.rowIdentifier.remove(field);
        this.getParentField().removeField(field);
        this.handleFieldDeleted(field);
    }

    private boolean validateFieldDelete(UIComplexField field) {
        return !this.isReadOnly() && !field.equals(this.newField);
    }

    private Widget buildMetadataWidget(UIComplexField field, UISimpleFieldDefinition definition, boolean applyContentClass) {
        ComplexTableMetadataWidgetBuilder builder = new ComplexTableMetadataWidgetBuilder(this);
        SimpleFieldWidget<?, ?, ?> fieldWidget = null;
        boolean fieldReadOnlyFlag = this.isReadOnly();
        try {
            UIField simpleField = this.getField(field, definition, applyContentClass);
            if (!fieldReadOnlyFlag) {
                fieldReadOnlyFlag = definition.isLocked();
            }
            fieldWidget = builder.build(field, definition, simpleField, fieldReadOnlyFlag);
        }
        catch (MetadataTypeMismatchException mtme) {
            return this.buildMetadataMismatchErrorWidget(mtme);
        }
        DataTypeWidget<?> widget = fieldWidget.getDataTypeWidget();
        if (!fieldReadOnlyFlag && field.equals(this.newField) && widget instanceof HasKeyUpHandlers) {
            MetadataWidgetKeyEventHandler handler = new MetadataWidgetKeyEventHandler(field, fieldWidget);
            HasKeyUpHandlers keyAwareWidget = (HasKeyUpHandlers)widget;
            this.newFieldHandlers.add(keyAwareWidget.addKeyUpHandler((KeyUpHandler)handler));
        }
        return fieldWidget;
    }

    private UIField getField(UIComplexField field, UISimpleFieldDefinition simpleDefinition, boolean applyContentClass) {
        UIComplexFieldDefinition complexDefinition = this.getFieldDefinition();
        CollapsedFieldHandler handler = new CollapsedFieldHandler(this.assetFactory, complexDefinition, (UIFieldDefinition)simpleDefinition);
        UIComplexField parentField = handler.getCollapsedFieldParent(field);
        UIField childField = parentField.getChildren().getField(simpleDefinition.getName());
        if (childField == null) {
            childField = this.assetFactory.createAssetField((UIFieldDefinition)simpleDefinition);
            if (applyContentClass && childField instanceof UISimpleField) {
                ((UISimpleField)childField).setStringValue(simpleDefinition.getDefaultValue());
            }
            parentField.addField(childField);
        }
        return childField;
    }

    void handleMetadataValueChanged(UIComplexField field, SimpleFieldWidget<?, ?, ?> widget) {
        this.handleFieldUpdated(field);
    }

    private void handleKeyUpEvent(UIComplexField field, SimpleFieldWidget<?, ?, ?> widget, KeyUpEvent event) {
        if (!field.equals(this.newField)) {
            return;
        }
        String stringValue = widget.getDataTypeWidget().getTextValue();
        if (stringValue != null && stringValue.length() > 0) {
            this.handleFieldUpdated(field);
        }
    }

    @Override
    public void validate(List<AssetValidationMessage> messages, boolean draft) {
        SimpleFieldWidget widget = null;
        int row = 0;
        while (row < this.table.getRowCount()) {
            int column = 0;
            while (column < this.columnFieldDefinitions.size()) {
                widget = (SimpleFieldWidget)this.table.getCellWidget(row, column);
                if (!widget.isValidValue(draft)) {
                    String name = this.columnFieldDefinitions.get(column).getDisplayName();
                    String error = widget.getCurrentToolTip();
                    messages.add(new AssetValidationMessage(this.getParentAsset(), name, (Widget)widget, error));
                }
                ++column;
            }
            ++row;
        }
    }

    @Override
    public void reportMismatchError(MetadataTypeMismatchException mtme) {
        Widget errorWidget = this.buildMetadataMismatchErrorWidget(mtme);
        this.container.setWidget(errorWidget);
    }

    private final class MetadataWidgetKeyEventHandler
    implements KeyUpHandler {
        private UIComplexField field;
        private SimpleFieldWidget<?, ?, ?> widget;

        public MetadataWidgetKeyEventHandler(UIComplexField field, SimpleFieldWidget<?, ?, ?> widget) {
            this.field = field;
            this.widget = widget;
        }

        public void onKeyUp(KeyUpEvent event) {
            ComplexFieldTable.this.handleKeyUpEvent(this.field, this.widget, event);
        }
    }
}

