/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeCodeField;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.SimpleFieldWidget;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeCodeValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeCodeFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.TimeWidgetConfiguration;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

public class TimeCodeFieldWidget
extends SimpleFieldWidget<UITimeCodeFieldDefinition, UITimeCodeField, String> {
    public TimeCodeFieldWidget(UITimeCodeFieldDefinition fieldDefinition, UITimeCodeField field, TimeWidgetConfiguration configuration) {
        super(fieldDefinition, field, TimeCodeFieldWidget.createTimeCodeDataTypeWidget(configuration, field));
    }

    private static DataTypeWidget<String> createTimeCodeDataTypeWidget(TimeWidgetConfiguration configuration, UITimeCodeField field) {
        TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);
        IValueConverter<String> converter = new IValueConverter<String>(){

            public String validate(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                value = TimeCodeValidator.getInstance().normalize(value);
                if (TimeCodeValidator.getInstance().validate(value)) {
                    return value;
                }
                throw new ValueFormatException("Failed to convert value(" + value + ")");
            }

            public String getStringValue(String value) {
                return this.validate(value);
            }

            public String getTypedValue(String value) throws ValueFormatException {
                return this.validate(value);
            }
        };
        TypedTextBoxWidget widget = new TypedTextBoxWidget((IValueConverter)converter);
        if (!configuration.isReadOnly()) {
            widget.setToolTip(myConstants.validTimeCodeTitle());
            widget.setErrorToolTip(myConstants.invalidTimeCodeTitle());
        } else {
            widget.setReadOnly(true);
        }
        TimeCodeFieldWidget.initializeWidgetValue(widget, field);
        return widget;
    }

    private static <DataType, FieldType extends UISimpleField<DataType>> void initializeWidgetValue(DataTypeWidget<DataType> widget, FieldType simpleField) {
        if (simpleField.getValue() != null) {
            DataType value = simpleField.getValue();
            widget.setValue(value);
        } else if (simpleField.getStringValue() != null) {
            widget.setTextValue(simpleField.getStringValue());
        } else {
            widget.setValue(null);
        }
    }
}

