/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.table;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasKeyUpHandlers;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.asset.MetadataTypeMismatchException;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.SimpleFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.table.SimpleFieldTable;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.table.SimpleViewMetadataWidgetBuilder;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PushButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SimpleFieldGroup {
    private SimpleFieldTable fieldTable;
    private UISimpleFieldDefinition fieldDefinition;
    private boolean readOnly;
    private AssetTree.AssetInfo parentAsset;
    private UIComplexField parentField;
    private IUIAssetFactory assetFactory = new UIAssetFactory();
    private UISimpleField<?> newField;
    private List<HandlerRegistration> newFieldHandlers = new ArrayList<HandlerRegistration>();
    private Map<UISimpleField<?>, SimpleFieldView> viewIdentifier = new HashMap();
    private static final String STYLE_FIELD_WIDGET_CONTENTS = "content-SimpleFieldGroup-fieldWidget";
    static final String STYLE_FIELD_LABEL = "content-SimpleFieldGroup-fieldLabel";
    private static final String STYLE_NULLIFY_CHECKBOX = "content-SimpleFieldGroup-nullifyCheckBox";

    public SimpleFieldGroup(SimpleFieldTable table, UISimpleFieldDefinition fieldDefinition, boolean readOnly) {
        this.fieldTable = table;
        this.fieldDefinition = fieldDefinition;
        this.readOnly = readOnly;
    }

    public void setInput(AssetTree.AssetInfo parentAsset, UIComplexField parentField) {
        this.parentAsset = parentAsset;
        this.parentField = parentField;
        this.refresh();
    }

    public UISimpleFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public AssetTree.AssetInfo getParentAsset() {
        return this.parentAsset;
    }

    public UIComplexField getParentField() {
        return this.parentField;
    }

    private List<UISimpleField<?>> getFields() throws MetadataTypeMismatchException {
        if (this.parentField == null) {
            return null;
        }
        ArrayList inputFields = new ArrayList();
        String name = this.fieldDefinition.getName();
        for (UIField field : this.parentField.getChildren().getFields(name)) {
            if (!(field instanceof UISimpleField)) {
                throw new MetadataTypeMismatchException(name, (UIFieldDefinition)this.fieldDefinition, field);
            }
            UISimpleField simpleField = (UISimpleField)field;
            String dataTypeName = this.fieldDefinition.getDatatype().getName();
            if (!dataTypeName.equals(simpleField.getDatatype().getName())) {
                throw new MetadataTypeMismatchException(name, (UIFieldDefinition)this.fieldDefinition, simpleField);
            }
            inputFields.add(simpleField);
        }
        return inputFields;
    }

    private int getMaximumCount() {
        int minimumCount = this.getFieldDefinition().getMinimumCount();
        int maximumCount = this.getFieldDefinition().getMaximumCount();
        if (maximumCount < minimumCount) {
            maximumCount = minimumCount;
        }
        return maximumCount;
    }

    public void refresh() {
        this.fieldTable.removeAllRows(this);
        this.clearNewFieldState();
        this.viewIdentifier.clear();
        if (this.getParentField() == null) {
            return;
        }
        List<UISimpleField<?>> inputFields = null;
        try {
            inputFields = this.getFields();
        }
        catch (MetadataTypeMismatchException mtme) {
            this.fieldTable.addMismatchErrorRow(this, mtme);
            return;
        }
        for (UISimpleField<?> field : inputFields) {
            this.buildFieldView(field);
        }
        this.addNewField();
    }

    private void buildFieldView(UISimpleField<?> field) {
        if (this.parentAsset.isBatchEdit() && !this.fieldDefinition.isBatch()) {
            return;
        }
        if (this.fieldDefinition.hideInUI()) {
            return;
        }
        Widget label = this.buildLabelWidget(field);
        Widget fieldWidget = this.buildMetadataWidget(field);
        Widget deleteButton = this.buildDeleteButton(field);
        Widget nullifyCheckBox = this.buildNullifyCheckBox(field, fieldWidget);
        Widget autoFillCheckBox = this.buildAutoFillCheckBox(field, fieldWidget);
        SimpleFieldView fieldView = new SimpleFieldView(label, fieldWidget, deleteButton, nullifyCheckBox, autoFillCheckBox);
        this.fieldTable.addRow(this, fieldView.getWidgets());
        this.viewIdentifier.put(field, fieldView);
    }

    private void addNewField() {
        boolean showNewRow;
        int maxCount = this.getMaximumCount();
        int fieldCount = this.getFieldCount();
        boolean newFieldMissing = this.newField == null;
        boolean underMaxLimit = maxCount > fieldCount;
        boolean bl = showNewRow = !this.isReadOnly() || fieldCount == 0;
        if (newFieldMissing && underMaxLimit && showNewRow) {
            this.newField = this.createField();
            this.parentField.addField(this.newField);
            this.buildFieldView(this.newField);
        }
    }

    private void clearNewFieldState() {
        this.newField = null;
        for (HandlerRegistration registration : this.newFieldHandlers) {
            registration.removeHandler();
        }
        this.newFieldHandlers.clear();
    }

    private int getFieldCount() {
        String name = this.fieldDefinition.getName();
        return this.parentField != null ? this.parentField.getChildren().getFieldCount(name) : 0;
    }

    private UISimpleField<?> createField() {
        UISimpleField newField = (UISimpleField)this.assetFactory.createAssetField((UIFieldDefinition)this.fieldDefinition);
        if (this.getParentAsset().getAsset().getId() == null) {
            if (this.parentAsset.isBatchEdit() && !this.fieldDefinition.isBatch()) {
                newField.setStringValue(null);
            } else {
                newField.setStringValue(this.fieldDefinition.getDefaultValue());
            }
        }
        return newField;
    }

    private void handleFieldUpdated(UISimpleField<?> field, String widgetValue) {
        if (widgetValue != null && widgetValue.length() > 0 && field.equals(this.newField)) {
            this.clearNewFieldState();
            this.tryShowDeleteButton(field);
            this.addNewField();
        }
        this.fieldTable.fireViewChangeEvent();
    }

    private void handleFieldDeleted(UISimpleField<?> field) {
        for (UISimpleField<?> currentField : this.getFields()) {
            this.tryShowDeleteButton(currentField);
        }
        this.addNewField();
    }

    private Widget buildLabelWidget(UISimpleField<?> field) {
        TitleViewMessages messages = this.fieldTable.getViewMessages();
        String labelText = messages.simpleFieldNameLabel(this.fieldDefinition.getDisplayName());
        String html = null;
        html = this.fieldDefinition.isRequired() ? "<span class='nwt-FormContainer-required'>* </span>" + labelText : labelText;
        html = "<span title='" + this.fieldDefinition.getXPath() + "'>" + html + "</span>";
        HTML widget = new HTML();
        widget.setHTML(html);
        widget.addStyleName(STYLE_FIELD_LABEL);
        return widget;
    }

    private Widget buildNullifyCheckBox(final UISimpleField<?> field, final Widget fieldWidget) {
        boolean isBatchEditable = this.parentAsset.isBatchEdit();
        if (!isBatchEditable || this.fieldDefinition.isRequired()) {
            return null;
        }
        TitleViewMessages messages = this.fieldTable.getViewMessages();
        String label = messages.simpleFieldNullifyCheckBox();
        final CheckBoxWidget widget = new CheckBoxWidget(label);
        widget.addStyleName(STYLE_NULLIFY_CHECKBOX);
        widget.setEnabled(!this.fieldDefinition.isLocked() && !this.isReadOnly());
        widget.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SimpleFieldGroup.this.handleNullifyCheckBoxValueChange(field, widget, fieldWidget, (ValueChangeEvent<Boolean>)event);
            }
        });
        return widget;
    }

    private void handleNullifyCheckBoxValueChange(UISimpleField<?> field, CheckBoxWidget nullifyWidget, Widget fieldWidget, ValueChangeEvent<Boolean> event) {
        Boolean value = (Boolean)event.getValue();
        field.setNullify(value != null ? value : false);
        if (fieldWidget instanceof SimpleFieldWidget) {
            SimpleFieldWidget simpleFieldWidget = (SimpleFieldWidget)fieldWidget;
            if (field.isNullify()) {
                simpleFieldWidget.setValue(null, true);
            }
            simpleFieldWidget.setEnabled(!field.isNullify());
        }
    }

    private Widget buildAutoFillCheckBox(UISimpleField<?> field, Widget fieldWidget) {
        return null;
    }

    private Widget buildDeleteButton(final UISimpleField<?> field) {
        ImageWidget image = new ImageWidget("cms_contentmgmt_ui/resources/images/title_metadata_delete.gif");
        final PushButtonWidget button = new PushButtonWidget(image);
        button.addStyleName("content-AssetContent-deleteButton");
        boolean canShow = this.canShowDeleteButton(field);
        button.setEnabled(canShow);
        button.setVisible(canShow);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimpleFieldGroup.this.handleDeleteButtonClicked(field, (Widget)button, event);
            }
        });
        return button;
    }

    private void tryShowDeleteButton(UISimpleField<?> field) {
        boolean visible = this.canShowDeleteButton(field);
        SimpleFieldView view = this.viewIdentifier.get(field);
        if (view != null && view.getDeleteButton() != null) {
            Widget button = view.getDeleteButton();
            button.setVisible(visible);
            if (button instanceof FocusWidget) {
                ((FocusWidget)button).setEnabled(visible);
            }
        }
    }

    private boolean canShowDeleteButton(UISimpleField<?> field) {
        int maxCount;
        int fieldCount = this.getFieldCount();
        boolean hasExtraFields = fieldCount > (maxCount = this.getMaximumCount());
        boolean canShow = !this.isReadOnly() && !field.equals(this.newField) && (maxCount > 1 || hasExtraFields);
        return canShow;
    }

    private void handleDeleteButtonClicked(UISimpleField<?> field, Widget button, ClickEvent event) {
        if (!this.validateFieldDelete(field)) {
            return;
        }
        SimpleFieldView fieldView = this.viewIdentifier.get(field);
        this.fieldTable.removeRow(this, fieldView.getFieldLabel());
        this.viewIdentifier.remove(field);
        this.getParentField().removeField(field);
        this.fieldTable.fireViewChangeEvent();
        this.handleFieldDeleted(field);
    }

    private boolean validateFieldDelete(UISimpleField<?> field) {
        return !this.isReadOnly() && !field.equals(this.newField);
    }

    private Widget buildMetadataWidget(UISimpleField<?> field) {
        SimpleViewMetadataWidgetBuilder builder = new SimpleViewMetadataWidgetBuilder(this);
        SimpleFieldWidget<?, ?, ?> fieldWidget = null;
        boolean fieldReadOnlyFlag = this.readOnly;
        try {
            if (!this.readOnly) {
                fieldReadOnlyFlag = this.fieldDefinition.isLocked();
            }
            if (this.parentAsset.isBatchEdit()) {
                field.setValue(null);
            }
            fieldWidget = builder.build(this.fieldDefinition, field, fieldReadOnlyFlag);
        }
        catch (MetadataTypeMismatchException mtme) {
            return this.fieldTable.buildMetadataMismatchErrorWidget(mtme);
        }
        DataTypeWidget<?> widget = fieldWidget.getDataTypeWidget();
        if (!fieldReadOnlyFlag && field.equals(this.newField) && widget instanceof HasKeyUpHandlers) {
            MetadataWidgetKeyEventHandler handler = new MetadataWidgetKeyEventHandler(field, fieldWidget);
            HasKeyUpHandlers keyAwareWidget = (HasKeyUpHandlers)widget;
            this.newFieldHandlers.add(keyAwareWidget.addKeyUpHandler((KeyUpHandler)handler));
        }
        return fieldWidget;
    }

    void handleMetadataValueChanged(UISimpleField<?> field, SimpleFieldWidget<?, ?, ?> widget) {
        this.handleFieldUpdated(field, widget.getTextValue());
    }

    private void handleKeyUpEvent(UISimpleField<?> field, SimpleFieldWidget<?, ?, ?> widget, KeyUpEvent event) {
        if (!field.equals(this.newField)) {
            return;
        }
        this.handleFieldUpdated(field, widget.getTextValue());
    }

    public void validate(List<AssetValidationMessage> messages, boolean draft) {
        if (this.parentField == null) {
            return;
        }
        List<UIField> fields = this.parentField.getChildren().getFields(this.fieldDefinition.getName());
        SimpleFieldWidget fieldWidget = null;
        for (UIField field : fields) {
            SimpleFieldView view = this.viewIdentifier.get(field);
            if (view == null || !(view.getFieldWidget() instanceof SimpleFieldWidget) || (fieldWidget = (SimpleFieldWidget)view.getFieldWidget()).isValidValue(draft)) continue;
            String name = this.fieldDefinition.getDisplayName();
            String error = fieldWidget.getCurrentToolTip();
            messages.add(new AssetValidationMessage(this.parentAsset, name, (Widget)fieldWidget, error));
        }
    }

    private final class MetadataWidgetKeyEventHandler
    implements KeyUpHandler {
        private UISimpleField<?> field;
        private SimpleFieldWidget<?, ?, ?> widget;

        public MetadataWidgetKeyEventHandler(UISimpleField<?> field, SimpleFieldWidget<?, ?, ?> widget) {
            this.field = field;
            this.widget = widget;
        }

        public void onKeyUp(KeyUpEvent event) {
            SimpleFieldGroup.this.handleKeyUpEvent(this.field, this.widget, event);
        }
    }

    private static final class SimpleFieldView {
        private Widget fieldLabel;
        private Widget fieldWidget;
        private Widget deleteButton;
        private Widget nullifyCheckBox;
        private Widget autoFillCheckBox;

        public SimpleFieldView(Widget label, Widget fieldWidget, Widget deleteButton, Widget nullifyCheckBox, Widget autoFillCheckBox) {
            this.fieldLabel = label;
            this.fieldWidget = fieldWidget;
            this.deleteButton = deleteButton;
            this.nullifyCheckBox = nullifyCheckBox;
            this.autoFillCheckBox = autoFillCheckBox;
        }

        public Widget getFieldLabel() {
            return this.fieldLabel;
        }

        public Widget getFieldWidget() {
            return this.fieldWidget;
        }

        public Widget getDeleteButton() {
            return this.deleteButton;
        }

        public Widget[] getWidgets() {
            HorizontalContainer content = new HorizontalContainer();
            content.addStyleName(SimpleFieldGroup.STYLE_FIELD_WIDGET_CONTENTS);
            content.add(this.fieldWidget);
            content.add(this.deleteButton);
            if (this.nullifyCheckBox != null) {
                content.add(this.nullifyCheckBox);
            }
            if (this.autoFillCheckBox != null) {
                content.add(this.autoFillCheckBox);
            }
            return new Widget[]{this.fieldLabel, content};
        }
    }
}

