/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.table;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.HasViewChangeHandlers;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessageCache;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeEvent;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.asset.MetadataTypeMismatchException;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.CollapsedFieldHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.table.SimpleFieldGroup;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleFieldTable
extends Composite
implements HasViewChangeHandlers {
    private final FlexTableContainer table;
    private final List<SimpleFieldGroup> simpleFieldGroups;
    private final Map<SimpleFieldGroup, Integer> sizeMap;
    private UIComplexFieldDefinition parentFieldDefinition;
    private boolean readOnly;
    private AssetTree.AssetInfo parentAsset;
    private UIComplexField parentField;
    private IUIAssetFactory assetFactory = new UIAssetFactory();
    private TitleViewMessages messages = TitleViewMessageCache.getMessages();
    private static final String STYLE_NAME = "content-SimpleFieldTable";
    private static final String STYLE_CELL_PREFIX = "content-SimpleFieldTable-columnCell";

    public SimpleFieldTable(UIComplexFieldDefinition parentFieldDefinition, boolean readOnly) {
        this.parentFieldDefinition = parentFieldDefinition;
        this.readOnly = readOnly;
        this.simpleFieldGroups = new ArrayList<SimpleFieldGroup>();
        this.sizeMap = new HashMap<SimpleFieldGroup, Integer>();
        this.table = new FlexTableContainer();
        this.table.addStyleName(STYLE_NAME);
        this.initWidget((Widget)this.table);
        this.initialize();
    }

    private void initialize() {
        this.buildSimpleFieldGroups(this.parentFieldDefinition);
    }

    private void buildSimpleFieldGroups(UIComplexFieldDefinition definition) {
        for (UIFieldDefinition child : definition.getChildren()) {
            UIComplexFieldDefinition complexChild;
            if (child instanceof UISimpleFieldDefinition) {
                UISimpleFieldDefinition simpleChild = (UISimpleFieldDefinition)child;
                SimpleFieldGroup group = new SimpleFieldGroup(this, simpleChild, this.readOnly);
                this.addSimpleFieldGroup(group);
                continue;
            }
            if (!(child instanceof UIComplexFieldDefinition) || (complexChild = (UIComplexFieldDefinition)child).getMaximumCount() != 1) continue;
            this.buildSimpleFieldGroups(complexChild);
        }
    }

    private void addSimpleFieldGroup(SimpleFieldGroup group) {
        this.simpleFieldGroups.add(group);
        this.sizeMap.put(group, 0);
    }

    public void setInput(AssetTree.AssetInfo parentAsset, UIComplexField parentField) {
        this.parentAsset = parentAsset;
        this.parentField = parentField;
        for (SimpleFieldGroup fieldGroup : this.simpleFieldGroups) {
            try {
                this.setInput(fieldGroup);
            }
            catch (MetadataTypeMismatchException mtme) {
                fieldGroup.setInput(parentAsset, null);
                this.addMismatchErrorRow(fieldGroup, mtme);
            }
        }
    }

    private void setInput(SimpleFieldGroup fieldGroup) throws MetadataTypeMismatchException {
        UISimpleFieldDefinition targetDefinition = fieldGroup.getFieldDefinition();
        CollapsedFieldHandler handler = new CollapsedFieldHandler(this.assetFactory, this.parentFieldDefinition, (UIFieldDefinition)targetDefinition);
        UIComplexField immediateParentField = handler.getCollapsedFieldParent(this.parentField);
        fieldGroup.setInput(this.parentAsset, immediateParentField);
    }

    public UIComplexFieldDefinition getParentFieldDefinition() {
        return this.parentFieldDefinition;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public AssetTree.AssetInfo getParentAsset() {
        return this.parentAsset;
    }

    public UIComplexField getParentField() {
        return this.parentField;
    }

    TitleViewMessages getViewMessages() {
        return this.messages;
    }

    public void refresh() {
        for (SimpleFieldGroup fieldGroup : this.simpleFieldGroups) {
            fieldGroup.refresh();
        }
    }

    void addRow(SimpleFieldGroup fieldGroup, Widget[] widgets) {
        if (!this.simpleFieldGroups.contains(fieldGroup)) {
            return;
        }
        int firstRow = this.getFirstRowIndex(fieldGroup);
        int rowCount = this.getRowCount(fieldGroup);
        int row = firstRow + rowCount;
        row = this.table.insertRow(row);
        int column = 0;
        Widget[] widgetArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            this.table.setWidget(row, column, widget);
            this.table.getCellFormatter().addStyleName(row, column, STYLE_CELL_PREFIX + column);
            ++column;
            ++n2;
        }
        this.sizeMap.put(fieldGroup, rowCount + 1);
    }

    void addMismatchErrorRow(SimpleFieldGroup fieldGroup, MetadataTypeMismatchException error) {
        String displayName = error.getFieldDefinition().getDisplayName();
        LabelWidget label = new LabelWidget(this.messages.simpleFieldNameLabel(displayName));
        label.addStyleName("content-SimpleFieldGroup-fieldLabel");
        Widget errorWidget = this.buildMetadataMismatchErrorWidget(error);
        this.addRow(fieldGroup, new Widget[]{label, errorWidget});
    }

    void removeRow(SimpleFieldGroup fieldGroup, Widget widget) {
        if (!this.simpleFieldGroups.contains(fieldGroup)) {
            return;
        }
        int matchingRow = -1;
        int firstRow = this.getFirstRowIndex(fieldGroup);
        int rowCount = this.getRowCount(fieldGroup);
        int row = firstRow;
        while (row < firstRow + rowCount) {
            int column = 0;
            while (column < this.table.getCellCount(row)) {
                Widget tableWidget = this.table.getWidget(row, column);
                if (tableWidget != null && tableWidget.equals(widget)) {
                    matchingRow = row;
                    break;
                }
                ++column;
            }
            ++row;
        }
        if (matchingRow != -1) {
            this.table.removeRow(matchingRow);
            this.sizeMap.put(fieldGroup, rowCount - 1);
        }
    }

    void removeAllRows(SimpleFieldGroup fieldGroup) {
        if (!this.simpleFieldGroups.contains(fieldGroup)) {
            return;
        }
        int firstRow = this.getFirstRowIndex(fieldGroup);
        int rowCount = this.getRowCount(fieldGroup);
        int row = rowCount - 1;
        while (row >= 0) {
            this.table.removeRow(row + firstRow);
            --row;
        }
        this.sizeMap.put(fieldGroup, 0);
    }

    private int getRowCount(SimpleFieldGroup group) {
        Integer size = this.sizeMap.get(group);
        return size != null ? size : 0;
    }

    private int getFirstRowIndex(SimpleFieldGroup fieldGroup) {
        if (!this.simpleFieldGroups.contains(fieldGroup)) {
            return -1;
        }
        int row = 0;
        for (SimpleFieldGroup current : this.simpleFieldGroups) {
            if (current.equals(fieldGroup)) break;
            row += this.getRowCount(current);
        }
        return row;
    }

    Widget buildMetadataMismatchErrorWidget(MetadataTypeMismatchException mtme) {
        String typeName = this.getFieldTypeName(mtme.getFieldDefinition());
        String receivedTypeName = this.getFieldTypeName(mtme.getReceivedField());
        String message = this.messages.metadataTypeMismatchError(typeName, receivedTypeName);
        LabelWidget label = new LabelWidget(message);
        label.addStyleName("content-AssetContent-datatypeMismatchLabel");
        return label;
    }

    private String getFieldTypeName(UIFieldDefinition fieldDefinition) {
        String name = null;
        name = fieldDefinition instanceof UIComplexFieldDefinition ? this.messages.complexTypeName() : (fieldDefinition instanceof UISimpleFieldDefinition ? ((UISimpleFieldDefinition)fieldDefinition).getDatatype().getName() : this.messages.unknownTypeName());
        return name;
    }

    private String getFieldTypeName(UIField field) {
        String name = null;
        name = field instanceof UIComplexField ? this.messages.complexTypeName() : (field instanceof UISimpleField ? ((UISimpleField)field).getDatatype().getName() : this.messages.unknownTypeName());
        return name;
    }

    public void validate(List<AssetValidationMessage> messages, boolean draft) {
        for (SimpleFieldGroup fieldGroup : this.simpleFieldGroups) {
            fieldGroup.validate(messages, draft);
        }
    }

    @Override
    public HandlerRegistration addViewChangeHandler(ViewChangeHandler handler) {
        return this.addHandler(handler, ViewChangeEvent.getType());
    }

    protected void fireViewChangeEvent() {
        this.fireEvent(new ViewChangeEvent());
    }
}

