/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.file;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.HasKeyUpHandlers;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiLookupKey;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyService;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.MetadataWidgetBuilder;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.BooleanFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.DateFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.FloatFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.IntegerFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.SimpleFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.StringFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.TimeFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileDataTypeWidgetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileURIWidgetConfiguration;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileView;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.LookupKeyWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.StringWidgetConfiguration;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import java.util.ArrayList;
import java.util.List;

class FileMetadataWidgetBuilder
extends MetadataWidgetBuilder {
    private FileView fileView;
    private UIAssetFile file;
    private UIAssetFileFieldDefinition fileFieldDefinition;
    private UIAssetFileField fileField;
    private static final String FILE_URI_FIELD_NAME = "/Fields/Locator/Uri";
    private static final String LOOKUP_KEY_FIELD_NAME = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";
    private static final String STYLE_VIEW_SUFFIX = "fileView";
    private static final String STYLE_TYPE_SUFFIX = "fileView-";
    private static final String FILE_URI_TYPE = "fileURI";
    private ILookupKeyServiceAsync lookupKeyService = (ILookupKeyServiceAsync)GWT.create(ILookupKeyService.class);

    public FileMetadataWidgetBuilder(FileView fileView, UIAssetFile file) {
        this.fileView = fileView;
        ((FileDataTypeWidgetFactory)this.factory).setFile(file);
    }

    @Override
    protected void initializeFactory() {
        this.factory = new FileDataTypeWidgetFactory();
    }

    public SimpleFieldWidget<?, ?, ?> build(UIAssetFile file, UIAssetFileFieldDefinition fieldDefinition, UIAssetFileField field, boolean readOnly) {
        this.file = file;
        this.fileFieldDefinition = fieldDefinition;
        this.fileField = field;
        UISimpleFieldDefinition simpleDefinition = this.fileFieldDefinition.getFieldDefinition();
        UISimpleField<?> simpleField = this.fileField.getField();
        return this.build(simpleDefinition, simpleField, readOnly);
    }

    @Override
    protected SimpleFieldWidget<?, ?, ?> getBuiltWidget() {
        this.file = null;
        this.fileFieldDefinition = null;
        this.fileField = null;
        return super.getBuiltWidget();
    }

    @Override
    public void visit(UIBooleanFieldDefinition definition) {
        super.visit(definition);
        if (!this.readOnly) {
            BooleanFieldWidget widget = (BooleanFieldWidget)this.builtWidget;
            widget.addValueChangeHandler(new WidgetValueChangeHandler<Boolean>(this.fileView, this.file, this.fileField, widget));
        }
        this.builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
        this.builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
    }

    @Override
    public void visit(UIIntegerFieldDefinition definition) {
        super.visit(definition);
        if (!this.readOnly) {
            IntegerFieldWidget widget = (IntegerFieldWidget)this.builtWidget;
            widget.addValueChangeHandler(new WidgetValueChangeHandler<Long>(this.fileView, this.file, this.fileField, widget));
        }
        this.builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
        this.builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
    }

    @Override
    public void visit(UIFloatFieldDefinition definition) {
        super.visit(definition);
        if (!this.readOnly) {
            FloatFieldWidget widget = (FloatFieldWidget)this.builtWidget;
            widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(this.fileView, this.file, this.fileField, widget));
        }
        this.builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
        this.builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
    }

    @Override
    public void visit(UIDateFieldDefinition definition) {
        super.visit(definition);
        if (!this.readOnly) {
            DateFieldWidget widget = (DateFieldWidget)this.builtWidget;
            widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(this.fileView, this.file, this.fileField, widget));
        }
        this.builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
        this.builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
    }

    @Override
    public void visit(UITimeFieldDefinition definition) {
        super.visit(definition);
        if (!this.readOnly) {
            TimeFieldWidget widget = (TimeFieldWidget)this.builtWidget;
            widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(this.fileView, this.file, this.fileField, widget));
        }
        this.builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
        this.builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
    }

    @Override
    public void visit(UIStringFieldDefinition definition) {
        boolean isFileURIField = definition.getName().equals(FILE_URI_FIELD_NAME);
        boolean isLookupKeyField = definition.getName().equals(LOOKUP_KEY_FIELD_NAME);
        if (isFileURIField) {
            this.buildFileURIWidget(definition);
        } else if (isLookupKeyField) {
            this.buildLookupKeyWidget(definition);
        } else {
            super.visit(definition);
        }
        if (!this.readOnly) {
            StringFieldWidget widget = (StringFieldWidget)this.builtWidget;
            String defaultToolTip = widget.getToolTip();
            widget.addValueChangeHandler(new WidgetValueChangeHandler<String>(this.fileView, this.file, this.fileField, widget, defaultToolTip, isFileURIField));
            if (isFileURIField && widget.getDataTypeWidget() instanceof HasKeyUpHandlers) {
                HasKeyUpHandlers handler = (HasKeyUpHandlers)widget.getDataTypeWidget();
                handler.addKeyUpHandler((KeyUpHandler)new WidgetKeyHandler(widget, defaultToolTip));
            }
        }
        this.builtWidget.addStyleDependentName(STYLE_VIEW_SUFFIX);
        if (isFileURIField) {
            String text = this.builtWidget.getTextValue();
            if (text != null && text.trim().length() > 0) {
                this.builtWidget.setToolTip(text.trim());
            }
            this.builtWidget.addStyleDependentName("fileView-fileURI");
        } else {
            this.builtWidget.addStyleDependentName(STYLE_TYPE_SUFFIX + definition.getDatatype().getName());
        }
    }

    private void buildFileURIWidget(UIStringFieldDefinition definition) {
        UIStringField field = this.getSimpleField((UIFieldDefinition)definition, this.field, UIStringField.class);
        FileURIWidgetConfiguration configuration = new FileURIWidgetConfiguration(definition);
        configuration.setFilePaths(this.fileView.getFilePaths());
        DataTypeWidget typedWidget = this.factory.createStringWidget((StringWidgetConfiguration)configuration);
        this.initializeWidgetValue(typedWidget, field);
        StringFieldWidget widget = new StringFieldWidget(definition, field, (DataTypeWidget<String>)typedWidget);
        widget.setReadOnly(this.readOnly);
        this.builtWidget = widget;
    }

    private void buildLookupKeyWidget(UIStringFieldDefinition definition) {
        UIStringField field = this.getSimpleField((UIFieldDefinition)definition, this.field, UIStringField.class);
        final LookupKeyWidgetConfiguration configuration = new LookupKeyWidgetConfiguration(definition);
        configuration.setOptions(new ArrayList());
        DataTypeWidget typedWidget = this.factory.createStringWidget((StringWidgetConfiguration)configuration);
        this.initializeWidgetValue(typedWidget, field);
        final StringFieldWidget widget = new StringFieldWidget(definition, field, (DataTypeWidget<String>)typedWidget);
        widget.setReadOnly(this.readOnly);
        this.builtWidget = widget;
        String assetType = this.fileFieldDefinition.getAssetFileDefinition().getParent().getAssetType();
        this.lookupKeyService.getLookupKeysByAssetType(assetType, (AsyncCallback<List<UiLookupKey>>)new NeptuneAsyncCallback<List<UiLookupKey>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<UiLookupKey> result) {
                TypedListBoxWidget listBox = (TypedListBoxWidget)widget.getDataTypeWidget();
                for (UiLookupKey key : result) {
                    configuration.getOptions().add(new UIValueOption(key.getName(), key.getName()));
                    listBox.addItem(key.getName(), (Object)key.getName());
                }
            }
        });
    }

    private static final class WidgetKeyHandler
    implements KeyUpHandler {
        private SimpleFieldWidget<?, ?, ?> widget;
        private String defaultToolTip;

        public WidgetKeyHandler(SimpleFieldWidget<?, ?, ?> widget, String defaultToolTip) {
            this.widget = widget;
            this.defaultToolTip = defaultToolTip;
        }

        public void onKeyUp(KeyUpEvent event) {
            String toolTip = this.defaultToolTip;
            String text = this.widget.getTextValue();
            if (text != null && text.trim().length() > 0) {
                toolTip = text.trim();
            }
            this.widget.setToolTip(toolTip);
        }
    }

    private static final class WidgetValueChangeHandler<DataType>
    implements ValueChangeHandler<DataType> {
        private FileView view;
        private UIAssetFile file;
        private UIAssetFileField field;
        private SimpleFieldWidget<?, ?, DataType> widget;
        private String defaultToolTip;
        private boolean showValueAsToolTip;

        public WidgetValueChangeHandler(FileView view, UIAssetFile file, UIAssetFileField field, SimpleFieldWidget<?, ?, DataType> widget) {
            this(view, file, field, widget, null, false);
        }

        public WidgetValueChangeHandler(FileView view, UIAssetFile file, UIAssetFileField field, SimpleFieldWidget<?, ?, DataType> widget, String defaultToolTip, boolean showValueAsToolTip) {
            this.view = view;
            this.file = file;
            this.field = field;
            this.widget = widget;
            this.defaultToolTip = defaultToolTip;
            this.showValueAsToolTip = showValueAsToolTip;
        }

        public void onValueChange(ValueChangeEvent<DataType> event) {
            Object simpleField = this.widget.getField();
            ((UISimpleField)simpleField).setValue((Object)event.getValue());
            if (this.showValueAsToolTip) {
                String toolTip = this.defaultToolTip;
                String text = this.widget.getTextValue();
                if (text != null && text.trim().length() > 0) {
                    toolTip = text.trim();
                }
                this.widget.setToolTip(toolTip);
            }
            this.view.handleMetadataValueChanged(this.file, this.field, this.widget);
        }
    }
}

