/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.file;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileURIOracle
extends SuggestOracle {
    private static List<FileURISuggestion> suggestions = new ArrayList<FileURISuggestion>();
    private UIAssetFile file;
    private ITitleViewServiceAsync titleService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
    private Boolean isProviderIdCaseSensitive;

    public FileURIOracle() {
    }

    public FileURIOracle(UIAssetFile file) {
        this.file = file;
        ContentComponent component = (ContentComponent)NeptuneApplication.getApplication().getComponent(ContentComponent.class);
        this.isProviderIdCaseSensitive = component.isProviderIdCaseSensitive();
    }

    public void add(UIAssetFilePath filePath) {
        FileURISuggestion suggestion = new FileURISuggestion(filePath);
        suggestions.add(suggestion);
    }

    public void addAll(Collection<UIAssetFilePath> filePaths) {
        for (UIAssetFilePath filePath : filePaths) {
            this.add(filePath);
        }
    }

    public void requestSuggestions(final SuggestOracle.Request request, final SuggestOracle.Callback callback) {
        if (suggestions.isEmpty()) {
            final BusyIndicator busyIndicator = new BusyIndicator();
            this.titleService.getAvailableFilePaths((AsyncCallback<List<UIAssetFilePath>>)new NeptuneAsyncCallback<List<UIAssetFilePath>>(){

                public void onNeptuneSuccess(List<UIAssetFilePath> filePaths) {
                    busyIndicator.hide();
                    int size = filePaths.size();
                    if (size > 0) {
                        filePaths.remove(size - 1);
                        FileURIOracle.this.addAll(filePaths);
                    }
                    FileURIOracle.this.exeCallback(request, callback);
                }

                public void onNeptuneFailure(Throwable caught) {
                    busyIndicator.hide();
                    FileURIOracle.this.exeCallback(request, callback);
                }
            });
        } else {
            this.exeCallback(request, callback);
        }
    }

    private void exeCallback(SuggestOracle.Request request, SuggestOracle.Callback callback) {
        List<FileURISuggestion> filteredSuggestions = this.getFilteredSuggestions(request);
        SuggestOracle.Response response = new SuggestOracle.Response(filteredSuggestions);
        callback.onSuggestionsReady(request, response);
    }

    private List<FileURISuggestion> getFilteredSuggestions(SuggestOracle.Request request) {
        ArrayList<FileURISuggestion> result = new ArrayList<FileURISuggestion>();
        int size = 0;
        String query = request.getQuery();
        if (query == null || query.trim().length() == 0) {
            return result;
        }
        query = query.trim().toLowerCase();
        int limit = request.getLimit();
        String filterFieldValue = this.getFilterFieldValue();
        for (FileURISuggestion suggestion : suggestions) {
            String path = suggestion.getFilePath().getFilePath();
            if (!this.isFilterValid(filterFieldValue, path) || !path.toLowerCase().contains(query)) continue;
            result.add(suggestion);
            if (limit > 0 && limit <= ++size) break;
        }
        return result;
    }

    private boolean isFilterValid(String filterFieldValue, String filePath) {
        if (filterFieldValue == null || filterFieldValue.trim().isEmpty()) {
            return true;
        }
        if (filePath == null || filePath.trim().isEmpty()) {
            return false;
        }
        String fileSeparator = filePath.contains("/") ? "/" : "\\";
        String filterValue = String.valueOf(fileSeparator) + filterFieldValue + fileSeparator;
        return this.isProviderIdCaseSensitive != false ? filePath.contains(filterValue) : filePath.toLowerCase().contains(filterValue.toLowerCase());
    }

    private String getFilterFieldValue() {
        UIField providerInfoField = this.file.getParentAsset().getRootAsset().getRootField().getChildren().getField("ProviderInfo");
        if (providerInfoField != null) {
            UIField identifierField = ((UIComplexField)providerInfoField).getChildren().getField("Identifier");
            if (identifierField != null) {
                UIField idField = ((UIComplexField)identifierField).getChildren().getField("Id");
                if (idField != null && idField instanceof UIStringField) {
                    return (String)((UIStringField)idField).getValue();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private class FileURISuggestion
    implements SuggestOracle.Suggestion {
        private UIAssetFilePath filePath;

        public FileURISuggestion(UIAssetFilePath filePath) {
            this.filePath = filePath;
        }

        public String getDisplayString() {
            return this.filePath.getFilePath();
        }

        public String getReplacementString() {
            return this.filePath.getFilePath();
        }

        public UIAssetFilePath getFilePath() {
            return this.filePath;
        }
    }
}

