/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.file;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasKeyUpHandlers;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.model.UIVideoPlayer;
import com.tandbergtv.cms.portal.content.client.title.model.UploadedFileTitleInfo;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UISimpleField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.content.client.title.service.IFileUploadViewService;
import com.tandbergtv.cms.portal.content.client.title.service.IFileUploadViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.IVideoPlayerService;
import com.tandbergtv.cms.portal.content.client.title.service.IVideoPlayerServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.SaveImageRequest;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.HasViewChangeHandlers;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessageCache;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeEvent;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetContentTable;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.asset.MetadataTypeMismatchException;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.simple.SimpleFieldWidget;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileMetadataWidgetBuilder;
import com.tandbergtv.cms.portal.content.client.title.view.imageeditor.EditImageDialogBox;
import com.tandbergtv.cms.portal.content.client.title.view.imageeditor.PreviewImageDialogBox;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.JWPlayerWidget;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoPreviewDialog;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.neptune.ui.realm.client.settings.service.ISettingsUIService;
import com.tandbergtv.neptune.ui.realm.client.settings.service.ISettingsUIServiceAsync;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiTokenAndSettings;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.file.FileUploadPopup;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.util.FormatUtil;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PushButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileView
extends Composite
implements HasViewChangeHandlers {
    private static final String UPLOAD_URL = "/fileuploader/upload";
    private static final String NEPTUNE_SETTING_MAX_FILE_SIZE = "reg_maxsize";
    private static final String NEPTUNE_SETTING_RETRY_ATTEMPTS = "retry_attempts";
    private static final String NEPTUNE_SETTING_RETRY_ATTEMPTS_INTERVAL = "retry_attempts_interval";
    private static final String NEPTUNE_SETTING_CMS_CONTENTMGMT_FILEUPLOAD = "com.ericsson.cms.contentmgmt.fileupload";
    private TitleView titleView;
    private DisclosureContainer disclosureContainer;
    private SimpleContainer container;
    private AssetContentTable table;
    private TitleViewMessages messages;
    private ButtonWidget uploadBtn;
    private Set<Button> editImageButtons = new HashSet<Button>();
    private boolean dirty = false;
    private final UIAssetFileDefinition fileDefinition;
    private final List<UIAssetFilePath> filePaths;
    private AssetTree.AssetInfo input;
    private boolean readOnly = false;
    private Set<Long> fileIDs = new HashSet<Long>();
    private long generatedFileID = -1L;
    private IUIAssetFactory assetFactory = new UIAssetFactory();
    private UIAssetFile newFile = null;
    private List<HandlerRegistration> newFileHandlers = new ArrayList<HandlerRegistration>();
    private Map<UIAssetFile, LabelWidget> rowIdentifier = new HashMap<UIAssetFile, LabelWidget>();
    private Map<String, Integer> columnIndices = new HashMap<String, Integer>();
    private static boolean licensedForVideoPreview;
    private List<String> imageAssetTypes;
    private List<String> videoAssetTypes;
    static TitleValidationViewInput viewInputFileUpload;
    private static final String FILE_ID_COLUMN = "FileID";
    private static final String METADATA_COLUMN_PREFIX = "Metadata_";
    private static final String PARENT_FILE_ID_COLUMN = "ParentFileID";
    private static final String DELETE_BUTTON_COLUMN = "Delete";
    private static final String STYLE_NAME = "content-FileView";
    private static final String STYLE_DISCLOSURE_CONTAINER = "content-FileView-disclosureContainer";
    private static final String STYLE_DISCLOSURE_CONTENTS = "content-FileView-disclosureContents";
    private static final String STYLE_SCROLL_CONTENTS = "content-FileView-scrollContents";
    private static final String STYLE_CELL_FILE_ID = "content-FileView-fileIdValueCell";
    private static final String STYLE_FILE_ID_LABEL = "content-FileView-fileIdValueLabel";
    private static final String STYLE_PARENT_FILE_WIDGET = "content-FileView-parentFileListBox";
    private static final String FILE_URI_XPATH = "/Fields/Locator/Uri";
    private static final String FILE_ENCODEFORMAT_XPATH = "/Fields/CustomFields/CustomField[@name=EncodeFormat]/@value";
    private static final String FILE_LOOKUP_KEY_XPATH = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";
    private static final String GET_IMAGE_JSP_PATH = "/portal/cms_contentmgmt_ui/jsps/get_image.jsp?fileURI=";
    private static final String BASE_64_RESPONSE_TYPE = "&responseType=BASE64";
    private static final int MAX_DIALOG_HEIGHT = 610;
    private IFileUploadViewServiceAsync sftpViewService = (IFileUploadViewServiceAsync)GWT.create(IFileUploadViewService.class);
    private IVideoPlayerServiceAsync videoPlayerService = (IVideoPlayerServiceAsync)GWT.create(IVideoPlayerService.class);
    private ISettingsUIServiceAsync settingsService = (ISettingsUIServiceAsync)GWT.create(ISettingsUIService.class);

    public FileView(TitleView titleView, UIAssetFileDefinition fileDefinition, List<UIAssetFilePath> filePaths, boolean readOnly) {
        this.titleView = titleView;
        this.fileDefinition = fileDefinition;
        this.filePaths = filePaths;
        this.readOnly = readOnly;
        this.messages = TitleViewMessageCache.getMessages();
        this.container = new SimpleContainer();
        this.container.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.container);
        this.initialize();
    }

    private void initialize() {
        this.disclosureContainer = new RoundedDisclosureContainer(this.messages.fileSectionHeading(), true);
        this.disclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.container.setWidget((Widget)this.disclosureContainer);
        VerticalContainer tableWrapper = new VerticalContainer();
        tableWrapper.addStyleName(STYLE_SCROLL_CONTENTS);
        this.table = new AssetContentTable();
        tableWrapper.add((Widget)this.table);
        this.initUploadBtn();
        tableWrapper.add((Widget)this.uploadBtn);
        ScrollContainer disclosureContents = new ScrollContainer((Widget)tableWrapper);
        disclosureContents.addStyleName(STYLE_DISCLOSURE_CONTENTS);
        this.disclosureContainer.setContent((Widget)disclosureContents);
        int columnIndex = 0;
        this.table.addHeading(this.messages.fileIdColumn());
        this.columnIndices.put(FILE_ID_COLUMN, columnIndex++);
        for (UIAssetFileFieldDefinition fieldDefinition : this.fileDefinition.getFieldDefinitions()) {
            this.table.addHeading(fieldDefinition.getDisplayName());
            this.columnIndices.put(METADATA_COLUMN_PREFIX + fieldDefinition.getName(), columnIndex++);
        }
        this.table.addHeading(this.messages.parentFileIdColumn());
        this.columnIndices.put(PARENT_FILE_ID_COLUMN, columnIndex++);
        this.columnIndices.put(DELETE_BUTTON_COLUMN, columnIndex++);
        NeptuneApplication application = NeptuneApplication.getApplication();
        ContentComponent component = (ContentComponent)application.getComponent(ContentComponent.class);
        this.imageAssetTypes = component.getImageAssetTypes();
        this.videoAssetTypes = component.getVideoAssetTypes();
        licensedForVideoPreview = component.isLicensedForVideoPreview();
        if (!JWPlayerWidget.isPlayableFormatsLoaded()) {
            this.loadVideoPlayableFormats();
        }
    }

    private void loadVideoPlayableFormats() {
        final BusyIndicator busyIndicator = new BusyIndicator((Widget)this);
        final FileView parentView = this;
        this.videoPlayerService.getSettings((AsyncCallback<UIVideoPlayer>)new NeptuneAsyncCallback<UIVideoPlayer>(){

            public void onNeptuneSuccess(UIVideoPlayer confSettings) {
                busyIndicator.hide();
                Map<String, String> vars = confSettings.getBasicVars();
                JWPlayerWidget.loadPlayableFormats(vars);
            }

            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
                parentView.handleGetVideoSettingsFailure(caught);
            }
        });
    }

    private void initUploadBtn() {
        this.uploadBtn = new ButtonWidget(this.messages.fileUploadButtonText());
        this.uploadBtn.setEnabled(!this.isReadOnly());
        this.uploadBtn.removeStyleName("gwt-Button");
        this.uploadBtn.addStyleName("ebBtn");
        this.uploadBtn.addStyleName("ebBtn_color_green");
        final BusyIndicator busyIndicator = new BusyIndicator((Widget)this);
        this.uploadBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                busyIndicator.center();
                FileView.this.settingsService.getTokenAndSettings(FileView.NEPTUNE_SETTING_CMS_CONTENTMGMT_FILEUPLOAD, (AsyncCallback)new AsyncCallback<UiTokenAndSettings>(){

                    public void onFailure(Throwable caught) {
                        busyIndicator.hide();
                        Window.alert((String)FileView.this.messages.fileUploadWidgetGettingConfError());
                    }

                    public void onSuccess(UiTokenAndSettings result) {
                        busyIndicator.hide();
                        FileView.this.showUploadDailog(result.getAccessToken(), result.getSettings());
                    }
                });
            }
        });
    }

    private void showUploadDailog(String accessToken, Map<String, String> map) {
        FileUploadPopup uploader = new FileUploadPopup(this.input.getDefinition().getSpecification().getProviderId(), accessToken, new FileUploadPopup.FileUploadCallback(){

            public void onSuccess(String fileUrl) {
                ArrayList<String> urls = new ArrayList<String>();
                urls.add(fileUrl);
                FileView.this.saveUploadedFileAssets(urls);
            }

            public void onFailure() {
            }

            public void onCancelled() {
            }
        }).setAssetId(String.valueOf(this.input.getAsset().getId())).setTitleId(String.valueOf(this.input.getInput().getTitleId())).setUploadUrl(UPLOAD_URL);
        if (map != null) {
            if (map.get(NEPTUNE_SETTING_RETRY_ATTEMPTS) != null && !"".equals(map.get(NEPTUNE_SETTING_RETRY_ATTEMPTS).trim())) {
                try {
                    uploader.setRetryAttempts(Integer.parseInt(map.get(NEPTUNE_SETTING_RETRY_ATTEMPTS)));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (map.get(NEPTUNE_SETTING_RETRY_ATTEMPTS_INTERVAL) != null && !"".equals(map.get(NEPTUNE_SETTING_RETRY_ATTEMPTS_INTERVAL).trim())) {
                try {
                    uploader.setRetryInterval(Integer.parseInt(map.get(NEPTUNE_SETTING_RETRY_ATTEMPTS_INTERVAL)) * 1000);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (map.get(NEPTUNE_SETTING_MAX_FILE_SIZE) != null && !"".equals(map.get(NEPTUNE_SETTING_MAX_FILE_SIZE))) {
                try {
                    uploader.setFileSizeLimit(FormatUtil.getBytes((String)map.get(NEPTUNE_SETTING_MAX_FILE_SIZE).trim()));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        uploader.center();
    }

    void saveUploadedFileAssets(List<String> fileUrls) {
        final BusyIndicator busyIndicator = new BusyIndicator((Widget)this);
        busyIndicator.center();
        final Long assetId = this.input.getAsset().getId();
        Long titleId = this.input.getInput().getTitleId();
        this.sftpViewService.saveUploadedFileAssets(assetId, titleId, fileUrls, (AsyncCallback<UploadedFileTitleInfo>)new NeptuneAsyncCallback<UploadedFileTitleInfo>(){

            public void onNeptuneSuccess(UploadedFileTitleInfo result) {
                busyIndicator.hide();
                if (result.getValidationStatus()) {
                    FileView.this.handleSaveFileAssetsSuccess(assetId);
                } else {
                    FileView.this.handleSaveFileAssetsSuccessWithWarning(assetId, result.getValidationMessages());
                }
            }

            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
                FileView.this.handleSaveFileAssetsFailure(assetId, caught);
            }
        });
    }

    void handleSaveFileAssetsSuccess(Long assetId) {
        this.titleView.getInput().invalidateMetadata();
        this.titleView.refresh();
        TitleValidationViewInput input = new TitleValidationViewInput();
        input.setInfoHeader(this.messages.fileUploadResgisterSuccessful(assetId.toString()));
        this.titleView.showMessage(input);
        this.titleView.getMetadataTab().updateAssetPanelHeight();
    }

    void handleSaveFileAssetsSuccessWithWarning(Long assetId, List<UITitleValidationMessage> valMsgs) {
        viewInputFileUpload = new TitleValidationViewInput();
        viewInputFileUpload.setInfoHeader(this.messages.fileUploadWithValidationErrors());
        if (!valMsgs.isEmpty()) {
            viewInputFileUpload.getTitleValidationMessages().addAll(valMsgs);
        }
        this.titleView.getInput().invalidateMetadata();
        this.titleView.refresh();
    }

    void handleSaveFileAssetsFailure(Long assetId, Throwable caught) {
        TitleValidationViewInput input = new TitleValidationViewInput();
        input.setErrorHeader(this.messages.fileUploadResgisterError(assetId.toString()));
        this.titleView.showMessage(input);
        this.titleView.getMetadataTab().updateAssetPanelHeight();
    }

    void handleFileUploadCanceled() {
        Long assetId = this.input.getAsset().getId();
        TitleValidationViewInput input = new TitleValidationViewInput();
        input.setInfoHeader(this.messages.fileUploadCanceled(assetId.toString()));
        this.titleView.showMessage(input);
        this.titleView.getMetadataTab().updateAssetPanelHeight();
    }

    void handleFileUploadError() {
        Long assetId = this.input.getAsset().getId();
        TitleValidationViewInput input = new TitleValidationViewInput();
        input.setErrorHeader(this.messages.fileUploadError(assetId.toString()));
        this.titleView.showMessage(input);
        this.titleView.getMetadataTab().updateAssetPanelHeight();
    }

    void showUploadedFileMessage() {
        this.titleView.showMessage(viewInputFileUpload);
        this.titleView.getMetadataTab().updateAssetPanelHeight();
        viewInputFileUpload = null;
    }

    public void setInput(AssetTree.AssetInfo asset) {
        this.input = asset;
        this.updateFileIDs();
        this.refresh();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    List<UIAssetFilePath> getFilePaths() {
        return this.filePaths;
    }

    private void updateFileIDs() {
        this.fileIDs.clear();
        this.generatedFileID = -1L;
        if (this.input == null) {
            return;
        }
        for (UIAssetFile file : this.input.getAsset().getFiles()) {
            if (file.getId() == null) continue;
            this.fileIDs.add(file.getId());
            long absoluteFileId = this.getAbsoluteValue(file.getId());
            if (this.getAbsoluteValue(this.generatedFileID) > absoluteFileId) continue;
            this.generatedFileID = -(++absoluteFileId);
        }
        for (UIAssetFile file : this.input.getAsset().getFiles()) {
            if (file.getId() != null) continue;
            this.generateFileID(file);
        }
    }

    private long getAbsoluteValue(long value) {
        return value < 0L ? -value : value;
    }

    private void generateFileID(UIAssetFile file) {
        file.setId(this.generatedFileID--);
        this.fileIDs.add(file.getId());
    }

    public void refresh() {
        this.disclosureContainer.setOpen(true);
        this.table.removeAllRows();
        this.rowIdentifier.clear();
        this.editImageButtons.clear();
        this.clearNewFileState();
        this.uploadBtn.setEnabled(false);
        if (this.input == null) {
            return;
        }
        for (UIAssetFile file : this.input.getAsset().getFiles()) {
            this.buildRow(file);
        }
        this.addNewFileRow();
        this.updateEnabledButtons();
        if (viewInputFileUpload != null) {
            this.showUploadedFileMessage();
        }
    }

    private void buildRow(UIAssetFile file) {
        int row = this.table.addRow();
        LabelWidget fileIDLabel = new LabelWidget(Long.toString(this.getAbsoluteValue(file.getId())));
        fileIDLabel.addStyleName(STYLE_FILE_ID_LABEL);
        this.table.addCell(row, (Widget)fileIDLabel);
        this.table.addTableCellStyle(row, this.table.getCellCount(row) - 1, STYLE_CELL_FILE_ID);
        this.rowIdentifier.put(file, fileIDLabel);
        for (UIAssetFileFieldDefinition fieldDefinition : this.fileDefinition.getFieldDefinitions()) {
            Widget widget = this.buildMetadataWidget(file, fieldDefinition);
            this.table.addCell(row, widget);
        }
        Widget parentFileWidget = this.buildParentFileWidget(file);
        this.table.addCell(row, parentFileWidget);
        Widget deleteButton = this.buildDeleteButton(file);
        this.table.addCell(row, deleteButton);
        this.table.addTableCellStyle(row, this.table.getCellCount(row) - 1, "content-AssetContentTable-cell-body-delete");
    }

    public void markDirty() {
        this.dirty = true;
        this.updateEnabledButtons();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void updateEnabledButtons() {
        boolean existingTitle = this.input != null && this.input.getInput().isExistingTitle();
        boolean enabled = !this.isReadOnly() && existingTitle && !this.dirty;
        this.uploadBtn.setEnabled(enabled);
        if (this.dirty) {
            this.uploadBtn.setTitle(this.messages.fileUploadDisableMessage());
        } else {
            this.uploadBtn.setTitle("");
        }
        for (Button button : this.editImageButtons) {
            button.setEnabled(enabled);
        }
    }

    void addNewFileRow() {
        this.newFile = this.assetFactory.createAssetFile(this.fileDefinition);
        this.generateFileID(this.newFile);
        this.buildRow(this.newFile);
    }

    private void clearNewFileState() {
        this.newFile = null;
        for (HandlerRegistration registration : this.newFileHandlers) {
            registration.removeHandler();
        }
        this.newFileHandlers.clear();
    }

    private void handleFileUpdated(UIAssetFile file) {
        if (file.equals(this.newFile)) {
            this.input.getAsset().addFile(file);
            this.clearNewFileState();
            this.updateParentFileWidgets();
            this.showDeleteButton(file);
            this.addNewFileRow();
        }
        this.fireViewChangeEvent();
    }

    private void handleFileDeleted(UIAssetFile file) {
        this.updateParentFileWidgets();
        this.fireViewChangeEvent();
    }

    private Widget buildParentFileWidget(final UIAssetFile file) {
        final ListBoxWidget widget = new ListBoxWidget();
        widget.addStyleName(STYLE_PARENT_FILE_WIDGET);
        this.updateParentFileWidgetItems(file, (ListBoxWidget<UIAssetFile>)widget);
        Long fileID = file.getId();
        boolean isReadOnly = this.readOnly || fileID != null && fileID > -1L;
        widget.setEnabled(!isReadOnly);
        widget.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FileView.this.handleParentFileChanged(file, (ListBoxWidget<UIAssetFile>)widget, event);
            }
        });
        return widget;
    }

    private void updateParentFileWidgets() {
        ListBoxWidget widget = null;
        for (UIAssetFile file : this.rowIdentifier.keySet()) {
            int row = this.table.getRow((Widget)this.rowIdentifier.get(file));
            int column = this.columnIndices.get(PARENT_FILE_ID_COLUMN);
            widget = (ListBoxWidget)this.table.getCellWidget(row, column);
            this.updateParentFileWidgetItems(file, (ListBoxWidget<UIAssetFile>)widget);
        }
    }

    private void updateParentFileWidgetItems(UIAssetFile file, ListBoxWidget<UIAssetFile> widget) {
        widget.clear();
        widget.addItem("", null);
        for (UIAssetFile otherFile : this.input.getAsset().getFiles()) {
            if (otherFile.equals(file)) continue;
            widget.addItem(Long.toString(this.getAbsoluteValue(otherFile.getId())), (Object)otherFile);
        }
        UIAssetFile parentFile = file.getParentFile();
        int index = widget.getIndex((Object)parentFile);
        if (index == -1) {
            widget.addItem(Long.toString(this.getAbsoluteValue(parentFile.getId())), (Object)parentFile);
        }
        widget.setSelectedItem((Object)parentFile);
    }

    private void handleParentFileChanged(UIAssetFile file, ListBoxWidget<UIAssetFile> widget, ChangeEvent event) {
        UIAssetFile newParent = (UIAssetFile)widget.getSelectedItem();
        if (!this.validateParentFileUpdate(file, newParent)) {
            widget.setSelectedItem((Object)file.getParentFile());
            return;
        }
        file.setParentFile(newParent);
        this.handleFileUpdated(file);
    }

    private boolean validateParentFileUpdate(UIAssetFile file, UIAssetFile newParent) {
        if (this.readOnly) {
            return false;
        }
        if (file.getId() != null && file.getId() > -1L) {
            Window.alert((String)this.messages.fileParentChangeError());
            return false;
        }
        if (this.isDescendant(file, newParent)) {
            Window.alert((String)this.messages.fileParentDescendantError());
            return false;
        }
        return true;
    }

    private boolean isDescendant(UIAssetFile file, UIAssetFile descendant) {
        ArrayList<UIAssetFile> descendants = new ArrayList<UIAssetFile>();
        descendants.add(file);
        int index = 0;
        while (index < descendants.size()) {
            UIAssetFile current = (UIAssetFile)descendants.get(index);
            for (UIAssetFile inputFile : this.input.getAsset().getFiles()) {
                if (!current.equals(inputFile.getParentFile()) || descendants.contains(inputFile)) continue;
                descendants.add(inputFile);
            }
            ++index;
        }
        return descendants.contains(descendant);
    }

    private Widget buildDeleteButton(final UIAssetFile file) {
        ImageWidget deleteImage = new ImageWidget("cms_contentmgmt_ui/resources/images/title_metadata_delete.gif");
        final PushButtonWidget button = new PushButtonWidget(deleteImage);
        button.addStyleName("content-AssetContent-deleteButton");
        boolean isReadOnly = this.readOnly || file.equals(this.newFile);
        button.setEnabled(!isReadOnly);
        button.setVisible(!isReadOnly);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FileView.this.handleDeleteButtonClicked(file, (Widget)button, event);
            }
        });
        return button;
    }

    private void showDeleteButton(UIAssetFile file) {
        int row = this.table.getRow((Widget)this.rowIdentifier.get(file));
        int column = this.columnIndices.get(DELETE_BUTTON_COLUMN);
        FocusWidget button = (FocusWidget)this.table.getCellWidget(row, column);
        button.setEnabled(true);
        button.setVisible(true);
    }

    private void handleDeleteButtonClicked(UIAssetFile file, Widget button, ClickEvent event) {
        if (!this.validateFileDelete(file)) {
            return;
        }
        int row = this.table.getRow(button);
        this.table.removeRow(row);
        this.input.getAsset().getFiles().remove(file);
        this.rowIdentifier.remove(file);
        this.handleFileDeleted(file);
    }

    private boolean validateFileDelete(UIAssetFile file) {
        if (this.readOnly || file.equals(this.newFile)) {
            return false;
        }
        for (UIAssetFile inputFile : this.input.getAsset().getFiles()) {
            if (!file.equals(inputFile.getParentFile())) continue;
            TitleValidationViewInput input = new TitleValidationViewInput();
            input.setErrorHeader(this.messages.fileDeleteWithChildrenError());
            this.titleView.showMessage(input);
            this.titleView.getMetadataTab().updateAssetPanelHeight();
            return false;
        }
        return true;
    }

    private Widget buildMetadataWidget(UIAssetFile file, UIAssetFileFieldDefinition definition) {
        UIAssetFileField encodeFormatField = file.getFields().get(FILE_ENCODEFORMAT_XPATH);
        UIAssetFileField lookupKeyField = file.getFields().get(FILE_LOOKUP_KEY_XPATH);
        UIAssetFileField field = file.getFields().get(definition.getName());
        if (field == null) {
            field = this.assetFactory.createAssetFileField(definition);
            file.addField(field);
        }
        HorizontalPanel panel = new HorizontalPanel();
        panel.addStyleName("cms_button_container");
        FileMetadataWidgetBuilder builder = new FileMetadataWidgetBuilder(this, file);
        SimpleFieldWidget<?, ?, ?> fieldWidget = null;
        try {
            fieldWidget = builder.build(file, definition, field, this.readOnly);
            panel.add(fieldWidget);
            final String assetType = this.input.getAsset().getAssetType();
            String fieldName = definition.getName();
            if (this.videoAssetTypes.contains(assetType) && FILE_URI_XPATH.equals(fieldName)) {
                this.addVideoPreviewButton((Panel)panel, file, field, encodeFormatField);
            } else if (this.imageAssetTypes.contains(assetType) && FILE_URI_XPATH.equals(fieldName)) {
                Button previewButton = new Button(this.messages.previewImageButtontext());
                previewButton.removeStyleName("gwt-Button");
                previewButton.addStyleName("ebBtn");
                previewButton.addStyleName("preview_button_icon");
                Button editImageButton = new Button(this.messages.editImageButtonText());
                editImageButton.removeStyleName("gwt-Button");
                editImageButton.addStyleName("ebBtn");
                this.editImageButtons.add(editImageButton);
                editImageButton.setEnabled(!this.isReadOnly());
                panel.add((Widget)previewButton);
                panel.add((Widget)editImageButton);
                final String fieldValue = field.getField().getDisplayValue();
                if (fieldValue == null || fieldValue.isEmpty()) {
                    previewButton.setEnabled(false);
                    editImageButton.setEnabled(false);
                } else {
                    String originalFilePathFieldValue = fieldValue;
                    UIAssetFile parentFile = file.getParentFile();
                    if (parentFile != null) {
                        UIAssetFileField parentFilefield = parentFile.getFields().get(definition.getName());
                        String parentFileFieldValue = parentFilefield.getField().getDisplayValue();
                        originalFilePathFieldValue = String.valueOf(parentFileFieldValue);
                    }
                    final String originalFilePath = originalFilePathFieldValue;
                    int lastIndexOfFileSeparator = fieldValue.lastIndexOf("/");
                    if (lastIndexOfFileSeparator < 0) {
                        lastIndexOfFileSeparator = fieldValue.lastIndexOf("\\");
                    }
                    final String imageFolder = fieldValue.substring(0, lastIndexOfFileSeparator);
                    final String imageUrl = String.valueOf(Window.Location.getProtocol()) + "//" + Window.Location.getHost() + GET_IMAGE_JSP_PATH + URL.encodeQueryString((String)fieldValue);
                    final Long assetId = file.getParentAsset().getId();
                    final Long titleId = this.input.getInput().getTitleId();
                    String lookupKeyFieldValue = null;
                    if (lookupKeyField != null && lookupKeyField.getField() != null) {
                        lookupKeyFieldValue = String.valueOf(lookupKeyField.getField().getValue());
                    }
                    final String lookupKey = lookupKeyFieldValue;
                    editImageButton.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            final EditImageDialogBox editImageDialogBox = new EditImageDialogBox(fieldValue, assetType, lookupKey, false, true);
                            editImageDialogBox.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                                public void setPosition(int offsetWidth, int offsetHeight) {
                                    int left = (Window.getClientWidth() - offsetWidth) / 3;
                                    int top = (Window.getClientHeight() - offsetHeight) / 3;
                                    editImageDialogBox.setPopupPosition(left, top);
                                }
                            });
                            SaveImageRequest saveImageRequest = new SaveImageRequest();
                            saveImageRequest.setImageFolderPath(imageFolder);
                            saveImageRequest.setOriginalFilePath(originalFilePath);
                            saveImageRequest.setTitleId(titleId);
                            saveImageRequest.setAssetId(assetId);
                            editImageDialogBox.setSaveImageRequest(saveImageRequest);
                            String url = String.valueOf(imageUrl) + FileView.BASE_64_RESPONSE_TYPE;
                            EditImageDialogBox.loadImageUrl(url, fieldValue);
                        }
                    });
                    previewButton.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            final PreviewImageDialogBox previewImageDialogBox = new PreviewImageDialogBox(false, true, imageUrl);
                            previewImageDialogBox.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                                public void setPosition(int offsetWidth, int offsetHeight) {
                                    int left = (Window.getClientWidth() - offsetWidth) / 3;
                                    int top = 0;
                                    if (Window.getClientHeight() > 610) {
                                        top = (Window.getClientHeight() - 610) / 3;
                                    }
                                    previewImageDialogBox.setPopupPosition(left, top);
                                }
                            });
                        }
                    });
                }
            }
        }
        catch (MetadataTypeMismatchException ex) {
            String typeName = this.getTypeName(ex.getFieldDefinition());
            String receivedTypeName = this.getTypeName(ex.getReceivedField());
            String message = this.messages.metadataTypeMismatchError(typeName, receivedTypeName);
            LabelWidget label = new LabelWidget(message);
            label.addStyleName("content-AssetContent-datatypeMismatchLabel");
            return label;
        }
        DataTypeWidget<?> widget = fieldWidget.getDataTypeWidget();
        if (file.equals(this.newFile) && widget instanceof HasKeyUpHandlers) {
            WidgetKeyEventHandler handler = new WidgetKeyEventHandler(this, file, field, fieldWidget);
            HasKeyUpHandlers keyAwareWidget = (HasKeyUpHandlers)widget;
            this.newFileHandlers.add(keyAwareWidget.addKeyUpHandler((KeyUpHandler)handler));
        }
        return panel;
    }

    private void addVideoPreviewButton(Panel panel, UIAssetFile file, UIAssetFileField uriField, UIAssetFileField encodeFormatField) {
        Object fieldValue;
        Button videoPreviewButton = new Button(this.messages.previewImageButtontext());
        videoPreviewButton.removeStyleName("gwt-Button");
        videoPreviewButton.addStyleName("ebBtn");
        videoPreviewButton.addStyleName("preview_button_icon");
        panel.add((Widget)videoPreviewButton);
        Object encodeFormatFieldValue = null;
        if (encodeFormatField != null && encodeFormatField.getField() != null) {
            encodeFormatFieldValue = encodeFormatField.getField().getValue();
        }
        if ((fieldValue = uriField.getField().getValue()) == null || String.valueOf(fieldValue).isEmpty()) {
            videoPreviewButton.setEnabled(false);
        } else {
            final String fileURI = String.valueOf(fieldValue);
            String fileEncodeFmt = "";
            fileEncodeFmt = encodeFormatFieldValue != null && !String.valueOf(encodeFormatFieldValue).isEmpty() ? String.valueOf(encodeFormatFieldValue) : fileURI.substring(fileURI.lastIndexOf(".") + 1);
            if (!licensedForVideoPreview || !JWPlayerWidget.isPlayable(fileEncodeFmt)) {
                videoPreviewButton.setEnabled(false);
                return;
            }
            final String fileEncodeFormat = fileEncodeFmt;
            final BusyIndicator busyIndicator = new BusyIndicator((Widget)this);
            final FileView parentView = this;
            videoPreviewButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    busyIndicator.center();
                    FileView.this.videoPlayerService.getSettings((AsyncCallback<UIVideoPlayer>)new NeptuneAsyncCallback<UIVideoPlayer>(){

                        public void onNeptuneSuccess(UIVideoPlayer confSettings) {
                            busyIndicator.hide();
                            Map<String, String> basicVars = confSettings.getBasicVars();
                            Map<String, String> flashVars = confSettings.getFlashVars();
                            VideoPreviewDialog dlg = new VideoPreviewDialog(String.valueOf(fileEncodeFormat.trim().toLowerCase()) + ":" + fileURI, basicVars, flashVars, FileView.this.getDuration());
                            dlg.center();
                        }

                        public void onNeptuneFailure(Throwable caught) {
                            busyIndicator.hide();
                            parentView.handleGetVideoSettingsFailure(caught);
                        }
                    });
                }
            });
        }
    }

    private int getDuration() {
        UIComplexField f;
        UIAsset videoAsset = this.input.getAsset();
        UIComplexField rootField = videoAsset.getRootField();
        int dur = 0;
        if (rootField != null && (f = (UIComplexField)rootField.getChildren().getField("Duration")) != null) {
            UITimeField durationField = (UITimeField)f.getChildren().getField("Duration");
            String duration = null;
            if (durationField != null && (duration = durationField.getDisplayValue()) != null && !duration.isEmpty()) {
                String[] parts = duration.split(":");
                dur += Integer.parseInt(parts[0]) * 60 * 60;
                dur += Integer.parseInt(parts[1]) * 60;
                dur += Integer.parseInt(parts[2]);
            }
        }
        return dur;
    }

    void handleGetVideoSettingsFailure(Throwable caught) {
    }

    void handleGetImageEditorSettingsFailure(Throwable caught) {
    }

    private String getTypeName(UIFieldDefinition fieldDefinition) {
        String name = null;
        name = fieldDefinition instanceof UIComplexFieldDefinition ? this.messages.complexTypeName() : (fieldDefinition instanceof UISimpleFieldDefinition ? ((UISimpleFieldDefinition)fieldDefinition).getDatatype().getName() : this.messages.unknownTypeName());
        return name;
    }

    private String getTypeName(UIField field) {
        String name = null;
        name = field instanceof UIComplexField ? this.messages.complexTypeName() : (field instanceof UISimpleField ? ((UISimpleField)field).getDatatype().getName() : this.messages.unknownTypeName());
        return name;
    }

    void handleMetadataValueChanged(UIAssetFile file, UIAssetFileField field, SimpleFieldWidget<?, ?, ?> widget) {
        this.handleFileUpdated(file);
    }

    private void handleKeyUpEvent(UIAssetFile file, UIAssetFileField field, SimpleFieldWidget<?, ?, ?> widget, KeyUpEvent event) {
        if (!file.equals(this.newFile)) {
            return;
        }
        String stringValue = widget.getTextValue();
        if (stringValue != null && stringValue.length() > 0) {
            this.handleFileUpdated(file);
        }
    }

    public void validate(List<AssetValidationMessage> messages, boolean draft) {
        int startIndex = this.columnIndices.get(FILE_ID_COLUMN) + 1;
        int endIndex = this.columnIndices.get(PARENT_FILE_ID_COLUMN) - 1;
        SimpleFieldWidget widget = null;
        int row = 0;
        while (row < this.table.getRowCount()) {
            int column = startIndex;
            while (column <= endIndex) {
                Widget tableCellWidget = this.table.getCellWidget(row, column);
                if (tableCellWidget instanceof SimpleFieldWidget && !(widget = (SimpleFieldWidget)this.table.getCellWidget(row, column)).isValidValue(draft)) {
                    int index = column - startIndex;
                    String name = ((UIAssetFileFieldDefinition)this.fileDefinition.getFieldDefinitions().get(index)).getDisplayName();
                    String error = widget.getCurrentToolTip();
                    messages.add(new AssetValidationMessage(this.input, name, (Widget)widget, error));
                }
                ++column;
            }
            ++row;
        }
    }

    @Override
    public HandlerRegistration addViewChangeHandler(ViewChangeHandler handler) {
        return this.addHandler(handler, ViewChangeEvent.getType());
    }

    private void fireViewChangeEvent() {
        this.fireEvent(new ViewChangeEvent());
    }

    private static final class WidgetKeyEventHandler
    implements KeyUpHandler {
        private FileView fileView;
        private UIAssetFile file;
        private UIAssetFileField field;
        private SimpleFieldWidget<?, ?, ?> widget;

        public WidgetKeyEventHandler(FileView view, UIAssetFile file, UIAssetFileField field, SimpleFieldWidget<?, ?, ?> widget) {
            this.fileView = view;
            this.file = file;
            this.field = field;
            this.widget = widget;
        }

        public void onKeyUp(KeyUpEvent event) {
            this.fileView.handleKeyUpEvent(this.file, this.field, this.widget, event);
        }
    }
}

