/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.compare;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.compare.report.TitleCompareReportView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.report.TitleCompareXmlView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class TitleCompareView
extends Composite {
    private ITitleCompareViewController controller;
    private SimpleContainer mainContainer;
    private TitleCompareViewMessages messages;
    private TitleCompareViewInput input;
    private TitleCompareReportView diffView;
    private TitleCompareXmlView xmlView;
    private BusyIndicator busyIndicator;
    private static final String STYLE_NAME = "content-TitleCompareView";
    private boolean showXML = true;
    private boolean isPopup = false;

    public TitleCompareView(ITitleCompareViewController controller) {
        this.controller = controller;
        this.mainContainer = new SimpleContainer();
        this.initWidget((Widget)this.mainContainer);
        this.initialize();
    }

    public TitleCompareView(ITitleCompareViewController controller, boolean showXML) {
        this.controller = controller;
        this.mainContainer = new SimpleContainer();
        this.initWidget((Widget)this.mainContainer);
        this.showXML = showXML;
        this.initialize();
    }

    public TitleCompareView(ITitleCompareViewController controller, boolean showXML, boolean isPopup) {
        this.controller = controller;
        this.mainContainer = new SimpleContainer();
        this.initWidget((Widget)this.mainContainer);
        this.isPopup = isPopup;
        this.initialize();
    }

    public ITitleCompareViewController getController() {
        return this.controller;
    }

    protected void onUnload() {
        this.busyIndicator.hide();
        super.onUnload();
    }

    private void initialize() {
        this.messages = (TitleCompareViewMessages)GWT.create(TitleCompareViewMessages.class);
        this.busyIndicator = new BusyIndicator();
        this.addStyleName(STYLE_NAME);
        this.diffView = new TitleCompareReportView(this, this.controller, this.showXML);
        this.xmlView = new TitleCompareXmlView(this, this.controller, this.showXML);
    }

    public TitleCompareViewInput getInput() {
        return this.input;
    }

    public void setInput(TitleCompareViewInput input) {
        this.input = input;
    }

    public TitleCompareViewMessages getMessages() {
        return this.messages;
    }

    private void clear() {
        this.mainContainer.clear();
    }

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    public void showDiffView() {
        this.clear();
        this.showBusyIndicator();
        if (this.isPopup) {
            VerticalContainer vc = new VerticalContainer();
            ScrollContainer sc = new ScrollContainer();
            sc.addStyleName("diff-content-scroll-panel");
            sc.add((Widget)this.diffView);
            int height = this.getInput().restrictedHeight;
            int width = this.getInput().restrictedWidth;
            sc.setHeight(String.valueOf((double)height - (double)height * 0.15) + "px");
            sc.setWidth(String.valueOf((double)width - (double)width * 0.015) + "px");
            this.diffView.getCompareSummaryLabel().removeFromParent();
            this.diffView.getButtonPanel().removeFromParent();
            vc.add((Widget)this.diffView.getCompareSummaryLabel());
            vc.add((Widget)sc);
            vc.add((Widget)this.diffView.getButtonPanel());
            this.mainContainer.setWidget((Widget)vc);
        } else {
            this.mainContainer.setWidget((Widget)this.diffView);
        }
        this.diffView.setSummaryLabel(this.getInput().header);
        this.diffView.refresh();
        this.diffView.updateSize();
        this.hideBusyIndicator();
    }

    public void showXmlView(UITitleCompareXmlData xmlData) {
        this.showXmlView(xmlData, false);
    }

    public void showXmlView(UITitleCompareXmlData xmlData, boolean isPreviewPopup) {
        this.clear();
        this.showBusyIndicator();
        this.mainContainer.setWidget((Widget)this.xmlView);
        this.xmlView.setSummaryLabel(this.getInput().header);
        this.xmlView.showXmlView(xmlData, isPreviewPopup);
        this.hideBusyIndicator();
    }

    public void removeResizeHandler() {
        this.xmlView.removeResizeHandler();
    }

    public void showErrorView(Throwable error) {
        String msg = this.getMessages().compareTitlesError(error.getLocalizedMessage());
        ErrorPanel errorPanel = new ErrorPanel(msg, this.controller);
        this.mainContainer.setWidget((Widget)errorPanel);
    }
}

