/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.compare.preview;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.XMLParser;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.FrameWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.List;

public class TitleCompareXmlWidget
extends Composite {
    private TitleCompareView view;
    private SimpleContainer container;
    private ListBoxWidget<UIAssetSpecificationListItem> specificationBox;
    private SimpleContainer previewContents;
    private HorizontalContainer previewsContainer;
    private Label preview1HeadingLabel;
    private Label preview2HeadingLabel;
    private SimpleContainer preview1Widget;
    private SimpleContainer preview2Widget;
    private Widget previewFrame1;
    private Widget previewFrame2;
    private BusyIndicator busyIndicator;
    private Command resizeCommand;
    private boolean isIE = false;
    private HandlerRegistration windowRegistration = null;
    private static final String STYLE_NAME = "content-TitleComparePreviewWidget";
    private static final String STYLE_SPECIFICATION_BOX = "content-TitleComparePreviewWidget-specificationsBox";
    private static final String STYLE_PREVIEWS_SECTION = "content-TitleComparePreviewWidget-previews";
    private static final String STYLE_PREVIEW_PANEL = "content-TitleComparePreviewWidget-previewPanel";
    private static final String STYLE_PREVIEW_HEADING_LABEL = "content-TitleComparePreviewWidget-previewLabel";
    private static final String STYLE_PREVIEW_WIDGET = "content-TitleComparePreviewWidget-previewWidget";
    private static final String STYLE_PREVIEW_CONTENTS = "content-TitleComparePreviewWidget-previewFrame";
    private static final String STYLE_PREVIEW_CONTENTS_IE = "content-TitleComparePreviewWidget-previewFrame-ie";
    private static final String STYLE_PREVIEW_XML_POPUP = "rule-preview-xml-popup";

    public TitleCompareXmlWidget(TitleCompareView widget) {
        this.view = widget;
        this.container = new SimpleContainer();
        this.initWidget((Widget)this.container);
        this.initialize();
    }

    private void initialize() {
        this.addStyleName(STYLE_NAME);
        this.busyIndicator = new BusyIndicator();
        DockPanel contents = new DockPanel();
        this.container.setWidget((Widget)contents);
        this.specificationBox = new ListBoxWidget();
        this.specificationBox.addStyleName(STYLE_SPECIFICATION_BOX);
        this.specificationBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TitleCompareXmlWidget.this.handleSpecificationChange();
            }
        });
        contents.add(this.specificationBox, DockPanel.NORTH);
        this.previewContents = new SimpleContainer();
        this.previewContents.addStyleName(STYLE_PREVIEWS_SECTION);
        contents.add((Widget)this.previewContents, DockPanel.CENTER);
        this.previewsContainer = new HorizontalContainer();
        this.previewContents.setWidget((Widget)this.previewsContainer);
        this.preview1HeadingLabel = this.buildPreviewHeadingLabel();
        this.preview1Widget = this.buildPreviewWidget();
        this.previewsContainer.add(this.buildPreviewContainer(this.preview1HeadingLabel, (Widget)this.preview1Widget));
        this.preview2HeadingLabel = this.buildPreviewHeadingLabel();
        this.preview2Widget = this.buildPreviewWidget();
        this.previewsContainer.add(this.buildPreviewContainer(this.preview2HeadingLabel, (Widget)this.preview2Widget));
        this.resizeCommand = new Command(){

            public void execute() {
                TitleCompareXmlWidget.this.resizeFrame();
            }
        };
    }

    private Widget buildPreviewContainer(Label previewLabel, Widget previewWidget) {
        VerticalPanel previewPanel = new VerticalPanel();
        previewPanel.addStyleName(STYLE_PREVIEW_PANEL);
        previewPanel.add((Widget)previewLabel);
        previewPanel.add(previewWidget);
        return previewPanel;
    }

    private Label buildPreviewHeadingLabel() {
        Label label = new Label();
        label.addStyleName(STYLE_PREVIEW_HEADING_LABEL);
        return label;
    }

    private SimpleContainer buildPreviewWidget() {
        SimpleContainer panel = new SimpleContainer();
        panel.addStyleName(STYLE_PREVIEW_WIDGET);
        return panel;
    }

    private TitleCompareViewInput getInput() {
        return this.view.getInput();
    }

    private TitleCompareViewMessages getMessages() {
        return this.view.getMessages();
    }

    private void updateSpecifications() {
        this.specificationBox.clear();
        if (this.getInput().compareData == null) {
            return;
        }
        List<UIAssetSpecificationListItem> specs = this.getInput().compareData.getSpecifications();
        if (specs == null) {
            return;
        }
        String selectedSpecificationName = this.getInput().specName;
        UIAssetSpecificationListItem selectedSpec = specs.size() == 0 ? null : specs.get(0);
        for (UIAssetSpecificationListItem spec : specs) {
            this.specificationBox.addItem(spec.getDisplayName(), (Object)spec);
            if (!spec.getName().equals(selectedSpecificationName)) continue;
            selectedSpec = spec;
        }
        if (selectedSpec != null) {
            this.specificationBox.setSelectedItem((Object)selectedSpec);
        }
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                TitleCompareXmlWidget.this.updateFrameSize();
            }
        });
    }

    public HandlerRegistration getWindowRegistration() {
        return this.windowRegistration;
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        this.busyIndicator.hide();
        super.onUnload();
    }

    private void handleSpecificationChange() {
        UIAssetSpecificationListItem specification = (UIAssetSpecificationListItem)this.specificationBox.getSelectedItem();
        String name = specification != null ? specification.getName() : null;
        this.view.getController().onSpecChanged(name);
    }

    public void showXmlView(UITitleCompareXmlData preview, boolean isPreviewPopup) {
        this.preview1Widget.clear();
        this.preview2Widget.clear();
        this.updateSpecifications();
        if (Window.Navigator.getUserAgent().toLowerCase().contains("trident") || Window.Navigator.getUserAgent().toLowerCase().contains("msie")) {
            this.previewFrame1 = this.buildPreviewFrameIE(this.preview1Widget, preview.preview1URL);
            this.previewFrame2 = this.buildPreviewFrameIE(this.preview2Widget, preview.preview2URL);
            this.isIE = true;
        } else {
            this.previewFrame1 = this.buildPreviewFrame(this.preview1Widget, preview.preview1URL);
            this.previewFrame2 = this.buildPreviewFrame(this.preview2Widget, preview.preview2URL);
        }
        String name = this.getInput().displayName1;
        this.preview1HeadingLabel.setText(this.getMessages().previewHeadingLabel(name));
        name = this.getInput().displayName2;
        this.preview2HeadingLabel.setText(this.getMessages().previewHeadingLabel(name));
        if (isPreviewPopup) {
            this.setRulePreviewPopupFrameSize();
        } else {
            this.updateFrameSize();
        }
        this.previewContents.setWidget((Widget)this.previewsContainer);
        this.busyIndicator.hide();
    }

    private Widget buildPreviewFrame(SimpleContainer previewResultContainer, String url) {
        FrameWidget frame = new FrameWidget(url);
        frame.addStyleName(STYLE_PREVIEW_CONTENTS);
        previewResultContainer.setWidget((Widget)frame);
        return frame;
    }

    private Widget buildPreviewFrameIE(SimpleContainer previewResultContainer, String url) {
        HTMLWidget xmlBox = new HTMLWidget();
        xmlBox.addStyleName(STYLE_PREVIEW_CONTENTS);
        xmlBox.addStyleName(STYLE_PREVIEW_CONTENTS_IE);
        try {
            RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url);
            requestBuilder.sendRequest(null, (RequestCallback)new requestCallbackImpl(xmlBox));
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        previewResultContainer.setWidget((Widget)xmlBox);
        return xmlBox;
    }

    public String formatXML(Node node, String tab_str) {
        String formatted = "";
        if (node.getNodeType() == 1) {
            String attributes = "";
            int k = 0;
            while (k < node.getAttributes().getLength()) {
                attributes = String.valueOf(attributes) + " " + node.getAttributes().item(k).getNodeName() + "=\"" + node.getAttributes().item(k).getNodeValue() + "\"";
                ++k;
            }
            formatted = String.valueOf(tab_str) + "<" + node.getNodeName() + attributes;
            if (node.getChildNodes().getLength() > 0) {
                formatted = String.valueOf(formatted) + ">\n";
            }
            int i = 0;
            while (i < node.getChildNodes().getLength()) {
                formatted = String.valueOf(formatted) + this.formatXML(node.getChildNodes().item(i), String.valueOf(tab_str) + "  ");
                ++i;
            }
            formatted = node.getChildNodes().getLength() > 0 ? String.valueOf(formatted) + tab_str + "</" + node.getNodeName() + ">\n" : String.valueOf(formatted) + " />\n";
        } else if (node.toString().trim().length() > 0) {
            formatted = String.valueOf(tab_str) + node.toString() + "\n";
        }
        return formatted;
    }

    private void updateFrameSize() {
        DeferredCommand.addCommand((Command)this.resizeCommand);
    }

    private void resizeFrame() {
        if (this.previewFrame1 == null || this.previewFrame2 == null) {
            return;
        }
        int width = Window.getClientWidth() - this.getInput().restrictedWidth;
        int height = Window.getClientHeight() - this.getInput().restrictedHeight - this.specificationBox.getOffsetHeight() - 60 - 30;
        this.previewFrame1.setPixelSize(width / 2 - 10 - 20, height);
        this.previewFrame2.setPixelSize(width / 2 - 10 - 20, height);
    }

    private void setRulePreviewPopupFrameSize() {
        int height;
        int width;
        if (this.previewFrame1 == null || this.previewFrame2 == null) {
            return;
        }
        int popUpWidth = this.view.getInput().restrictedWidth;
        int popUpHeight = this.view.getInput().restrictedHeight;
        if (this.isIE) {
            width = (int)((double)popUpWidth + 0.028 * (double)popUpWidth);
            height = (int)((double)popUpHeight - 0.26 * (double)popUpHeight);
        } else {
            width = (int)((double)popUpWidth + 0.045 * (double)popUpWidth);
            height = (int)((double)popUpHeight - 0.24 * (double)popUpHeight);
        }
        this.previewFrame1.setPixelSize(width / 2 - 10 - 20, height);
        this.previewFrame2.setPixelSize(width / 2 - 10 - 20, height);
        this.preview1Widget.setStyleName(STYLE_PREVIEW_XML_POPUP);
        this.preview2Widget.setStyleName(STYLE_PREVIEW_XML_POPUP);
    }

    public class requestCallbackImpl
    implements RequestCallback {
        private HTMLWidget htmlBox;

        public requestCallbackImpl(HTMLWidget htmlWidget) {
            this.htmlBox = htmlWidget;
        }

        public void setHTMLWidet(HTMLWidget htmlWidget) {
            this.htmlBox = htmlWidget;
        }

        public HTMLWidget getHTMLWidet() {
            return this.htmlBox;
        }

        public void onError(Request request, Throwable exception) {
            exception.printStackTrace();
        }

        public void onResponseReceived(Request request, Response response) {
            String res = response.getText().replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
            Document messageDom = XMLParser.parse((String)res);
            Node rootNode = messageDom.getFirstChild();
            this.htmlBox.setText(TitleCompareXmlWidget.this.formatXML(rootNode, "  "));
        }
    }
}

