/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.compare.report;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIAssetDifference;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.compare.report.MetadataCompareWidget;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareRecord;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareTable;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareTableColumn;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.field.FieldCompareTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FocusContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

class AssetMetadataCompareWidget
extends Composite
implements Focusable {
    private final MetadataCompareWidget metadataCompareWidget;
    private final FocusContainer container;
    private final UIAssetDifference difference;
    private static final String STYLE_NAME = "content-AssetMetadataCompareWidget";
    private static final String STYLE_ASSET_TABLE = "content-AssetMetadataCompareWidget-assetDescriptionTable";
    private static final String STYLE_ASSET_TABLE_WIDGET = "content-AssetMetadataCompareWidget-assetTable";
    private static final String STYLE_ASSET_TABLE_HEADING = "content-AssetMetadataCompareWidget-assetTableHeading";
    private static final String STYLE_ASSET_TABLE_VALUE = "content-AssetMetadataCompareWidget-assetTableValue";
    private static final int ASSET_TABLE_CELL_LIMIT = 6;

    public AssetMetadataCompareWidget(MetadataCompareWidget parent, UIAssetDifference difference) {
        this.metadataCompareWidget = parent;
        this.difference = difference;
        this.container = new FocusContainer();
        this.initWidget((Widget)this.container);
        this.initialize();
    }

    private void initialize() {
        this.addStyleName(STYLE_NAME);
        VerticalContainer contents = new VerticalContainer();
        this.container.setWidget((Widget)contents);
        Widget descriptionWidget = this.buildAssetDescriptionWidget();
        contents.add(descriptionWidget);
        FieldCompareTable table = new FieldCompareTable(this.getMessages(), this.getInput(), this.getDifference());
        contents.add((Widget)table);
        table.refresh();
    }

    public TitleCompareViewInput getInput() {
        return this.metadataCompareWidget.getInput();
    }

    public UIAssetDifference getDifference() {
        return this.difference;
    }

    private Widget buildAssetDescriptionWidget() {
        FlexTable table = new FlexTable();
        table.addStyleName(STYLE_ASSET_TABLE);
        AssetCompareTable compareTable = this.getAssetCompareTable();
        AssetCompareRecord record = compareTable.getRecord(this.getDifference());
        List columns = compareTable.getTableColumns();
        for (Column column : columns) {
            AssetCompareTableColumn tableColumn;
            if (!(column instanceof AssetCompareTableColumn) || !(tableColumn = (AssetCompareTableColumn)column).isShownInFieldDifference()) continue;
            LabelWidget label = new LabelWidget();
            label.addStyleName(STYLE_ASSET_TABLE_WIDGET);
            label.addStyleName(STYLE_ASSET_TABLE_HEADING);
            label.setText(String.valueOf(column.getDisplayName()) + ":");
            this.addTableWidget(table, (Widget)label);
            Widget widget = tableColumn.getWidget(record);
            widget.addStyleName(STYLE_ASSET_TABLE_WIDGET);
            widget.addStyleName(STYLE_ASSET_TABLE_VALUE);
            this.addTableWidget(table, widget);
        }
        return table;
    }

    private AssetCompareTable getAssetCompareTable() {
        AssetCompareTable table = null;
        table = this.difference.isFileAsset() ? this.metadataCompareWidget.getReportWidget().getFileCompareWidget().getTable() : this.metadataCompareWidget.getReportWidget().getAssetCompareWidget().getTable();
        return table;
    }

    private void addTableWidget(FlexTable table, Widget widgetToAdd) {
        int columnIndex;
        int rowCount = table.getRowCount();
        int rowIndex = rowCount == 0 ? 0 : rowCount - 1;
        int n = columnIndex = rowCount == 0 ? 0 : table.getCellCount(rowIndex);
        if (columnIndex >= 6) {
            ++rowIndex;
            columnIndex = 0;
        }
        table.setWidget(rowIndex, columnIndex, widgetToAdd);
    }

    private TitleCompareViewMessages getMessages() {
        return this.metadataCompareWidget.getMessages();
    }

    public int getTabIndex() {
        return this.container.getTabIndex();
    }

    public void setAccessKey(char key) {
        this.container.setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        this.container.setFocus(focused);
    }

    public void setTabIndex(int index) {
        this.container.setTabIndex(index);
    }
}

