/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.compare.report;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.compare.report.AssetCompareWidget;
import com.tandbergtv.cms.portal.content.client.title.view.compare.report.FileCompareWidget;
import com.tandbergtv.cms.portal.content.client.title.view.compare.report.MetadataCompareWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class TitleCompareReportView
extends ResizableContainer {
    private ITitleCompareViewController controller;
    private boolean showXML;
    private final TitleCompareView parentView;
    private AssetCompareWidget assetWidget;
    private AssetCompareWidget fileWidget;
    private MetadataCompareWidget metadataWidget;
    public HorizontalPanel buttonPanel;
    private LabelWidget compareSummaryLabel;
    private static final String STYLE_NAME = "content-TitleCompareReportWidget";
    private static final String STYLE_MESSAGE = "content-TitleCompareReportWidget-messageLabel";
    private static final String STYLE_SUMMARY_LABEL = "content-TitleCompareView-summaryLabel";
    private static final String STYLE_BUTTONS_PANEL = "content-TitleCompareView-buttonPanel";

    public TitleCompareReportView(TitleCompareView parent, ITitleCompareViewController controller, boolean showXML) {
        super((Widget)new VerticalContainer(), null, null);
        this.parentView = parent;
        this.controller = controller;
        this.showXML = showXML;
        this.setOffsetHeight(125);
        this.initialize();
    }

    public void setSummaryLabel(String str) {
        this.compareSummaryLabel.setText(str);
    }

    private void initialize() {
        this.addStyleName(STYLE_NAME);
        VerticalContainer contents = (VerticalContainer)this.getContent();
        this.compareSummaryLabel = new LabelWidget();
        this.compareSummaryLabel.addStyleName(STYLE_SUMMARY_LABEL);
        contents.add((Widget)this.compareSummaryLabel);
        this.assetWidget = new AssetCompareWidget(this);
        contents.add((Widget)this.assetWidget);
        this.fileWidget = new FileCompareWidget(this);
        contents.add((Widget)this.fileWidget);
        this.metadataWidget = new MetadataCompareWidget(this);
        contents.add((Widget)this.metadataWidget);
        this.buttonPanel = this.createButtonsPanel();
        this.buttonPanel.addStyleName(STYLE_BUTTONS_PANEL);
        this.addBottomWidget(null, (Widget)this.buttonPanel);
    }

    public HorizontalPanel createButtonsPanel() {
        HorizontalPanel hc = new HorizontalPanel();
        ButtonWidget showDiffButton = new ButtonWidget("Show Differences");
        showDiffButton.removeStyleName("gwt-Button");
        showDiffButton.addStyleName("ebBtn");
        showDiffButton.addStyleName("ebBtn_color_green");
        showDiffButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleCompareReportView.this.controller.onShowDifferences();
            }
        });
        hc.add((Widget)showDiffButton);
        if (this.showXML) {
            ButtonWidget showXmlButton = new ButtonWidget("Show XML");
            showXmlButton.removeStyleName("gwt-Button");
            showXmlButton.addStyleName("ebBtn");
            showXmlButton.addStyleName("ebBtn_color_green");
            showXmlButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    TitleCompareReportView.this.controller.onShowXml();
                }
            });
            hc.add((Widget)showXmlButton);
        }
        ButtonWidget cancelButton = new ButtonWidget();
        cancelButton.setText(this.getMessages().cancelButtonLabel());
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleCompareReportView.this.controller.onCancel();
            }
        });
        hc.add((Widget)cancelButton);
        return hc;
    }

    public LabelWidget getCompareSummaryLabel() {
        return this.compareSummaryLabel;
    }

    public HorizontalPanel getButtonPanel() {
        return this.buttonPanel;
    }

    TitleCompareViewInput getInput() {
        return this.parentView.getInput();
    }

    TitleCompareViewMessages getMessages() {
        return this.parentView.getMessages();
    }

    public void refresh() {
        UITitleCompareData data = this.getInput().compareData;
        if (data == null || data.getReport() == null) {
            return;
        }
        this.assetWidget.refresh();
        this.fileWidget.refresh();
        this.metadataWidget.refresh();
    }

    AssetCompareWidget getAssetCompareWidget() {
        return this.assetWidget;
    }

    AssetCompareWidget getFileCompareWidget() {
        return this.fileWidget;
    }

    MetadataCompareWidget getMetadataCompareWidget() {
        return this.metadataWidget;
    }
}

