/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.compare.report;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.preview.TitleCompareXmlWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;

public class TitleCompareXmlView
extends VerticalPanel {
    private static final String STYLE_SUMMARY_LABEL = "content-TitleCompareView-summaryLabel";
    private LabelWidget compareSummaryLabel = new LabelWidget();
    private TitleCompareXmlWidget xmlWidget;

    public TitleCompareXmlView(TitleCompareView view, ITitleCompareViewController controller, boolean showXML) {
        this.compareSummaryLabel.addStyleName(STYLE_SUMMARY_LABEL);
        this.add((Widget)this.compareSummaryLabel);
        this.xmlWidget = new TitleCompareXmlWidget(view);
        this.add((Widget)this.xmlWidget);
        HorizontalPanel buttonPanel = this.createButtonPanel(controller, showXML);
        this.add((Widget)buttonPanel);
    }

    private HorizontalPanel createButtonPanel(final ITitleCompareViewController controller, boolean showXML) {
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.addStyleName("cms_button_container");
        ButtonWidget showDiffButton = new ButtonWidget("Show Differences");
        showDiffButton.removeStyleName("gwt-Button");
        showDiffButton.addStyleName("ebBtn");
        showDiffButton.addStyleName("ebBtn_color_green");
        showDiffButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                controller.onShowDifferences();
            }
        });
        buttonPanel.add((Widget)showDiffButton);
        if (showXML) {
            ButtonWidget showXmlButton = new ButtonWidget("Show XML");
            showXmlButton.removeStyleName("gwt-Button");
            showXmlButton.addStyleName("ebBtn");
            showXmlButton.addStyleName("ebBtn_color_green");
            showXmlButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    controller.onShowXml();
                }
            });
            buttonPanel.add((Widget)showXmlButton);
        }
        ButtonWidget cancelButton = new ButtonWidget();
        cancelButton.setText("Cancel");
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                controller.onCancel();
            }
        });
        buttonPanel.add((Widget)cancelButton);
        return buttonPanel;
    }

    public void setSummaryLabel(String str) {
        this.compareSummaryLabel.setText(str);
    }

    public void showXmlView(UITitleCompareXmlData preview, boolean isPreviewPopup) {
        this.xmlWidget.showXmlView(preview, isPreviewPopup);
    }

    public void removeResizeHandler() {
        this.xmlWidget.getWindowRegistration().removeHandler();
    }
}

