/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.compare.table;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.List;

public abstract class TitleCompareTable<K, R extends TitleCompareRecord<K>>
extends Composite {
    private final SimpleContainer mainContainer;
    private TitleCompareDataProvider<K, R> dataProvider;
    private Table<K, R> tableWidget;
    private TitleCompareViewInput input;
    private LabelWidget blankLabel;
    private final TitleCompareViewMessages messages;
    private boolean sortingEnabled = true;
    private static final String STYLE_NAME = "content-TitleCompareTable";
    private static final String STYLE_TABLE = "content-TitleCompareTable-table";
    private static final String STYLE_BLANK_LABEL = "content-TitleCompareTable-blankLabel";
    private static final String STYLE_ERROR_LABEL = "content-TitleCompareTable-errorLabel";

    public TitleCompareTable(TitleCompareViewMessages messages) {
        this.messages = messages;
        this.mainContainer = new SimpleContainer();
        this.initWidget((Widget)this.mainContainer);
        this.initialize();
    }

    public TitleCompareViewInput getInput() {
        return this.input;
    }

    public void setInput(TitleCompareViewInput input) {
        this.input = input;
    }

    public TitleCompareViewMessages getMessages() {
        return this.messages;
    }

    public boolean isSortingEnabled() {
        return this.sortingEnabled;
    }

    public void setSortingEnabled(boolean sortingEnabled) {
        this.sortingEnabled = sortingEnabled;
    }

    public List<Column<?, R>> getTableColumns() {
        return this.getDataProvider().getColumns();
    }

    public void refresh() {
        this.getContainer().setWidget((Widget)this.blankLabel);
        if (this.getInput() == null) {
            return;
        }
        this.dataProvider = this.buildDataProvider();
        this.tableWidget = this.buildTable();
        this.getTable().initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneSuccess(Void result) {
                TitleCompareTable.this.handleTableInitializationSuccess();
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleCompareTable.this.handleTableInitializationFailure(caught);
            }
        });
    }

    private void initialize() {
        this.setStylePrimaryName(STYLE_NAME);
        this.blankLabel = new LabelWidget();
        this.blankLabel.addStyleName(STYLE_BLANK_LABEL);
        this.getContainer().setWidget((Widget)this.blankLabel);
    }

    protected SimpleContainer getContainer() {
        return this.mainContainer;
    }

    protected Table<K, R> getTable() {
        return this.tableWidget;
    }

    protected TitleCompareDataProvider<K, R> getDataProvider() {
        return this.dataProvider;
    }

    protected abstract TitleCompareDataProvider<K, R> buildDataProvider();

    protected Table<K, R> buildTable() {
        Table table = new Table(this.getDataProvider());
        if (this.isSortingEnabled()) {
            table.addSortFeature(this.getDataProvider().getSortFeature());
        }
        table.addStyleName(STYLE_TABLE);
        return table;
    }

    protected void handleTableInitializationSuccess() {
        this.getTable().refresh();
        this.getContainer().setWidget(this.getTable());
    }

    protected void handleTableInitializationFailure(Throwable error) {
        String msg = error.getLocalizedMessage();
        LabelWidget label = new LabelWidget();
        label.addStyleName(STYLE_ERROR_LABEL);
        label.setText(this.messages.titleCompareTableInitializationError(msg));
        this.getContainer().setWidget((Widget)label);
    }

    protected void handleRecordsUpdated() {
    }
}

