/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareTableColumn;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareRecord;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;

public class AssetCompareTableColumn
extends TitleCompareTableColumn<AssetCompareRecord>
implements Column<AssetCompareRecord, AssetCompareRecord> {
    private final AssetCompareTable table;
    static final String ASSET_TYPE_COLUMN_NAME = "AssetType";
    static final String METADATA_COLUMN_PREFIX = "AssetMetadata-";
    static final String FILE_METADATA_COLUMN_PREFIX = "FileMetadata-";
    static final String FILE1ID_COLUMN_NAME = "File1ID";
    static final String FILE2ID_COLUMN_NAME = "File2ID";
    static final String DIFFERENCE_TYPE_COLUMN_NAME = "DifferenceType";

    public AssetCompareTableColumn(AssetCompareTable table, String name, String displayName) {
        super(name, displayName);
        this.table = table;
    }

    public AssetCompareTableColumn(AssetCompareTable table, String metadataName, String displayName, boolean fileMetadata) {
        this(table, AssetCompareTableColumn.getColumnName(metadataName, fileMetadata), displayName);
    }

    public boolean isShownInFieldDifference() {
        return !DIFFERENCE_TYPE_COLUMN_NAME.equals(this.getName());
    }

    public boolean isMetadataColumn() {
        return this.isAssetMetadataColumn() || this.isFileMetadataColumn();
    }

    public boolean isAssetMetadataColumn() {
        return this.getName().startsWith(METADATA_COLUMN_PREFIX);
    }

    public boolean isFileMetadataColumn() {
        return this.getName().startsWith(FILE_METADATA_COLUMN_PREFIX);
    }

    public String getMetadataFieldName() {
        if (this.isFileMetadataColumn()) {
            return this.getName().substring(FILE_METADATA_COLUMN_PREFIX.length());
        }
        if (this.isAssetMetadataColumn()) {
            return this.getName().substring(METADATA_COLUMN_PREFIX.length());
        }
        return null;
    }

    @Override
    public Widget getWidget(AssetCompareRecord record) {
        LabelWidget label = new LabelWidget();
        if (this.getName().equals(ASSET_TYPE_COLUMN_NAME)) {
            label.setText(record.getAssetTypeName());
        } else if (this.getName().equals(FILE1ID_COLUMN_NAME)) {
            label.setText(record.getAsset1ID());
        } else if (this.getName().equals(FILE2ID_COLUMN_NAME)) {
            label.setText(record.getAsset2ID());
        } else if (this.getName().equals(DIFFERENCE_TYPE_COLUMN_NAME)) {
            label.setText(record.getDifferenceTypeName());
            label.addClickHandler((ClickHandler)new ColumnClickHandler(this.table, record));
        } else if (this.isAssetMetadataColumn()) {
            String metadataName = this.getMetadataFieldName();
            label.setText(record.getAssetMetadataValue(metadataName));
        } else if (this.isFileMetadataColumn()) {
            String metadataName = this.getMetadataFieldName();
            label.setText(record.getFileMetadataValue(metadataName));
        }
        return label;
    }

    private static String getColumnName(String metadataName, boolean fileMetadata) {
        String name = fileMetadata ? FILE_METADATA_COLUMN_PREFIX : METADATA_COLUMN_PREFIX;
        return String.valueOf(name) + metadataName;
    }

    private static final class ColumnClickHandler
    implements ClickHandler {
        private final AssetCompareTable table;
        private final AssetCompareRecord record;

        public ColumnClickHandler(AssetCompareTable table, AssetCompareRecord record) {
            this.table = table;
            this.record = record;
        }

        public void onClick(ClickEvent event) {
            this.table.handleDifferenceTypeColumnClicked(this.record);
        }
    }
}

