/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.history;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UIActionTitle;
import com.tandbergtv.cms.portal.content.client.title.model.compare.TitleCompareRequest;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.TitleValidationUIException;
import com.tandbergtv.cms.portal.content.client.title.view.HtmlorXmlDisplayHelper;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetPanel;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.history.HistoryPanel;
import com.tandbergtv.cms.portal.content.client.title.view.history.TitleHistoryTab;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.preview.TitlePreviewWidget;
import com.tandbergtv.cms.portal.content.client.title.view.preview.TitlePreviewWidgetInput;
import com.tandbergtv.cms.portal.content.client.title.view.series.SeriesTitleView;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.GridContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;
import java.util.List;

class MetadataHistoryPanel
extends HistoryPanel
implements ITitleCompareViewController {
    private GridContainer mainContainer;
    private LabelWidget blankPanelLabel;
    private SimpleContainer controlsContainer;
    private HorizontalContainer buttonContainer;
    private ButtonWidget roleBackButton;
    private ButtonWidget compareButton;
    private ButtonWidget previewButton;
    private ButtonWidget cancelButton;
    private ButtonWidget rollbackAsDraftButton;
    private AssetTree.AssetInfo assetInfo;
    private AssetPanel assetPanel;
    private String titleRevision;
    private boolean isDraft;
    private HandlerRegistration windowRegistration = null;
    protected TitleView titleView;
    private TitleCompareView compareView;
    private TitleCompareRequest lastRequest;
    private static final String INVALID_LICENSE_DATE = "INVALID_LICENSE_DATE";
    private static final String STYLE_CONTROLS_CONTAINER = "content-MetadataHistoryPanel-controlsContainer";
    private static final String STYLE_REVISION_CELL = "content-MetadataHistoryPanel-revisionLabelCell";
    private static final String STYLE_ASSETPANEL_CELL = "content-MetadataHistoryPanel-assetPanelCell";
    private static final String STYLE_REVISION_LABEL = "content-MetadataHistoryPanel-revisionLabel";
    private static final String STYLE_ASSET_PANEL = "content-MetadataHistoryPanel-assetPanel";
    private ITitleViewServiceAsync viewService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);

    public MetadataHistoryPanel(TitleHistoryTab parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.addStyleDependentName("metadata");
        this.mainContainer = new GridContainer(2, 1);
        this.controlsContainer = new SimpleContainer();
        this.controlsContainer.addStyleName(STYLE_CONTROLS_CONTAINER);
        this.buttonContainer = new HorizontalContainer();
        this.buttonContainer.addStyleName("cms_button_container");
        this.controlsContainer.setWidget((Widget)this.buttonContainer);
        String rollbackText = this.getTab().getViewMessages().rollbackButton();
        this.roleBackButton = new ButtonWidget(rollbackText);
        this.roleBackButton.removeStyleName("gwt-Button");
        this.roleBackButton.addStyleName("ebBtn");
        this.roleBackButton.addStyleName("rollback_button_icon");
        this.roleBackButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MetadataHistoryPanel.this.rollbackClickedAction();
            }
        });
        this.roleBackButton.setVisible(false);
        this.roleBackButton.setEnabled(false);
        this.buttonContainer.add((Widget)this.roleBackButton);
        String rollbackAsDraftText = this.getTab().getViewMessages().rollbackAsDraftButton();
        this.rollbackAsDraftButton = new ButtonWidget(rollbackAsDraftText);
        this.rollbackAsDraftButton.removeStyleName("gwt-Button");
        this.rollbackAsDraftButton.addStyleName("ebBtn");
        this.rollbackAsDraftButton.addStyleName("rollback_button_icon");
        this.rollbackAsDraftButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Long titleId = MetadataHistoryPanel.this.getTab().getViewInput().getTitleId();
                MetadataHistoryPanel.this.getTab().getViewService().rollbackTitleAsDraft(titleId, MetadataHistoryPanel.this.titleRevision, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneSuccess(Void result) {
                        MetadataHistoryPanel.this.handleRollbackTitleSuccess();
                    }

                    public void onNeptuneFailure(Throwable caught) {
                        String msg = MetadataHistoryPanel.this.getTab().getViewMessages().rollbackFailureMessage(MetadataHistoryPanel.this.titleRevision);
                        MetadataHistoryPanel.this.getTab().showProgressHistory(false, msg, true);
                        MetadataHistoryPanel.this.clearPanel();
                    }
                });
            }
        });
        this.rollbackAsDraftButton.setVisible(false);
        this.rollbackAsDraftButton.setEnabled(false);
        this.buttonContainer.add((Widget)this.rollbackAsDraftButton);
        String compareText = this.getTab().getViewMessages().compareButton();
        this.compareButton = new ButtonWidget(compareText);
        this.compareButton.removeStyleName("gwt-Button");
        this.compareButton.addStyleName("ebBtn");
        this.compareButton.addStyleName("ebBtn_color_green");
        this.compareButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MetadataHistoryPanel.this.compareClickedAction();
            }
        });
        this.buttonContainer.add((Widget)this.compareButton);
        String previewText = this.getTab().getViewMessages().previewButton();
        this.previewButton = new ButtonWidget(previewText);
        this.previewButton.removeStyleName("gwt-Button");
        this.previewButton.addStyleName("ebBtn");
        this.previewButton.addStyleName("preview_button_icon");
        this.previewButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MetadataHistoryPanel.this.previewClickedAction();
            }
        });
        this.buttonContainer.add((Widget)this.previewButton);
        String cancelText = this.getTab().getViewMessages().cancelButton();
        this.cancelButton = new ButtonWidget(cancelText);
        this.cancelButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MetadataHistoryPanel.this.cancelClickedAction();
            }
        });
        this.buttonContainer.add((Widget)this.cancelButton);
        this.mainContainer.setWidget(1, 0, (Widget)this.controlsContainer);
        this.blankPanelLabel = new LabelWidget("");
        this.setWidget((Widget)this.blankPanelLabel);
    }

    private void rollbackClickedAction() {
        Long titleId = this.getTab().getViewInput().getTitleId();
        this.getTab().getViewService().rollbackTitle(titleId, this.titleRevision, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneSuccess(Void result) {
                MetadataHistoryPanel.this.handleRollbackTitleSuccess();
            }

            public void onNeptuneFailure(Throwable caught) {
                MetadataHistoryPanel.this.handleRollbackTitleFailure(caught);
            }
        });
    }

    private void handleRollbackTitleSuccess() {
        String message = this.getTab().getViewMessages().successfullRollbackMessage(this.titleRevision);
        this.getTab().showProgressHistory(true, message, true);
        this.clearPanel();
    }

    private void handleRollbackTitleFailure(Throwable caught) {
        TitleViewMessages messages = this.getTab().getViewMessages();
        if (!(caught instanceof TitleValidationUIException)) {
            String message = messages.rollbackFailureMessage(this.titleRevision);
            this.getTab().showProgressHistory(false, message, true);
            this.clearPanel();
            return;
        }
        if (!this.canSaveAsDraft((TitleValidationUIException)((Object)caught))) {
            String message = messages.rollbackValidationFailureMessage(this.titleRevision);
            this.getTab().showProgressHistory(false, message, true);
            this.clearPanel();
            return;
        }
        TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
        validationViewInput.getTitleValidationMessages().clear();
        validationViewInput.setErrorHeader(messages.rollbackSaveAsDraftMessage(this.titleRevision));
        if (((TitleValidationUIException)((Object)caught)).getValidationMessages().size() > 0) {
            validationViewInput.getTitleValidationMessages().addAll(((TitleValidationUIException)((Object)caught)).getValidationMessages());
        } else {
            validationViewInput.setErrorHeader(this.getTab().getViewMessages().rollbackFailureMessage(this.titleRevision));
        }
        this.titleView.showMessage(validationViewInput);
        this.rollbackAsDraftButton.setVisible(true);
        this.rollbackAsDraftButton.setEnabled(true);
    }

    private void compareClickedAction() {
        String header;
        this.compareView = new TitleCompareView(this, !this.isSeriesTitle());
        UIActionTitle title1 = new UIActionTitle();
        title1.setTitleId(this.getTab().getViewInput().getTitleId());
        UIActionTitle title2 = new UIActionTitle();
        title2.setTitleId(this.getTab().getViewInput().getTitleId());
        title2.setVersion(this.titleRevision);
        TitleCompareViewInput input = new TitleCompareViewInput();
        input.specName = this.getTab().getViewInput().getSpecificationName();
        input.header = header = this.getTab().getViewMessages().titleCompareSummaryMessage(this.getTab().getViewMessages().compareTitleHeading(), this.getTab().getViewMessages().compareRevisionHeading(this.titleRevision));
        input.displayName1 = this.getTab().getViewMessages().compareCurrentRevisionName();
        input.displayName2 = this.getTab().getViewMessages().compareRevisionName(this.titleRevision);
        input.restrictedHeight = this.getTab().getUsedHeight();
        input.restrictedWidth = this.getTab().getUsedWidth();
        this.compareView.setInput(input);
        this.lastRequest = new TitleCompareRequest();
        this.lastRequest.title1 = title1;
        this.lastRequest.title2 = title2;
        this.lastRequest.specName = input.specName;
        this.lastRequest.specificationType = this.titleView instanceof SeriesTitleView ? "SERIES" : "PACKAGE";
        this.compareDiff();
        this.setWidget((Widget)this.compareView);
    }

    private void handleViewCancelled() {
        this.setWidget((Widget)this.mainContainer);
        this.updateScrollContainerSize();
    }

    private void previewClickedAction() {
        UIActionTitle title = new UIActionTitle();
        title.setTitleId(this.getTab().getViewInput().getTitleId());
        title.setVersion(this.titleRevision);
        TitlePreviewWidgetInput input = new TitlePreviewWidgetInput(title);
        input.setSelectedSpecification(this.getTab().getViewInput().getSpecificationName());
        input.setRestrictedHeight(this.getTab().getUsedHeight());
        input.setRestrictedWidth(this.getTab().getUsedWidth());
        TitlePreviewWidget previewWidget = new TitlePreviewWidget(this.getTab().getViewMessages());
        previewWidget.addViewCancelHandler(new ViewCancelHandler(){

            public void onCancel(ViewCancelEvent event) {
                MetadataHistoryPanel.this.handleViewCancelled();
            }
        });
        previewWidget.setInput(input);
        previewWidget.refresh();
        this.setWidget((Widget)previewWidget);
    }

    private void cancelClickedAction() {
        this.getTab().showProgressHistory(false, null, false);
        this.clearPanel();
    }

    @Override
    public void refresh() {
        this.clearPanel();
    }

    private void clearPanel() {
        this.titleRevision = null;
        this.assetInfo = null;
        this.assetPanel = null;
        this.setWidget((Widget)this.blankPanelLabel);
    }

    public void setInput(String revision, boolean draft, UIAssetSpecification specification, UITitleMetadata metadata, TitleView tView) {
        this.titleRevision = revision;
        this.isDraft = draft;
        this.titleView = tView;
        GridContainer contentPanel = new GridContainer(2, 1);
        contentPanel.setWidth("100%");
        this.rollbackAsDraftButton.setVisible(false);
        this.rollbackAsDraftButton.setEnabled(false);
        String revisionMessage = this.getTab().getViewMessages().titleRevisionMessage(revision);
        LabelWidget revisionLabel = new LabelWidget(revisionMessage);
        revisionLabel.addStyleName(STYLE_REVISION_LABEL);
        contentPanel.setWidget(0, 0, (Widget)revisionLabel);
        contentPanel.getCellFormatter().setStyleName(0, 0, STYLE_REVISION_CELL);
        UIAsset asset = metadata.getRootAsset();
        UIAssetDefinition definition = specification.getAssetDefinition(asset.getAssetType());
        this.assetInfo = new AssetTree.AssetInfo(this.getTab().getViewInput(), asset, definition);
        this.assetPanel = new AssetPanel(tView, this.assetInfo, null, true);
        this.assetPanel.addStyleName(STYLE_ASSET_PANEL);
        contentPanel.setWidget(1, 0, (Widget)this.assetPanel);
        contentPanel.getCellFormatter().setStyleName(1, 0, STYLE_ASSETPANEL_CELL);
        this.assetPanel.addOffsettingWidget(this.titleView.getMessageViewWidget());
        this.assetPanel.addOffsettingWidget((Widget)revisionLabel);
        this.assetPanel.addOffsettingWidget((Widget)this.controlsContainer);
        this.mainContainer.setWidget(0, 0, (Widget)contentPanel);
        this.setWidget((Widget)this.mainContainer);
        this.updateScrollContainerSize();
        boolean enabled = metadata.isActive() && this.getTab().getViewInput().hasTitleModifyPermission() && !this.isDraft;
        this.roleBackButton.setVisible(enabled);
        this.roleBackButton.setEnabled(enabled);
        if (this.isSeriesTitle()) {
            this.previewButton.setVisible(false);
        }
    }

    private boolean canSaveAsDraft(TitleValidationUIException exception) {
        for (UITitleValidationMessage message : exception.getValidationMessages()) {
            if (!message.getErrorCode().equalsIgnoreCase(INVALID_LICENSE_DATE)) continue;
            return false;
        }
        return true;
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                MetadataHistoryPanel.this.updateScrollContainerSize();
            }
        });
        this.updateScrollContainerSize();
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        super.onUnload();
    }

    private void updateScrollContainerSize() {
        if (this.assetPanel != null) {
            this.assetPanel.updateSize();
        }
    }

    @Override
    public void onCancel() {
        this.handleViewCancelled();
    }

    @Override
    public void onShowDifferences() {
        this.compareDiff();
    }

    @Override
    public void onShowXml() {
        this.compareXml();
    }

    @Override
    public void onSpecChanged(String newSpec) {
        this.lastRequest.specName = newSpec;
        this.compareView.getInput().specName = newSpec;
        this.compareXml();
    }

    public void compareXml() {
        this.compareView.showBusyIndicator();
        this.viewService.compareTitlePreviews(this.lastRequest.title1, this.lastRequest.title2, this.lastRequest.specName, HtmlorXmlDisplayHelper.useHtml(), (AsyncCallback<UITitleCompareXmlData>)new NeptuneAsyncCallback<UITitleCompareXmlData>(){

            public void onNeptuneFailure(Throwable caught) {
                MetadataHistoryPanel.this.compareView.showErrorView(caught);
                MetadataHistoryPanel.this.compareView.hideBusyIndicator();
            }

            public void onNeptuneSuccess(UITitleCompareXmlData result) {
                MetadataHistoryPanel.this.compareView.showXmlView(result);
                MetadataHistoryPanel.this.compareView.hideBusyIndicator();
            }
        });
    }

    public void compareDiff() {
        this.compareView.showBusyIndicator();
        this.viewService.compareTitles(this.lastRequest, (AsyncCallback<UITitleCompareData>)new NeptuneAsyncCallback<UITitleCompareData>(){

            public void onNeptuneFailure(Throwable caught) {
                MetadataHistoryPanel.this.compareView.showErrorView(caught);
                MetadataHistoryPanel.this.compareView.hideBusyIndicator();
            }

            public void onNeptuneSuccess(UITitleCompareData data) {
                MetadataHistoryPanel.this.setSpecName(data);
                ((MetadataHistoryPanel)MetadataHistoryPanel.this).compareView.getInput().compareData = data;
                MetadataHistoryPanel.this.compareView.showDiffView();
                MetadataHistoryPanel.this.compareView.hideBusyIndicator();
            }
        });
    }

    private void setSpecName(UITitleCompareData data) {
        List<UIAssetSpecificationListItem> specs;
        if (this.lastRequest != null && data != null && this.lastRequest.specName == null && (specs = data.getSpecifications()) != null && specs.size() > 0) {
            this.lastRequest.specName = specs.get(0).getName();
        }
    }

    private boolean isSeriesTitle() {
        return this.titleView instanceof SeriesTitleView;
    }
}

